$(function () {
	// Check / uncheck all checkboxes
	$('.check_all').click(function() {
		$(this).parents('form').find('input:checkbox').attr('checked', $(this).is(':checked'));
	});
});

function remove_row(subjm,txt)
{
	if (confirm(txt))
	{
		$.ajax({
			type:'POST',
			url:'acpanel/ajax.php?do=ajax_cc_commands',
			data:({id : subjm,'go' : 3}),
			success:function(result) {
				if( result.indexOf('id="success"') + 1)
				{
					$('.accessMessage').html('');
					humanMsg.displayMsg(result,'success');
					$('tr#' + subjm).remove();
					rePagination(-1);
					$('table').trigger('update');
					$('table').trigger('applyWidgets', 'zebra');
				}
				else
				{
					humanMsg.displayMsg(result,'error');
				}
			}
		});
	}
	return false;
}

function edit_row(subjm)
{
	if($('tr td[id] input').length > 0)
	{
		cancelhandler();
	}

	$('tr#' + subjm + ' td[id]').each( function() {
		var valtext = $(this).text();
		var valid = $(this).attr('id');

		$(this).html($('<input>')
			.attr('type','text')
			.attr('name',valid)
			.attr('value',valtext)
			.addClass('text small')
		).append($('<input>')
			.attr('type','hidden')
			.attr('name',valid)
			.attr('value',valtext)
		);
	});

	var $actionstr = $('tr#' + subjm + ' td.delete');

	$actionstr.html($('<a>')
		.click(function() {
			savehandler();
			return false;
		})
		.attr('href','#')
		.addClass('save')
		.text('Save')
	).append(' | ').append($('<a>')
		.click(function() {
			cancelhandler();
			return false;
		})
		.attr('href','#')
		.addClass('cancel')
		.text('Cancel')
	);

	return false;
}

function cancelhandler()
{
	$('tr td[id] input:hidden').each( function() {
		var tempval = $(this).val();
		var tempname = $(this).attr('name');

		$(this).parent().attr('id',tempname).html(tempval);
	});

	var $b = $('tr td.delete .cancel');
	var idrow = $b.parents('tr').attr("id");

	$b.parent().html($('<a>')
		.click(function() {
			return edit_row(idrow);
		})
		.attr('href','#')
		.text('Edit')
	).append(' | ').append($('<a>')
		.click(function() {
			return remove_row(idrow);
		})
		.attr('href','#')
		.text('Delete')
	);
}

function savehandler()
{
	var str = '';

	$('tr td[id] input:text').each( function() {
		var editval = $(this).val();
		var editname = $(this).attr('name');

		str = str + '&' + editname + '=' + editval;
	});

	var $b = $('tr td.delete .save');
	var idrow = $b.parents('tr').attr("id");

	$.ajax({
		type:'POST',
		url:'acpanel/ajax.php?do=ajax_cc_commands',
		data:'go=5&editid=' + idrow + str,
		success:function(result) {
			if( result.indexOf('id="success"') + 1)
			{
				$('.accessMessage').html('');
				humanMsg.displayMsg(result,'success');
				$('tr td[id] input:text').each( function() {
					$(this).parent().attr('id',$(this).attr('name')).html($(this).val());
				});
				$b.parent().html($('<a>')
					.click(function() {
						return edit_row(idrow);
					})
					.attr('href','#')
					.text('Edit')
				).append(' | ').append($('<a>')
					.click(function() {
						return remove_row(idrow);
					})
					.attr('href','#')
					.text('Delete')
				);
			}
			else
			{
				humanMsg.displayMsg(result,'error');
			}
		}
	});
}

$(document).ready(function() {
	$('.tablesorter').tablesorter({
		widgets: ['zebra'],
		headers: {0:{sorter: false}}
	});

	$('.cancel').click(cancelhandler);
	$('.save').click(savehandler);

	$('#forma').submit(function() {
		var len = $("tbody input:checked").length;
		if (len > 0)
		{
			if (confirm($('input:submit',this).val() + '?'))
			{
				var arr = new Array();
				$('tbody input:checked').each( function() {
					arr.push($(this).val());
				});

				$.ajax({
					type:'POST',
					url:'acpanel/ajax.php?do=ajax_cc_commands',
					data:({'marked_word[]' : arr,'go' : 4}),
					success:function(result) {
						if( result.indexOf('id="success"') + 1)
						{
							$('.accessMessage').html('');
							humanMsg.displayMsg(result,'success');
							rePagination(-arr.length);
							$('table').trigger('update');
							$('table').trigger('applyWidgets', 'zebra');
						}
						else
						{
							humanMsg.displayMsg(result,'error');
						}
					}
				});

				$(this).find('input:checkbox').attr('checked', $(this).is(''));
			}
		} else {
			alert($('input:hidden:last',this).val());
		}

		return false;
	});
});