//
// TRACKER SCHEME RESOURCE FILE
//
// sections:
//		colors			- all the colors used by the scheme
//		basesettings	- contains settings for app to use to draw controls
//		fonts			- list of all the fonts used by app
//		borders			- description of all the borders
//
// notes:
// 		hit ctrl-alt-shift-R in the app to reload this file
//
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	Colors
	{
		// base colors
		"BaseText"			"80 220 230 255"		// Kommandozeile (Console)
		"BrightBaseText"		"255 255 255 255"		// Buttons
		"SelectedText"		"80 220 230 255"		// markierter Text
		"DimBaseText"		"160 170 149 255"		// Kontextmenuetext
		"LabelDimText"		"160 170 149 255"		// Infotexte
		"ControlText"		"80 220 230 255"		// Haupttext (Console, Optionen...)
		"BrightControlText"	"196 181 80 255"		// aktiver Reitertitel
		"DisabledText1"		"117 128 111 255"		// inaktive Buttons
		"DisabledText2"		"40 46 34 255"		// inaktive Buttons (Schatten Hintergrund)
		"DimListText"		"117 134 102 255"		// offline friends, unsubscribed games, etc.

		// background colors
		"ControlBG"			"0 30 70 220"		// Aeuere der Fenster  Scrollbalken
		"ControlDarkBG"		"0 30 70 240"		// Hintergrund der Scrollbalken
		"WindowBG"			"0 70 105 220"		// Textfelder
		"SelectionBG"		"0 30 70 220"		// Markierungen
		"SelectionBG2"		"80 80 80 220"		// Markierungen (inaktives Fenster)
		"ListBG"			"80 80 80 220"		// Serverliste  Hakenkaestchen

		// titlebar colors
		"TitleText"			"80 220 230 255"		// Titel vom aktiven Fenster
		"TitleDimText"		"100 100 100 255"		// Titel vom inaktiven Fenster
		"TitleBG"			"76 88 68 0"		// Hintergrund vom Titel des aktiven Fensters (durchsichtig lassen)
		"TitleDimBG"		"76 88 68 0"		// Hintergrund vom Titel des inaktiven Fensters (durchsichtig lassen)
		
		// slider tick colors
		"SliderTickColor"		"255 255 255 255"		// Streifen (Sensitivitaet, Lautstaerke)
		"SliderTrackColor"	"80 220 230 255"		// Schieberegler (Sensitivitaet, Lautstaerke)

		// border colors
		"BorderBright"		"100 100 100 100"		// Fensterrand: oben + links
		"BorderDark"		"80 80 80 100"		// Fensterrand: unten + rechts
		"BorderSelection"		"0 0 0 255"			// the additional border color for displaying the default/selected button
	}

	///////////////////// BASE SETTINGS ////////////////////////
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		"FgColor"					"ControlText"
		"BgColor"					"ControlBG"
		"LabelBgColor"				"0 0 0 0"
		"SubPanelBgColor"				"ControlBG"

		"DisabledFgColor1"			"DisabledText1" 
		"DisabledFgColor2"			"DisabledText2"

		"TitleBarFgColor"				"TitleText"
		"TitleBarDisabledFgColor"		"TitleDimText"
		"TitleBarBgColor"				"TitleBG"
		"TitleBarDisabledBgColor"		"TitleDimBG"

		"TitleBarIcon"				"resource/icon_steam"
		"TitleBarDisabledIcon"			"resource/icon_steam_disabled"

		"TitleButtonFgColor"			"BorderBright"
		"TitleButtonBgColor"			"ControlBG"
		"TitleButtonDisabledFgColor"		"TitleDimText"
		"TitleButtonDisabledBgColor"		"TitleDimBG"

		"TextCursorColor"				"BaseText"
		"URLTextColor"				"BrightBaseText"

		Menu
		{
			"FgColor"				"DimBaseText"
			"BgColor"				"ControlBG"
			"ArmedFgColor"			"BrightBaseText"
			"ArmedBgColor"			"SelectionBG"
			"DividerColor"			"BorderDark"

			"TextInset"				"6"
		}

		MenuButton
		{
			"ButtonArrowColor"		"DimBaseText"
		   	"ButtonBgColor"			"WindowBG"
			"ArmedArrowColor"			"BrightBaseText"
			"ArmedBgColor"			"DimBaseText"
		}

		Slider
		{
			"SliderFgColor"			"ControlBG"
			"SliderBgColor"			"ControlDarkBG"
		}

		ScrollBarSlider
		{
			"BgColor"				"ControlBG"
			"ScrollBarSliderFgColor"	"ControlBG"
			"ScrollBarSliderBgColor"	"ControlDarkBG"
			"ButtonFgColor"			"DimBaseText"
		}


		// text edit windows
		"WindowFgColor"				"BaseText"
		"WindowBgColor"				"WindowBG"
		"WindowDisabledFgColor"			"DimBaseText"
		"WindowDisabledBgColor"			"ListBG"
		"SelectionFgColor"			"SelectedText"
		"SelectionBgColor"			"SelectionBG"
		"ListSelectionFgColor"			"SelectedText"
		"ListBgColor"				"ListBG"		
		"BuddyListBgColor"			"ListBG"		
		
		// App-specific stuff
		"ChatBgColor"				"WindowBG"

		// status selection
		"StatusSelectFgColor"			"BrightBaseText"
		"StatusSelectFgColor2"			"BrightControlText"	

		// checkboxes
		"CheckButtonBorder1"   			"BorderDark"		
		"CheckButtonBorder2"   			"BorderBright"		
		"CheckButtonCheck"			"BrightControlText"	
		"CheckBgColor"				"ListBG"

		// buttons (default fg/bg colors are used if these are not set)
//		"ButtonArmedFgColor"
//		"ButtonArmedBgColor"
//		"ButtonDepressedFgColor"		"BrightControlText"
//		"ButtonDepressedBgColor"

		// buddy buttons
		BuddyButton
		{
			"FgColor1"				"ControlText"
			"FgColor2"				"DimListText"
			"ArmedFgColor1"			"BrightBaseText"
			"ArmedFgColor2"			"BrightBaseText"
			"ArmedBgColor"			"SelectionBG"
		}

		Chat
		{
			"TextColor"				"BrightControlText"
			"SelfTextColor"			"BaseText"
			"SeperatorTextColor"		"DimBaseText"
		}

		InGameDesktop
		{
			"MenuColor"				"255 255 255 255"
			"ArmedMenuColor"			"5 30 82 255"
			"DepressedMenuColor" 		"192 186 80 255"
			"WidescreenBarColor" 		"0 0 0 0"
			"MenuItemVisibilityRate" 	"0.03" 
			"MenuItemHeight"			"28"
			"GameMenuInset"			"32"
		}

		"SectionTextColor"			"BrightControlText"
		"SectionDividerColor"			"BorderDark"
	}

	//
	//////////////////////// FONTS /////////////////////////////
	//
	// describes all the fonts
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		"Default"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"0"
			}
		}
		"DefaultBold"						// Default, DefaultBold, DefaultUnderline - Console, Titelleiste...
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"500"
			}
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"0"
				"underline" "1"
			}
		}
		"DefaultSmall"						// Serverliste
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"0"
			}
		}
		"DefaultSmallBold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"600"
			}
		}
		"DefaultVerySmall"					// kleine Infotexte (Optionen)
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"0"
			}
		}
		"MenuLarge"							// Schriftart im Menue
		{
			"1"
			{
				"name"		"Dungeon"
				"tall"		"18"
				"weight"	"1000"
				"antialias" "0"
			}
		}
		"UiHeadline"
		{
			"1"
			{
				"name"		"Dungeon"
				"tall"		"16"
				"weight"	"1000"
				"antialias" "0"
			}
		}

		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"14"
				"weight"	"0"
				"symbol"	"1"
			}
		}
		
		"EngineFont"						// Ab hier Schriftart des Saytextes
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"12"
				"weight"	"100"
				"yres"	"480 599"
				"dropshadow"	"1"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"13"
				"weight"	"100"
				"yres"	"600 767"
				"dropshadow"	"1"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"14"
				"weight"	"100"
				"yres"	"768 1023"
				"dropshadow"	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"20"
				"weight"	"100"
				"yres"	"1024 1199"
				"dropshadow"	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"24"
				"weight"	"100"
				"yres"	"1200 6000"
				"dropshadow"	"1"
			}
		}	
		
		"CreditsFont"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"18"
				"weight"	"600"
				"antialias"	"1"
			}
		}

		"Legacy_CreditsFont" // Added to accomodate 3rd party server plugins, etc. This version should not scale.
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"20"
				"weight"	"700"
				"antialias"	"1"
				"yres"	"1 10000"
			}
		}
	}

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		// references to other borders
		BaseBorder		"InsetBorder"
		ComboBoxBorder	"InsetBorder"
		BrowserBorder	"InsetBorder"
		ButtonBorder	"RaisedBorder"
		FrameBorder		"RaisedBorder"
		TabBorder		"RaisedBorder"
		MenuBorder		"RaisedBorder"
		
		// standard borders
		InsetBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		RaisedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// special border types
		TitleButtonBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"4"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDisabledBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BgColor"
					"offset" "1 0"
				}
			}
			Top
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDepressedBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "1 0 0 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
		
		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "6 2"
				}
			}
		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}
			Top
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}
			Right
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}
			Bottom
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 1"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "2 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
	}
}