/*

 ==----------=--=-=======-==-=============-=-=-=======--===--=-
   ___    ___      _______     __    _     _______     _______
 /__ /\ /__ /|    /_____ /|  /__/| /_/|  /_______/|  /_______/|
|    \/    | |  /   _   | | |   |/   |' | ___    |' | ___    |'
|          | | |   |/   | | |       <   ||/  /  /__ ||/  /  /__
|   |\/|   | | |    /|  | | |     <   \    /  /__//|   /  /__//|
|   | ||   | | |   | |  | | |       \ /| /  /___|| | /  /___|| |
|___|/ |___|/  |___|/|__|/  |___|\___|/ |________|/ |________|/

    +                 +             +          +
          +                      +                   +
	          +         +           +      +
	      +        +            +        +

*/
#include <amxmisc>
#include <fakemeta>

#define VERSION			"1.0"
#define CLASS_NAME		"nai_zone"
#define TASK_BASIS_SHOWZONES	1000
#define TASK_DUBLICATED		1500
#define MAX_NAMES		106

new g_Enabled, g_MsgMode, gMsgLocation, i_MaxZones, i_MaxNames, g_Dot, g_Editor,
Index, g_NameMenu, Direction, setupunits = 10

new g_LastLocation[33], bool:g_Duplicated[33]
new g_LocNames[MAX_NAMES][20], zone[100]

new const g_TeamNames[][] =
{
	"",
	"Terrorist",
	"Counter-Terrorist",
	"Spectator"
}

public plugin_init()
{
	register_plugin ( "Navigation Area Info", VERSION, "Makzz" )
	
	g_Enabled = register_cvar ( "nai_enabled", "1" )
	g_MsgMode = register_cvar ( "nai_msgmode", "1" ) // [0] - CZ Style, [1] - HUD ( Recommended )
	
	register_dictionary ( "navigation_area_info.txt" )
	
	register_forward ( FM_Touch, "Fwd_Touch" )
	//register_forward ( FM_Voice_SetClientListening, "Fwd_SetVoice" )
	register_message ( get_user_msgid ( "TextMsg" ), "Message_TextMsg" )
	
	gMsgLocation = get_user_msgid ( "Location" )
	
	register_menu ( "MainMenu", -1, "MainMenuAction" )
	register_menu ( "EditMenu", -1, "EditMenuAction" )
	register_menu ( "KillMenu", -1, "KillMenuAction" )
	
	register_clcmd ( "nai_menu", "InitNaiMenu", ADMIN_RCON )
	register_clcmd ( "say_team", "Hook_SayTeam" )
	
	set_task ( 0.2, "LoadAreaNameFile" )
}

public client_disconnect ( id )
{
	if ( g_Editor == id )
	{
		g_Editor = 0
		
		for ( new i; i < i_MaxZones; i++ )
		{
			new z = zone[i]
			remove_task ( TASK_BASIS_SHOWZONES + z )
		}
	}
	
	remove_task ( id+TASK_DUBLICATED )
	g_Duplicated[id] = false
}

public client_putinserver ( id )
	g_LastLocation[id] = -1

public plugin_precache ()
	g_Dot = precache_model ( "sprites/dot.spr" )

public Fwd_Touch ( zone, id )
{
	if ( !get_pcvar_num ( g_Enabled ) || !i_MaxZones )
		return FMRES_IGNORED
	
	if ( !is_user_alive ( id ) )
		return FMRES_IGNORED
	
	static s_ClassName[32]
	pev ( zone, pev_classname, s_ClassName, sizeof s_ClassName - 1 )
	
	if ( equal ( s_ClassName, CLASS_NAME ) ) //   !!
	{
		new i_Name = pev ( zone, pev_iuser1 )
		if( i_Name != g_LastLocation[id] )
		{
			if ( !is_user_bot ( id ) )
			{
				if ( get_pcvar_num ( g_MsgMode ) )
				{
					set_hudmessage ( 0, 255, 0, 0.01, 0.22, 2, 0.1, 6.0, 0.05, 2.0, 2 )
					show_hudmessage ( id, "%L", id, g_LocNames[i_Name][1] )
				}
				else
				{
					message_begin ( MSG_ONE, gMsgLocation, _, id )
					write_byte ( 1 )
					write_string ( g_LocNames[i_Name] )
					message_end ()
				}
			}
			
			g_LastLocation[id] = i_Name // We need to save i_Name also for bots
		}
	}
	return PLUGIN_CONTINUE
}

public Message_TextMsg ( /*msg_id, dest, id*/ )
{
	if ( get_msg_args() != 5 || !i_MaxZones || !get_pcvar_num ( g_Enabled ) )
		return PLUGIN_CONTINUE
	
	static s_Msg[32]
	get_msg_arg_string ( 3, s_Msg, sizeof s_Msg - 1 )
	
	if ( !equal ( s_Msg, "#Game_radio" ) )
		return PLUGIN_CONTINUE
	
	static s_Name[32], s_RadioMsg[32], s_NewMsg[256], s_Player[3]
	get_msg_arg_string ( 2, s_Player, sizeof s_Player - 1 )
	get_msg_arg_string ( 4, s_Name, sizeof s_Name - 1 )
	get_msg_arg_string ( 5, s_RadioMsg, sizeof s_RadioMsg - 1 )
	
	static i_Player
	i_Player = str_to_num ( s_Player )
	if ( i_Player > 32 || !i_Player )
	{
		server_print("Oops %i",i_Player)
		return PLUGIN_CONTINUE
	}
	
	formatex ( s_NewMsg, sizeof s_NewMsg - 1, "^3%s^1 @^4 %s^1 (%L): %L", s_Name, g_LocNames[g_LastLocation[i_Player]][1], i_Player, "Radio", i_Player, s_RadioMsg[1] )
	client_printcolor ( i_Player, s_NewMsg )
	
	return PLUGIN_HANDLED
}

public LoadAreaNameFile ()
{
	new s_File[64]
	get_configsdir ( s_File, sizeof s_File -1 )
	
	format ( s_File, sizeof s_File -1, "%s/navigation_area/area_names.ini", s_File )
	
	if ( file_exists ( s_File ) )
	{
		new Input[48], Line, Len
		while ( ( Line = read_file ( s_File, Line, Input, sizeof Input -1, Len ) ) != 0 )
		{
			if ( !Len || ( Input[0] == '/' ) )
				continue //   
			
			if ( Input[0] == '#' ) // Name?
			{
				copy ( g_LocNames[i_MaxNames], 19, Input )
				i_MaxNames++
			}
		}
		server_print ( "[NAI] Loaded %i navigation area names", i_MaxNames )
	}
	else
	{
		server_print ( "[NAI] File not found '%s'", s_File )
		return
	}
	LoadAreaFile ()
}

public LoadAreaFile ()
{
	new s_File[64], s_MapName[32]
	get_configsdir ( s_File, sizeof s_File -1 )
	get_mapname ( s_MapName, sizeof s_MapName - 1 )
	
	format ( s_File, sizeof s_File -1, "%s/navigation_area/%s.nai", s_File , s_MapName )
	
	if ( file_exists ( s_File ) )
	{
		new Input[48], Line, Len
		while ( ( Line = read_file ( s_File, Line, Input, sizeof Input -1, Len ) ) != 0 )
		{
			if ( !Len || ( Input[0] == '/' ) )
				continue //   
			
			new Data[20][10], Float:mins[3], Float:maxs[3], Float:pos[3]
			
			parse ( Input, Data[0], 19, Data[1], 19, Data[2], 19, Data[3], 19, Data[4], 19,
			Data[5], 19, Data[6], 19, Data[7], 19, Data[8], 19, Data[9], 19 )
			
			pos[0] = str_to_float ( Data[0] )
			pos[1] = str_to_float ( Data[1] )
			pos[2] = str_to_float ( Data[2] )
			
			mins[0] = str_to_float ( Data[3] )
			mins[1] = str_to_float ( Data[4] )
			mins[2] = str_to_float ( Data[5] )
			
			maxs[0] = str_to_float ( Data[6] )
			maxs[1] = str_to_float ( Data[7] )
			maxs[2] = str_to_float ( Data[8] )
			
			new zm = str_to_num ( Data[9] )
			
			zone[i_MaxZones] = CreateZone ( pos, mins, maxs, zm )
			i_MaxZones++
		}
		server_print ( "[NAI] Loaded %i navigation areas",i_MaxZones)
		set_pcvar_num ( g_Enabled, 1 )
	}
	else
	{
		server_print ( "[NAI] File not found '%s'", s_File )
		set_pcvar_num ( g_Enabled, 0 )
	}
}

stock CreateZone ( Float:position[3], Float:mins[3], Float:maxs[3], zm )
{
	new ent = engfunc ( EngFunc_CreateNamedEntity, engfunc ( EngFunc_AllocString, "info_target" ) )
	
	set_pev ( ent, pev_classname, CLASS_NAME ) //  
	dllfunc ( DLLFunc_Spawn, ent )
	engfunc ( EngFunc_SetOrigin, ent, position )
	set_pev ( ent, pev_movetype, MOVETYPE_FLY )
	set_pev ( ent, pev_solid, SOLID_TRIGGER )
	engfunc ( EngFunc_SetSize, ent, mins, maxs )
	
	set_pev ( ent, pev_iuser1, zm )
	
	return ent
}
//--------------------------------------
public FindAllZones ()
{
	new entity = -1
	i_MaxZones = 0
	while ( ( entity = engfunc ( EngFunc_FindEntityByString, entity, "classname", CLASS_NAME ) ) )
	{
		zone[i_MaxZones] = entity
		i_MaxZones++
	}
}

public ShowAllZones ()
{
	FindAllZones ()
	
	for ( new i; i < i_MaxZones; i++ )
	{
		new z = zone[i]
		remove_task ( TASK_BASIS_SHOWZONES + z )
		set_task ( 0.2, "ShowZoneBox", TASK_BASIS_SHOWZONES + z, _, _, "b" )
	}
}

public InitNaiMenu ( id )
{
	if ( !( get_user_flags ( id ) & ADMIN_RCON ) )
		return PLUGIN_CONTINUE
	
	g_Editor = id
	
	FindAllZones ()
	ShowAllZones ()
	
	set_task ( 0.1, "OpenLocMenu", id )

	return PLUGIN_HANDLED
}

public ShowZoneBox ( entity )
{
	entity -= TASK_BASIS_SHOWZONES
	
	if ( ( !pev_valid ( entity ) ) || !g_Editor )
		return
	
	new Float:pos[3], Float:editorpos[3]
	
	pev ( entity, pev_origin, pos )
	pev ( g_Editor, pev_origin, editorpos )
	
	if ( entity == zone[Index] )
		DrawLine(editorpos[0], editorpos[1], editorpos[2] - 16.0, pos[0], pos[1], pos[2], { 255, 0, 0} )
	
	new Float:hitpoint[3]
	fm_trace_line(-1, editorpos, pos, hitpoint)
	
	new Float:dh = vector_distance ( editorpos, pos ) - vector_distance ( editorpos, hitpoint )
	if ( ( floatabs ( dh ) > 128.0 ) && ( entity != zone[Index] ) )
		return
	
	new Float:mins[3], Float:maxs[3]
	pev ( entity, pev_mins, mins )
	pev ( entity, pev_maxs, maxs )
	
	mins[0] += pos[0]
	mins[1] += pos[1]
	mins[2] += pos[2]
	maxs[0] += pos[0]
	maxs[1] += pos[1]
	maxs[2] += pos[2]
	
	new g_ZoneColorYellow[3] = { 255, 255, 0 }, g_ZoneColorRed[3] = { 255, 0, 0 }, color[3] = { 0, 255, 50 }
	//  
	DrawLine ( mins[0], mins[1], mins[2], mins[0], maxs[1], mins[2], Direction == 2?(g_ZoneColorRed):(Direction == 0?g_ZoneColorRed:color))//5
	DrawLine ( mins[0], maxs[1], mins[2], maxs[0], maxs[1], mins[2], Direction == 2?(g_ZoneColorRed):(Direction == 1?g_ZoneColorYellow:color))//8
	DrawLine ( maxs[0], maxs[1], mins[2], maxs[0], mins[1], mins[2], Direction == 2?(g_ZoneColorRed):(Direction == 0?g_ZoneColorYellow:color))//9
	DrawLine ( mins[0], mins[1], mins[2], maxs[0], mins[1], mins[2], Direction == 2?(g_ZoneColorRed):(Direction == 1?g_ZoneColorRed:color))//4
	
	if ( entity != zone[Index] )
		return
	// 
	DrawLine ( mins[0], mins[1], maxs[2], mins[0], maxs[1], maxs[2], Direction == 2?(g_ZoneColorYellow):(Direction == 0?g_ZoneColorRed:color))//12
	DrawLine ( maxs[0], maxs[1], maxs[2], mins[0], maxs[1], maxs[2], Direction == 2?(g_ZoneColorYellow):(Direction == 1?g_ZoneColorYellow:color))//1
	DrawLine ( maxs[0], maxs[1], maxs[2], maxs[0], mins[1], maxs[2], Direction == 2?(g_ZoneColorYellow):(Direction == 0?g_ZoneColorYellow:color))//2
	DrawLine ( maxs[0], mins[1], maxs[2], mins[0], mins[1], maxs[2], Direction == 2?(g_ZoneColorYellow):(Direction == 1?g_ZoneColorRed:color))//11
	// 
	DrawLine ( mins[0], mins[1], mins[2], mins[0], mins[1], maxs[2], Direction == 1?(g_ZoneColorRed):(Direction == 0?g_ZoneColorRed:color))//6
	DrawLine ( maxs[0], mins[1], mins[2], maxs[0], mins[1], maxs[2], Direction == 1?(g_ZoneColorRed):(Direction == 0?g_ZoneColorYellow:color))//10
	
	DrawLine ( maxs[0], maxs[1], maxs[2], maxs[0], maxs[1], mins[2], Direction == 1?(g_ZoneColorYellow):(Direction == 0?g_ZoneColorYellow:color))//3
	DrawLine ( mins[0], maxs[1], maxs[2], mins[0], maxs[1], mins[2], Direction == 1?(g_ZoneColorYellow):(Direction == 0?g_ZoneColorRed:color)) // 7
}

public DrawLine ( Float:x1, Float:y1, Float:z1, Float:x2, Float:y2, Float:z2, color[3] )
{
	message_begin ( MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, _, g_Editor )
	write_byte ( TE_BEAMPOINTS )
	write_coord ( floatround( x1 ) )
	write_coord ( floatround( y1 ) )
	write_coord ( floatround( z1 ) )
	write_coord ( floatround( x2 ) )
	write_coord ( floatround( y2 ) )
	write_coord ( floatround( z2 ) )
	write_short ( g_Dot )
	write_byte ( 1 )		//  
	write_byte ( 1 )		//  
	write_byte ( 4 )		//   0.1'
	write_byte ( 4 )		// 
	write_byte ( 0 ) 		// 
	write_byte ( color[0] )   	// r, g, b
	write_byte ( color[1] )  	// r, g, b
	write_byte ( color[2] )   	// r, g, b
	write_byte ( 250 ) 	// 
	write_byte ( 0 )   		// 
	message_end()
}
//-----------------------------------------
public OpenLocMenu ( id )
{
	new menu[512], len, zm = -1,
	menukeys = MENU_KEY_0 + MENU_KEY_4 + MENU_KEY_9 //    ,   
	
	if ( pev_valid ( zone[Index] ) )
		zm = pev ( zone[Index], pev_iuser1 )
	
	len += formatex ( menu[len], charsmax ( menu ) - len, "\y  %L\w", id, "MENU_TITLE" )
	len += formatex ( menu[len], charsmax ( menu ) - len, "^n<<%i %L", i_MaxZones, id, "MENU_EXIST" )
	
	if (zm != -1)
	{
		menukeys += MENU_KEY_1 + MENU_KEY_2 + MENU_KEY_3 //   1 2 3
		len += formatex ( menu[len], charsmax ( menu ) - len, " \y|\w (%L #%i -> '\y%s\w')>>", id, "MENU_CURRENT", Index + 1, zm>i_MaxNames?"\rError\w":g_LocNames[zm])
		len += formatex ( menu[len], charsmax ( menu ) - len, "^n^n\r1.\w %L", id, "MENU_EDIT" ) // 1
		len += formatex ( menu[len], charsmax ( menu ) - len, "^n \y          2\w <- %L     \y3\w -> %L", id, "MENU_PREVIOUS", id, "MENU_NEXT" )
	}
	
	len += formatex(menu[len], charsmax(menu) - len, "^n\r4.\w %L", id, "MENU_CREATE" ) // 4
	
	if (zm != -1)
	{
		menukeys += MENU_KEY_6 //   6
		len += formatex ( menu[len], charsmax ( menu ) - len, "^n^n\r6. %L", id, "MENU_DELETE" )
	}
	
	len += formatex ( menu[len], charsmax ( menu ) - len, "^n^n\r9.\y %L", id, "MENU_SAVE" ) // 9
	len += formatex ( menu[len], charsmax ( menu ) - len, "^n\r0.\w %L", id, "MENU_EXIT" ) // 0
	
	show_menu ( id, menukeys, menu, -1, "MainMenu" )
	
	client_cmd ( id, "spk sound/buttons/button9.wav" )
}

public MainMenuAction ( id, i_Key )
{
	switch ( i_Key ) // key = ( key == 10 ) ? 0 : key + 1
	{
		case 0:
		{
			if ( pev_valid ( zone[Index] ) )
				OpenEditMenu ( id )
			else
				OpenLocMenu ( id )
		}
		case 1: // 
		{
			Index = (Index > 0) ? Index - 1 : Index
			OpenLocMenu ( id )
		}
		case 2: // 
		{
			Index = (Index < i_MaxZones - 1) ? Index + 1 : Index
			OpenLocMenu ( id )
		}
		case 3: // 
		{
			if ( i_MaxZones < 100 - 1 )
			{
				new Float:position[3]
				pev ( id, pev_origin, position )
				new entity = CreateZone ( position, Float:{ -32.0, -32.0, -32.0 }, Float:{ 32.0, 32.0, 32.0 }, 1 )
				FindAllZones()
				for ( new c; c < i_MaxZones; c++ )
				{
					if ( zone[c] == entity )
						Index = c
				}
				ShowAllZones()
				OpenEditMenu ( id )
			}
			else
			{
				client_print(id, print_chat, "[NAI] To many areas")
				client_cmd ( id, "spk sound/buttons/button10.wav" )
				set_task ( 0.5, "OpenLocMenu", id )
			}
		}
		case 5: // 
		{
			OpenKillMenu ( id )
		}
		case 8: // 
		{
			g_Editor = 0
			Save_Zones ( id )
		}
		case 9:
		{
			g_Editor = 0
		}
	}
}

public OpenEditMenu ( id )
{
	new menu[354], dir[3], len, zm = -1, menukeys = MENU_KEY_0 + MENU_KEY_1 + MENU_KEY_2 + MENU_KEY_4 + MENU_KEY_5 + MENU_KEY_6 + MENU_KEY_7 + MENU_KEY_8
	
	len += formatex ( menu[len], charsmax ( menu ) - len, "\y%L\w^n", id, "MENU_TILTE_EDIT" )
	
	if ( pev_valid ( zone[Index] ) )
		zm = pev ( zone[Index], pev_iuser1 )
	
	if ( zm != -1 )
		len += formatex ( menu[len], charsmax(menu) - len, "^n\r1.\w %L -> '\y%s\w'", id, "MENU_CURRENT", zm>i_MaxNames?"\rError\w":g_LocNames[zm]) // 1
	
	switch ( Direction )
	{
		case 0:
			formatex ( dir, 2, "X" )
		case 1:
			formatex ( dir, 2, "Y" )
		case 2:
			formatex ( dir, 2, "Z" )
	}
	
	len += formatex(menu[len], charsmax(menu) - len, "^n\r2.\w %L", id, "MENU_SIZE_STEP", setupunits ) // 2
	len += formatex(menu[len], charsmax(menu) - len, "^n\r4.\w %L '\d%s\w'", id, "MENU_SIZE_INIT", dir ) // 4
	len += formatex(menu[len], charsmax(menu) - len, "^n \r          5 <- %L       6 -> %L\w", id, "MENU_STRIP", id, "MENU_WIDER" ) // 5 6
	len += formatex(menu[len], charsmax(menu) - len, "^n \y          7 <- %L       8 -> %L\w^n^n", id, "MENU_STRIP", id, "MENU_WIDER" ) // 7 8
	len += formatex(menu[len], charsmax(menu) - len, "^n\r0.\w %L", id, "MENU_BACK" ) // 0
	
	show_menu ( id, menukeys, menu, -1, "EditMenu" )
	
	client_cmd ( id, "spk sound/buttons/lightswitch2.wav" )
}

public EditMenuAction ( id, i_Key )
{
	switch ( i_Key )
	{
		case 0: //  
		{
			OpenNameMenu ( id, 0 )
		}
		case 1: // 
		{
			setupunits = (setupunits < 100) ? setupunits * 10 : 1
			OpenEditMenu ( id )
		}
		case 3: //     
		{
			Direction = ( Direction < 2 ) ? Direction + 1 : 0
			OpenEditMenu ( id )
		}
		case 4: //  "mins" /    -> ""
		{
			ResizeLines ( 0, 1 )
			OpenEditMenu ( id )
		}
		case 5: //  "mins" /    -> ""
		{
			ResizeLines ( 1, 1 )
			OpenEditMenu ( id )
		}
		case 6: //  "maxs" /    -> ""
		{
			ResizeLines ( 0, 0 )
			OpenEditMenu ( id )
		}
		case 7: //  "maxs" /    -> ""
		{
			ResizeLines ( 1, 0 )
			OpenEditMenu ( id )
		}
		case 9:
		{
			OpenLocMenu ( id )
		}
	}
}

public ResizeLines ( direction, color )
{
	new entity = zone[Index], Float:pos[3], Float:mins[3], Float:maxs[3]
	pev ( entity, pev_origin, pos )
	pev ( entity, pev_mins, mins )
	pev ( entity, pev_maxs, maxs )
	
	if( direction ) // 
	{
		mins[Direction] -= float(setupunits) / 2.0
		maxs[Direction] += float(setupunits) / 2.0
		
		// 
		color ? (pos[Direction] -= float(setupunits) / 2.0) : (pos[Direction] += float(setupunits) / 2.0)
	}
	else // 
	{
		if ((floatabs(mins[Direction]) + maxs[Direction]) < setupunits + 1) return
		mins[Direction] += float(setupunits) / 2.0
		maxs[Direction] -= float(setupunits) / 2.0
		
		// 
		color ? (pos[Direction] += float(setupunits) / 2.0) : (pos[Direction] -= float(setupunits) / 2.0)
	}
		
	set_pev ( entity, pev_origin, pos )
	engfunc ( EngFunc_SetSize, entity, mins, maxs )
}

public OpenKillMenu ( id )
{
	new menu[256]
	
	format ( menu, sizeof menu - 1, "%L^n\y1\w - %L^n  \r0\w - %L", id, "MENU_TITLE_DELETE", id, "MENU_NO", id, "MENU_YES" )
	
	show_menu ( id, MENU_KEY_1 + MENU_KEY_0, menu, -1, "KillMenu" )
	client_cmd ( id, "spk sound/debris/bustglass1.wav" )
}

public KillMenuAction ( id, i_Key )
{
	switch ( i_Key )
	{
		case 0:
			client_print ( id, print_chat, "[NAI] Area not deleted")
		case 9:
		{
			engfunc(EngFunc_RemoveEntity, zone[Index])
			Index--
			if (Index < 0) Index = 0
			client_print ( id, print_chat, "[NAI] Area deleted" )
			FindAllZones ()
		}
	}
	OpenLocMenu ( id )
}

public Save_Zones ( id )
{
	new s_File[64], s_MapName[32]
	get_configsdir ( s_File, sizeof s_File -1 )
	get_mapname ( s_MapName, sizeof s_MapName - 1 )
	
	format ( s_File, sizeof s_File -1, "%s/navigation_area", s_File )
	if (!dir_exists ( s_File ) ) mkdir ( s_File )
	
	format( s_File, sizeof s_File -1, "%s/%s.nai", s_File , s_MapName )
	delete_file ( s_File )
	
	FindAllZones ()
	
	new s_Name[32], s_Out[64]
	get_user_name ( id, s_Name, sizeof s_Name - 1 )
	formatex ( s_Out, sizeof s_Out - 1, "// Created by %s^n", s_Name )
	write_file ( s_File, s_Out )
	
	for(new i; i < i_MaxZones; i++)
	{
		new z = zone[i]
		new zm = pev(z, pev_iuser1) //  
		
		new Float:pos[3], Float:mins[3], Float:maxs[3]
		pev(z, pev_origin, pos)
		pev(z, pev_mins, mins)
		pev(z, pev_maxs, maxs)
		
		new output[500]
		format(output, sizeof output - 1, "%.1f %.1f %.1f %.1f %.1f %.1f", pos[0], pos[1], pos[2], mins[0], mins[1], mins[2])
		format(output, sizeof output - 1, "%s %.1f %.1f %.1f %d", output, maxs[0], maxs[1], maxs[2], zm)
		
		replace_all ( output, sizeof output - 1, ".0", "" ) // I don't understend, but %.0f doesn't work :/
		
		write_file ( s_File, output )
	}
	
	client_print ( id, print_chat, "[NAI] Saved" )
}

public OpenNameMenu ( id, i_Page )
{
	new s_Str[64]
	
	formatex ( s_Str, charsmax(s_Str), "%L #%d (%s)", id, "MENU_TITLE_NAME", Index,g_LocNames[pev(zone[Index],pev_iuser1 )])
	g_NameMenu = menu_create ( s_Str,"MenuAction_Name" )
	
	for ( new i; i < i_MaxNames; i++ )
	{
		formatex ( s_Str,sizeof s_Str - 1,"%L", id, g_LocNames[i][1] )
		menu_additem ( g_NameMenu,s_Str )
	}
	
	formatex ( s_Str, charsmax(s_Str), "%L", id, "MENU_BACK" )
	menu_setprop ( g_NameMenu, MPROP_BACKNAME, s_Str )
	formatex ( s_Str, charsmax(s_Str), "%L", id, "MENU_NEXT" )
	menu_setprop ( g_NameMenu, MPROP_NEXTNAME, s_Str )
	formatex ( s_Str, charsmax(s_Str), "%L", id, "MENU_EXIT" )
	menu_setprop ( g_NameMenu, MPROP_EXITNAME, s_Str )
	
	menu_display ( id, g_NameMenu, i_Page )
}

public MenuAction_Name ( id, menu, i_Key )
{
	new i_Null, i_Page
	player_menu_info ( id, i_Null, i_Null, i_Page )
	switch ( i_Key )
	{
		case MENU_BACK: // 
		{
			OpenNameMenu ( id, i_Page-- )
			return PLUGIN_HANDLED
		}
		case MENU_MORE: // 
		{
			OpenNameMenu ( id, i_Page++ )
			return PLUGIN_HANDLED
		}
		case MENU_EXIT: // 
		{
			menu_destroy ( g_NameMenu )
			OpenEditMenu ( id )
			return PLUGIN_HANDLED
		}
		default:
		{
			set_pev ( zone[Index], pev_iuser1, i_Key )
			OpenEditMenu ( id )
			return PLUGIN_HANDLED
		}
	}
	return PLUGIN_HANDLED
}

stock fm_trace_line ( ignoreent, const Float:start[3], const Float:end[3], Float:ret[3] )
{
	engfunc ( EngFunc_TraceLine, start, end, ignoreent == -1 ? 1 : 0, ignoreent, 0 )

	new ent = get_tr2 ( 0, TR_pHit )
	get_tr2 ( 0, TR_vecEndPos, ret )

	return pev_valid ( ent ) ? ent : 0
}

public Hook_SayTeam ( id )
{
	if ( !i_MaxZones || !get_pcvar_num ( g_Enabled ) )
		return PLUGIN_CONTINUE
	
	new s_Msg[256]
	read_args ( s_Msg, sizeof s_Msg - 1 )
	
	remove_quotes ( s_Msg )
	
	if ( !strlen ( s_Msg ) || s_Msg[0] == '@' ||  s_Msg[0] == '!' ||  s_Msg[0] == '/')
		return PLUGIN_CONTINUE
	
	new s_Name[32], s_NewMsg[256]
	get_user_name ( id, s_Name, sizeof s_Name - 1)
	
	formatex ( s_NewMsg, sizeof s_NewMsg - 1, "^1%s(%s)^3 %s^1 @^4 %s^1 :  %s", is_user_alive(id) ? "" : "*DEAD*", g_TeamNames[get_user_team(id)], s_Name, g_LocNames[g_LastLocation[id]][1], s_Msg )
	client_printcolor ( id, s_NewMsg )
	server_print ( "(%s) %s : %s", g_TeamNames[get_user_team(id)], s_Name, s_Msg )
	
	return PLUGIN_HANDLED
}

stock client_printcolor(const sender_id, const input[], any:...)
{
	if ( g_Duplicated[sender_id] ) // Fixes some problems with POD Bot
		return
	
	new s_Players[32], i_Num, sender_team = get_user_team ( sender_id )
	get_players( s_Players, i_Num)
	
	for ( new i; i < i_Num ; i++ )
	{
		new id = s_Players[i]
		
		if (is_user_connected ( id ) && sender_team == get_user_team ( id ) )
		{
			message_begin ( MSG_ONE, get_user_msgid ( "SayText" ), _, id )
			write_byte ( id )
			write_string( input )
			message_end ()
		}
	}
	
	g_Duplicated[sender_id] = true
	set_task ( 0.5, "Avoid_Duplicated", sender_id+TASK_DUBLICATED )
}

public Avoid_Duplicated ( id )
	g_Duplicated[id-TASK_DUBLICATED] = false

/*
public Fwd_SetVoice(receiver, sender, bool:bListen)
{
	// Doesn't work :/
	
	if(!is_user_connected(receiver) || !is_user_connected(sender) || receiver == sender)
		return FMRES_IGNORED
	
	message_begin(MSG_ONE, get_user_msgid("BotVoice"), _, receiver )
	write_byte(bListen) // Show/Hide
	write_byte(sender) // Sender id
	message_end()
	
	return FMRES_SUPERCEDE
}
*/
