////////////////////////////////////////////
// Monster Control  (by SamTsuki & ExTr)  //
////////////////////////////////////////////

#include < amxmodx >
#include < amxmisc >
#include < engine >
#include < fakemeta >
#include < fakemeta_util >
#include < hamsandwich >
#include < xs >
#include < fun >

#define MAXDISTANCE	4000.0

//////////////////////////////////////////////////////////////////////////////////
/////                               Oberon                                   /////
//////////////////////////////////////////////////////////////////////////////////

#define OBERON_CLASSNAME 		"npc_oberon"

#define HEALTH_OBERON_MULTI		1000.0
#define SPEED_OBERON			300.0
#define RADIOUS				400.0
#define L_ATTACK_RADIOUS		150.0
#define H_ATTACK_RADIOUS		150.0
#define POISON_RADIOUS			175.0
#define BW_MAX_HEIGHT			700.0

#define ANIM_IDLE_OBERON		2
#define ANIM_WALK_OBERON		3
#define ANIM_ATTACK_OBERON		6
#define ANIM_ATTACK2_OBERON		7
#define BLAST_WAVE_OBERON		8
#define ANIM_BOMB_OBERON		9
#define ANIM_DIE_OBERON			20

// Claws Animations

#define C_ANIM_SCENE_OBERON		11
#define C_ANIM_IDLE_OBERON		12
#define C_ANIM_WALK_OBERON		13
#define C_ANIM_ATTACK_OBERON		14
#define C_ANIM_ATTACK2_OBERON		15
#define C_BLAST_WAVE_OBERON		16

//////////////////////////
//	Damage		//
//////////////////////////

// No Claws
#define L_ATTACK_MIN_DMG		5
#define L_ATTACK_MAX_DMG		5
#define H_ATTACK_MIN_DMG		10
#define H_ATTACK_MAX_DMG		10

// Claws
#define C_L_ATTACK_MIN_DMG		10
#define C_L_ATTACK_MAX_DMG		10
#define C_H_ATTACK_MIN_DMG		20
#define C_H_ATTACK_MAX_DMG		20

// Blast Wave
#define BW_MAX_DMG			30
#define BW_MIN_DMG			10

// Bombs
#define POISON_DMG			20

new const oberon_model[] = 		"models/MonsterAI/oberon.mdl"
new const oberon_bomb_model[] = 	"models/MonsterAI/oberon_bomb.mdl"
new rocks_gibs;

new const oberon_hurt_sound[] = 	"MonsterAI/oberon_hurt_01.wav"
new const oberon_attack_sound[] = 	"MonsterAI/oberon_attack_1.wav"
new const oberon_die_sound[] = 		"MonsterAI/oberon_death_1.wav"
new const oberon_l_attack_sound[] = 	"MonsterAI/oberon_l_attack.wav"
new const oberon_h_attack_sound[] = 	"MonsterAI/oberon_h_attack.wav"
new const oberon_bw_sound[] = 		"MonsterAI/oberon_bw.wav"
new const oberon_earth_sound[] = 	"MonsterAI/oberon_earth.wav"
new const oberon_claws_deploy_sound[] = "MonsterAI/oberon_claws_deploy.wav"
new const oberon_claws_out_sound[] = 	"MonsterAI/oberon_claws_out.wav"
new const oberon_bomb_deploy_sound[] =	"MonsterAI/oberon_bomb_deploy.wav"
new const oberon_bomb_explode_sound[] =	"MonsterAI/oberon_bomb_explode.wav"

const UNIT_SECOND = 			(1<<12);
const FFADE_IN = 			0x0000;

///////////////////////////////////
//				 //
//           Variables		 //
//				 //
///////////////////////////////////

new Float: visibility[ 2058 ];
new bool: bwave[ 2058 ], bool: claws[ 2058 ], bool: has_bombs[ 2058 ];

new g_sprRing, g_msgScreenShake, g_msgScreenFade;
new g_szSmokeSprites;
new spr_dot;
new mdl_target[] = "models/MonsterAI/target.mdl"

new Float: max_health[ 2058 ];

new oberon_control[ 33 ];
new bool: can_move[ 33 ];
new bool: can_switch[ 33 ];
new camera[ 33 ];
new Float: origin[ 33 ][ 3 ];
new Float: mins[ 2058 ][ 3 ];
new Float: maxs[ 2058 ][ 3 ];

new g_victim[ 33 ];
new start[ 33 ][ 3 ];
new stop[ 33 ][ 3 ];
new target_ent[ 33 ];

new bool: in_claws_scene[ 33 ];

new g_MsgSync;

///////////////////////////////////
//				 //
//           Init		 //
//				 //
///////////////////////////////////

public plugin_init( )
{
	register_plugin( "Monster Control", "1.0", "Sam Tsuki" );
    
	register_think( OBERON_CLASSNAME, "oberon_think" );
	register_think( "poison", "poison_think" );
	register_think( "target_model", "target_model_think" );
	register_touch( "oberon_bomb", "*", "bomb_touch" );
    
	register_clcmd( "say /create_oberon", "create_oberon" );

	register_forward( FM_AddToFullPack, "fw_addtofullpack", 1 );
	
	register_event( "CurWeapon", "monster_weapons", "b" );

	register_event( "DeathMsg", "player_death", "a", "1>0" );
	register_event( "ResetHUD", "Event_ResetHUD", "b" );
	register_logevent("round_end",   2, "1=Round_End");

	RegisterHam( Ham_Killed, "info_target", "monster_killed" );
	RegisterHam( Ham_TraceAttack, "info_target", "npc_TraceAttack" );
	
	g_msgScreenShake = get_user_msgid( "ScreenShake" );
	g_msgScreenFade = get_user_msgid( "ScreenFade" );

	g_MsgSync = CreateHudSyncObj();
}

///////////////////////////////////
//				 //
//           Precache		 //
//				 //
///////////////////////////////////

public plugin_precache( )
{
	//Oberon - BOSS
	engfunc( EngFunc_PrecacheModel, oberon_model );
	engfunc( EngFunc_PrecacheModel, oberon_bomb_model );
	engfunc( EngFunc_PrecacheModel, mdl_target );
	rocks_gibs = precache_model( "models/MonsterAI/rocksgibs.mdl" );
	g_szSmokeSprites = precache_model( "sprites/gas_puff_01r.spr" );
	
	precache_sound( oberon_hurt_sound );
	precache_sound( oberon_attack_sound );
	precache_sound( oberon_die_sound );
	precache_sound( oberon_l_attack_sound );
	precache_sound( oberon_h_attack_sound );
	precache_sound( oberon_bw_sound );
	precache_sound( oberon_earth_sound );
	precache_sound( oberon_claws_deploy_sound );
	precache_sound( oberon_claws_out_sound );
	precache_sound( oberon_bomb_deploy_sound );
	precache_sound( oberon_bomb_explode_sound );
	
	g_sprRing = precache_model( "sprites/shockwave.spr" );
	spr_dot = precache_model("sprites/dot.spr");

	precache_model("models/camera.mdl")
}

///////////////////////////////////
//				 //
//           Monster		 //
//				 //
///////////////////////////////////

public create_oberon( id )
{
	if( oberon_control[ id ] || !is_user_alive( id ) )
		return 0;

	fm_strip_user_weapons( id );
	entity_set_float( id, EV_FL_takedamage, 0.0 );
	entity_set_int( id, EV_INT_solid, 0 );
	entity_set_int( id, EV_INT_movetype, MOVETYPE_NOCLIP );
	Util_SetRendering( id, kRenderFxGlowShell, { 0.0, 0.0, 0.0 }, kRenderTransAlpha, 0.0 );

	new ent = create_entity( "info_target" );
	
	new Float: iOrigin[ 3 ];
	entity_get_vector( id, EV_VEC_origin, iOrigin );
	entity_set_origin( ent, iOrigin );
    
	max_health[ ent ] = HEALTH_OBERON_MULTI * get_playersnum( );
	entity_set_float( ent, EV_FL_takedamage, 1.0 );
	entity_set_float( ent, EV_FL_health, max_health[ ent ] );
    
	entity_set_string( ent, EV_SZ_classname, OBERON_CLASSNAME );
	entity_set_model( ent, oberon_model );
	entity_set_int( ent, EV_INT_solid, 2 );

	entity_set_edict( ent, EV_ENT_owner, id );
    
	entity_set_int( ent, EV_INT_movetype, MOVETYPE_PUSHSTEP );
    
	set_pev( ent, pev_enemy, 0 );
    
	entity_set_byte( ent, EV_BYTE_controller1, 125 );
	entity_set_byte( ent, EV_BYTE_controller2, 125 );
	entity_set_byte( ent, EV_BYTE_controller3, 125 );
	entity_set_byte( ent, EV_BYTE_controller4, 125 );
    
	maxs[ ent ][ 0 ] = 32.0;
	maxs[ ent ][ 1 ] = 32.0;
	maxs[ ent ][ 2 ] = 150.0;
	mins[ ent ][ 0 ] = -32.0;
	mins[ ent ][ 1 ] = -32.0;
	mins[ ent ][ 2 ] = -36.0;

	entity_set_size( ent, mins[ ent ], maxs[ ent ] );

	bwave[ ent ] = false;
	claws[ ent ] = false;
	in_claws_scene[ id ] = false;
	has_bombs[ ent ] = true;
	can_move[ id ] = true;
	can_switch[ id ] = true;
	g_victim[ id ] = 0;
 
	play_anim( ent, ANIM_IDLE_OBERON, 1.0 );
    
	drop_to_floor( ent );
    
	RegisterHamFromEntity( Ham_TakeDamage, ent, "fw_zb_takedmg" );

	oberon_control[ id ] = ent;

	create_camera( id );
	view_camera( id );

	entity_set_float( ent, EV_FL_nextthink, halflife_time() + 0.01 );
    
	return 1;
}

public oberon_think( ent )
{
	// If the monster has 0 velocity its animation bugs
	new Float: flAngles[ 3 ];
	
	pev( ent, pev_angles, flAngles );
	flAngles[ 0 ] = 0.0;

	new Float: Direction[ 3 ];
	
	angle_vector( flAngles, ANGLEVECTOR_FORWARD, Direction );
	xs_vec_mul_scalar( Direction, 0.01, Direction );

	new Float: speed[ 3 ];
	entity_get_vector( ent, EV_VEC_velocity, speed );
	speed[ 0 ] += Direction[ 0 ];
	speed[ 1 ] += Direction[ 1 ];
	new owner = entity_get_edict( ent, EV_ENT_owner );
	if( speed[ 2 ] > 0.0 && can_move[ owner ] )
		speed[ 2 ] = 0.0;
	entity_set_vector( ent, EV_VEC_velocity, speed );
	entity_set_float( ent, EV_FL_nextthink, get_gametime() + 0.01 );
}

///////////////////////////////////
//				 //
//         Takedamage		 //
//				 //
///////////////////////////////////

public fw_zb_takedmg( victim, inflictor, attacker, Float:damage, damagebits )
{
	if( is_valid_ent( victim ) )
	{
		new classname[ 64 ];
		pev( victim, pev_classname, classname, charsmax( classname ) );
	
		if( equali( classname, OBERON_CLASSNAME ) )
			emit_sound( victim, CHAN_VOICE, oberon_hurt_sound,  VOL_NORM, ATTN_IDLE, 0, PITCH_HIGH );
	}
}

///////////////////////////////////
//				 //
//         Die function		 //
//				 //
///////////////////////////////////

public monster_killed( ent, attacker )
{	
	new classname[ 64 ];
	pev( ent, pev_classname, classname, charsmax( classname ) );

	if( !equali( classname, OBERON_CLASSNAME ) )
		return;

	new Float: Origin[ 3 ], Float: Angles[ 3 ];

	pev( ent, pev_origin, Origin );
	pev( ent, pev_angles, Angles );
	
	remove_task( ent );
	
	new ent2 = create_entity( "info_target" );
	
	entity_set_origin( ent2, Origin );
	entity_set_vector( ent2, EV_VEC_angles, Angles );
    
	entity_set_string( ent2, EV_SZ_classname, "temp_zb" );
    
	new Float: maxs[ 3 ] = { 16.0, 16.0, 36.0 };
	new Float: mins[ 3 ] = { -16.0, -16.0, -36.0 };
	entity_set_size( ent2, mins, maxs );
    
	drop_to_floor( ent2 );
	
	entity_set_model( ent2, oberon_model );
	play_anim( ent2, ANIM_DIE_OBERON, 1.0 );
	emit_sound( ent2, CHAN_VOICE, oberon_die_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
    
	visibility[ ent2 ] = 255.0

	new owner = entity_get_edict( ent, EV_ENT_owner );
	if( is_user_alive( owner ) )
		ExecuteHamB( Ham_Killed, owner, attacker, 0 );

	set_task( 10.0, "fadeout", ent2 );
}

public fadeout( ent2 )
{
	visibility[ ent2 ] -= 5;
	Util_SetRendering( ent2, kRenderFxGlowShell, { 0.0, 0.0, 0.0 }, kRenderTransAlpha, visibility[ ent2 ] );
	
	if( visibility[ ent2 ] > 0 )
		set_task( 0.1, "fadeout", ent2 );
	else
		remove_entity( ent2 );
}

///////////////////////////////////
//				 //
//        Monster Brain		 //
//				 //
///////////////////////////////////

public client_PreThink( id )
{
	if( !is_user_alive( id ) || !oberon_control[ id ] )
		return;
	
	new Float: health = entity_get_float( oberon_control[ id ], EV_FL_health );
	new targ_name[ 32 ];
	if( g_victim[ id ] )
		get_user_name( g_victim[ id ], targ_name, 31 );
	else
		targ_name = "None";
	new ulti_rdy[ 32 ];
	if( has_bombs[ oberon_control[ id ] ] )
		ulti_rdy = "Yes";
	else
		ulti_rdy = "No";

	set_hudmessage( 255, 255, 255, 0.1, 0.50, 0, 0.1, 1.0, 0.1, 0.1, -1 );
	ShowSyncHudMsg( id, g_MsgSync, "Health: %i^nTarget: %s^nUltimate Ready: %s", floatround( health ), targ_name, ulti_rdy );

	if(camera[id])
	{
		new Float: iOrigin[ 3 ], Float: CamOrigin[ 3 ];
		entity_get_vector( id, EV_VEC_origin, iOrigin );
		new Float: v_angle[ 3 ], Float: angles[ 3 ];
		entity_get_vector( id, EV_VEC_angles, angles );
		entity_get_vector( id, EV_VEC_v_angle, v_angle );
		for( new Float: i = 200.0; i >= 0.0; i -= 0.1 )
		{
			CamOrigin[ 0 ] = floatcos( v_angle[ 1 ], degrees ) * -i;
			CamOrigin[ 1 ] = floatsin( v_angle[ 1 ], degrees ) * -i;
			CamOrigin[ 2 ] = i - ( i / 4 );
			CamOrigin[ 0 ] += iOrigin[ 0 ];
			CamOrigin[ 1 ] += iOrigin[ 1 ];
			CamOrigin[ 2 ] += iOrigin[ 2 ];
			if( PointContents( CamOrigin ) != CONTENTS_SOLID && PointContents( CamOrigin ) != CONTENTS_SKY )
				break;
		}
		v_angle[ 0 ] = 20.0
		entity_set_origin( camera[ id ], CamOrigin );
		entity_set_vector( camera[ id ], EV_VEC_angles, v_angle );
		entity_set_vector( camera[ id ], EV_VEC_v_angle, v_angle );
	}

	if( !g_victim[ id ] )
	{
		g_victim[ id ] = FindClosestEnemy( oberon_control[ id ] );
		if( target_ent[ id ] )
		{
			remove_entity( target_ent[ id ] );
			target_ent[ id ] = 0;
		}
	}

	if( g_victim[ id ] && !can_see_fm( oberon_control[ id ], g_victim[ id ] ) )
		g_victim[ id ] = 0;

	if( g_victim[ id ] && !is_user_alive( g_victim[ id ] ) )
		g_victim[ id ] = 0;

	if( g_victim[ id ] )
	{
		get_origin_int( id, start[ id ] );
		get_origin_int( g_victim[ id ], stop[ id ] );
		if( !target_ent[ id ] )
			create_target_spr( id, g_victim[ id ] );
	}

	new Float: Ent_Origin[ 3 ];
	entity_get_vector( oberon_control[ id ], EV_VEC_origin, Ent_Origin );

	if( !claws[ oberon_control[ id ] ] && health <= max_health[ oberon_control[ id ] ] / 2 )
	{
		new Float: flAngles[ 3 ];
	
		pev( oberon_control[ id ], pev_angles, flAngles );

		new Float: Direction[ 3 ];

		//entity_set_int( oberon_control[ id ], EV_INT_movetype, MOVETYPE_FLY );
	
		angle_vector( flAngles, ANGLEVECTOR_FORWARD, Direction );
		xs_vec_mul_scalar( Direction, 1.0, Direction );
		entity_set_vector( oberon_control[ id ], EV_VEC_velocity, Direction );

		entity_set_float( oberon_control[ id ], EV_FL_takedamage, 0.0 );
		Util_SetRendering( oberon_control[ id ], kRenderFxGlowShell, { 255.0, 0.0, 0.0 }, kRenderNormal, 20.0 );

		emit_sound( oberon_control[ id ], CHAN_VOICE, oberon_bw_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );

		play_anim( oberon_control[ id ], C_ANIM_SCENE_OBERON, 1.0 );
		claws[ oberon_control[ id ] ] = true;
		in_claws_scene[ id ] = true;
		set_task( 4.0, "claws_sounds", oberon_control[ id ] );
		set_task( 7.0, "remove_shield", oberon_control[ id ] );
		set_task( 7.0, "claws_scene_end", id );
		can_move[ id ] = false;
	}
    
	new buttons = get_user_button(id)
	if( buttons & IN_FORWARD && can_move[id] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );

		new Float: Direction[ 3 ];

		entity_set_int( oberon_control[ id ], EV_INT_movetype, MOVETYPE_PUSHSTEP );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ];
		ConAngles[ 2 ] = flAngles[ 2 ];
		if( buttons & IN_MOVERIGHT )
			ConAngles[ 1 ] -= 45.0;
		if( buttons & IN_MOVELEFT )
			ConAngles[ 1 ] += 45.0;

		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		angle_vector( ConAngles, ANGLEVECTOR_FORWARD, Direction );
		xs_vec_mul_scalar( Direction, SPEED_OBERON, Direction );
		
		new Float: NewOrigin[ 3 ];

		for( new Float: iAngle = ConAngles[ 1 ] - 60.0; iAngle <= ConAngles[ 1 ] + 60.0; iAngle += 10.0 )
		{
			for( new Float: i = 0.0; i <= maxs[ oberon_control[ id ] ][ 0 ] + 1.0; i += 1.0 )
			{
				NewOrigin[ 0 ] = floatcos( iAngle, degrees ) * i;
				NewOrigin[ 1 ] = floatsin( iAngle, degrees ) * i;
				NewOrigin[ 0 ] += Ent_Origin[ 0 ];
				NewOrigin[ 1 ] += Ent_Origin[ 1 ];
				NewOrigin[ 2 ] = Ent_Origin[ 2 ] + mins[ oberon_control[ id ] ][ 2 ];
				if( PointContents( NewOrigin ) == CONTENTS_SOLID && i >= maxs[ oberon_control[ id ] ][ 0 ] )
				{
					for( new Float: i2 = 0.0; i2 <= 36.0; i2 += 1.0 )
					{
						NewOrigin[ 2 ] += i2;
						if( PointContents( NewOrigin ) != CONTENTS_SOLID )
						{
							NewOrigin[ 0 ] = Ent_Origin[ 0 ];
							NewOrigin[ 1 ] = Ent_Origin[ 1 ];
							NewOrigin[ 2 ] += -mins[ oberon_control[ id ] ][ 2 ];
							entity_set_origin( oberon_control[ id ], NewOrigin );
							break;
						}
						else
							NewOrigin[ 2 ] -= i2;
					}
					break;
				}
			}
		}

		new Float: z_speed[ 3 ];
		entity_get_vector( oberon_control[ id ], EV_VEC_velocity, z_speed );
		Direction[ 2 ] = z_speed[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_velocity, Direction );

		if( get_anim( oberon_control[ id ] ) != ANIM_WALK_OBERON && !claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], ANIM_WALK_OBERON, 1.0 );
		else if( get_anim( oberon_control[ id ] ) != C_ANIM_WALK_OBERON && claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], C_ANIM_WALK_OBERON, 1.0 );

		entity_set_float( oberon_control[ id ], EV_FL_framerate, 1.0 );
	}
	else if( buttons & IN_BACK && can_move[ id ] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );

		new Float: Direction[ 3 ];

		entity_set_int( oberon_control[ id ], EV_INT_movetype, MOVETYPE_PUSHSTEP );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ];
		ConAngles[ 2 ] = flAngles[ 2 ];
		if( buttons & IN_MOVERIGHT )
			ConAngles[ 1 ] += 45.0;
		if( buttons & IN_MOVELEFT )
			ConAngles[ 1 ] -= 45.0;

		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		angle_vector( ConAngles, ANGLEVECTOR_FORWARD, Direction );
		xs_vec_mul_scalar( Direction, -SPEED_OBERON, Direction );
		
		new Float: NewOrigin[ 3 ];

		for( new Float: iAngle = ConAngles[ 1 ] - 60.0; iAngle <= ConAngles[ 1 ] + 60.0; iAngle += 10.0 )
		{
			for( new Float: i = 0.0; i <= maxs[ oberon_control[ id ] ][ 0 ] + 1.0; i += 1.0 )
			{
				NewOrigin[ 0 ] = floatcos( iAngle, degrees ) * -i;
				NewOrigin[ 1 ] = floatsin( iAngle, degrees ) * -i;
				NewOrigin[ 0 ] += Ent_Origin[ 0 ];
				NewOrigin[ 1 ] += Ent_Origin[ 1 ];
				NewOrigin[ 2 ] = Ent_Origin[ 2 ] + mins[ oberon_control[ id ] ][ 2 ];
				if( PointContents( NewOrigin ) == CONTENTS_SOLID && i >= maxs[ oberon_control[ id ] ][ 0 ] )
				{
					for( new Float: i2 = 0.0; i2 <= 36.0; i2 += 1.0 )
					{
						NewOrigin[ 2 ] += i2;
						if( PointContents( NewOrigin ) != CONTENTS_SOLID )
						{
							NewOrigin[ 0 ] = Ent_Origin[ 0 ];
							NewOrigin[ 1 ] = Ent_Origin[ 1 ];
							NewOrigin[ 2 ] += -mins[ oberon_control[ id ] ][ 2 ];
							entity_set_origin( oberon_control[ id ], NewOrigin );
							break;
						}
						else
							NewOrigin[ 2 ] -= i2;
					}
					break;
				}
			}
		}

		new Float: z_speed[ 3 ];
		entity_get_vector( oberon_control[ id ], EV_VEC_velocity, z_speed );
		Direction[ 2 ] = z_speed[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_velocity, Direction );

		if( get_anim( oberon_control[ id ] ) != ANIM_WALK_OBERON && !claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], ANIM_WALK_OBERON, 1.0 );
		else if( get_anim( oberon_control[ id ] ) != C_ANIM_WALK_OBERON && claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], C_ANIM_WALK_OBERON, 1.0 );

		entity_set_float( oberon_control[ id ], EV_FL_framerate, -1.0 );
	}
	else if( buttons & IN_MOVERIGHT && can_move[id] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );

		new Float: Direction[ 3 ];

		entity_set_int( oberon_control[ id ], EV_INT_movetype, MOVETYPE_PUSHSTEP );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ] - 90;
		ConAngles[ 2 ] = flAngles[ 2 ];

		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		angle_vector( ConAngles, ANGLEVECTOR_FORWARD, Direction );
		xs_vec_mul_scalar( Direction, SPEED_OBERON, Direction );
		
		new Float: NewOrigin[ 3 ];

		for( new Float: iAngle = ConAngles[ 1 ] - 60.0; iAngle <= ConAngles[ 1 ] + 60.0; iAngle += 10.0 )
		{
			for( new Float: i = 0.0; i <= maxs[ oberon_control[ id ] ][ 0 ] + 1.0; i += 1.0 )
			{
				NewOrigin[ 0 ] = floatcos( iAngle, degrees ) * i;
				NewOrigin[ 1 ] = floatsin( iAngle, degrees ) * i;
				NewOrigin[ 0 ] += Ent_Origin[ 0 ];
				NewOrigin[ 1 ] += Ent_Origin[ 1 ];
				NewOrigin[ 2 ] = Ent_Origin[ 2 ] + mins[ oberon_control[ id ] ][ 2 ];
				if( PointContents( NewOrigin ) == CONTENTS_SOLID && i >= maxs[ oberon_control[ id ] ][ 0 ] )
				{
					for( new Float: i2 = 0.0; i2 <= 36.0; i2 += 1.0 )
					{
						NewOrigin[ 2 ] += i2;
						if( PointContents( NewOrigin ) != CONTENTS_SOLID )
						{
							NewOrigin[ 0 ] = Ent_Origin[ 0 ];
							NewOrigin[ 1 ] = Ent_Origin[ 1 ];
							NewOrigin[ 2 ] += -mins[ oberon_control[ id ] ][ 2 ];
							entity_set_origin( oberon_control[ id ], NewOrigin );
							break;
						}
						else
							NewOrigin[ 2 ] -= i2;
					}
					break;
				}
			}
		}

		new Float: z_speed[ 3 ];
		entity_get_vector( oberon_control[ id ], EV_VEC_velocity, z_speed );
		Direction[ 2 ] = z_speed[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_velocity, Direction );

		if( get_anim( oberon_control[ id ] ) != ANIM_WALK_OBERON && !claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], ANIM_WALK_OBERON, 1.0 );
		else if( get_anim( oberon_control[ id ] ) != C_ANIM_WALK_OBERON && claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], C_ANIM_WALK_OBERON, 1.0 );
		entity_set_float( oberon_control[ id ], EV_FL_framerate, 1.0 );
	}
	else if( buttons & IN_MOVELEFT && can_move[id] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );

		new Float: Direction[ 3 ];

		entity_set_int( oberon_control[ id ], EV_INT_movetype, MOVETYPE_PUSHSTEP );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ] + 90;
		ConAngles[ 2 ] = flAngles[ 2 ];

		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		angle_vector( ConAngles, ANGLEVECTOR_FORWARD, Direction );
		xs_vec_mul_scalar( Direction, SPEED_OBERON, Direction );
		
		new Float: NewOrigin[ 3 ];

		for( new Float: iAngle = ConAngles[ 1 ] - 60.0; iAngle <= ConAngles[ 1 ] + 60.0; iAngle += 10.0 )
		{
			for( new Float: i = 0.0; i <= maxs[ oberon_control[ id ] ][ 0 ] + 1.0; i += 1.0 )
			{
				NewOrigin[ 0 ] = floatcos( iAngle, degrees ) * i;
				NewOrigin[ 1 ] = floatsin( iAngle, degrees ) * i;
				NewOrigin[ 0 ] += Ent_Origin[ 0 ];
				NewOrigin[ 1 ] += Ent_Origin[ 1 ];
				NewOrigin[ 2 ] = Ent_Origin[ 2 ] + mins[ oberon_control[ id ] ][ 2 ];
				if( PointContents( NewOrigin ) == CONTENTS_SOLID && i >= maxs[ oberon_control[ id ] ][ 0 ] )
				{
					for( new Float: i2 = 0.0; i2 <= 36.0; i2 += 1.0 )
					{
						NewOrigin[ 2 ] += i2;
						if( PointContents( NewOrigin ) != CONTENTS_SOLID )
						{
							NewOrigin[ 0 ] = Ent_Origin[ 0 ];
							NewOrigin[ 1 ] = Ent_Origin[ 1 ];
							NewOrigin[ 2 ] += -mins[ oberon_control[ id ] ][ 2 ];
							entity_set_origin( oberon_control[ id ], NewOrigin );
							break;
						}
						else
							NewOrigin[ 2 ] -= i2;
					}
					break;
				}
			}
		}

		new Float: z_speed[ 3 ];
		entity_get_vector( oberon_control[ id ], EV_VEC_velocity, z_speed );
		Direction[ 2 ] = z_speed[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_velocity, Direction );

		if( get_anim( oberon_control[ id ] ) != ANIM_WALK_OBERON && !claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], ANIM_WALK_OBERON, 1.0 );
		else if( get_anim( oberon_control[ id ] ) != C_ANIM_WALK_OBERON && claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], C_ANIM_WALK_OBERON, 1.0 );

		entity_set_float( oberon_control[ id ], EV_FL_framerate, 1.0 );
	}
	else if( can_move[ id ] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ];
		ConAngles[ 2 ] = flAngles[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		if( get_anim( oberon_control[ id ] ) != ANIM_IDLE_OBERON && !claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], ANIM_IDLE_OBERON, 1.0 );
		else if( get_anim( oberon_control[ id ] ) != C_ANIM_IDLE_OBERON && claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], C_ANIM_IDLE_OBERON, 1.0 );
	}

	if( buttons & IN_ATTACK && can_move[ id ] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ];
		ConAngles[ 2 ] = flAngles[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		light_attack( oberon_control[ id ] );

		can_move[ id ] = false;
		if( !claws[ oberon_control[ id ] ] )
			set_task( 2.0, "can_move_again", id );
		else
			set_task( 1.5, "can_move_again", id );
	}
	if( buttons & IN_ATTACK2 && can_move[ id ] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ];
		ConAngles[ 2 ] = flAngles[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		heavy_attack( oberon_control[ id ] );

		can_move[ id ] = false;
		if( !claws[ oberon_control[ id ] ] )
			set_task( 2.7, "can_move_again", id );
		else
			set_task( 1.8, "can_move_again", id );
	}
	if( buttons & IN_USE && can_move[ id ] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ];
		ConAngles[ 2 ] = flAngles[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		emit_sound( oberon_control[ id ], CHAN_VOICE, oberon_bw_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
		if( !claws[ oberon_control[ id ] ] )
			play_anim( oberon_control[ id ], BLAST_WAVE_OBERON, 1.0 );
		else
			play_anim( oberon_control[ id ], C_BLAST_WAVE_OBERON, 1.0 );
		set_task( 0.5, "oberon_jump", oberon_control[ id ] );
		set_task( 2.0, "oberon_bw_deploy", oberon_control[ id ] );
		set_task( 2.0, "oberon_land", oberon_control[ id ] );

		can_move[ id ] = false;
		set_task( 4.0, "can_move_again", id );
	}
	if( buttons & IN_RELOAD && can_move[ id ] && has_bombs[ oberon_control[ id ] ] )
	{
		new Float: flAngles[ 3 ];
	
		pev( id, pev_angles, flAngles );
	
		new Float: ConAngles[ 3 ];
		ConAngles[ 0 ] = 0.0;
		ConAngles[ 1 ] = flAngles[ 1 ];
		ConAngles[ 2 ] = flAngles[ 2 ];
		entity_set_vector( oberon_control[ id ], EV_VEC_angles, ConAngles );

		new ent2 = create_entity( "info_target" );
		entity_set_origin( ent2, Ent_Origin );
		entity_set_int( ent2, EV_INT_movetype, MOVETYPE_NOCLIP );

		entity_set_edict( ent2, EV_ENT_owner, id );

		new Float: Direction[ 3 ], Float: Dir[ 3 ];
	
		angle_vector( flAngles, ANGLEVECTOR_FORWARD, Direction );
		xs_vec_mul_scalar( Direction, 1.0, Direction );
		entity_set_vector( oberon_control[ id ], EV_VEC_velocity, Direction );
		xs_vec_mul_scalar( Direction, 125.0, Dir );
		entity_set_vector( ent2, EV_VEC_velocity, Dir );

		set_task( 1.0, "stop_movement", ent2 );

		maxs[ oberon_control[ id ] ][ 2 ] = 36.0;
		entity_set_size( oberon_control[ id ], mins[ oberon_control[ id ] ], maxs[ oberon_control[ id ] ] );

		entity_set_float( oberon_control[ id ], EV_FL_takedamage, 0.0 );
		Util_SetRendering( oberon_control[ id ], kRenderFxGlowShell, { 255.0, 0.0, 0.0 }, kRenderNormal, 20.0 );

		emit_sound( oberon_control[ id ], CHAN_VOICE, oberon_h_attack_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );

		play_anim( oberon_control[ id ], ANIM_BOMB_OBERON, 1.0 );
		has_bombs[ oberon_control[ id ] ] = false;
		set_task( 3.0, "oberon_bomb", ent2 );
		set_task( 6.0, "oberon_bomb", ent2 );
		set_task( 9.0, "oberon_bomb", ent2 );
		set_task( 11.2, "remove_this_ent", ent2 );
		set_task( 11.2, "remove_shield", oberon_control[ id ] );
		set_task( 100.0, "bomb_cooldown", oberon_control[ id ] );
		set_task( 11.2, "can_move_again", id );

		can_move[ id ] = false;
	}
	if( buttons & IN_JUMP && g_victim[ id ] && can_switch[ id ] )
	{
		for( new i = g_victim[ id ] + 1; i != g_victim[ id ]; i++ )
		{
			if( i > get_maxplayers() )
				i = 0;
			if( !is_user_alive( i ) )
				continue;
			new Float: takedmg = entity_get_float( i, EV_FL_takedamage );
			if( can_see_fm( oberon_control[ id ], i ) && takedmg )
			{
				if( target_ent[ id ] )
				{
					remove_entity( target_ent[ id ] );
					target_ent[ id ] = 0;
				}
				g_victim[ id ] = i;
				can_switch[ id ] = false;
				break;
			}
		}
	}
	if( !(buttons & IN_JUMP) )
		can_switch[ id ] = true;
			

	entity_set_float( oberon_control[ id ], EV_FL_gravity, 1.0 );
	entity_set_origin( id, Ent_Origin );
}

public create_target_spr( id, target )
{
	new ent = create_entity( "info_target" );
	entity_set_string( ent, EV_SZ_classname, "target_model" );
	entity_set_edict( ent, EV_ENT_owner, target );
	entity_set_model( ent, mdl_target );

	new Float: origin[ 3 ];
	entity_get_vector( target, EV_VEC_origin, origin );
	origin[ 2 ] += 16.0;
	entity_set_vector( ent, EV_VEC_origin, origin );

    	entity_set_int( ent, EV_INT_movetype, MOVETYPE_NOCLIP );
	set_pev( ent, pev_rendermode, kRenderTransAlpha );
    	set_pev( ent, pev_renderamt, 0.0 );

	play_anim( ent, 0, 1.0 );

	entity_set_float( ent, EV_FL_nextthink, halflife_time() + 0.01 );

	target_ent[ id ] = ent;
}

public target_model_think( ent )
{
	new owner = entity_get_edict( ent, EV_ENT_owner );
	new Float: origin[ 3 ];
	entity_get_vector( owner, EV_VEC_origin, origin );
	origin[ 2 ] += 16.0;
	entity_set_vector( ent, EV_VEC_origin, origin );
	if( get_anim( ent ) != 0 )
		play_anim( ent, 0, 1.0 );
	entity_set_float( ent, EV_FL_nextthink, get_gametime() + 0.01 );
}

public claws_scene_end( id )
{
	if( !is_user_alive( id ) )
		return;
	can_move[ id ] = true;
}

public can_move_again( id )
{
	if( !is_user_alive( id ) || in_claws_scene[ id ] )
		return;
	can_move[ id ] = true;
}

public stop_movement( ent )
{
	if( !is_valid_ent( ent ) )
		return;

	new Float: Direction[ 3 ] = {0.0,0.0,0.0};
	entity_set_vector( ent, EV_VEC_velocity, Direction );
}

public remove_this_ent( ent )
{
	if( !is_valid_ent( ent ) )
		return;

	remove_entity( ent );
}

public claws_sounds( ent )
{
	if( !is_valid_ent( ent ) )
		return;
	emit_sound( ent, CHAN_BODY, oberon_claws_deploy_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
	set_task( 0.7, "claws_out", ent );
}

public claws_out( ent )
	emit_sound( ent, CHAN_BODY, oberon_claws_out_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );

public remove_shield( ent )
{
	if( !is_valid_ent( ent ) )
		return;

	maxs[ ent ][ 2 ] = 136.0;
	entity_set_size( ent, mins[ ent ], maxs[ ent ] );
	entity_set_float( ent, EV_FL_takedamage, 1.0 );
	Util_SetRendering( ent, kRenderFxGlowShell, { 0.0, 0.0, 0.0 }, kRenderNormal, 0.0 );
}

///////////////////////////////////
//				 //
//        Attack function	 //
//				 //
///////////////////////////////////

public light_attack( ent )
{
	emit_sound( ent, CHAN_VOICE, oberon_l_attack_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
	
	if( !claws[ ent ] )
	{
		play_anim( ent, ANIM_ATTACK2_OBERON, 1.0 );
		set_task( 0.1, "l_attack_dmg", ent );
	}
	else
	{
		play_anim( ent, C_ANIM_ATTACK2_OBERON, 1.0 );
		set_task( 0.1, "c_l_attack_dmg", ent );
	}
}

public l_attack_dmg( ent )
{
	new iVictim, Float: iOrigin[ 3 ];
	new Float: radious = L_ATTACK_RADIOUS;
	pev( ent, pev_origin, iOrigin );
	while( ( iVictim = find_ent_in_sphere( iVictim, iOrigin, radious ) ) != 0 )
	{
		if( is_user_alive( iVictim ) )
		{
			new Float: takedmg = entity_get_float( iVictim, EV_FL_takedamage );
			if( !takedmg )
				continue;

			static iNewHealth;
			
			iNewHealth = max( 0, get_user_health( iVictim ) - random_num( L_ATTACK_MIN_DMG, L_ATTACK_MAX_DMG ) );
			
			if( !iNewHealth )
			{
				new owner = entity_get_edict( ent, EV_ENT_owner );
				ExecuteHamB( Ham_Killed, iVictim, owner, 0 );
				continue;
			}

			emit_sound( iVictim, CHAN_BODY, oberon_attack_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
			screen_effects( iVictim );
			set_user_health( iVictim, iNewHealth );
		}
	}
}

public c_l_attack_dmg( ent )
{
	new iVictim, Float: iOrigin[ 3 ];
	new Float: radious = L_ATTACK_RADIOUS;
	pev( ent, pev_origin, iOrigin );
	while( ( iVictim = find_ent_in_sphere( iVictim, iOrigin, radious ) ) != 0 )
	{
		if( is_user_alive( iVictim ) )
		{
			new Float: takedmg = entity_get_float( iVictim, EV_FL_takedamage );
			if( !takedmg )
				continue;

			static iNewHealth;
			
			iNewHealth = max( 0, get_user_health( iVictim ) - random_num( C_L_ATTACK_MIN_DMG, C_L_ATTACK_MAX_DMG ) );
			
			if( !iNewHealth )
			{
				new owner = entity_get_edict( ent, EV_ENT_owner );
				ExecuteHamB( Ham_Killed, iVictim, owner, 0 );
				continue;
			}

			emit_sound( iVictim, CHAN_BODY, oberon_attack_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
			screen_effects( iVictim );
			set_user_health( iVictim, iNewHealth );
		}
	}
}

public heavy_attack( ent )
{
	new Float: Ent_Origin[ 3 ];

    	pev( ent, pev_origin, Ent_Origin );

	new ent2 = create_entity( "info_target" );
	entity_set_origin( ent2, Ent_Origin );
	entity_set_int( ent2, EV_INT_movetype, MOVETYPE_NOCLIP );

	new owner = entity_get_edict( ent, EV_ENT_owner );
	entity_set_edict( ent2, EV_ENT_owner, owner );
	
	new Float: flAngles[ 3 ];
	
	pev( ent, pev_angles, flAngles );

	new Float: Dir[ 3 ];
	
	angle_vector( flAngles, ANGLEVECTOR_FORWARD, Dir );
	xs_vec_mul_scalar( Dir, 150.0, Dir );
	entity_set_vector( ent2, EV_VEC_velocity, Dir );

	emit_sound( ent, CHAN_VOICE, oberon_h_attack_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
	
	if( !claws[ ent ] )
	{
		play_anim( ent, ANIM_ATTACK_OBERON, 1.0 );
		set_task( 1.0, "h_attack_dmg", ent2 );
	}
	else
	{
		play_anim( ent, C_ANIM_ATTACK_OBERON, 1.0 );
		set_task( 0.5, "c_h_attack_dmg", ent );
	}
}

public h_attack_dmg( ent )
{
	new iVictim, Float: iOrigin[ 3 ];
	new Float: radious = H_ATTACK_RADIOUS;
	pev( ent, pev_origin, iOrigin );
	while( ( iVictim = find_ent_in_sphere( iVictim, iOrigin, radious ) ) != 0 )
	{
		if( is_user_alive( iVictim ) )
		{
			new Float: takedmg = entity_get_float( iVictim, EV_FL_takedamage );
			if( !takedmg )
				continue;

			static iNewHealth;
			
			iNewHealth = max( 0, get_user_health( iVictim ) - random_num( H_ATTACK_MIN_DMG, H_ATTACK_MAX_DMG ) );
			
			if( !iNewHealth )
			{
				new owner = entity_get_edict( ent, EV_ENT_owner );
				ExecuteHamB( Ham_Killed, iVictim, owner, 0 );
				continue;
			}

			emit_sound( iVictim, CHAN_BODY, oberon_attack_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
			screen_effects( iVictim );
			set_user_health( iVictim, iNewHealth );
		}
	}
	remove_entity( ent );
}

public c_h_attack_dmg( ent )
{
	new iVictim, Float: iOrigin[ 3 ];
	new Float: radious = H_ATTACK_RADIOUS;
	pev( ent, pev_origin, iOrigin );
	while( ( iVictim = find_ent_in_sphere( iVictim, iOrigin, radious ) ) != 0 )
	{
		if( is_user_alive( iVictim ) )
		{
			new Float: takedmg = entity_get_float( iVictim, EV_FL_takedamage );
			if( !takedmg )
				continue;

			static iNewHealth;
			
			iNewHealth = max( 0, get_user_health( iVictim ) - random_num( C_H_ATTACK_MIN_DMG, C_H_ATTACK_MAX_DMG ) );
			
			if( !iNewHealth )
			{
				new owner = entity_get_edict( ent, EV_ENT_owner );
				ExecuteHamB( Ham_Killed, iVictim, owner, 0 );
				continue;
			}

			emit_sound( iVictim, CHAN_BODY, oberon_attack_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
			screen_effects( iVictim );
			set_user_health( iVictim, iNewHealth );
		}
	}
}

///////////////////////////////////
//				 //
//      Change target/See	 //
//				 //
///////////////////////////////////

public npc_turntotarget( ent, Float: Ent_Origin[ 3 ], target, Float: Vic_Origin[ 3 ] ) 
{
	if( target ) 
	{
		new Float: newAngle[ 3 ];
		entity_get_vector( ent, EV_VEC_angles, newAngle );
		new Float: x = Vic_Origin[ 0 ] - Ent_Origin[ 0 ];
		new Float: z = Vic_Origin[ 1 ] - Ent_Origin[ 1 ];

		new Float:radians = floatatan( z/x, radian );
		newAngle[ 1 ] = radians * ( 180 / 3.14 );
		
		if( Vic_Origin[ 0 ] < Ent_Origin[ 0 ] )
			newAngle[ 1 ] -= 180.0;
        
		entity_set_vector( ent, EV_VEC_angles, newAngle );
	}
}

///////////////////////////////////
//				 //
//           Stocks		 //
//				 //
///////////////////////////////////

stock bool: IsValidTarget( iTarget )
{
	if( !iTarget || !( 1 <= iTarget <= get_maxplayers( ) ) || !is_user_alive( iTarget ) )
		return false,
		
	return true;
}

public FindClosestEnemy( entid )
{
	new Float: Dist;
	new Float: maxdistance = MAXDISTANCE;
	new indexid = 0;
	
	for( new i = 1; i <= get_maxplayers( ); i++ )
	{
		if( is_user_alive( i ) && can_see_fm( entid, i ) )
		{
			Dist = entity_range( entid, i );
			
			new Float: takedmg = entity_get_float( i, EV_FL_takedamage );
			if( !takedmg )
				continue;

			if( Dist <= maxdistance )
			{
				maxdistance = Dist;
				indexid = i;
			}
		}    
	}
	
	return indexid;
}

public bool: can_see_fm( entindex1, entindex2 )
{
	if( !entindex1 || !entindex2 )
		return false;

	new flags = pev( entindex1, pev_flags )
	if( flags & EF_NODRAW || flags & FL_NOTARGET )
	{
		return false;
	}

	new Float: lookerOrig[ 3 ], Float: temp[ 3 ];
	entity_get_vector( entindex1, EV_VEC_origin, lookerOrig );

	pev( entindex1, pev_view_ofs, temp );
	lookerOrig[ 0 ] += temp[ 0 ];
	lookerOrig[ 1 ] += temp[ 1 ];
	lookerOrig[ 2 ] += temp[ 2 ];

	new Float: NewOrigin[ 3 ];
	new Float:angles[3];
	entity_get_vector(entindex1,EV_VEC_angles,angles);

	new is_oberon[ 32 ];
	entity_get_string( entindex1, EV_SZ_classname, is_oberon, 31 )
	if( equal( is_oberon, OBERON_CLASSNAME ) )
	{
		new owner = entity_get_edict( entindex1, EV_ENT_owner );
		entity_get_vector(owner,EV_VEC_angles,angles);
	}

	NewOrigin[ 0 ] = floatcos( angles[ 1 ], degrees ) * MAXDISTANCE ;
	NewOrigin[ 1 ] = floatsin( angles[ 1 ], degrees ) * MAXDISTANCE ;
	NewOrigin[ 0 ] += lookerOrig[ 0 ];
	NewOrigin[ 1 ] += lookerOrig[ 1 ];
	NewOrigin[ 2 ] = lookerOrig[ 2 ];

	new iVictim;
	while( ( iVictim = find_ent_in_sphere( iVictim, NewOrigin, MAXDISTANCE ) ) != 0 )
	{
		if( iVictim == entindex2 && is_user_alive( iVictim ) )
		{
			new Float: targetBaseOrig[ 3 ];
			new Float: targetOrig[ 3 ];

			pev( entindex2, pev_origin, targetBaseOrig );
			pev( entindex2, pev_view_ofs, temp );
			targetOrig[ 0 ] = targetBaseOrig[ 0 ] + temp[ 0 ];
			targetOrig[ 1 ] = targetBaseOrig[ 1 ] + temp[ 1 ];
			targetOrig[ 2 ] = targetBaseOrig[ 2 ] + temp[ 2 ];

			engfunc( EngFunc_TraceLine, lookerOrig, targetOrig, 0, entindex1, 0 ); //  checks the had of seen player
		
			if( get_tr2( 0, TraceResult:TR_InOpen ) && get_tr2( 0, TraceResult:TR_InWater ) )
			{
				return false;
			} 
			else 
			{
				new Float: flFraction;
				get_tr2( 0, TraceResult:TR_flFraction, flFraction );
			
				if( flFraction == 1.0 || ( get_tr2( 0, TraceResult:TR_pHit ) == entindex2 ) )
				{
					return true;
				}
				else
				{
					targetOrig[ 0 ] = targetBaseOrig[ 0 ];
					targetOrig[ 1 ] = targetBaseOrig[ 1 ];
					targetOrig[ 2 ] = targetBaseOrig[ 2 ];
					engfunc( EngFunc_TraceLine, lookerOrig, targetOrig, 0, entindex1, 0 ); //  checks the body of seen player
					get_tr2( 0, TraceResult:TR_flFraction, flFraction );
				
					if( flFraction == 1.0 || ( get_tr2( 0, TraceResult:TR_pHit ) == entindex2 ) )
					{
						return true;
					}
					else
					{
						targetOrig[ 0 ] = targetBaseOrig[ 0 ];
						targetOrig[ 1 ] = targetBaseOrig[ 1 ];
						targetOrig[ 2 ] = targetBaseOrig[ 2 ] - 17.0;
						engfunc( EngFunc_TraceLine, lookerOrig, targetOrig, 0, entindex1, 0 ); //  checks the legs of seen player
						get_tr2( 0, TraceResult:TR_flFraction, flFraction );
						
						if( flFraction == 1.0 || ( get_tr2( 0, TraceResult:TR_pHit ) == entindex2 ) )
						{
							return true;
						}
					}
				}
			}
		}
	}
	return false;
}

stock get_anim( id )
{
	return pev( id, pev_sequence );
}

stock play_anim( index, sequence, Float:framerate = 1.0 )
{
	entity_set_float( index, EV_FL_animtime, get_gametime() );
	entity_set_float( index, EV_FL_frame, 0.0 );
	entity_set_float( index, EV_FL_framerate,  framerate );
	entity_set_int( index, EV_INT_sequence, sequence );
}

public npc_TraceAttack( ent, attacker, Float: damage, Float: direction[ 3 ], trace, damageBits ) 
{ 
	if( !is_valid_ent( ent ) ) 
		return;  
         
	new Float: end[ 3 ] ;
	get_tr2( trace, TR_vecEndPos, end ); 
     
	new classname[ 64 ];
	pev( ent, pev_classname, classname, charsmax( classname ) );
	
	if( equali( classname, OBERON_CLASSNAME ) )
	{
		message_begin( MSG_BROADCAST, SVC_TEMPENTITY );
		write_byte( TE_SPARKS );
		engfunc( EngFunc_WriteCoord, end[ 0 ] );
		engfunc( EngFunc_WriteCoord, end[ 1 ] );
		engfunc( EngFunc_WriteCoord, end[ 2 ] );
		message_end( );
	}
}

Util_SetRendering( iEntity, kRenderFx = kRenderFxNone, {Float,_}: fVecColor[ 3 ] = {0.0, 0.0, 0.0 }, kRender = kRenderNormal, Float: flAmount = 0.0 ) 
{ 
	set_pev( iEntity, pev_renderfx, kRenderFx );
	set_pev( iEntity, pev_rendercolor, fVecColor );
	set_pev( iEntity, pev_rendermode, kRender );
	set_pev( iEntity, pev_renderamt, flAmount );
}

screen_effects( id )
{
	message_begin( MSG_ONE_UNRELIABLE, g_msgScreenFade, _, id );
	write_short( UNIT_SECOND * 1 );
	write_short( UNIT_SECOND * 1 );
	write_short( FFADE_IN );
	write_byte( 200 );
	write_byte( 0 );
	write_byte( 0 );
	write_byte( 125 );
	message_end( );
	
	message_begin( MSG_ONE_UNRELIABLE, g_msgScreenShake, _, id );
	write_short( UNIT_SECOND * 5 );
	write_short( UNIT_SECOND * 1 );
	write_short( UNIT_SECOND * 5 );
	message_end( );
}

///////////////////////////////////
//				 //
//          Oberon Skill	 //
//				 //
///////////////////////////////////

public oberon_jump( ent )
{
	if( !is_valid_ent( ent ) )
		return;

	new Float: flAngles[ 3 ];
	
	pev( ent, pev_angles, flAngles );

	new Float: Direction[ 3 ];
	
	angle_vector( flAngles, ANGLEVECTOR_FORWARD, Direction );
	xs_vec_mul_scalar( Direction, 300.0, Direction );
	Direction[ 2 ] = 300.0;
	entity_set_int( ent, EV_INT_movetype, MOVETYPE_BOUNCE );
	entity_set_float( ent, EV_FL_friction, 0.8 );
	entity_set_vector( ent, EV_VEC_velocity, Direction );
}

public oberon_land( ent )
{
	if( !is_valid_ent( ent ) )
		return;

	bwave[ ent ] = false;
	new Float: speed[ 3 ] = {0.01,0.0,0.0}
	entity_set_vector( ent, EV_VEC_velocity, speed );
	entity_set_int( ent, EV_INT_movetype, MOVETYPE_PUSHSTEP );
}

public oberon_bw_deploy( ent )
{
	if( !is_valid_ent( ent ) )
		return;
	new Float: flAngles[ 3 ];
	
	pev( ent, pev_angles, flAngles );

	new Float: Ent_Origin[ 3 ];

    	pev( ent, pev_origin, Ent_Origin );
		
	new Float: NewOrigin[ 3 ];

	for( new Float: i = 0.0; i <= 200.0; i += 0.1 )
	{
		NewOrigin[ 0 ] = floatcos( flAngles[ 1 ], degrees ) * i;
		NewOrigin[ 1 ] = floatsin( flAngles[ 1 ], degrees ) * i;
		NewOrigin[ 0 ] += Ent_Origin[ 0 ];
		NewOrigin[ 1 ] += Ent_Origin[ 1 ];
		NewOrigin[ 2 ] = Ent_Origin[ 2 ];
		if( PointContents( NewOrigin ) == CONTENTS_SOLID )
		{
			i -= 0.1;
			NewOrigin[ 0 ] = floatcos( flAngles[ 1 ], degrees ) * i;
			NewOrigin[ 1 ] = floatsin( flAngles[ 1 ], degrees ) * i;
			NewOrigin[ 0 ] += Ent_Origin[ 0 ];
			NewOrigin[ 1 ] += Ent_Origin[ 1 ];
			NewOrigin[ 2 ] = Ent_Origin[ 2 ];
			break;
		}
	}

	new ent2 = create_entity( "info_target" );
	entity_set_origin( ent2, NewOrigin );
	new owner = entity_get_edict( ent, EV_ENT_owner );
	entity_set_edict( ent2, EV_ENT_owner, owner );

	oberon_blastwave( ent2 );
}

public oberon_blastwave( ent )
{
	new Float: iOrigin[ 3 ], Float: cView[ 3 ], iVictim, Float: radious;
	entity_get_vector( ent, EV_VEC_origin, iOrigin );
	
	radious = RADIOUS;
	
	engfunc( EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, iOrigin, 0 );
	write_byte( TE_BEAMCYLINDER );
	engfunc( EngFunc_WriteCoord, iOrigin[ 0 ] );
	engfunc( EngFunc_WriteCoord, iOrigin[ 1 ] );
	engfunc( EngFunc_WriteCoord, iOrigin[ 2 ] );
	engfunc( EngFunc_WriteCoord, iOrigin[ 0 ] );
	engfunc( EngFunc_WriteCoord, iOrigin[ 1 ] );
	engfunc( EngFunc_WriteCoord, iOrigin[ 2 ] + ( radious * 10 ) );
	write_short( g_sprRing );
	write_byte( 0 );
	write_byte( 0 );
	write_byte( 1 );
	write_byte( 100 );
	write_byte( 0 );
	write_byte( 255 );
	write_byte( 255 );
	write_byte( 255 );
	write_byte( 200 );
	write_byte( 0 );
	message_end( );

	new origin[ 3 ];
	get_origin_int( ent, origin );
	rocks_explode( origin );

	emit_sound( ent, CHAN_BODY, oberon_earth_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
	
	while( ( iVictim = find_ent_in_sphere( iVictim, iOrigin, radious ) ) != 0 )
	{
		if( is_user_alive( iVictim ) )
		{
			new Float: takedmg = entity_get_float( iVictim, EV_FL_takedamage );
			if( !takedmg )
				continue;

			static iNewHealth;
			
			new Float: Orig[ 3 ];
			entity_get_vector( iVictim, EV_VEC_origin, Orig );
			new Float: distance = get_distance_f( iOrigin, Orig );
			new Float: speed = distance / radious;
			cView[ 0 ] = ( Orig[ 0 ] - iOrigin[ 0 ] ) * speed;
			cView[ 1 ] = ( Orig[ 1 ] - iOrigin[ 1 ] ) * speed;
			cView[ 2 ] = BW_MAX_HEIGHT - distance;
			new Float: dis_dmg = ( distance / radious ) * 100.0;
			dis_dmg = ( BW_MAX_DMG * dis_dmg ) / 100.0;
			new dis_dmg_round = floatround( dis_dmg , floatround_ceil );
			if( ( BW_MAX_DMG - dis_dmg_round ) > BW_MIN_DMG )
				iNewHealth = max( 0, get_user_health( iVictim ) - ( BW_MAX_DMG - dis_dmg_round ) );
			else
				iNewHealth = max( 0, get_user_health( iVictim ) - BW_MIN_DMG );
			entity_set_vector( iVictim, EV_VEC_velocity, cView );
			
			if( !iNewHealth )
			{
				new owner = entity_get_edict( ent, EV_ENT_owner );
				ExecuteHamB( Ham_Killed, iVictim, owner, 0 );
				continue;
			}

			screen_effects( iVictim );
			set_user_health( iVictim, iNewHealth );
		}
	}
	remove_entity( ent );
}

public get_origin_int(index, origin[3])
{
	new Float:FVec[3]

	pev(index,pev_origin,FVec)

	origin[0] = floatround(FVec[0])
	origin[1] = floatround(FVec[1])
	origin[2] = floatround(FVec[2])

	return 1
}

rocks_explode( origin[ 3 ] )
{
	new gibtime = 20

	for(new i = 0; i < 25; i++) {
		message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
		write_byte(TE_MODEL)
		write_coord(origin[0])
		write_coord(origin[1])
		write_coord(origin[2])
		write_coord(random_num( -500, 500 ))
		write_coord(random_num( -500, 500 ))
		write_coord(random_num( 100, 200))
		write_angle(random_num(0,360))
		write_short(rocks_gibs)
		write_byte(0) // bounce
		write_byte(gibtime) // life
		message_end()
	}
}

public oberon_bomb( id )
{
	new owner = entity_get_edict( id, EV_ENT_owner );
	if( !is_valid_ent( oberon_control[ owner ] ) )
		return;

	new target = g_victim[ owner ];
	new Float: iOrigin[ 3 ];
	entity_get_vector( id, EV_VEC_origin, iOrigin );

	new Float: Direction[ 3 ];
	new ent = create_entity( "info_target" );
	entity_set_string( ent, EV_SZ_classname, "oberon_bomb" );
	entity_set_model( ent, oberon_bomb_model );
	entity_set_edict( ent, EV_ENT_owner, owner );
    
	new Float: maxs[ 3 ] = { 1.0, 1.0, 1.0 };
	new Float: mins[ 3 ] = { -1.0, -1.0, -1.0 };
	entity_set_size( ent, mins, maxs );
	
	iOrigin[ 2 ] += 40.0;
	entity_set_origin( ent, iOrigin );

	entity_set_int( ent, EV_INT_effects, 2 );
	entity_set_int( ent, EV_INT_solid, 1 );
	entity_set_int( ent, EV_INT_movetype, MOVETYPE_BOUNCE );

	if( target )
	{
		new Float: TarOrigin[ 3 ];
		entity_get_vector( target, EV_VEC_origin, TarOrigin );
		Direction[ 0 ] = ( TarOrigin[ 0 ] - iOrigin[ 0 ] ) * 1.3;
		Direction[ 1 ] = ( TarOrigin[ 1 ] - iOrigin[ 1 ] ) * 1.3;
		Direction[ 2 ] = 250.0;
		npc_turntotarget( ent, TarOrigin, target, iOrigin );
	}
	else
	{
		new Float: angles[ 3 ];
		pev( owner, pev_angles, angles );
	
		angle_vector( angles, ANGLEVECTOR_FORWARD, Direction );
		xs_vec_mul_scalar( Direction, 1000.0, Direction );
		Direction[ 2 ] = 250.0;
	}
	entity_set_vector( ent, EV_VEC_velocity, Direction );

	emit_sound( id, CHAN_BODY, oberon_bomb_deploy_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );
}
	
public bomb_touch( id, touched )
{
	new owner = entity_get_edict( id, EV_ENT_owner );
	new Float: origin[ 3 ];
	entity_get_vector( id, EV_VEC_origin, origin );
	
	message_begin( MSG_BROADCAST, SVC_TEMPENTITY );
	write_byte( TE_FIREFIELD );
	engfunc( EngFunc_WriteCoord, origin[ 0 ] );
	engfunc( EngFunc_WriteCoord, origin[ 1 ] );
	engfunc( EngFunc_WriteCoord, origin[ 2 ] + 50 );
	write_short( 100 );
	write_short( g_szSmokeSprites );
	write_byte( 100 );
	write_byte( TEFIRE_FLAG_ALPHA );
	write_byte( 100 );
	message_end();

	new ent = create_entity( "info_target" );
	entity_set_string( ent, EV_SZ_classname, "poison" );
	entity_set_edict( ent, EV_ENT_owner, owner );
	entity_set_vector( ent, EV_VEC_origin, origin );
	set_task( 10.0, "remove_this_ent", ent );
	entity_set_float( ent, EV_FL_nextthink, halflife_time( ) + 0.01 );

	emit_sound( id, CHAN_BODY, oberon_bomb_explode_sound, 1.0, ATTN_NORM, 0, PITCH_NORM );

	remove_entity( id );
}

public poison_think( ent )
{
	new Float: iOrigin[ 3 ], iVictim;
	entity_get_vector( ent, EV_VEC_origin, iOrigin );
	
	new Float: radious = POISON_RADIOUS;

	while( ( iVictim = find_ent_in_sphere( iVictim, iOrigin, radious ) ) != 0 )
	{
		if( is_user_alive( iVictim ) )
		{
			new Float: takedmg = entity_get_float( iVictim, EV_FL_takedamage );
			if( !takedmg )
				continue;

			static iNewHealth;
			
			iNewHealth = max( 0, get_user_health( iVictim ) - POISON_DMG );

			if( !iNewHealth )
			{
				new owner = entity_get_edict( ent, EV_ENT_owner );
				ExecuteHamB( Ham_Killed, iVictim, owner, 0 );
				continue;
			}

			screen_effects( iVictim );
			set_user_health( iVictim, iNewHealth );
		}
	}
	entity_set_float( ent, EV_FL_nextthink, get_gametime( ) + 1.0 );
}

public bomb_cooldown( id )
{
	if( !is_valid_ent( id ) )
		return;

	has_bombs[ id ] = true;
}

public fw_addtofullpack(es_handle,e,ent,host,hostflags,player,pSet)
{
    	if( oberon_control[ host ] == ent )
   	{
      		set_es( es_handle, ES_RenderMode, kRenderTransAlpha);
     	 	set_es( es_handle, ES_RenderAmt, 150 );
    	}

	if( g_victim[ host ] == ent )
	{
		new color[ 3 ] = {255,0,0};
		FX_Line(host, start[ host ], stop[ host ], color, 200);
	}

	if( target_ent[ host ] == ent )
		set_es( es_handle, ES_RenderAmt, 255.0 );

    	return FMRES_IGNORED;
}

public FX_Line(user, start[3], stop[3], color[3], brightness)
{
	if(!user)
		return;
	
	message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, _, user) 
	
	write_byte( TE_BEAMPOINTS ) 
	
	write_coord(start[0]) 
	write_coord(start[1])
	write_coord(start[2])
	
	write_coord(stop[0])
	write_coord(stop[1])
	write_coord(stop[2])
	
	write_short( spr_dot )
	
	write_byte( 1 )	// framestart 
	write_byte( 1 )	// framerate 
	write_byte( 1 )	// life in 0.1's 
	write_byte( 10 )	// width
	write_byte( 0 ) 	// noise 
	
	write_byte( color[0] )   // r, g, b 
	write_byte( color[1] )   // r, g, b 
	write_byte( color[2] )   // r, g, b 
	
	write_byte( brightness )  	// brightness 
	write_byte( 0 )   	// speed 
	
	message_end() 
}

stock create_camera( id )
{	
	new Float: v_angle[ 3 ], Float: angles[ 3 ];
	entity_get_vector( id, EV_VEC_origin, origin[ id ] );
	entity_get_vector( id, EV_VEC_v_angle, v_angle );
	entity_get_vector( id, EV_VEC_angles, angles );

	new ent = create_entity( "info_target" );

	entity_set_string( ent, EV_SZ_classname, "JJG75_Camera" );

	entity_set_int( ent, EV_INT_solid, 0 );
	entity_set_int( ent, EV_INT_movetype, MOVETYPE_NOCLIP );
	entity_set_edict( ent, EV_ENT_owner, id );
	entity_set_model( ent, "models/camera.mdl" );

	new Float:mins[ 3 ];
	mins[ 0 ] = -1.0;
	mins[ 1 ] = -1.0;
	mins[ 2 ] = -1.0;

	new Float:maxs[ 3 ];
	maxs[ 0 ] = 1.0;
	maxs[ 1 ] = 1.0;
	maxs[ 2 ] = 1.0;

	entity_set_size( ent, mins, maxs );

	entity_set_origin( ent, origin[ id ] );
	entity_set_vector( ent, EV_VEC_v_angle, v_angle );
	entity_set_vector( ent, EV_VEC_angles, angles );

	Util_SetRendering( ent, kRenderFxGlowShell, { 0.0, 0.0, 0.0 }, kRenderTransAlpha, 0.0 );

	camera[ id ] = ent;

	return 1;
}

stock view_camera( id )
{
	if( is_valid_ent( camera[ id ] ) )
	{
		attach_view( id, camera[ id ] );
		return 1;
	}
	return 0;
}

public Event_ResetHUD(id)
{
	if( !is_user_alive( id ) )
		return;

	reset_all( id );
}

public client_connect( id )
{
	reset_all( id );
}

public client_disconnect( id )
{
	reset_all( id );
}

public player_death( )
{
	new id = read_data(2);
	reset_all( id );
}

public round_end( )
{
	for( new i = 0; i <= get_maxplayers( ); i++ )
	{
		if( is_user_alive( i ) && oberon_control[ i ] )
			reset_all( i );
	}
}

public reset_all( id )
{
	if( !is_valid_ent( oberon_control[ id ] ) )
		return;

	remove_entity( oberon_control[ id ] );
	if( is_valid_ent( camera[ id ] ) )
		remove_entity( camera[ id ] );
	if( target_ent[ id ] )
	{
		remove_entity( target_ent[ id ] );
		target_ent[ id ] = 0;
	}

	entity_set_int( id, EV_INT_movetype, MOVETYPE_WALK );
	if( is_user_alive( id ) )
		attach_view( id, id );
	entity_set_float( id, EV_FL_takedamage, 1.0 );

	fm_give_item(id, "weapon_knife");
	
	oberon_control[ id ] = 0;
	camera[ id ] = 0 ;
	can_move[ id ] = false;
	g_victim[ id ] = 0;

	Util_SetRendering( id, kRenderFxGlowShell, { 0.0, 0.0, 0.0 }, kRenderTransAlpha, 255.0 );
}

public monster_weapons( id )
{
	if( !is_user_alive( id ) )
		return;

	if( oberon_control[ id ] )
		fm_strip_user_weapons( id );
}