#include "osconfig.h"
#include "mmtimer.h"
#include "dynpatcher_base.h"


bool ParseEngine_Win() {
	int Cnt;
	uint32_t coderef_addr;
	uint32_t coderef2_addr;
	/* Search for code that limits host_frametime to 0.001:
			F6C4					?? test    ah, ?
			7414					jz      short loc_1D5053F
			C705 ???????? FCA9F1D2	mov     dword ptr host_frametime, 0D2F1A9FCh
			C705 ???????? 4D62503F	mov     dword ptr host_frametime+4, 3F50624Dh
	*/

	const char ScanData[] = "\x74\x00\xC7\x05\x00\x00\x00\x00\xFC\xA9\xF1\xD2";
	const char ScanMask[] = "\xF0\x00\xFF\xFF\x00\x00\x00\x00\xFF\xFF\xFF\xFF";
	Cnt = 0;
	coderef2_addr = 0;
	coderef_addr = Dll_ScanForTemplate_Forward(&GenericEngineData, (unsigned char*) ScanData,(unsigned char*) ScanMask, sizeof(ScanMask) - 1, GenericEngineData.code.start, GenericEngineData.code.end - GenericEngineData.code.start);
	while (coderef_addr) {
		Cnt++;
		coderef2_addr = coderef_addr;
		coderef_addr = Dll_ScanForTemplate_Forward(&GenericEngineData, (unsigned char*) ScanData,(unsigned char*) ScanMask, sizeof(ScanMask) - 1, coderef_addr+1, GenericEngineData.code.end - GenericEngineData.code.start);
	}

	if (Cnt <= 0) {
		LCPrintf(true, "[MMTIMER]: %s: WARNING: Unable to locate 1000FPS limitation code\n", __FUNCTION__);
	} else if (Cnt > 1) {
		LCPrintf(true, "[MMTIMER]: %s: WARNING: %d candidates found for 1000FPS limitation code\n", __FUNCTION__, Cnt);
	}

	DSEngineData.Limit1000FPS_haddr = coderef2_addr;

	if (coderef2_addr)
		DSEngineData.Limit1000FPS_JumpAddr = *((uint8_t*) (coderef2_addr + 1)) + coderef2_addr + 2;

	/* ================================== */
	/* Get address of Sleep() function */

	HMODULE hKernel = GetModuleHandleW(L"kernel32.dll");
	if (hKernel == NULL) {
		LCPrintf(true, "[MMTIMER]: %s: ERROR: Unable to locate kernel32.dll\n", __FUNCTION__);
		return false;
	}
	DSEngineData.Sleep_addr = (uint32_t) GetProcAddress(hKernel, "Sleep");
	if (DSEngineData.Sleep_addr == 0) {
		LCPrintf(true, "[MMTIMER]: %s: ERROR: Unable to locate address of Sleep()\n", __FUNCTION__);
		return false;
	}

	/* ================================== */
	/* Get address of NtDelayExecution() */

	HMODULE hNtDll = GetModuleHandleW(L"ntdll.dll");
	if (hNtDll == NULL) {
		LCPrintf(true, "[MMTIMER]: %s: ERROR: Unable to locate ntdll.dll\n", __FUNCTION__);
		return false;
	}
	DSEngineData.NtDelayExecution_addr = (uint32_t) GetProcAddress(hNtDll, "NtDelayExecution");
	if (DSEngineData.NtDelayExecution_addr == 0) {
		LCPrintf(true, "[MMTIMER]: %s: ERROR: Unable to locate address of NtDelayExecution()\n", __FUNCTION__);
		return false;
	}

	return true;
}