/* Plugin generated by AMXX-Studio */

#define CS 1

#include <amxmodx>
#include <fakemeta>
#if CS
#include <cstrike>
#endif
#include <xs>

#define PLUGIN "Camper Mark"
#define VERSION "1.0"
#define AUTHOR "peku33"

#define PIECES 8


new Float:old_origin[33][3];
new camp_ticks[33];

new p_time_to_mark, p_time_to_show, p_move_tolerance, p_max_mark;

new g_sprite;
public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	set_task(1.0, "check_origin", _, _, _, "b");
	
	p_time_to_mark = register_cvar("amx_cm_time_to_mark", "20", FCVAR_SERVER | FCVAR_PRINTABLEONLY);
	p_time_to_show = register_cvar("amx_cm_time_to_show", "10", FCVAR_SERVER | FCVAR_PRINTABLEONLY);
	p_move_tolerance = register_cvar("amx_cm_move_tolerance", "50.0", FCVAR_SERVER | FCVAR_PRINTABLEONLY);
	p_max_mark = register_cvar("amx_cm_max_mark", "300", FCVAR_SERVER | FCVAR_PRINTABLEONLY);
}
public check_origin()
{
	for(new i = 1; i <= 32; i++)
	{
		if(is_user_alive(i))
		{
			new Float:cur_origin[3];
			pev(i, pev_origin, cur_origin);
			cur_origin[2] = 0.0;
			if(xs_vec_diff(old_origin[i], cur_origin) < get_pcvar_float(p_move_tolerance) * 3.0 && pev(i, pev_maxspeed) > 1.0)
			{
				//Not Moved
				camp_ticks[i]++;
				if(camp_ticks[i] >= get_pcvar_num(p_time_to_show))
				{
					camp_show(i);
				}
				if(camp_ticks[i] >= get_pcvar_num(p_time_to_mark))
				{
					camp_mark(i, min(get_pcvar_num(p_max_mark), (camp_ticks[i] - get_pcvar_num(p_time_to_mark))*20+100));
				}
			}
			else
			{
				//Moved
				camp_ticks[i] = 0;
				xs_vec_copy(cur_origin, old_origin[i]);
			}
		}
		else
		{
			camp_ticks[i] = 0;
		}
	}
}
public client_putinserver(id)
{
	camp_ticks[id] = 0;
}
stock camp_show(id)
{
	set_hudmessage(255, 0, 0, -1.0, 0.01, 0, 0.1, 1.0, 0.1, 0.1, 3);
	show_hudmessage(id, "[Camper Mark] You are camping since %d seconds", camp_ticks[id]);
	
}
stock camp_mark(id, size)
{
	new Float:origin[3];
	pev(id, pev_origin, origin);
	new Float:m[3];
	pev(id, pev_mins, m);
	
	origin[2] += m[2] + 1.0;
	
	new Float:angle_diff = 360.0 / float(PIECES);
	
	new Float:a[3];
	new Float:v1[3], Float:v2[3];
	
	new r, g, b;
	#if CS
	if(cs_get_user_team(id) == CS_TEAM_T)
		r = 255;
	if(cs_get_user_team(id) == CS_TEAM_CT)
		b = 255;
	#else
		r = 255; g = 255; b = 255;
	#endif
	
	while(a[1] < 360.0)
	{
		angle_vector(a, ANGLEVECTOR_FORWARD, v1);
		a[1] += angle_diff;
		angle_vector(a, ANGLEVECTOR_FORWARD, v2);
		
		xs_vec_mul_scalar(v1, float(size), v1);
		xs_vec_mul_scalar(v2, float(size), v2);
		
		xs_vec_add(v1, origin, v1);
		xs_vec_add(v2, origin, v2);
		
		draw_line(v1, v2, r, g, b);
		draw_line(v1, origin, r, g, b);
	}
}
stock draw_line(Float:from[3], Float:to[3], r, g, b)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(0);
	write_coord(floatround(from[0]));
	write_coord(floatround(from[1]));
	write_coord(floatround(from[2]));
	write_coord(floatround(to[0]));
	write_coord(floatround(to[1]));
	write_coord(floatround(to[2]));
	write_short(g_sprite);
	write_byte(1);
	write_byte(1);
	write_byte(10);
	write_byte(10);
	write_byte(0);
	write_byte(r);
	write_byte(g);
	write_byte(b);
	write_byte(100);
	write_byte(0);
	message_end();
}
public plugin_precache()
{
	g_sprite = precache_model("sprites/dot.spr");
}
stock Float:xs_vec_diff(Float:vec1[3], Float:vec2[3])
{
	new Float:result[3];
	xs_vec_sub(vec1, vec2, result);
	
	return floatabs(result[0]) + floatabs(result[1]) + floatabs(result[2]);
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1045\\ f0\\ fs16 \n\\ par }
*/
