#include <amxmodx>
#include <fakemeta>
#include <fun>
#include <hamsandwich>
#include <cstrike>
#include <engine>

#pragma semicolon 1

#define VERSION "3.0"

#define fm_get_user_money(%1)	get_pdata_int( %1, 115 )
#define fm_create_entity(%1)	engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, %1))

#define MAX_CLIENTS 32

enum Color {
	NORMAL = 1,	// clients scr_concolor cvar color
	GREEN,		// Green
	TEAM_COLOR,	// Red, grey, blue
	GREY,		// grey
	RED,		// Red
	BLUE,		// Blue
};

new TeamName[][] = {
	"",
	"TERRORIST",
	"CT",
	"SPECTATOR"
};
	

// Pcvars
new plugin_on, smokecost, noflashcost, hpcost, flashcost, grenadecost, gravitycost, speedcost, respawncost, mp5cost, tercost, bhopcost;
new allowsmoke, allownoflash, allowhp, allowflash, allowgrenade, allowgravity, allowspeed, allowrespawn, allowgodmode, allowmp5, allowter, allowbhop;
new usersilent[33], userstealth[33], usernoflash[33], userhp[33], userarmor[33], usergrenade[33], usergravity[33], userspeed[33];
new hpcvar, menu, hasspeed[33], hassilent[33], gotgodmode[33], hasgodmode[33], mess[33], mess2[33];
new g_msgScreenFade, g_msgMoney, grenade[32], last;
new usert[33];

new Float:g_gametime, g_owner;
new Float:g_gametime2;

new bool:g_bPlayerNonSpawnEvent[MAX_CLIENTS + 1];
new bool:g_track_enemy;
new bool:g_track[33];

new g_iFwFmClientCommandPost;
new g_sync_check_data;

new mxplr;

public plugin_init() {
	register_plugin("DR Shop", VERSION, "xPaw & Grim edition DeSeRt");
	register_cvar("dr_shop_version", VERSION, FCVAR_SERVER);
	set_cvar_string("dr_shop_version", VERSION);
	register_logevent("round_end", 2, "0=World triggered", "1=Round_End");
	register_logevent("round_start", 2, "0=World triggered", "1=Round_Start");

	// Player Spawn
	register_event("ResetHUD", "fwEvResetHUD", "b");
	register_event("TextMsg", "fwEvGameWillRestartIn", "a", "2=#Game_will_restart_in");
	register_clcmd("fullupdate", "fwCmdClFullupdate");

	// Events
	register_event("DeathMsg", "eDeath", "a");
	register_event("CurWeapon", "speed_on", "be");
	register_event("ScreenFade", "eventFlash", "be", "4=255", "5=255", "6=255", "7>199");
	register_event("TextMsg", "fire_in_the_hole", "b", "2&#Game_radio", "4&#Fire_in_the_hole");
	register_event("TextMsg", "fire_in_the_hole2", "b", "3&#Game_radio", "5&#Fire_in_the_hole");
	register_event("99", "grenade_throw", "b");

	// Pcvars
	plugin_on	= register_cvar("dr_shop", "1");
	smokecost	= register_cvar("dr_shop_smokecost",		"3000");
	noflashcost	= register_cvar("dr_shop_noflashcost",		"2000");
	grenadecost	= register_cvar("dr_shop_grenadecost",		"4000");
	gravitycost	= register_cvar("dr_shop_gravitycost",		"8000");
	speedcost	= register_cvar("dr_shop_speedcost",		"8000");
	respawncost	= register_cvar("dr_shop_respawncost",		"10000");
	bhopcost	= register_cvar("dr_shop_bhopcost",		"16000");
	hpcost		= register_cvar("dr_shop_hpcost",		"5000");
	flashcost	= register_cvar("dr_shop_flashcost",		"4000");
	hpcvar		= register_cvar("dr_shop_hpcvar",		"255");
	mp5cost		= register_cvar("dr_shop_mp5cost",		"16000");
	tercost		= register_cvar("dr_shop_tercost",		"6000");
	allowsmoke	= register_cvar("dr_shop_allowsmoke",		"1");
	allownoflash	= register_cvar("dr_shop_allownoflash",	"1");
	allowgrenade	= register_cvar("dr_shop_allowgrenade",	"1");
	allowgravity	= register_cvar("dr_dr_allowgravity",	"1");
	allowspeed	= register_cvar("dr_dr_allowspeed",		"1");
	allowrespawn	= register_cvar("dr_dr_allowrespawn",		"1");
	allowbhop	= register_cvar("dr_dr_allowbhop",		"1");
	allowhp		= register_cvar("dr_dr_allowhp",		"1");
	allowflash	= register_cvar("dr_dr_allowflash",		"1");
	allowter	= register_cvar("dr_dr_allowter",		"1");
	allowmp5	= register_cvar("dr_dr_allowmp5",		"1");
	allowgodmode	= register_cvar("dr_shop_lol",	"1");

	//lang
	register_dictionary( "drshop.txt" );

	// Clcmds
	register_clcmd("say /drshop",	"show_hnsmenu");
	register_clcmd("say /shop",	"show_hnsmenu");
	register_clcmd("say drshop",	"show_hnsmenu");
	register_clcmd("say shop",	"show_hnsmenu");

	// Menu
	menu = register_menuid("DeathRun Shop");
	register_menucmd(menu, 1023, "shop_handler");
	
	// Forwards
	register_forward(FM_EmitSound,"fw_emitsound"); 
	register_forward(FM_CmdStart, "fwd_FM_CmdStart_pre", 0);
	

	// Tasks
	set_task( 2.0, "bad_fix2",_,_,_, "b" );
	set_task( 100.0, "advert",_,_,_, "b" );
	
	g_msgScreenFade = get_user_msgid("ScreenFade");
	g_msgMoney = get_user_msgid("Money");
	mxplr = get_maxplayers();
}

public client_connect( id ) {
	usersilent[id]	= 0;
	userstealth[id]	= 0;
	usernoflash[id]	= 0;
	userhp[id]	= 0;
	userarmor[id]	= 0;
	usergrenade[id]	= 0;
	usergravity[id]	= 0;
	userspeed[id]	= 0;
	gotgodmode[id]	= 0;
	hasspeed[id]	= 0;
	hassilent[id]	= 0;
	mess[id]	= 0;
	mess2[id]	= 0;
	usert[id] = 0;
}

public client_disconnect( id ) {
	usersilent[id]	= 0;
	userstealth[id]	= 0;
	usernoflash[id]	= 0;
	userhp[id]	= 0;
	userarmor[id]	= 0;
	usergrenade[id]	= 0;
	usergravity[id]	= 0;
	userspeed[id]	= 0;
	gotgodmode[id]	= 0;
	hasspeed[id]	= 0;
	hassilent[id]	= 0;
	mess[id]	= 0;
	mess2[id]	= 0;
	usert[id] = 0;
} 

public speed_on( id )
	if(is_user_alive(id))
		if(hasspeed[id])
			fm_set_user_maxspeed(id, 320.0);

// Advert
public advert() {
	new g_Maxplayers;
	g_Maxplayers = get_maxplayers();
	
	for(new i=1; i<=g_Maxplayers; i++)
		if(is_user_connected(i))
			ColorChat(i, RED, "^x01[DeathRun]^x04 %L", i, "DRSHOP_ADVERT" );
}

public fwd_FM_CmdStart_pre( id, uc_handle, random_seed ) {
		if(!is_user_alive(id))
			return FMRES_IGNORED;
	
		if(hassilent[id] > 0)
			set_pev(id, pev_flTimeStepSound, 999);

		static button;
		button = get_uc(uc_handle, UC_Buttons);
		if(button & IN_RELOAD) {
			if(get_pcvar_num(allowgodmode) == 1)
				return FMRES_IGNORED;
			
			if(!gotgodmode[id]) {	
				if(!mess[id]) {
					ColorChat(id, RED, "^x04[DeathRun Shop]^x01 You need to buy godmode first!");
					mess[id]++;
					set_task(3.0, "remove_mess", id);
					return FMRES_IGNORED;
				}
				return FMRES_IGNORED;
			}
			
			if(hasgodmode[id] > 0) {
				if(!mess[id]) {
					ColorChat(id, RED, "^x04[DeathRun Shop]^x01 Your godmode is already activated!");
					mess[id]++;
					set_task(3.0, "remove_mess", id);
					return FMRES_IGNORED;
				}
				return FMRES_IGNORED;
			}
        
			gotgodmode[id] = 0;
			hasgodmode[id]++;
			fm_set_user_godmode(id, 1);
			if(get_user_team(id) == 1)
				fm_set_user_rendering(id, kRenderFxGlowShell, 255, 0, 0, kRenderTransAlpha, 255);
			else if(get_user_team(id) == 2)
				fm_set_user_rendering(id, kRenderFxGlowShell, 0, 0, 255, kRenderTransAlpha, 255);
			
			set_task(5.0, "remove_godmode", id);
		
			if(!mess[id]) {
				ColorChat(id, RED, "^x04[DeathRun Shop]^x01 Your godmode is now active!");
				mess[id]++;
				set_task(3.0, "remove_mess", id);
			} 
			return FMRES_SUPERCEDE;
		} 
		return FMRES_IGNORED;
}


// User Spawn event
public fwEvResetHUD( id ) {
        if (!is_user_alive(id))
                return;
 
 
        if (g_bPlayerNonSpawnEvent[id]) {
                g_bPlayerNonSpawnEvent[id] = false;
                return;
        }
 
        fwPlayerSpawn(id);
}
 
public fwEvGameWillRestartIn() {
        static iPlayers[32], iPlayersNum, i;
        get_players(iPlayers, iPlayersNum, "a");
        for (i = 0; i < iPlayersNum; ++i)
                g_bPlayerNonSpawnEvent[iPlayers[i]] = true;
}
 
public fwCmdClFullupdate( id ) {
        g_bPlayerNonSpawnEvent[id] = true;
        static const szFwFmClientCommandPost[] = "fwFmClientCommandPost";
        g_iFwFmClientCommandPost = register_forward(FM_ClientCommand, szFwFmClientCommandPost, 1);
        return PLUGIN_CONTINUE;
}
 
public fwFmClientCommandPost( id ) {
        unregister_forward(FM_ClientCommand, g_iFwFmClientCommandPost, 1);
        g_bPlayerNonSpawnEvent[id] = false;
        return FMRES_HANDLED;
}
 
public fwPlayerSpawn( id ) {
	if(!is_user_alive(id))
		return PLUGIN_HANDLED;
		
		
	if(get_pcvar_num(plugin_on) == 1) {
		set_pev(id, pev_flTimeStepSound, 400);
		fm_set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 255);
		fm_set_user_health(id, 100);
		fm_set_user_armor(id, 0);
		fm_set_user_gravity(id, 1.0);
		usersilent[id]	= 0;
		userstealth[id]	= 0;
		usernoflash[id]	= 0;
		userhp[id]	= 0;
		userarmor[id]	= 0;
		usergrenade[id]	= 0;
		usergravity[id]	= 0;
		//userspeed[id]	= 0;
		//userter[33]	= 0;
		hassilent[id]	= 0;
	}
	return PLUGIN_HANDLED;
}  

// User Death event
public eDeath( id ) {
	new victem = read_data(2);
		
	usersilent[victem]	= 0;
	userstealth[victem]	= 0;
	usernoflash[victem]	= 0;
	userhp[victem]		= 0;
	userarmor[victem]	= 0;
	usergrenade[victem]	= 0; 
	usergravity[victem]	= 0;
	//userspeed[victem]	= 0;
	//userter[33]	= 0;
	hasspeed[victem]	= 0;
	hasgodmode[victem]	= 0;
	hassilent[victem]	= 0;
}


// Showing menu
public show_hnsmenu( id ) {
	if(get_pcvar_num(plugin_on) == 1) {
		new szText[ 555 char ];
		formatex( szText, charsmax( szText ),"%L", id, "DRSHOP_MENU_TITLE" );
		new menu = menu_create( szText, "shop_handler" );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_1", get_pcvar_num(smokecost) );
		menu_additem( menu, szText, "1", 0 );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_2", get_pcvar_num(noflashcost) );
		menu_additem( menu, szText, "2", 0 );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_3", get_pcvar_num(hpcvar), get_pcvar_num(hpcost) );
		menu_additem( menu, szText, "3", 0 );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_4", get_pcvar_num(flashcost) );
		menu_additem( menu, szText, "4", 0 );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_5", get_pcvar_num(grenadecost) );
		menu_additem( menu, szText, "5", 0 );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_6", get_pcvar_num(gravitycost) );
		menu_additem( menu, szText, "6", 0 );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_7", get_pcvar_num(speedcost) );
		menu_additem( menu, szText, "7", 0 );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_8", get_pcvar_num(respawncost) );
		menu_additem( menu, szText, "8", 0 );
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_9", get_pcvar_num(bhopcost) );
		menu_additem( menu, szText, "9", 0 );

		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_10", get_pcvar_num(mp5cost) );
		menu_additem( menu, szText, "10", 0 );
		
		formatex( szText, charsmax( szText ), "%L", id, "DRSHOP_ITEM_11", get_pcvar_num(tercost) );
		menu_additem( menu, szText, "11", 0 );

		menu_setprop( menu, MPROP_EXIT, MEXIT_ALL );
	
		menu_display( id, menu, 0 );

		//new iKeys = ( 1<<0 | 1<<1 | 1<<2 | 1<<3 | 1<<4 | 1<<5 | 1<<6 | 1<<7 | 1<< 8 | 1<<9 );
		//show_menu(id, iKeys, szBuffer, -1, "DeathRun Shop");
	} else
		ColorChat(id, BLUE, "^x04[DeathRun Shop]^x01 Shop has been disabled.");
	return PLUGIN_HANDLED;
}


public shop_handler( id, menu, item, key )
{
	/* --| If key is 0, let's close the menu */
	if( item == MENU_EXIT )
	{
		menu_destroy( menu );
		return PLUGIN_HANDLED;
	}

	/* --| Getting the menu information */
	new data[ 6 ], iName[ 64 ], access, callback;
	menu_item_getinfo( menu, item, access, data, charsmax( data ), iName, charsmax( iName ), callback );

	/* --| Get menu keys */
	new key = str_to_num( data );
	
	static Float:originF[3];
	pev(id, pev_origin, originF);
	
	switch( key )
	{
		case 1: // smoke
		{
			if(!is_user_alive(id)) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_ALIVE" );
				return PLUGIN_HANDLED;  
			}
			if(usersilent[id] > 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 You already own this item!");
				return PLUGIN_HANDLED;
			}
			if(get_pcvar_num(allowsmoke) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(smokecost);
	
			if(money > cost || money == cost) {
				set_pev(id, pev_flTimeStepSound, 999);
				fm_set_user_money(id, money - cost);
				//usersilent[id]++;
				fm_give_item(id, "weapon_smokegrenade");
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_1" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 2: // NoFlash Blinding
		{
			if(!is_user_alive(id)) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_ALIVE" );
				return PLUGIN_HANDLED;
			}
			if(usernoflash[id] > 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 Вы уже это имеете!");
				return PLUGIN_HANDLED;
			}
			if(get_pcvar_num(allownoflash) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(noflashcost);
	
			if(money > cost || money == cost) {
				fm_set_user_money(id, money - cost);
				usernoflash[id]++;
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_2" );
			} else {  
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			} 
		}
		case 3: // HP
		{
			if(!is_user_alive(id)) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_ALIVE" );
				return PLUGIN_HANDLED;
			}
			if(userhp[id] > 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 Вы уже это имеете!");
				return PLUGIN_HANDLED;
			}
			if(get_pcvar_num(allowhp) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(hpcost);
	
			if(money > cost || money == cost) {
				new health = get_pcvar_num(hpcvar);
				fm_set_user_money(id, money - cost);
				fm_set_user_health(id, health);
				//userhp[id]++;
				client_cmd(id, "spk items/medshot4");
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_3", get_pcvar_num(hpcvar) );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 4: // Flash
		{
			if(!is_user_alive(id)) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_ALIVE" );
				return PLUGIN_HANDLED;
			}
			if(userarmor[id] > 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 Вы уже это имеете!");
				return PLUGIN_HANDLED;
			}
			if(get_pcvar_num(allowflash) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(flashcost);
		
			if(money > cost || money == cost) {
				//new armor = get_pcvar_num(flashcost);
				fm_set_user_money(id, money - cost);
				fm_give_item(id, "weapon_flashbang");
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_4" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 5: // HE Grenade
		{
			if(!is_user_alive(id)) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_ALIVE" );
				return PLUGIN_HANDLED;
			}
			if(usergrenade[id] > 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 Вы уже это имеете!");
				return PLUGIN_HANDLED;
			}
			if(get_pcvar_num(allowgrenade) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(grenadecost);
	
			if(money > cost || money == cost) {
				fm_set_user_money(id, money - cost);
				fm_give_item(id, "weapon_hegrenade");
				//usergrenade[id]++;
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_5" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 6: // Gravity
		{
			if(!is_user_alive(id)) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_ALIVE" );
				return PLUGIN_HANDLED;
			}
			if(usergravity[id] > 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 Вы уже это имеете!");
				return PLUGIN_HANDLED;
			}
			if(get_pcvar_num(allowgravity) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(gravitycost);
		
			if(money > cost || money == cost) {
				fm_set_user_money(id, money - cost);
				fm_set_user_gravity(id, 0.50);
				//usergravity[id]++;
				//set_task(30.0, "remove_gravity", id);
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_6" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 7: // Faster Speed
		{
			if(!is_user_alive(id)) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_ALIVE" );
				return PLUGIN_HANDLED; 
			}
			if(get_pcvar_num(allowspeed) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(speedcost);
	
			if(money > cost || money == cost) {
				fm_set_user_money(id, money - cost);
				//userspeed[id]++;
				hasspeed[id]++;
				fm_set_user_maxspeed(id, 500.0);
				//set_task(50.0, "remove_speed", id);
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_7" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 8: // Respawn
		{
			if(get_pcvar_num(allowrespawn) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(respawncost);
	
			if(money > cost || money == cost) {
				fm_set_user_money(id, money - cost);
				ExecuteHam(Ham_CS_RoundRespawn, id);
				//set_user_health(id, 100)
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_8" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 9: // Bhop
		{
			if(get_pcvar_num(allowbhop) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(bhopcost);
	
			if(money > cost || money == cost) {
				fm_set_user_money(id, money - cost);
				userspeed[id] = 1;
				set_task(1.0, "client_PreThink", id);
				set_task(300.0, "remove_bhop", id);
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_9" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 10: // MP5
		{
			if(get_pcvar_num(allowmp5) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(mp5cost);
	
			if(money > cost || money == cost) {
				fm_set_user_money(id, money - cost);
				fm_give_item(id, "weapon_mp5navy");
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_10" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
		case 11: // Ter
		{
			if(get_pcvar_num(allowter) == 0) {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 This item is disabled.");
				return PLUGIN_HANDLED;
			}
	
			new money = fm_get_user_money(id);
			new cost = get_pcvar_num(tercost);
	
			if(money > cost || money == cost) {
				fm_set_user_money(id, money - cost);
				usert[id] = 1;
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_BUYITEM_11" );
			} else {
				ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 %L", id, "DRSHOP_NOT_MONEY" );
			}
		}
	}
	
	return PLUGIN_HANDLED;
}


// Remove Gravity
public remove_gravity( id ) {
	fm_set_user_gravity(id, 1.0);
	ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 Your gravity now is normal.");
}  

// Remove Stealth
public remove_stealth( id ) {
	fm_set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 255);
	ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 You are^x03 visible^x01 like others.");
}

// Remove Speed
public remove_speed( id ) {
	fm_set_user_maxspeed(id, 250.0);
	hasspeed[id] = 0;
	ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 Your speed is normal now.");
}

// Remove Bhop
public remove_bhop( id ) {
	userspeed[id] = 0;
	ColorChat(id, BLUE, "^x04[DeathRun Магазин]^x01 У вас кончилась Авто распрыжка.");
}

public client_PreThink(id)
{
    if(is_user_alive(id))
    {
	if(userspeed[id] == 1)
        {
            
            new oldbuttons = get_user_oldbutton(id);
        
            
            oldbuttons &= ~IN_JUMP;
            entity_set_int(id, EV_INT_oldbuttons, oldbuttons);
        }
    }
}  

public round_end(id)
{
	{
		if(usergravity[id] == 1)
		{
		cs_set_user_team(id, CS_TEAM_T);
		engclient_cmd(id, "jointeam", "1");
		engclient_cmd(id, "joinclass", "1");
		client_print(id, print_chat, "End round");
		usergravity[id] = 0;
		}
	}
}  

public round_start()
{
    static id;
    for(id = 1; id <= mxplr; id++) 
    { 
        if(!is_user_alive(id)) 
        continue; 

        if(cs_get_user_team(id) == CS_TEAM_CT && usert[id]) 
        { 
            user_silentkill(id); 
            cs_set_user_team(id, CS_TEAM_T, CS_T_LEET); 
            ExecuteHamB(Ham_CS_RoundRespawn, id); 
             
            message_begin(MSG_ALL, get_user_msgid("ScoreAttrib")); 
            write_byte(id); 
            write_byte(0); 
            message_end(); 
             
            usert[id] = 0; 
        } 
    }  
}




// Remove Godmode
public remove_godmode( id ) {
	hasgodmode[id] = 0;
	fm_set_user_godmode(id, 0);
	if(!mess2[id]) {
		ColorChat(id, RED, "^x04[DeathRun Магазин]^x01 You dont have godmode anymore.");
		mess2[id]++;
		fm_set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 255);
		set_task(3.0, "remove_mess2", id);
	}
}

public remove_mess( id )		mess[id]	= 0;
public remove_mess2( id )	mess2[id]	= 0;

/// NoFlash Blinding - Start
public bad_fix2() {
	new Float:gametime = get_gametime();
	if(gametime - g_gametime2 > 2.5)
		for(new i = 0; i < 32; i++)
			grenade[i] = 0;
}

public eventFlash( id ) {
	new Float:gametime = get_gametime();
	if(gametime != g_gametime) { 
		g_owner = get_grenade_owner();
		g_gametime = gametime;
		for(new i = 0; i < 33; i++) 
			g_track[i] = false;
		g_track_enemy = false;
	}    
	if(is_user_connected(g_owner) && usernoflash[id] > 0) {
		g_track_enemy = true;

		message_begin(MSG_ONE, g_msgScreenFade, {0,0,0}, id);
		write_short(1);
		write_short(1);
		write_short(1);
		write_byte(0);
		write_byte(0);
		write_byte(0);
		write_byte(255);
		message_end();
	}
}

public flash_delay() {
	if(g_track_enemy == false) {
		for(new i = 0; i < 33; i++) {
			if(g_track[i] == true && is_user_connected(i)) {
				message_begin(MSG_ONE, g_msgScreenFade, {0,0,0}, i) ;
				write_short(1);
				write_short(1);
				write_short(1);
				write_byte(0);
				write_byte(0);
				write_byte(0);
				write_byte(255);
				message_end();
			}
		}
	}
}

public grenade_throw() {
	if(g_sync_check_data == 0)
		return PLUGIN_CONTINUE;
	g_sync_check_data--;
	if(read_datanum() < 2)
		return PLUGIN_HANDLED_MAIN;

	if(read_data(1) == 11 && (read_data(2) == 0 || read_data(2) == 1))
		add_grenade_owner(last);

	return PLUGIN_CONTINUE;
}

public fire_in_the_hole() {
	new name[32];
	read_data(3, name, 31);
	new temp_last = get_user_index(name);
	new junk;
	if((temp_last == 0) || (!is_user_connected(temp_last)))
		return PLUGIN_CONTINUE;
	if(get_user_weapon(temp_last,junk,junk) == CSW_FLASHBANG) {
		last = temp_last;
		g_sync_check_data = 2; 
	}
	return PLUGIN_CONTINUE;
}

public fire_in_the_hole2() {
	new name[32];
	read_data(4, name, 31);
	new temp_last = get_user_index(name);
	new junk;
	if((temp_last == 0) || (!is_user_connected(temp_last)))
		return PLUGIN_CONTINUE;
	if(get_user_weapon(temp_last,junk,junk) == CSW_FLASHBANG) {    
		last = temp_last;
		g_sync_check_data = 2;
	}
	return PLUGIN_CONTINUE;
}

add_grenade_owner(owner) {
	new Float:gametime = get_gametime();
	g_gametime2 = gametime;
	for(new i = 0; i < 32; i++) {
		if(grenade[i] == 0) {
			grenade[i] = owner;
			return;
		}
	}
}

get_grenade_owner() {
	new which = grenade[0];
	for(new i = 1; i < 32; i++)  
		grenade[i-1] = grenade[i];
	grenade[31] = 0;
	return which;
}

// from XxAvalanchexX "Flashbang Dynamic Light"
public fw_emitsound(entity,channel,const sample[],Float:volume,Float:attenuation,fFlags,pitch) {
	if(!equali(sample,"weapons/flashbang-1.wav") && !equali(sample,"weapons/flashbang-2.wav"))
		return FMRES_IGNORED;

	new Float:gametime = get_gametime();

	//in case no one got flashed, the sound happens after all the flashes, same game time
	if(gametime != g_gametime) {
		g_owner = get_grenade_owner();
		return FMRES_IGNORED;
	}
	return FMRES_IGNORED;
}
// NoFlash Blinding - End 

// Stocks - Start
public fm_set_user_money ( index, i_Money ) { 
	set_pdata_int ( index, 115, i_Money ); 

	message_begin ( MSG_ONE, g_msgMoney, _, index ); 
	write_long ( i_Money ); 
	write_byte ( 1 ); 
	message_end (); 
}

stock fm_get_user_godmode( index ) {
	new Float:val;
	pev(index, pev_takedamage, val);

	return (val == DAMAGE_NO);
}

stock fm_set_user_godmode( index, godmode = 0 ) {
	set_pev(index, pev_takedamage, godmode == 1 ? DAMAGE_NO : DAMAGE_AIM);

	return 1;
}

stock fm_set_user_health( index, health ) {
	health > 0 ? set_pev(index, pev_health, float(health)) : dllfunc(DLLFunc_ClientKill, index);

	return 1;
}

stock fm_set_user_rendering(index, fx = kRenderFxNone, r = 255, g = 255, b = 255, render = kRenderNormal, amount = 16) {
	return fm_set_rendering(index, fx, r, g, b, render, amount);
}

stock fm_set_user_maxspeed( index, Float:speed = -1.0 ) {
	engfunc(EngFunc_SetClientMaxspeed, index, speed);
	set_pev(index, pev_maxspeed, speed);

	return 1;
}

stock fm_set_user_armor( index, armor ) {
	set_pev(index, pev_armorvalue, float(armor));

	return 1;
}

stock fm_set_user_gravity( index, Float:gravity = 1.0 ) {
	set_pev(index, pev_gravity, gravity);

	return 1;
}

stock fm_give_item( index, const item[] ) {
	if (!equal(item, "weapon_", 7) && !equal(item, "ammo_", 5) && !equal(item, "item_", 5))
		return 0;

	new ent = fm_create_entity(item);
	if (!pev_valid(ent))
		return 0;

	new Float:origin[3];
	pev(index, pev_origin, origin);
	set_pev(ent, pev_origin, origin);
	set_pev(ent, pev_spawnflags, pev(ent, pev_spawnflags) | SF_NORESPAWN);
	dllfunc(DLLFunc_Spawn, ent);

	new save = pev(ent, pev_solid);
	dllfunc(DLLFunc_Touch, ent, index);
	if (pev(ent, pev_solid) != save)
		return ent;

	engfunc(EngFunc_RemoveEntity, ent);

	return -1;
}

stock fm_set_rendering(entity, fx = kRenderFxNone, r = 255, g = 255, b = 255, render = kRenderNormal, amount = 16) {
	new Float:RenderColor[3];
	RenderColor[0] = float(r);
	RenderColor[1] = float(g);
	RenderColor[2] = float(b);

	set_pev(entity, pev_renderfx, fx);
	set_pev(entity, pev_rendercolor, RenderColor);
	set_pev(entity, pev_rendermode, render);
	set_pev(entity, pev_renderamt, float(amount));

	return 1;
}
// Stocks - End

// ColorChat - Start
ColorChat(id, Color:type, const msg[], {Float,Sql,Result,_}:...) {
	new message[256];

	switch(type) {
		case NORMAL:	message[0] = 0x01;
		case GREEN:	message[0] = 0x04;
		default:	message[0] = 0x03;
	}

	vformat(message[1], 251, msg, 4);

	// Make sure message is not longer than 192 character. Will crash the server.
	message[192] = '^0';

	new team, ColorChange, index, MSG_Type;
	
	if(id) {
		MSG_Type = MSG_ONE;
		index = id;
	} else {
		index = FindPlayer();
		MSG_Type = MSG_ALL;
	}
	
	team = get_user_team(index);
	ColorChange = ColorSelection(index, MSG_Type, type);

	ShowColorMessage(index, MSG_Type, message);
		
	if(ColorChange)
		Team_Info(index, MSG_Type, TeamName[team]);
}

ShowColorMessage(id, type, message[]) {
	static bool:saytext_used;
	static get_user_msgid_saytext;
	if(!saytext_used) {
		get_user_msgid_saytext = get_user_msgid("SayText");
		saytext_used = true;
	}
	message_begin(type, get_user_msgid_saytext, _, id);
	write_byte(id);
	write_string(message);
	message_end();	
}

Team_Info(id, type, team[]) {
	static bool:teaminfo_used;
	static get_user_msgid_teaminfo;
	if(!teaminfo_used) {
		get_user_msgid_teaminfo = get_user_msgid("TeamInfo");
		teaminfo_used = true;
	}
	message_begin(type, get_user_msgid_teaminfo, _, id);
	write_byte(id);
	write_string(team);
	message_end();

	return 1;
}

ColorSelection(index, type, Color:Type) {
	switch(Type) {
		case RED:	return Team_Info(index, type, TeamName[1]);
		case BLUE:	return Team_Info(index, type, TeamName[2]);
		case GREY:	return Team_Info(index, type, TeamName[0]);
	}

	return 0;
}

FindPlayer(){
	new i = -1;

	while(i <= get_maxplayers())
		if(is_user_connected(++i))
			return i;
	
	return -1;
}