/*
MAP REQUESTER

=============

Description:
This plugin is made for clients to request maps that aren't on the server easier instead of asking admins every time they play about new maps.
It writes the requested map in a maprequests.ini file, located at the amxmodx/data folder.
There are a max number of requests a client can make, to avoid spammers.
It also writes the name and the steamid of the requester, so abusers can be punished.


Commands:
requestmap <mapname> : Adds a request to the ini file.
checkreq : Lists the requested maps in console.

Credits:
Fysiks: Improving my code.

Cvars:
amx_mapreq_advertdelay : The delay between 2 adverts printed.

Changelog:
v1.0 - Initial release
v1.1 - Minor fix, added checkreq command
v1.2 - Fixed admin access(fysiks)
v1.3 - Added colorchat(optional)

Note 1:
- You can change the number of maps clients can choose by editing #define MAX_REQUESTS 3 to the number you want

Note 2:
-To enable colorchat, uncomment the line //define USE_CC
*/  
#include <amxmodx>

//#define USE_CC

#if defined USE_CC
#include <colorchat>
#endif

#define MAX_REQUESTS 3

new g_szFile[64]
new requested[33]

public plugin_init()
{
	register_plugin("Map requests", "1.3", "Drekes")
	
	register_concmd("requestmap", "addmap")
	register_concmd("checkreq", "checkrequests", ADMIN_CFG, "prints the mapsrequest.ini file in your console")
	
	register_clcmd("say advert", "advert")
		
	new datadir[64]
	get_localinfo("amxx_datadir", datadir, 63)
	format(g_szFile, 63, "%s/maprequests.ini", datadir)
	
	// Advertisements
	register_cvar("amx_mapreq_advertdelay", "180") 
	
	new Float:fDelay = get_cvar_float("amx_mapreq_advertdelay")	//Thanks to fysiks
	if( fDelay > 0.1 )
		set_task(fDelay, "advert", _, _, _, "b")
}

public client_putinserver(id)
{
	requested[id] = 0
}

public advert()
{
	#if defined USE_CC
	ColorChat(0, GREEN, "[AMXX]:^x03 Want a map that isn't on the server? Type^x01 requestmap mapname^x03 in console")
	#else
	client_print(0, print_chat, "[AMXX]: Want a map that isn't on the server? Type requestmap mapname in console")
	#endif
}

public addmap(id)
{
	if(requested[id] >= MAX_REQUESTS)
	{
		console_print(id, "[AMXX]: You already requested %i maps. You can request more after map change.", MAX_REQUESTS)
		return PLUGIN_HANDLED
	}
	
	new szData[35], szWrite[128]
	new szName[33], szSteamID[35]

	read_argv(1, szData, 34)
	get_user_name(id, szName, 32)
	get_user_authid(id, szSteamID, 34)

	formatex(szWrite, 127, "%s STEAMID: %s requests map: %s", szName, szSteamID, szData)
	write_file(g_szFile, szWrite)

	requested[id]++
	
	console_print(id, "Your map request has been succesfully added.")
	
	return PLUGIN_HANDLED
}  

public checkrequests(id, level)
{
	if(!(get_user_flags(id) & level)) // thanks to fysiks
	{
		console_print(id, "You have no access to this command")
		return
	} 
	
	new f
	if(!file_exists(g_szFile))
	{
		console_print(id, "File doesn't exist, no maps requested")
		return
	}

	f = fopen(g_szFile, "r")
	
	if(!f)
	{
		log_amx("Error: Could not open file (%s).", g_szFile)
		return
	}

	new data[128]
	
	while(!feof(f))
	{
		fgets(f, data, 127)
		console_print(id, "%s", data)
	}
	fclose(f)
}  