/*	AMX Mod X script

	      :

******************************************************************************

	Info Rank v0.2.0 by ConnorMcLeod

	Info Rank is free software;
	you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Info Rank; if not, write to the
	Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	Boston, MA 02111-1307, USA.

******************************************************************************

    PS3 Stats - Psychostats3 in-game statistic v. 1.0
    Author: GeroiN
    E-Mail: maxim<.at.>osetia.org
    Homepage: http://portal.kaliningrad.ru
 
******************************************************************************

	Rebuilding by UFPS.Team
*/

#define ENABLED_BY_DEFAULT	true
#define RANK_EVERYROUND		false

//#define USING_PS3

#include <amxmodx>
#include <amxmisc>

#if defined USING_PS3
#include <sqlx>
#else
#include <csx>
#endif

#define PLUGIN_NAME			"Info Rank"
#define PLUGIN_VERSION		"4.0"
#define PLUGIN_AUTHOR		"UFPS.Team"


#define STATS_KILLS			0
#define STATS_DEATHS		1
#define STATS_HS			2
#define STATS_TKS			3
#define STATS_SHOTS			4
#define STATS_HITS			5
#define STATS_DAMAGE		6

#define SAYRANK				1
#define GETUNIQUEID			3

#if defined USING_PS3
new Handle:g_DbInfo
new g_psprefix[64]
new g_QueryNum
new g_Type[32]
#endif

new g_oldrank[33]
new bool:g_enable[33]

new msg_SayText, msg_TeamInfo, g_maxplayers, pcv_inforank

enum Color
{
	NORMAL = 1,
	GREEN,
	TEAM_COLOR,
	GREY,
	RED,
	BLUE,
}

new const TeamName[][] =
{
	"",
	"TERRORIST",
	"CT",
	"SPECTATOR"
}

public plugin_init()
{
	register_plugin ( PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR )

	register_dictionary ( "info_rank.txt" )

	register_logevent ( "event_end_round", 2, "1=Round_End" )

	register_clcmd ( "say /inforank",		"cmd_inforank", 0, "- enable/disable info rank messages" )
	register_clcmd ( "say_team /inforank",	"cmd_inforank", 0, "- enable/disable info rank messages" )

	pcv_inforank = register_cvar("amx_inforank", "1")

	msg_TeamInfo = get_user_msgid ( "TeamInfo" )
	msg_SayText = get_user_msgid ( "SayText" )

	g_maxplayers = get_maxplayers()

#if defined USING_PS3
	if ( !get_cvar_pointer ( "amx_sql_pshost" ) )
		register_cvar ( "amx_sql_pshost", "127.0.0.1" )

	if ( !get_cvar_pointer ( "amx_sql_psuser" ) )
		register_cvar ( "amx_sql_psuser", "root" )

	if ( !get_cvar_pointer ( "amx_sql_pspass" ) )
		register_cvar ( "amx_sql_pspass", "" )

	if ( !get_cvar_pointer ( "amx_sql_psdb" ) )
		register_cvar ( "amx_sql_psdb", "ps3" )

	if ( !get_cvar_pointer ( "amx_sql_psprefix" ) )
		register_cvar ( "amx_sql_psprefix", "ps_" )

	new configsdir[64]
	get_configsdir ( configsdir, sizeof ( configsdir ) - 1 )
	
	server_cmd ( "exec %s/sql.cfg", configsdir )
	server_exec ( )
#endif
}

public event_end_round ( )
{
	if ( get_pcvar_num ( pcv_inforank ) )
	{
		static players[32], num, i
		get_players ( players, num, "ch" )

#if defined USING_PS3
		for ( i = 0; i < num; i++ ) print_inforank_ps3 ( players[i] )
#else
		for ( i = 0; i < num; i++ ) print_inforank_statsx ( players[i] )
#endif
	}

	return PLUGIN_CONTINUE
}

public cmd_inforank ( id )
{
	if( get_pcvar_num ( pcv_inforank ) )
	{
		if ( ( g_enable[id] = !g_enable[id] ) )
		{
			client_cmd ( id, ";setinfo _ir 1" )
			client_print_color ( id, GREEN, "%L", id, "IR_ENABLE" )
		}

		else
		{
			client_cmd ( id, ";setinfo _ir 0" )
			client_print_color ( id, RED, "%L", id, "IR_DISABLE" )
		}
	}

	return PLUGIN_CONTINUE
}

public client_putinserver ( id )
{
	if ( is_user_bot (id) || is_user_hltv ( id ) )
	{
		return PLUGIN_CONTINUE
	}

#if defined USING_PS3
	g_oldrank[id] = 0
#else
	new izStats[8]
	g_oldrank[id] = get_user_stats ( id, izStats, izStats )
#endif

	new szEnable[2]
	get_user_info ( id, "_ir", szEnable, 1 )

	if ( !szEnable[0] )
	{
		g_enable[id] = ENABLED_BY_DEFAULT

		return PLUGIN_CONTINUE
	}

	if ( szEnable[0] == '1' )
		g_enable[id] = true

	else
		g_enable[id] = false

	return PLUGIN_CONTINUE
}

public client_disconnect ( id )
{
	g_oldrank[id] = 0
	g_enable[id] = false
}

#if defined USING_PS3
public plugin_cfg ( )
{
	new pshost[64]
	new psuser[64]
	new pspass[64]
	new psdb[64]

	new query[1024]
	new data[3]

	get_cvar_string ( "amx_sql_pshost", pshost, sizeof ( pshost ) - 1 )
	get_cvar_string ( "amx_sql_psuser", psuser, sizeof ( psuser ) - 1 )
	get_cvar_string ( "amx_sql_pspass", pspass, sizeof ( pspass ) - 1 )
	get_cvar_string ( "amx_sql_psdb", psdb, sizeof ( psdb ) - 1 )
	get_cvar_string ( "amx_sql_psprefix", g_psprefix, sizeof ( g_psprefix ) - 1 )
	
	g_DbInfo = SQL_MakeDbTuple ( pshost, psuser, pspass, psdb )

	format ( query, 1024, "SELECT value FROM %sconfig WHERE var = 'uniqueid' LIMIT 1", g_psprefix )

	data[0] = g_QueryNum
	data[1] = GETUNIQUEID
	data[2] = 0

	SQL_ThreadQuery ( g_DbInfo, "GetMyStuff", query, data, 3 )
	g_QueryNum++
}

public print_inforank_ps3 ( id )
{
	new query[1024]
	new data[3]
	new uniqueid[32]
	
	data[0] = g_QueryNum
	data[1] = SAYRANK
	data[2] = id
	
	get_user_unique_id ( id, g_Type, uniqueid, 31 )
	quote_sql ( uniqueid, 31 )

	format ( query, 1024, "SELECT plr.rank, (SELECT COUNT( * ) FROM %splr plr WHERE plr.allowrank = 1) AS ranked, d.kills, d.deaths, d.hits, plr.skill, d.accuracy FROM %sc_plr_data as d, %splr as plr, %splr_profile as pp WHERE plr.plrid=d.plrid AND plr.uniqueid=pp.uniqueid AND pp.uniqueid='%s' AND plr.rank > 0 AND plr.allowrank = 1 ORDER BY plr.rank ASC LIMIT 1", g_psprefix, g_psprefix, g_psprefix, g_psprefix, uniqueid )

	SQL_ThreadQuery ( g_DbInfo, "GetMyStuff", query, data, 3 )
	g_QueryNum++

	return PLUGIN_CONTINUE
}

public GetMyStuff ( failstate, Handle:query, error[], errnum, data[], size, Float:queuetime )
{
	if ( failstate )
	{
		if ( failstate == TQUERY_CONNECT_FAILED )
			log_amx ( " --> Connection failed!" )

		else if ( failstate == TQUERY_QUERY_FAILED )
			log_amx ( " --> Query failed!" )

		log_amx ( " --> Error code: %d (Message: ^"%s^")", errnum, error )

		new querystring[1024]

		SQL_GetQueryString ( query, querystring, sizeof ( querystring ) - 1 )
		log_amx ( " --> Original query: %s", querystring )
	}

	else
	{
		if ( data[1] == SAYRANK )
		{
		    PrintRankData ( query, data[2] )
		}

		else if ( data[1] == GETUNIQUEID )
		{
		    SaveUniqueId ( query )
		}
	}
}

public SaveUniqueId ( Handle:query )
{
	if ( SQL_MoreResults ( query ) )
		SQL_ReadResult ( query, 0, g_Type, sizeof ( g_Type ) - 1 )

	else
		log_amx ( " --> Error in Psychostats DB. Can't get uniqueid type." )
}

public PrintRankData ( Handle:query, id )
{
	if ( g_enable[id] && SQL_MoreResults ( query ) )
	{
		new iRankCur, iRanked, iRankPos
		new iKills, iDeaths, iHits
		new Float:fSkill, Float:fAccuracy

		iRankCur	= SQL_ReadResult ( query, 0 )
		iRanked		= SQL_ReadResult ( query, 1 )
		iKills		= SQL_ReadResult ( query, 2 )
		iDeaths		= SQL_ReadResult ( query, 3 )
		iHits		= SQL_ReadResult ( query, 4 )
		SQL_ReadResult ( query, 5, fSkill )
		SQL_ReadResult ( query, 6, fAccuracy )

		iRankPos = g_oldrank[id]

		if ( iRankPos == 0 ) iRankPos = iRankCur

		g_oldrank[id] = iRankCur

		new iRankDelta = iRankPos - iRankCur
		new stats_everyround = RANK_EVERYROUND

		if ( !iRankDelta )
		{
			if ( stats_everyround )
				client_print_color ( id, GREY, "%L", id, "IR_RANK", iRankCur, iRanked, iKills, iDeaths, iHits, fSkill, fAccuracy )
		}

		else
		{
			if ( iRankDelta > 0 )
				client_print_color ( id, GREEN, "%L", id, "IR_GOOD", iRankDelta )

			else if ( iRankDelta < 0 )
				client_print_color ( id, RED, "%L", id, "IR_BAD", -iRankDelta )

			client_print_color ( id, GREY, "%L", id, "IR_RANK", iRankCur, iRanked, iKills, iDeaths, iHits, fSkill, fAccuracy )
		}
	}
}

public get_user_unique_id ( id, type[], uniqueid[], len )
{
	if ( equal ( type, "name" ) )
		get_user_name ( id, uniqueid, len )

	else if ( equal ( type, "steamid" ) || equal ( type, "worldid" ) )
		get_user_authid ( id, uniqueid, len )

	else if ( equal ( type, "ipaddr" ) )
		get_user_ip ( id, uniqueid, len )

	else
		log_amx ( " --> Error at get_user_unique_id; 'type' = '%s'", type )
}

public quote_sql ( string[],len )
{
	new charnum

	while ( replace ( string[charnum], len, "'", "\'" ) != 0 )
	{
		charnum += contain ( string[charnum], "\'" ) + 2
	}

	charnum = 0
	while ( replace ( string[charnum], len, "`", "\`" ) != 0 )
	{
		charnum += contain ( string[charnum], "\`" ) + 2
	}
}
	
public plugin_end ( )
{
	SQL_FreeHandle ( g_DbInfo )
}

#else

print_inforank_statsx ( id )
{
	if ( g_enable[id] )
	{
		new iMax = get_statsnum()
		new izStats[8], izBody[8], iRankPos
		new iRankCur = get_user_stats ( id, izStats, izBody )

		iRankPos = g_oldrank[id]

		if ( iRankPos == 0 ) iRankPos = iRankCur

		g_oldrank[id] = iRankCur

		new iRankDelta = iRankPos - iRankCur
		new stats_everyround = RANK_EVERYROUND

		if ( !iRankDelta )
		{
			if ( stats_everyround )
				client_print_color ( id, GREY, "%L", id, "IR_RANK", iRankCur, iMax, izStats[STATS_KILLS], izStats[STATS_DEATHS], izStats[STATS_HITS], effec(izStats), accuracy(izStats) )
		}

		else
		{
			if ( iRankDelta > 0 )
				client_print_color ( id, GREEN, "%L", id, "IR_GOOD", iRankDelta )

			else if ( iRankDelta < 0 )
				client_print_color ( id, RED, "%L", id, "IR_BAD", -iRankDelta )

			client_print_color ( id, GREY, "%L", id, "IR_RANK", iRankCur, iMax, izStats[STATS_KILLS], izStats[STATS_DEATHS], izStats[STATS_HITS], effec(izStats), accuracy(izStats) )
		}
	}
}

Float:accuracy ( izStats[8] )
{
	if ( !izStats[STATS_SHOTS] )
		return ( 0.0 )
	
	return ( 100.0 * float ( izStats[STATS_HITS] ) / float ( izStats[STATS_SHOTS] ) )
}

Float:effec ( izStats[8] )
{
	if ( !izStats[STATS_KILLS] )
		return ( 0.0 )
	
	return ( 100.0 * float ( izStats[STATS_KILLS] ) / float ( izStats[STATS_KILLS] + izStats[STATS_DEATHS] ) )
}

#endif

client_print_color ( id, Color:type, const msg[], any:... )
{
	new message[256]

	switch ( type )
	{
		case NORMAL:	message[0] = 0x01;
		case GREEN:		message[0] = 0x04;
		default:		message[0] = 0x03;
	}

	vformat(message[1], 251, msg, 4)
	message[192] = '^0'

	new team, team_restore, index, MSG_Type
	
	if ( id )
	{
		MSG_Type = MSG_ONE_UNRELIABLE
		index = id
	}

	else
	{
		index = find_anyplayer()
		MSG_Type = MSG_BROADCAST
	}
	
	team = get_user_team(index);
	team_restore = select_color(index, MSG_Type, type);
	print_message(index, MSG_Type, message);
	
	if ( team_restore )
	{
		select_team(index, MSG_Type, TeamName[team]);
	}
}

print_message ( id, type, message[] )
{
	message_begin ( type, msg_SayText, _, id )
	write_byte ( id )
	write_string ( message )
	message_end ( )
}

select_team ( id, type, team[] )
{
	message_begin ( type, msg_TeamInfo, _, id )
	write_byte ( id )
	write_string ( team )
	message_end ( )

	return 1
}

select_color ( index, type, Color:Type )
{
	switch ( Type )
	{
		case RED:	return select_team ( index, type, TeamName[1] );
		case BLUE:	return select_team ( index, type, TeamName[2] );
		case GREY:	return select_team ( index, type, TeamName[0] );
	}

	return 0;
}

find_anyplayer ( )
{
	static i = -1

	while ( i <= g_maxplayers )
		if ( g_enable[++i] )
			return i

	return -1;
}
