/***************************************************************************************************
********************
***********
******
***
*                       New Bullet Damage with Director Hud Message
*
*                       All credits return to ArkShine for : 
*                		http://forums.alliedmods.net/showthread.php?t=149210
*                       And thanks to ConnorMcLeod for a lot of optimizations and take the RGB in one CVAR :
*				http://forums.alliedmods.net/showthread.php?t=62224
*			Thanks to schmurgel1983 for : ( Help with the bd_show_text native )
*				http://forums.alliedmods.net/showthread.php?p=1436434#post1436434 
*                       Big Thanks to Micapat :D
*                      
*              		The victim Hud color : Red
*           		The attacker Hud color : Green
*             		When the player does damage to himself, Hud color is Orange
*
*                       Version : 1.6
*                       Author : Bboy GruN
*
*                       *********** Cvars :
*                       * Bullet Damage Mode : 
*                           	 - 0 : It just uses the director Hud Message = DEFAULT
*                           	 - 1 : It Uses HudMessage when the victim is far from the attacker AND 
*                           	 when the victim & attacker are near it uses Director Hud Message.
*                       * Bullet Distance : 
*                           	 - Only work if Bullet Damage Mode is set to 1, when the attacker and the victim 
*                           	 are at X distance, we will use HudMessage.
*                       * Bullet Walls :
*                       	- 0 : Disabled = DEFAULT
*                       	- 1 : Don't show the damage you did when you shot through a wall
*                       * Bullet Show Spec
*                       	- 0 : Disabled
*                      		- 1 : Show the HudMessage / Director Hud Message to the spectator = DEFAULT
*			* Bullet_Hs_Mode
*				- 0 : Disabled
*  				- 1 : Always show Director Hud Message on HeadShot
*				- 2 : Show : "HEADSHOT" to : Victim & Attacker = Default
*                       * Color_RGB_Victim
*                      		- Color of the Message : RGB ( DEFAULT = 255000000 )
*  		        * Color_RGB_Attacker
*                       	- Color of the Message : RGB ( DEFAULT = 000255000 )
*			* Color_RGB_Ourself
*                       	- Color of the Message : RGB ( DEFAULT = 255102021 )
*			* Bullet_Text_Mode
*				- 0 : DIRECTOR HUD MESSAGE SIZE
*				- 1 : HUD MESSAGE SIZE
*
***
******
***********
********************
***************************************************************************************************/

#include < amxmodx >
#include < engine >

#define VERSION "1.6"


new __dhud_color, __dhud_x, __dhud_y, __dhud_effect, __dhud_fxtime, __dhud_holdtime, __dhud_fadeintime, 
__dhud_fadeouttime, __dhud_reliable

new Float: Yv[ 33 ] /* Victim*/, Float: Ya[ 33 ] // Attacker

enum All
{
	VictimC, AttackerC, OurselfC, BulletMode, Bullet_Distance, Bullet_Walls, Bullet_ShowSpec, 
	Bullet_Hs_Mode, Bullet_Text_Mode
}
new pCvar[ All ]

public plugin_init() 
{
	register_plugin( "Bullet Damage", VERSION, "BboY GruN" )
	register_cvar( "Director_bullet_dmg", VERSION, FCVAR_SERVER|FCVAR_SPONLY );
	set_cvar_string( "Director_bullet_dmg", VERSION )
    
	pCvar[ BulletMode ] =     	register_cvar("Bullet_Damage_Mode", "0" ) 
	pCvar[ Bullet_Distance ] =    	register_cvar("Bullet_Damage_Distance", "600" ) 
	pCvar[ Bullet_Walls ] = 		register_cvar("Bullet_Damage_NoShowWalls", "0" )
	pCvar[ Bullet_ShowSpec ] =	register_cvar("Bullet_Show_Spec", "1" )
	pCvar[ Bullet_Hs_Mode ]  = 	register_cvar("Bullet_Hs_Mode", "2" )
	pCvar[ Bullet_Text_Mode ] =	register_cvar("Bullet_Text_Mode", "0" )
	
	pCvar[ VictimC ] = 		register_cvar("Color_RGB_Victim", "255000000" )
	pCvar[ AttackerC ] = 		register_cvar("Color_RGB_Attacker", "000255000" )
	pCvar[ OurselfC ] =		register_cvar("Color_RGB_Ourself", "255102021" )
	
	register_event( "Damage", "on_damage", "b", "2!0", "3=0", "4!0" )  
}

public plugin_natives( )
{
	register_native( "bd_show_damage", "native_bd_show_damage", 1 )
	register_native( "bd_show_text", "native_bd_show_text", 0 )
}

// HELP : http://forums.alliedmods.net/showthread.php?p=1436434#post1436434 Thanks to schmurgel1983
public native_bd_show_text( iPlugin, iParams )
{
	static id
	id = get_param( 1 )
	if( !is_user_connected( id ) )
	{
		return 0
	}
	new Text[ 128 ], Attacker, Size; Attacker = get_param( 2 ); Size = get_param( 3 )
	get_string( 3, Text, charsmax( Text ) )
	show_client_text( id, Text, Attacker, Size )
	if( Attacker == 1 ) // Is the player attacker ? Yes = 1 -- No = 0
	{
		Ya[ id ] += 0.05
		if( Ya[ id ] >= 0.90 )
		{
			Ya[ id ] = 0.55
		}
		return 1
	}
	Yv[ id ] += 0.05
	if( Yv[ id ] >= 0.85 )
	{
		Yv[ id ] = 0.50
	}
	return 1
}

public native_bd_show_damage( id, damage, style, Attacker )
{
	if( !is_user_connected( id ) )
	{
		return 0
	}
	if( style == 0 ) // Show Director Hud Message if style = 0
	{
		show_client_dhm( id, damage, Attacker )
	}
	else // Show Hud Message if style = 1 ( Or != 0 )
	{
		show_client_hm( id, damage, Attacker )
	}
	if( Attacker == 1 ) // Is the player attacker ? Yes = 1 -- No = 0
	{
		Ya[ id ] += 0.05
		if( Ya[ id ] >= 0.90 )
		{
			Ya[ id ] = 0.55
		}
		return 1
	}
	Yv[ id ] += 0.05
	if( Yv[ id ] >= 0.85 )
	{
		Yv[ id ] = 0.50
	}
	return 1
}

// Director Hud Message, go to : http://forums.alliedmods.net/showthread.php?t=149210 by : ARKSHINE
public on_damage( Victim )
{    
	new Attacker, AttackerWpn, VictimBodyPart; Attacker = get_user_attacker( Victim, AttackerWpn, VictimBodyPart )
	if( !is_user_alive( Attacker )
	|| ( get_pcvar_num( pCvar[ Bullet_Walls ] ) && !is_visible( Attacker, Victim ) ) )
		return PLUGIN_CONTINUE;
		
	new damage, R, G, B, pCvar_H, pCvar_TMODE ; damage = read_data( 2 )
	pCvar_H = get_pcvar_num( pCvar[ Bullet_Hs_Mode ] ); pCvar_TMODE = get_pcvar_num( pCvar[ Bullet_Text_Mode ] )
	new AttackerOrigin[ 3 ], VictimOrigin[ 3 ]
	
	if( Attacker != Victim )
	{
		if( pCvar_H > 0 && VictimBodyPart == HIT_HEAD )
		{
			if( pCvar_H == 1 )
			{
				show_client_dhm( Victim, damage, 0 )
				show_client_dhm( Attacker, damage, 1 )
			}
			else
			{
				show_client_text( Victim, "HEADSHOT", 0, pCvar_TMODE )
				show_client_text( Attacker, "HEADSHOT", 1, pCvar_TMODE )
			}
		}
		else
		{
			if( !get_pcvar_num( pCvar[ BulletMode ] ) )
			{
				show_client_dhm( Victim, damage, 0 )
				show_client_dhm( Attacker, damage, 1 )
			}
		
			else
			{
				get_user_origin( Attacker, AttackerOrigin )
				get_user_origin( Victim, VictimOrigin )
				if( get_distance( AttackerOrigin, VictimOrigin ) >  get_pcvar_num( pCvar[ Bullet_Distance ] ) )
				{
					show_client_hm( Victim, damage, 0 )
					show_client_hm( Attacker, damage, 1 )
				}
				else
				{
					show_client_dhm( Victim, damage, 0 )
					show_client_dhm( Attacker, damage, 1 )
				}
			}
		}
        
		Yv[ Victim ] += 0.05
		if( Yv[ Victim ] >= 0.85 )
		{
			Yv[ Victim ] = 0.50
		}
		Ya[ Attacker ] += 0.05
		if( Ya[ Attacker ] >= 0.90 )
		{
			Ya[ Attacker ] = 0.55
		}
	}
	else
	{
		// http://forums.alliedmods.net/showthread.php?t=62224
		new iColor = get_pcvar_num( pCvar[ VictimC ] )
		R = iColor / 1000000
		iColor %= 1000000
		G = iColor / 1000
		B = iColor % 1000
		// http://forums.alliedmods.net/showthread.php?t=62224
		set_dhudmessage( R, G, B, -1.0, -1.0, 2, 0.0, 2.0, 0.1, 0.1 )
		show_dhudmessage( Victim, "%i", damage )    
	}
	return PLUGIN_CONTINUE;
}

show_client_dhm( id, damage, Attacker )
{
	new iColor, R, G, B, Float: Y_Pos, Float: X_Pos
	
	if( Attacker == 1 ) // The user is the Attacker ( Attacker value = 1 )
	{
		// Attacker
		iColor = get_pcvar_num( pCvar[ AttackerC ] )
		Y_Pos = Ya[ id ]
		X_Pos = 0.53
	}
	else
	{
		// Victim
		iColor = get_pcvar_num( pCvar[ VictimC ] )
		Y_Pos = Yv[ id ]
		X_Pos = 0.45
	}
	R = iColor / 1000000
	iColor %= 1000000
	G = iColor / 1000
	B = iColor % 1000
	
	set_dhudmessage( R, G, B, X_Pos, Y_Pos, 2, 0.0, 1.0, 0.02, 0.02 )
	show_dhudmessage( id, "%i", damage )
	
	if( !get_pcvar_num( pCvar[ Bullet_ShowSpec ] ) )
	{
		return;
	}
	new Players[ 32 ], iNum
	get_players( Players, iNum, "bch" )
	for( new i = 0, Spectator; i < iNum; i++ )
	{
		Spectator = Players[ i ]				
		if( entity_get_int( Spectator, EV_INT_iuser2 ) == id )
		{
			show_dhudmessage( Spectator, "%i", damage )
		}
	}
}

show_client_hm( id, damage, Attacker )
{
	new iColor, R, G, B, Float: Y_Pos, Float: X_Pos
	
	if( Attacker == 1 ) // The user is the Attacker ( Attacker value = 1 )
	{
		// Attacker
		iColor = get_pcvar_num( pCvar[ AttackerC ] )
		Y_Pos = Ya[ id ]
		X_Pos = 0.53
	}
	else
	{
		// Victim
		iColor = get_pcvar_num( pCvar[ VictimC ] )
		Y_Pos = Yv[ id ]
		X_Pos = 0.45
	}
	R = iColor / 1000000
	iColor %= 1000000
	G = iColor / 1000
	B = iColor % 1000
	
	set_hudmessage( R, G, B, X_Pos, Y_Pos, 2, 0.0, 1.0, 0.02, 0.02 )
	show_hudmessage( id, "%i", damage )
	
	if( !get_pcvar_num( pCvar[ Bullet_ShowSpec ] ) )
	{
		return;
	}
	new Players[ 32 ], iNum
	get_players( Players, iNum, "bch" )
	for( new i = 0, Spectator; i < iNum; i++ )
	{
		Spectator = Players[ i ]				
		if( entity_get_int( Spectator, EV_INT_iuser2 ) == id )
		{
			show_hudmessage( Spectator, "%i", damage )
		}
	}
}

show_client_text( id, text[], Attacker, size )
{
	new iColor, R, G, B, Float: Y_Pos, Float: X_Pos
	
	if( Attacker == 1 ) // The user is the Attacker ( Attacker value = 1 )
	{
		// Attacker
		iColor = get_pcvar_num( pCvar[ AttackerC ] )
		Y_Pos = Ya[ id ]
		X_Pos = 0.53
	}
	else
	{
		// Victim
		iColor = get_pcvar_num( pCvar[ VictimC ] )
		Y_Pos = Yv[ id ]
		X_Pos = 0.45
	}
	R = iColor / 1000000
	iColor %= 1000000
	G = iColor / 1000
	B = iColor % 1000
	
	if( !size )
	{
		set_dhudmessage( R, G, B, X_Pos, Y_Pos, 2, 0.0, 1.0, 0.02, 0.02 )
		show_dhudmessage( id, "%s", text )
	}
	else
	{
		set_hudmessage( R, G, B, X_Pos, Y_Pos, 2, 0.0, 1.0, 0.02, 0.02, -1 )
		show_hudmessage( id, "%s", text )
	}
	
	if( !get_pcvar_num( pCvar[ Bullet_ShowSpec ] ) )
	{
		return;
	}
	new Players[ 32 ], iNum
	get_players( Players, iNum, "bch" )
	for( new i = 0, Spectator; i < iNum; i++ )
	{
		Spectator = Players[ i ]				
		if( entity_get_int( Spectator, EV_INT_iuser2 ) == id )
		{
			if( !size )
			{
				show_dhudmessage( Spectator, "%s", text )
			}
			else
			{
				show_hudmessage( Spectator, "%s", text )
			}
		}
	}
}

public client_putinserver( id )
{
	Ya[ id ] = 0.55
	Yv[ id ] = 0.50
}


// Director Hud Message, go to : http://forums.alliedmods.net/showthread.php?t=149210 by : ARKSHINE

stock set_dhudmessage( red = 0, green = 160, blue = 0, Float:x = -1.0, Float:y = 0.65, effects = 2, Float:fxtime = 6.0, Float:holdtime = 3.0, Float:fadeintime = 0.1, Float:fadeouttime = 1.5, bool:reliable = false )
{
	#define clamp_byte(%1)       	( clamp( %1, 0, 255 ) )
	#define pack_color(%1,%2,%3)	( %3 + ( %2 << 8 ) + ( %1 << 16 ) )

	__dhud_color		= 	pack_color( clamp_byte( red ), clamp_byte( green ), clamp_byte( blue ) );
	__dhud_x 		=	_:x;
	__dhud_y 		= 	_:y;
	__dhud_effect 		= 	effects;
	__dhud_fxtime 		= 	_:fxtime;
	__dhud_holdtime 	=	_:holdtime;
	__dhud_fadeintime 	=	_:fadeintime;
	__dhud_fadeouttime 	=	_:fadeouttime;
	__dhud_reliable 	= 	_:reliable;

	return 1;
}

stock show_dhudmessage( index, const message[], any:... )
{
	new buffer[ 128 ];
	new numArguments = numargs();

	if( numArguments == 2 )
	{
		send_dhudMessage( index, message );
	}
	else if( index || numArguments == 3 )
	{
		vformat( buffer, charsmax( buffer ), message, 3 );
		send_dhudMessage( index, buffer );
	}
	else
	{
		new playersList[ 32 ], numPlayers;
		get_players( playersList, numPlayers, "ch" );

		if( !numPlayers )
		{
		return 0;
		}

		new Array:handleArrayML = ArrayCreate();

		for( new i = 2, j; i < numArguments; i++ )
		{
			if( getarg( i ) == LANG_PLAYER )
			{
				while( ( buffer[ j ] = getarg( i + 1, j++ ) ) ) {}
				j = 0;

				if( GetLangTransKey( buffer ) != TransKey_Bad )
				{
					ArrayPushCell( handleArrayML, i++ );
				}
			}
		}

		new size = ArraySize( handleArrayML );

		if( !size )
		{
			vformat( buffer, charsmax( buffer ), message, 3 );
			send_dhudMessage( index, buffer );
		}
		else
		{
			for( new i = 0, j; i < numPlayers; i++ )
			{
				index = playersList[ i ];

				for( j = 0; j < size; j++ )
				{
					setarg( ArrayGetCell( handleArrayML, j ), 0, index );
				}
				
				vformat( buffer, charsmax( buffer ), message, 3 );
				send_dhudMessage( index, buffer );
			}
		}

		ArrayDestroy( handleArrayML );
	}
	return 1;
}

stock send_dhudMessage( const index, const message[] )
{
	message_begin( __dhud_reliable ? ( index ? MSG_ONE : MSG_ALL ) : ( index ? MSG_ONE_UNRELIABLE : MSG_BROADCAST ), SVC_DIRECTOR, _, index );
	{
		write_byte( strlen( message ) + 31 );
		write_byte( DRC_CMD_MESSAGE );
		write_byte( __dhud_effect );
		write_long( __dhud_color );
		write_long( __dhud_x );
		write_long( __dhud_y );
		write_long( __dhud_fadeintime );
		write_long( __dhud_fadeouttime );
		write_long( __dhud_holdtime );
		write_long( __dhud_fxtime );
		write_string( message );
	}
	message_end();
} 

/***************************************************************************************************
********************				*****			        ********************
***********							                         ***********
******											      ******
***												 ***
*                       CHANGE LOG :								   *
*                       1.0 : First								   *
*			1.1 : Adding Bullet Damage Mode						   *
* 			1.2 : Adding Bullet Damage Walls					   *
*			1.3 : Spectators see damage						   *
*			1.4 : Cvar : Bullet_Hs_Mode 						   *
*			1.5 : 2 New Natives							   *
*			1.6 : Text SIZE								   *
*								  				   *
***												 ***
******											      ******
***********							                         ***********
********************				*****			        ********************
***************************************************************************************************/
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1036\\ f0\\ fs16 \n\\ par }
*/
