#pragma semicolon 1

#include <sourcemod>
#include <clientprefs>
#include <colors>

#define YELLOW "\x01"
#define GREEN  "\x04"
#define OLIVE  "\x05"

#define VERSION "1.2"


/*****************************************************************
			P L U G I N   I N F O
*****************************************************************/

public Plugin:myinfo = {
	name = "Killer Info Display",
	author = "Berni, gH0sTy, Smurfy1982, MOD by Snake60",
	description = "Displays the health, the armor and the weapon of the player who has killed you",
	version = VERSION,
	url = "http://forums.alliedmods.net/showthread.php?p=670361"
}


/*****************************************************************
			G L O B A L   V A R S
*****************************************************************/

// ConVar Handles
new Handle:kid_version			= INVALID_HANDLE,
	Handle:kid_printtochat		= INVALID_HANDLE,
	Handle:kid_printtopanel		= INVALID_HANDLE,
	Handle:kid_showdistance		= INVALID_HANDLE,
	Handle:kid_metricdistance	= INVALID_HANDLE,
	Handle:kid_showarmorleft	= INVALID_HANDLE,
	Handle:kid_CvarPrefDefault	= INVALID_HANDLE,
	Handle:kid_AnnounceOnTimer	= INVALID_HANDLE,
	Handle:cookieKidPref		= INVALID_HANDLE,
	kid_pref[MAXPLAYERS + 1],
	kid_PrefDefault;

/*****************************************************************
			F O R W A R D   P U B L I C S
*****************************************************************/

public OnPluginStart() {
	
	// ConVars
	kid_version = CreateConVar("kid_version", VERSION, "Killer info display plugin version", FCVAR_DONTRECORD|FCVAR_REPLICATED|FCVAR_NOTIFY);
	// Set it to the correct version, in case the plugin gets updated...
	SetConVarString(kid_version, VERSION);

	kid_printtochat		= CreateConVar("kid_printtochat",		"1",	"Prints the killer info to the victims chat");
	kid_printtopanel	= CreateConVar("kid_printtopanel",		"0",	"Displays the killer info to the victim as a panel");
	kid_showdistance	= CreateConVar("kid_showdistance",		"1",	"Show the distance to the killer");
	kid_metricdistance	= CreateConVar("kid_metricdistance",	"1",	"Show distance in meters (metric) or ft");
	kid_showarmorleft	= CreateConVar("kid_showarmorleft",		"1",	"Show the killers armor left");
	kid_AnnounceOnTimer	= CreateConVar("kid_announce_on_timer",	"1",	"Print once in chat announce about ability on/off plugin");
	kid_CvarPrefDefault	= CreateConVar("kid_pref_default",		"1",	"Default client preference (0 - killer info display off, 1 - killer info display on)");

	HookEvent("player_death", Event_PlayerDeath, EventHookMode_Pre);

	AutoExecConfig(true);// create or load cfg

	LoadTranslations( "killer_info_display.phrases" ); // add translations support

	// prepare title for clientPref menu
	decl String:menutitle[64];
	Format(menutitle, sizeof(menutitle), "%T", "Menu_Title", LANG_SERVER);
	SetCookieMenuItem(PrefMenu, 0, menutitle);
	cookieKidPref = RegClientCookie("Killer Info Display", "Killer Info Display", CookieAccess_Private);

	RegConsoleCmd("kid", KidCookie, "On/Off Killer info display");
}

/****************************************************************
			C A L L B A C K   F U N C T I O N S
****************************************************************/

public OnConfigsExecuted() {
	kid_PrefDefault = GetConVarInt(kid_CvarPrefDefault);
	}

public OnClientCookiesCached(client) {
	decl String:pref[8];
	GetClientCookie(client, cookieKidPref, pref, sizeof(pref));
	if (StrEqual(pref, "")) {
		kid_pref[client] = kid_PrefDefault;
		}
	else {
		kid_pref[client] = StringToInt(pref);
		}
	}

public PrefMenu(client, CookieMenuAction:action, any:info, String:buffer[], maxlen) {
	if (action == CookieMenuAction_SelectOption) {
		decl String:MenuItem[128];
		new Handle:prefmenu = CreateMenu(PrefMenuHandler);
		new currPref = kid_pref[client];
		Format(MenuItem, sizeof(MenuItem), "%t", "KID_Control");
		SetMenuTitle(prefmenu, MenuItem);
		Format(MenuItem, sizeof(MenuItem), "%t%t", "Disabled", currPref == 0 ? "(Selected)" : "space");
		AddMenuItem(prefmenu, "0", MenuItem);
		Format(MenuItem, sizeof(MenuItem), "%t%t", "Enabled", currPref == 1 ? "(Selected)" : "space");
		AddMenuItem(prefmenu, "1", MenuItem);
		DisplayMenu(prefmenu, client, MENU_TIME_FOREVER);
		}
	}

public PrefMenuHandler(Handle:prefmenu, MenuAction:action, client, item) {
	if (action == MenuAction_Select) {
		decl String:pref[8];
		GetMenuItem(prefmenu, item, pref, sizeof(pref));
		kid_pref[client] = StringToInt(pref);
		SetClientCookie(client, cookieKidPref, pref);
		ShowCookieMenu(client);
		}
	else if (action == MenuAction_End) {
		CloseHandle(prefmenu);
		}
	}
///////////////////////////////////////////////////////////////////////////

public Action:KidCookie(client, args) {
	decl String:buffer[PLATFORM_MAX_PATH];
	if(kid_pref[client] != 0) {
		kid_pref[client] = 0;
		CPrintToChat(client, "\x04[\x01Killer Info\x04] {red}%t", "KID Off");
		}
	else {
		kid_pref[client] = 1;
		CPrintToChat(client, "\x04[\x01Killer Info\x04] {blue}%t", "KID On");
		}
	IntToString(kid_pref[client], buffer, 5);
	SetClientCookie(client, cookieKidPref, buffer);
	}

public Action:TimerAnnounce(Handle:timer, any:client) {
	if(IsClientInGame(client) && GetConVarBool(kid_AnnounceOnTimer)) {
		CPrintToChat(client, "\x04[\x01Killer Info\x04] \x05%t", "Announce Message", OLIVE, GREEN, OLIVE, YELLOW, OLIVE);
		}
	}

public OnClientPutInServer(client) {
	if(!IsFakeClient(client)) {
		if (AreClientCookiesCached(client)) {
			loadClientCookiesFor(client);
			}
		CreateTimer(30.0, TimerAnnounce, client);
		}
	}

loadClientCookiesFor(client) {
	new String:buffer[5];
	GetClientCookie(client, cookieKidPref, buffer, 5);
	if(!StrEqual(buffer, "")) {
		kid_pref[client] = StringToInt(buffer);
		}
	else {
		kid_pref[client] = 0;
		}
	}

///////////////////////////////////////////////////////////////////////////

public Action:Event_PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast) {
	
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	new attacker = GetClientOfUserId(GetEventInt(event, "attacker"));
	
	if (client == 0 || attacker == 0 || client == attacker) {
		return Plugin_Continue;
	}

	decl String:weapon[32];
	GetEventString(event, "weapon", weapon, sizeof(weapon));

	new Float:distance;
	decl String:unit[20];
	decl String:metersMsg[20];
	decl String:ftMsg[20];
	
	if (GetConVarBool(kid_showdistance)) {
		
		decl Float:pos_client[3], Float:pos_killer[3];

		GetClientAbsOrigin(client, pos_client);
		GetClientAbsOrigin(attacker, pos_killer);
		distance = GetVectorDistance(pos_client, pos_killer) / 100.0;
		
		if (GetConVarBool(kid_metricdistance)) {
			Format(metersMsg, sizeof(metersMsg), "%t", "meters");
			strcopy(unit, sizeof(unit), metersMsg);
		}
		else {
			distance /= 0.305;
			Format(ftMsg, sizeof(ftMsg), "%t", "ft");
			strcopy(unit, sizeof(unit), ftMsg);
		}
	}
	
	if ((GetConVarBool(kid_printtopanel)) && (kid_pref[client] != 0)) {

		new Handle:panel= CreatePanel();
		decl String:buf[128];
		
		Format(buf, sizeof(buf), "%N %t", attacker, "killed you");
		SetPanelTitle(panel, buf);

		Format(buf, sizeof(buf), "%t %s", "weapon", weapon);
		DrawPanelText(panel, buf);

		Format(buf, sizeof(buf), "%t", "Health left", GetClientHealth(attacker));
		DrawPanelText(panel, buf);
		
		if (GetConVarBool(kid_showarmorleft)) {
			Format(buf, sizeof(buf), "%t", "Armor left", GetClientArmor(attacker));
			DrawPanelText(panel, buf);
		}
		if (GetConVarBool(kid_showdistance)) {
			Format(buf, sizeof(buf), "%t %.1f %s", "distance", distance, unit);
			DrawPanelText(panel, buf);
		}

		SetPanelCurrentKey(panel, 10);
		SendPanelToClient(panel, client, Handler_DoNothing, 10);
	}
	
	if ((GetConVarBool(kid_printtochat))&& (kid_pref[client] != 0)) {
		
		decl String:msg[600];
		new String:distanceMsg[220] = "\0";
		
		if (GetConVarBool(kid_showdistance)) {
			Format(distanceMsg, sizeof(distanceMsg), " \x05%t \x04%.1f \x05%s", "at a distance of", distance, unit);
		}
		if (GetConVarBool(kid_showarmorleft)) {
			Format(msg, sizeof(msg), "\x04[\x01Killer Info\x04] \x05%t {teamcolor}%N \x05%t \x04%s%s \x05%t \x04%d \x05%t \x04%d \x05%t", "attacker", attacker, "killed you with", weapon, distanceMsg, "and has", GetClientHealth(attacker), "hp and", GetClientArmor(attacker), "armor");}
		else {
			Format(msg, sizeof(msg), "\x04[\x01Killer Info\x04] \x05%t {teamcolor}%N \x05%t \x04%s%s \x05%t \x04%d \x05%t", "attacker", attacker, "killed you with", weapon, distanceMsg, "and has", GetClientHealth(attacker), "hp left");}
		CPrintToChatEx(client, attacker, msg);
	}
	return Plugin_Continue;
}

public Handler_DoNothing(Handle:menu, MenuAction:action, param1, param2) {}