/*
-----------------------// UTF-8 \\-----------------------
Изначальный автор плагина Exolent
Официальная страница стандартного(!) плагина https://forums.alliedmods.net/showthread.php?p=610161
Пофиксел, перевёл и немного укаратил Alucard
Бесплатная версия, рабочий исходник!
Посетите также мой хостинг игровых серверов http://www.evil-host.ru/
Мой игровой проект http://www.evil-game.ru
Список игровых серверов кс 1.6 и ксс http://www.evil-game.ru/servers/

Короткое Описание:
	Плагин для автораспределения игроков по командам
	Блокирует возможность смены команды в игре, при этом
		пишет в чат о невозможности игроку сменить команду
		разными цветами!(обычный, красный, синий, зелёный)
	Доступен настраиваемый иммунитет админа
	
Квары:
	tjm_join_team (дефолт 4)
	// за какую команду будет раскидывать игроков (1-T, 2-CT, 3-SPEC, 4-Рандомно)
	tjm_block_change (дефолт 1)
	// Блокировка смены команды в игре!(0-НЕТ, 1-ДА)
	tjm_adm_immune (дефолт 1)
	// админ может выбирать команду(0-НЕТ, 1-ДА)

Изначально доступ админа по имунитету, вы можете его сменить чуть ниже =)

-----------------------// ANSI \\-----------------------
   Exolent
  (!)  https://forums.alliedmods.net/showthread.php?p=610161
,     Alucard
 ,  !
      http://www.evil-host.ru/
   http://www.evil-game.ru
    1.6   http://www.evil-game.ru/servers/

 :
	     
	     ,  
		       
		 !(, , , )
	   
	
:
	tjm_join_team ( 4)
	//       (1-T, 2-CT, 3-SPEC, 4-)
	tjm_block_change ( 1)
	//     !(0-, 1-)
	tjm_adm_immune ( 1)
	//    (0-, 1-)

    ,       =)
*/


#include <amxmodx>
#include <amxmisc>
#include <colorchat>

#define ACCESS_LEVEL ADMIN_IMMUNITY // админский доступ

enum
{
	TEAM_NONE = 0,
	TEAM_T,
	TEAM_CT,
	TEAM_SPEC,
	
	MAX_TEAMS
};
new const g_cTeamChars[MAX_TEAMS] =
{
	'U',
	'T',
	'C',
	'S'
};
new const g_sTeamNums[MAX_TEAMS][] =
{
	"0",
	"1",
	"2",
	"3"
};
new const g_sClassNums[MAX_TEAMS][] =
{
	"1",
	"2",
	"3",
	"4"
};

// Old Style Menus
stock const FIRST_JOIN_MSG[] =		"#Team_Select";
stock const FIRST_JOIN_MSG_SPEC[] =	"#Team_Select_Spect";
stock const INGAME_JOIN_MSG[] =		"#IG_Team_Select";
stock const INGAME_JOIN_MSG_SPEC[] =	"#IG_Team_Select_Spect";
const iMaxLen = sizeof(INGAME_JOIN_MSG_SPEC);

// New VGUI Menus
stock const VGUI_JOIN_TEAM_NUM =		2;

new g_iTeam[33];
new g_iPlayers[MAX_TEAMS];

new tjm_join_team ;
new tjm_block_change;
new tjm_adm_immune;

public plugin_init()
{
	register_plugin("Team Join Management", "0.3fix", "Exolent&Alucard");
	register_event("TeamInfo", "event_TeamInfo", "a");
	register_message(get_user_msgid("ShowMenu"), "message_ShowMenu");
	register_message(get_user_msgid("VGUIMenu"), "message_VGUIMenu");
	tjm_join_team = register_cvar("tjm_join_team", "2");
	tjm_adm_immune = register_cvar("tjm_adm_immune", "1");
	tjm_block_change = register_cvar("tjm_block_change", "1");
}

public plugin_cfg()
{
	if (get_pcvar_num(tjm_join_team) == 1 || get_pcvar_num(tjm_join_team) == 2 ) { //если надо кидать за КТ или Т, делаем больше лимиты по переводу игроков за одну из команд(например для DeathRun или KZ сервера)
		set_cvar_num("mp_limitteams", 32);
		set_cvar_num("sv_restart", 3);
	}
	server_cmd("exec addons/amxmodx/configs/amxx.cfg"); //фикс странного бага, который не давал сменить квар
}

public client_disconnect(id)
{
	remove_task(id);
}

public event_TeamInfo()
{
	new id = read_data(1);
	new sTeam[32], iTeam;
	read_data(2, sTeam, sizeof(sTeam) - 1);
	for(new i = 0; i < MAX_TEAMS; i++)
	{
		if(g_cTeamChars[i] == sTeam[0])
		{
			iTeam = i;
			break;
		}
	}
	
	if(g_iTeam[id] != iTeam)
	{
		g_iPlayers[g_iTeam[id]]--;
		g_iTeam[id] = iTeam;
		g_iPlayers[iTeam]++;
	}
}

public message_ShowMenu(iMsgid, iDest, id)
{
	if(get_pcvar_num(tjm_adm_immune) && access(id, ACCESS_LEVEL) ) {
		return PLUGIN_CONTINUE;
	}
	else {
		static sMenuCode[iMaxLen];
		get_msg_arg_string(4, sMenuCode, sizeof(sMenuCode) - 1);
		if(equal(sMenuCode, FIRST_JOIN_MSG) || equal(sMenuCode, FIRST_JOIN_MSG_SPEC))
		{
			if(should_autojoin(id))
			{
				set_autojoin_task(id, iMsgid);
				return PLUGIN_HANDLED;
			}
		}
		else if(equal(sMenuCode, INGAME_JOIN_MSG) || equal(sMenuCode, INGAME_JOIN_MSG_SPEC))
		{
			if(get_pcvar_num(tjm_block_change))
			{
			new rnd_color = random_num(1,4);
			if (rnd_color == 2 && get_user_team(id) == TEAM_CT) {	
				ColorChat(id, RED, " Вы не можете сменить команду!");
			}
			else if (rnd_color == 2 && get_user_team(id) == TEAM_T) {	
				ColorChat(id, BLUE, " Вы не можете сменить команду!");
			}
			else {
				ColorChat(id, NORMAL, "%s Вы не можете сменить команду!", rnd_color);
			}
			return PLUGIN_HANDLED;
			}
		}
	}
	return PLUGIN_CONTINUE;
}

public message_VGUIMenu(iMsgid, iDest, id)
{
	if(get_pcvar_num(tjm_adm_immune) && access(id, ACCESS_LEVEL)) {
		return PLUGIN_CONTINUE;
	}
	else {
		if(get_msg_arg_int(1) != VGUI_JOIN_TEAM_NUM)
		{
			return PLUGIN_CONTINUE;
		}
		
		if(should_autojoin(id))
		{
			set_autojoin_task(id, iMsgid);
			return PLUGIN_HANDLED;
		}
		else if((TEAM_NONE < g_iTeam[id] < TEAM_SPEC) && get_pcvar_num(tjm_block_change))
		{
			new rnd_color = random_num(1,4);
			if (rnd_color == 2 && get_user_team(id) == TEAM_CT) {	
				ColorChat(id, RED, " Вы не можете сменить команду!");
			}
			else if (rnd_color == 2 && get_user_team(id) == TEAM_T) {	
				ColorChat(id, BLUE, " Вы не можете сменить команду!");
			}
			else {
				ColorChat(id, NORMAL, "%s Вы не можете сменить команду!", rnd_color);
			}
			return PLUGIN_HANDLED;
		}
	}
	return PLUGIN_CONTINUE;
}

stock bool:should_autojoin(id)
{
	return ((5 > get_pcvar_num(tjm_join_team) > 0) && is_user_connected(id) && !(TEAM_NONE < g_iTeam[id] < TEAM_SPEC) && !task_exists(id));
}

stock set_autojoin_task(id, iMsgid)
{
	new iParam[2];
	iParam[0] = iMsgid;
	set_task(0.1, "task_Autojoin", id, iParam, sizeof(iParam));
}

public task_Autojoin(iParam[], id)
{
	new iTeam = get_team(get_cvar_num("tjm_join_team"));
	handle_join(id, iParam[0], iTeam);
}

public get_team(iTeam) {
	switch(iTeam)
	{
		case 1:
		{
			return TEAM_T;
		}
		case 2:
		{
			return TEAM_CT;
		}
		case 3:
		{
			return TEAM_SPEC;
		}
		case 4:
		{
			new iTCount = g_iPlayers[TEAM_T];
			new iCTCount = g_iPlayers[TEAM_CT];
			if(iTCount < iCTCount)
			{
				return TEAM_T;
			}
			else if(iTCount > iCTCount)
			{
				return TEAM_CT;
			}
			else
			{
				return random_num(TEAM_T, TEAM_CT);
			}
		}
	}
	return -1;
}


stock handle_join(id, iMsgid, iTeam)
{
	new iMsgBlock = get_msg_block(iMsgid);
	set_msg_block(iMsgid, BLOCK_SET);
	
	engclient_cmd(id, "jointeam", g_sTeamNums[iTeam]);
	
	new iClass = random_num(1, 4);
	if(1 <= iClass <= 4)
	{
		engclient_cmd(id, "joinclass", g_sClassNums[iClass - 1]);
	}
	set_msg_block(iMsgid, iMsgBlock);
}