/* gm_engine.sma is part of GabenMod
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include "gabenmod"

#if defined CSDM_COMPILATION
#include <csdm>
#endif

#define PLUGIN "GM Engine"
#define AUTHOR "Basic-Master"

// Defines
#define MAX_CLASSES 		20           		// Max classes
#define GM_LEVEL      		ADMIN_LEVEL_A 		// Needed adminlevel to use admin commands
#define STARTWPN_EXTRADMGMUL	0.2			// Some extra damage for the startweapon (if enabled)
#define AllKeys (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9) // Menu keys

// Lots of variables
new gClassesName[MAX_CLASSES][20] 			// Names of registered classes
new gClassesDesc[MAX_CLASSES][60] 			// Short description
new gClassesInit[MAX_CLASSES][20]			// Init function
new gClassesMenu[MAX_CLASSES][20]			// Menu function
new gClassesBuyM[MAX_CLASSES][20]			// Buy menu function
new gClassesReqP[MAX_CLASSES]				// Required points for class
new gClassesReqK[MAX_CLASSES]				// Required karma for class
new gClassesPlug[MAX_CLASSES][20] 			// Name of the source plugin
new gRegisteredClasses = 0         			// Number of registered classes

new gPoints[33], gAvailablePoints[33]			// Game points
new gClass[33]   					// Class (class id) of player
new gAlreadySelected[33]				// User can select only one class per life, prevent abuse
new gNew[33]						// Show hudmessage once on respawn
new gWpnClip[33]					// Weapon info for the start weapon

new gBaseClass = -1					// Base class for each user
new uSelMenuPage[33]					// Menu page for select menu
new dmgvictim,  dmg_attacker				// We need that for the damage event
new dmg_wpnname[32], wpn_clip, wpn_ammo
new dmg_dmg, dmg_wpn, s_txt[64]				// Some variables for the CurWeapon hook
new Float:wpn_fVec1[3], Float:wpn_fVec2[3]
new wpn_origin[3], wpn_hitpos[3]
new wpn_ent = 0
new cc_arg[13], cc_a
new gExpSprite, gSteam					// Explosion Sprite+Steam for the tracer
new tl_player, tl_name[32], tl_class[20]			// for trace_line, zomg!
new death_attacker, death_victim			// Variables for the DeathMsg event

new gBlockDeathMsg = 0					// Block the messages once
new gInBlock = 0
new fwd_result, fwd_tmp
new gStrippedFwd, gJoinedFwd, gClassChangedFwd
new gOpeningClassMnuFwd, gOpeningBuyMnuFwd
new gCreatingItemFwd, gUsingSkillFwd, gUsedSkillFwd
new gPlayerInfoFwd, gReadMapInfoFwd, gWriteMapInfoFwd
new gDeleteMapInfoFwd, gDamageFwd, gRespawnFwd
new gEnablingFwd, gDisablingFwd

new cStartWpn, cPlayerHints, cKillPoints, cGrenTracers	// PCVAR stuff
new cModEnabled
#if !defined CSDM_COMPILATION
new cRespawn, cRemoveWeapons, cRespawnDelay
new resp_players[32], resp_count, resp_player
new gRespawning[33], gKilled[33]
new chk_i, rem_weapon[32], rem_lastent, rem_startent
new rem_owner, rem_owner_class[32]
#endif
new CsTeams:gOldTeam[33]
new gCanGiveBomb, gBuyzoneExists
new Float:gMaxspeed[33]
new read_result[256]
new gIsEnabled = 1					// Is GabenMod enabled, yes/no

// copied from CSDM
new g_Aliases[34][] = {"usp","glock","deagle","p228","elites","fn57","m3","xm1014","mp5","tmp","p90","mac10","ump45","ak47","galil","famas","sg552","m4a1","aug","scout","awp","g3sg1","sg550","m249","vest","vesthelm","flash","hegren","sgren","defuser","nvgs","shield","primammo","secammo"} 
new g_Aliases2[34][] = {"km45","9x19mm","nighthawk","228compact","elites","fiveseven","12gauge","autoshotgun","smg","mp","c90","mac10","ump45","cv47","defender","clarion","krieg552","m4a1","bullpup","scout","magnum","d3au1","krieg550","m249","vest","vesthelm","flash","hegren","sgren","defuser","nvgs","shield","primammo","secammo"}

public plugin_init() {
	// Register stuff here
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	/* CVars */
	register_cvar("gm_startpoints", "85")			// Points you get when you join (min)
	register_cvar("gm_dynamicpoints", "1")			// Give a user a fraction of the points every user has
	register_cvar("gm_setsettings", "0")			// Change the server settings to a GabenMod Server config?
	register_cvar("gm_buyzone_req", "0")			// Do you have to be in the buyzone to buy things?
	cKillPoints = register_cvar("gm_killpoints", "7")	// Points per kill
	cStartWpn = register_cvar("gm_startwpn", "1")		// M3 as startweapon (with small upgrade)
	cPlayerHints = register_cvar("gm_playerhints", "1")	// Show player hints when looking at another player?
	cGrenTracers = register_cvar("gm_grenadetracers", "1")	// Show grenade tracers?
	#if !defined CSDM_COMPILATION
	cRespawn = register_cvar("gm_respawn", "1")		// Respawn enabled for non-CSDM servers?
	cRemoveWeapons = register_cvar("gm_removeweapons", "1")	// Remove weapons, should be enabled to prevent crashes..
	cRespawnDelay = register_cvar("gm_respawn_delay", "1.5")	// Respawn delay, how long GabenMod waits until it respawns
	#endif
	cModEnabled = register_cvar("gm_enabled", "1", FCVAR_SERVER|FCVAR_SPONLY)
	register_cvar("gm_version", GABENMOD_VERSION , FCVAR_SERVER|FCVAR_SPONLY)
	/* Admin commands */
	register_concmd("gm_setpoints", "cmdSetPoints", GM_LEVEL, "- Set points of an user")
	register_concmd("gm_getpoints", "cmdGetPoints", GM_LEVEL, "- Get points of an user")
	register_concmd("gm_whois", "cmdGetPoints", GM_LEVEL, "- Get points of an user")
	register_concmd("gm_addpoints", "cmdAddPoints", GM_LEVEL, "- Adds points to an user")
	register_concmd("gm_rempoints", "cmdRemPoints", GM_LEVEL, "- Remove points from user")
	register_concmd("gm_on", "cmdOn", GM_LEVEL, "- Turns GabenMod on")
	register_concmd("gm_off", "cmdOff", GM_LEVEL, "- Turns GabenMod off")
	/* Say commands */
	register_saycmd("playerpoints", "cmdShowPoints", -1, "- Shows how many points each user has")
	register_saycmd("playerclasses", "cmdShowPoints", -1, "- Shows how many points each user has")
	register_saycmd("playerskills", "cmdShowPoints", -1, "- Shows how many points each user has")
	register_saycmd("showpoints", "cmdShowPoints", -1, "- Shows how many points each user has")
	register_saycmd("points", "cmdShowUserPoints", -1, "- Shows user points")
	register_saycmd("select", "cmdSelectClass", -1, "- Change class")
	register_saycmd("switch", "cmdSelectClass", -1, "- Change class")
	register_saycmd("selectclass", "cmdSelectClass", -1, "- Change class")
	register_saycmd("changeclass", "cmdSelectClass", -1, "- Change class")
	register_saycmd("changerace", "cmdSelectClass", -1, "- Change class")
	register_saycmd("class", "cmdSelectClass", -1, "- Change class")
	register_saycmd("classes", "cmdShowClasses", -1, "- Shows a list of all the classes")
	register_saycmd("showclasses", "cmdShowClasses", -1, "- Shows a list of all the classes")
	register_saycmd("menu", "cmdMenu", -1, "- Shows the class menu")
	register_saycmd("buy", "cmdBuy", -1, "- Shows the buy menu")
	register_saycmd("buymenu", "cmdBuy", -1, "- Shows the buy menu")
	register_saycmd("help", "cmdHelp", -1, "- Shows the help")
	register_saycmd("info", "cmdHelp", -1, "- Shows the help")
	#if !defined CSDM_COMPILATION
	register_saycmd("spawn", "cmdRespawn", -1, "- Respawns you if you're dead")
	register_saycmd("respawn", "cmdRespawn", -1, "- Respawns you if you're dead")
	#endif
	/* Client commands */
	register_clcmd("buy", "cmdMenu") 
	register_clcmd("client_buy_open", "cmdVGUIBuy") 
	register_clcmd("buyammo1", "cmdMenu") 
	register_clcmd("buyammo2", "cmdMenu") 
	register_clcmd("buyequip", "cmdMenu") 
	register_clcmd("cl_autobuy", "cmdMenu") 
	register_clcmd("cl_rebuy", "cmdMenu") 
	register_clcmd("cl_setautobuy", "cmdMenu") 
	register_clcmd("cl_setrebuy", "cmdMenu")
	register_clcmd("fullupdate", "cmdBlockThis")
	// 5 skill commands should be enough ^^
	register_clcmd("+skill1", "cmdStartSkill1")
	register_clcmd("+skill2", "cmdStartSkill2")
	register_clcmd("+skill3", "cmdStartSkill3")
	register_clcmd("+skill4", "cmdStartSkill4")
	register_clcmd("+skill5", "cmdStartSkill5")
	register_clcmd("-skill1", "cmdStopSkill1")
	register_clcmd("-skill2", "cmdStopSkill2")
	register_clcmd("-skill3", "cmdStopSkill3")
	register_clcmd("-skill4", "cmdStopSkill4")
	register_clcmd("-skill5", "cmdStopSkill5")
	/* Forwards */
	register_forward(FM_ClientConnect, "hook_connect")
	register_forward(FM_ClientDisconnect, "hook_disconnect")
	register_forward(FM_TraceLine, "hook_traceline", 1)
	register_logevent("hook_bombplant", 3, "2=Planted_The_Bomb")
	// Some other forwards for the message block
	register_forward(FM_MessageBegin, "hook_messagebegin")
	register_forward(FM_WriteByte, "hook_writebyte")
	register_forward(FM_WriteChar, "hook_writechar")
	register_forward(FM_WriteShort, "hook_writeshort")
	register_forward(FM_WriteLong, "hook_writelong")
	register_forward(FM_WriteAngle, "hook_writeangle")
	register_forward(FM_WriteCoord, "hook_writecoord")
	register_forward(FM_WriteString, "hook_writestring")
	register_forward(FM_WriteEntity, "hook_writeent")
	register_forward(FM_MessageEnd, "hook_messageend")
	// People will need that if they try to write additional plugins for GM
	gStrippedFwd = CreateMultiForward("gm_WeaponsStripped", ET_IGNORE, FP_CELL)
	// Other forwards, zomg!
	gJoinedFwd = CreateMultiForward("gm_UserJoined", ET_IGNORE, FP_CELL)
	gClassChangedFwd = CreateMultiForward("gm_ClassChanged", ET_IGNORE, FP_CELL, FP_STRING, FP_STRING)
	gOpeningClassMnuFwd = CreateMultiForward("gm_OpeningClassMenu", ET_STOP, FP_CELL, FP_STRING, FP_CELL)
	gOpeningBuyMnuFwd = CreateMultiForward("gm_OpeningBuyMenu", ET_STOP, FP_CELL, FP_STRING, FP_CELL)
	gCreatingItemFwd = CreateMultiForward("gm_CreatingOwnedItem", ET_STOP, FP_CELL, FP_STRING)
	gUsingSkillFwd = CreateMultiForward("gm_UsingSkillCommand", ET_IGNORE, FP_CELL, FP_CELL)
	gUsedSkillFwd = CreateMultiForward("gm_UsedSkillCommand", ET_IGNORE, FP_CELL, FP_CELL)
	gDamageFwd = CreateMultiForward("gm_DamageEvent", ET_IGNORE, FP_CELL, FP_CELL, FP_STRING, FP_CELL, FP_CELL)
	gPlayerInfoFwd = CreateMultiForward("gm_PlayerInfo", ET_STOP, FP_CELL, FP_CELL, FP_STRING)
	gReadMapInfoFwd = CreateMultiForward("gm_OnMapInfoRead", ET_STOP, FP_STRING)
	gWriteMapInfoFwd = CreateMultiForward("gm_OnMapInfoWrite", ET_STOP, FP_STRING, FP_STRING)
	gDeleteMapInfoFwd = CreateMultiForward("gm_OnMapInfoDelete", ET_STOP, FP_STRING)
	gRespawnFwd = CreateMultiForward("gm_Respawn", ET_IGNORE, FP_CELL)
	gEnablingFwd = CreateMultiForward("gm_EnablingMod", ET_IGNORE)
	gDisablingFwd = CreateMultiForward("gm_DisablingMod", ET_IGNORE)
	/* Events */
	register_event("DeathMsg", "hook_death", "a")
	register_event("StatusText", "hook_status", "b")
	register_event("CurWeapon", "hook_wpn", "be")
	register_event("SendAudio","hook_grenade","be","2=%!MRAD_FIREINHOLE")
	register_event("Damage", "hook_dmg", "b")
	/* Some other stuff, >:o oink */
	#if !defined CSDM_COMPILATION
	set_task(1.0, "task_check", 0, "", 0, "ab", 1)
	register_event("HLTV", "hook_roundstart", "a", "1=0", "2=0")	// reliable
	register_event("ResetHUD", "hook_reset", "b")			// unreliable since fullupdate might exploit it (not here, blocked)
	#endif
	register_menucmd(register_menuid("Select class"), AllKeys, "mnu_select")
	
	arrayset(gNew, 1, 33)
}

public plugin_cfg() {
	if (get_cvar_num("gm_setsettings")) {
		set_cvar_float("mp_freezetime", 0.0) 	// mp_freezetime sucks on DM servers
		set_cvar_num("mp_roundtime", 9)	 	// honestly, this is a GabenMod server
		set_cvar_num("mp_c4timer", 60)		// hrm, wouldn't be fair otherwise
		set_cvar_num("mp_timelimit", 0) 		// no mapchange allowed
		set_cvar_num("sv_maxspeed", 9999) 	// !important! otherwise some speed funtions wouldn't work
	}
	
	gIsEnabled = get_pcvar_num(cModEnabled)
	gBuyzoneExists = pev_valid(engfunc(EngFunc_FindEntityByString, 0, "classname", "func_buyzone"))
	hook_roundstart()
	
	if (!gIsEnabled)
		ExecuteForward(gDisablingFwd, fwd_result)
}

register_saycmd(saycommand[], function[], flags, info[]) {
	new temp[64]
	format(temp, 63, "say /%s", saycommand)
	register_clcmd(temp, function, flags, info)
	format(temp, 63, "say .%s", saycommand)
	register_clcmd(temp, function, flags, info)
	format(temp, 63, "say_team /%s", saycommand)
	register_clcmd(temp, function, flags, info)
	format(temp, 63, "say_team .%s", saycommand)
	register_clcmd(temp, function, flags, info)
}

public plugin_precache() {
	gExpSprite = engfunc(EngFunc_PrecacheModel, "sprites/explode1.spr")
	gSteam = engfunc(EngFunc_PrecacheModel, "sprites/steam1.spr")
}

// ----------------------------------------------------------------------
// --- NATIVE section ---------------------------------------------------
// ----------------------------------------------------------------------

public plugin_natives() {
	// Register natives
	register_native("gm_SetPoints", "native_SetPoints")
	register_native("gm_GetPoints", "native_GetPoints")
	register_native("gm_AddPoints", "native_AddPoints")
	register_native("gm_RemPoints", "native_RemPoints")
	register_native("gm_RegClass", "native_RegClass")
	register_native("gm_ExtraDamage", "native_ExtraDamage")
	register_native("gm_StripWeapons", "native_StripWeapons")
	register_native("gm_CreateOwnedItem", "native_CreateOwnedItem")
	register_native("gm_IsValidPlayer", "native_IsValidPlayer")
	register_native("gm_AimingAtWall", "native_AimingAtWall")
	register_native("gm_VelocityByAim", "native_VelocityByAim")
	register_native("gm_SetRendering", "native_SetRendering")
	register_native("gm_FakeDamage", "native_FakeDamage")
	register_native("gm_FindEntByOwner", "native_FindEntByOwner")
	register_native("gm_GetUserClass", "native_GetUserClass")
	register_native("gm_WriteMapInfo", "native_WriteMapInfo")
	register_native("gm_ReadMapInfo", "native_ReadMapInfo")
	register_native("gm_DeleteMapInfo", "native_DeleteMapInfo")
	register_native("gm_SetReadResult", "native_SetReadResult")
	register_native("gm_IsEnabled", "native_IsEnabled")
}

/* SetPoints native */
public native_SetPoints(id, numParams) { // id, newpoints, setavailable = 1
	if (numParams != 3)
		return log_error(10, "Bad native parameters")
	
	new p_id = get_param(1)
	new newpoints = get_param(2)
	if (p_id > 0 && p_id < 33) { // is_user_connected could be used here but would cause error in pointskeeper plugin
		updatePoints(p_id, newpoints, get_param(3))
		return 1
	}
	else
		return log_error(10, "User ID out of range")
	
	return 1
}

/* GetPoints native */
public native_GetPoints(id, numParams) { // id, getavailable = 1
	if (numParams != 2)
		return log_error(10, "Bad native parameters")
	
	new p_id = get_param(1)
	if (p_id > 0 && p_id < 33) {
		if (get_param(2))
			return gAvailablePoints[p_id]
		else
			return gPoints[p_id]
	}
	else
		return log_error(10, "User ID out of range")
	
	return 1
}

/* AddPoints native */
public native_AddPoints(id, numParams) { // id, addpoints, addavailable = 1
	if (numParams != 3)
		return log_error(10, "Bad native parameters")
	
	new p_id = get_param(1)
	new addpoints = get_param(2)
	if (p_id > 0 && p_id < 33) {
		if (get_param(3))
			updatePoints(p_id, gAvailablePoints[p_id] + addpoints, 1)
		else
			updatePoints(p_id, gPoints[p_id] + addpoints, 0)
		return 1
	}
	// No error here because this function is called after a player disconnected
	
	return 1
}

/* RemPoints native */
public native_RemPoints(id, numParams) { // id, rempoints, remavailable = 1
	if (numParams != 3)
		return log_error(10, "Bad native parameters")
	
	new p_id = get_param(1)
	new addpoints = get_param(2)
	if (p_id > 0 && p_id < 33) {
		if (get_param(3))
			updatePoints(p_id, gAvailablePoints[p_id] - addpoints, 1)
		else
			updatePoints(p_id, gPoints[p_id] - addpoints, 0)
		return 1
	}
	else
		return log_error(10, "User ID out of range")
	
	return 1
}

/* Extradamage native, thanks to the SuperheroMod dev team :) */
public native_ExtraDamage(id, numParams) { // attacker, victim, damage, weaponDescription[], headshot, dmgType = DMG_BULLET, ff = -1
	if (numParams != 7)
		return log_error(10, "Bad native parameters")
	
	new attacker = get_param(1)
	new id = get_param(2)
	new damage = get_param(3)
	new weaponDescription[32]
	get_string(4, weaponDescription, 31)
	new headshot = get_param(5)
	new dmgType = get_param(6)
	new FFon = get_param(7)
	if (FFon == -1)
		FFon = get_cvar_num("mp_friendlyfire")
	if (!is_user_alive(id) || !is_user_connected(attacker))
		return 0
	if (pev(id, pev_takedamage) == 0.0) return 0
	if (damage <= 0) return 0
	
	// *** Damage calculation due to armor from: multiplayer/dlls/player.cpp ***
	new Float:flNewDamage = float(damage) * 0.2
	new Float:flArmor = (float(damage) - flNewDamage) * 0.5
	new CsArmorType:armortype
	new plrArmor = cs_get_user_armor(id, armortype)
	
	// Does this use more armor than we have figured for?
	if ( flArmor > float(plrArmor) ) {
		flArmor = float(plrArmor)
		flArmor *= 2 // (1/ARMOR_BONUS)
		flNewDamage = float(damage) - flArmor
		plrArmor = 0
	}
	else
		plrArmor = floatround(plrArmor - flArmor)
	
	//Commenting this out so it does the orginal ammount of damage still
	//damage = floatround(flNewDamage)
	
	//*** End of damage-armor calculations ***
	
	new userHealth = get_user_health(id)
	new Float:health
	pev(attacker, pev_health, health)
	if (userHealth - damage <= 0 ) {
		new bool:kill = false
		new Float:frags
		pev(attacker, pev_frags, frags)
		
		if (id == attacker) {
			kill = true
			updatePoints(attacker, gPoints[attacker] - get_pcvar_num(cKillPoints), 0)
		}
		else if (FFon && get_user_team(id) == get_user_team(attacker)) {
			kill = true
			set_pev(attacker, pev_frags, floatsub(frags, 1.0))
			set_pev(attacker, pev_health, floatadd(health, 10.0))
			updatePoints(attacker, gPoints[attacker] - get_pcvar_num(cKillPoints), 0)
			client_print(attacker, print_center, "You killed a teammate")
			new money = cs_get_user_money(attacker)
			if (money != 0) cs_set_user_money(attacker, money - 150, 1)
		}
		else if (get_user_team(id) != get_user_team(attacker)) {
			kill = true
			set_pev(attacker, pev_frags, floatadd(frags, 1.0))
			set_pev(attacker, pev_health, floatadd(health, 10.0))
			updatePoints(attacker, gPoints[attacker] + get_pcvar_num(cKillPoints), 0)
			new money = cs_get_user_money(attacker)
			if (money < 16000) cs_set_user_money(attacker, money + 300, 1)
		}
		
		if (!kill)
			return 0
		
		// Kill the victim and block the messages
		dmgvictim = id
		gBlockDeathMsg = 1
		user_kill(id, 1)
		dmgvictim = 0
		
		
		// Log the Kill
		logKill(attacker, id, weaponDescription)
		
		// user_kill removes a frag, this gives it back...prevents from getting 2 kills :/ 
		//pev(id, pev_frags, frags)
		//set_pev(id, pev_frags, floatsub(frags, 1.0))
		
		// Replaced HUD death message
		message_begin(MSG_ALL, get_user_msgid("DeathMsg"))
		write_byte(attacker)
		write_byte(id)
		write_byte(headshot)
		write_string(weaponDescription)
		message_end()
		
		// Update killers scorboard with new info
		message_begin(MSG_ALL, get_user_msgid("ScoreInfo"))
		write_byte(attacker)
		write_short(get_user_frags(attacker))
		write_short(get_user_deaths(attacker))
		write_short(0)
		write_short(get_user_team(attacker))
		message_end()
		
		// Update victims scoreboard with correct info
		message_begin(MSG_ALL, get_user_msgid("ScoreInfo"))
		write_byte(id)
		write_short(get_user_frags(id))
		write_short(get_user_deaths(id))
		write_short(0)
		write_short(get_user_team(id))
		message_end()
		
	}
	else {
		new bool:hurt = false
		if (id == attacker) {
			hurt = true
		}
		else if (FFon && get_user_team(id) == get_user_team(attacker)) {
			hurt = true
			new name[33]
			get_user_name(attacker,name,32)
			client_print(0,print_chat,"%s attacked a teammate",name)
		}
		else if (get_user_team(id) != get_user_team(attacker)) {
			hurt = true
		}
		
		if (!hurt)
			return 0
		
		if (userHealth - damage > 0) {
			set_pev(id, pev_health, float(userHealth - damage))
			cs_set_user_armor(id, plrArmor, armortype)
		}
		else {
			dmgvictim = id
			gBlockDeathMsg = 1
			user_kill(id, 1)
			dmgvictim = 0
			
			if (get_user_team(id) == get_user_team(attacker))
				updatePoints(attacker, gPoints[attacker] - get_pcvar_num(cKillPoints), 0)
			else {
				set_pev(id, pev_health, floatadd(health, 10.0))
				updatePoints(attacker, gPoints[attacker] + get_pcvar_num(cKillPoints), 0)
			}
		}
		
		new aOrigin[3]
		get_user_origin(attacker, aOrigin)
		
		dmgvictim = id
		//Damage message
		message_begin(MSG_ONE, get_user_msgid("Damage"), { 0, 0, 0 }, id)
		write_byte(0) // dmg_save
		write_byte(damage) // dmg_take
		write_long(dmgType) // visibleDamageBits
		write_coord(aOrigin[0]) // damageOrigin.x
		write_coord(aOrigin[1]) // damageOrigin.y
		write_coord(aOrigin[2]) // damageOrigin.z
		message_end()
		dmgvictim = 0
	}
	
	ExecuteForward(gDamageFwd, fwd_result, id, attacker, weaponDescription, damage, 1)
	return 1
}

/* RegClass native */
public native_RegClass(id, numParams) { // name[], shorthelp[], initfunction[], buyfunction[], requiredpoints, requiredkarma = -25, isbaseclass = 0
	if (numParams != 8)
		return log_error(10, "Bad native parameters")
	// Get params
	new name[20], tmp1[20], tmp2[20]
	get_string(1, name, 19)
	new shortdesc[40]
	get_string(2, shortdesc, 39)
	new initfunc[20]
	get_string(3, initfunc, 19)
	new menufunc[20]
	get_string(4, menufunc, 19)
	new buyfunc[20]
	get_string(5, buyfunc, 19)
	new requiredpoints = get_param(6)
	new requiredkarma
	requiredkarma = get_param(7)
	if (get_param(8)) {
		gBaseClass = gRegisteredClasses
		requiredkarma = -25
		requiredpoints = 0
	}
	// Process values
	copy(gClassesName[gRegisteredClasses], 19, name)
	copy(gClassesDesc[gRegisteredClasses], 59, shortdesc)
	copy(gClassesInit[gRegisteredClasses], 19, initfunc)
	copy(gClassesMenu[gRegisteredClasses], 19, menufunc)
	copy(gClassesBuyM[gRegisteredClasses], 19, buyfunc)
	// Abuse already defined variables, we don't need them anyway any more
	get_plugin(id, name, 19, tmp1, 19, shortdesc, 19, initfunc, 19, tmp2, 19)
	copy(gClassesPlug[gRegisteredClasses], 19, name)
	gClassesReqK[gRegisteredClasses] = requiredkarma
	gClassesReqP[gRegisteredClasses] = requiredpoints
	gRegisteredClasses++
	return 1
}

/* CreateOwendItem native */
public native_CreateOwnedItem(id, numParams) { // id, class[]
	if (numParams != 2)
		return log_error(10, "Bad native parameters")
	
	new player = get_param(1)
	new class[32]
	get_string(2, class, 31)
	// Check forward
	ExecuteForward(gCreatingItemFwd, fwd_result, player, class)
	if (fwd_result != PLUGIN_CONTINUE)
		return -1
	// Create entity and give it to the player
	new nid = engfunc(EngFunc_AllocString, class)
	new item = engfunc(EngFunc_CreateNamedEntity, nid)
	if (!item)
		return -1
	
	new Float:origin[3]
	pev(player, pev_origin, origin)
	set_pev(item, pev_origin, origin)
	// Add SF_NORESPAWN to the flags
	set_pev(item, pev_spawnflags, pev(item, pev_spawnflags)|(1<<30))
	dllfunc(DLLFunc_Spawn, item)
	
	new save
	save = pev(item, pev_solid)
	dllfunc(DLLFunc_Touch, item, player)
	if (pev(item, pev_solid) == save) {
		engfunc(EngFunc_RemoveEntity, item)
		return -1
	}
	return item
}

/* StripWeapons native */
public native_StripWeapons(id, numParams) { // id
	if (numParams != 1)
		return log_error(10, "Bad native parameters")
	
	new player = get_param(1)
	new nid = engfunc(EngFunc_AllocString, "player_weaponstrip")
	new stripper = engfunc(EngFunc_CreateNamedEntity, nid)
	new has_c4 = user_has_weapon(player, CSW_C4)
	
	dllfunc(DLLFunc_Spawn, stripper)
	dllfunc(DLLFunc_Use, stripper, player)
	engfunc(EngFunc_RemoveEntity, stripper)
	
	if (has_c4) {
		gm_CreateOwnedItem(player, "weapon_c4")
		cs_set_user_plant(player, 1, 1)
	}
	
	// Give m3 (if startwpn is enabled)
	set_task(0.1, "check_user_wpn", player)
	
	ExecuteForward(gStrippedFwd, fwd_result, player)
	return 1
}

public check_user_wpn(id) {
	if (gm_IsValidPlayer(id)) {
		new wpn[32], currwpn = get_user_weapon(id, wpn_clip, wpn_ammo)
		// Give C4 if nobody has it
		if (!pev_valid(engfunc(EngFunc_FindEntityByString, 0, "classname", "weapon_c4")) && cs_get_user_team(id) == CS_TEAM_T && gCanGiveBomb) {
			gm_CreateOwnedItem(id, "weapon_c4")
			cs_set_user_plant(id, 1, 1)
		}
		// Give startweapon if enabled
		if (get_cvar_num("gm_startwpn")) {
			gm_CreateOwnedItem(id, "weapon_m3")
			gm_CreateOwnedItem(id, "ammo_buckshot")
			gm_CreateOwnedItem(id, "ammo_buckshot")
		}
		get_weaponname(currwpn, wpn, 31)
		client_cmd(id, wpn)
	}
}

/* A simple check function to check whether you can give items to an user */
public native_IsValidPlayer(id, numParams) { // id
	if (numParams != 1)
		return log_error(10, "Bad native parameters")
	new player = get_param(1)
	
	if (!player || !pev_valid(player))
		return 0
	if (!is_user_connected(player) || !is_user_alive(player))
		return 0
	if (cs_get_user_team(player) != CS_TEAM_CT && cs_get_user_team(player) != CS_TEAM_T)
		return 0
	
	return 1
}

/* Check if user is aiming at a spawn-protecting wall */
public native_AimingAtWall(id, numParams) {
	if (numParams != 2)
		return log_error(10, "Bad native parameters")
	new player = get_param(1)
	new dist = get_param(2)
	
	new tid, body
	get_user_aiming(player, tid, body, dist)
	if (pev_valid(tid)) {
		new class[32]
		pev(tid, pev_classname, class, 31)
		if (equali(class, "gm_wall") && pev(tid, pev_owner) == 0)
			return 1
	}
	return 0
}

/* VelocityByAim clone */
public native_VelocityByAim(id, numParams) {
	if (numParams != 3)
		return log_error(10, "Bad native parameters")
	new ent = get_param(1)
	new Float:velocity = float(get_param(2))
	new Float:fForward[3], Float:fAngle[3]
	
	pev(ent, pev_v_angle, fAngle)
	engfunc(EngFunc_MakeVectors, fAngle)
	global_get(glb_v_forward, fForward)
	
	fAngle[0] = fForward[0] * velocity
	fAngle[1] = fForward[1] * velocity
	fAngle[2] = fForward[2] * velocity
	
	set_array_f(3, fAngle, 3)
	return 1
}


/* set_rendering clone */
public native_SetRendering(id, numParams) { 
	if (numParams != 7)
		return log_error(10, "Bad native parameters")
	
	new ent = get_param(1)
	new Float:fColor[3]
	fColor[0] = float(get_param(3))
	fColor[1] = float(get_param(4))
	fColor[2] = float(get_param(5))
	
	set_pev(ent, pev_renderfx, get_param(2))
	set_pev(ent, pev_rendercolor, fColor)
	set_pev(ent, pev_rendermode, get_param(6))
	set_pev(ent, pev_renderamt, float(get_param(7)))
	return 1
}

/* fakedamage clone */
public native_FakeDamage(id, numParams) {
	if (numParams != 4)
		return log_error(10, "Bad native parameters")
	new dmgent = get_param(1)
	new class[32]
	get_array(2, class, 31)
	new Float:dmg = get_param_f(3)
	new dmgtype = get_param(4)
	new tmp[16]
	
	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "trigger_hurt"))
	set_keyvalue(ent, "classname", "trigger_hurt")
	float_to_str(dmg *2, tmp, 15)
	set_keyvalue(ent, "dmg", tmp )
	num_to_str(dmgtype, tmp, 15)
	set_keyvalue(ent, "damagetype", tmp)
	set_keyvalue(ent, "origin", "8192 8192 8192")
	dllfunc(DLLFunc_Spawn, ent)
	set_pev(ent, pev_classname, class)
	dllfunc(DLLFunc_Touch, ent, dmgent)
	engfunc(EngFunc_RemoveEntity, ent)
	
	return 1
}

/* find_ent_by_owner clone */
public native_FindEntByOwner(id, numParams) {
	if (numParams != 2)
		return log_error(10, "Bad native parameters")
	new classname[32]
	get_string(1, classname, 31)
	new owner = get_param(2)
	new startent = -1, lastent = 0, setstartent = 0
	
	while (lastent != startent || setstartent) {
		lastent = engfunc(EngFunc_FindEntityByString, lastent, "classname", classname)
		setstartent = 0
		
		if (pev_valid(lastent)) {
			if (pev(lastent, pev_owner) == owner)
				return lastent
			else if (startent == -1) {
				startent = lastent
				setstartent = 1
			}
		}
		else
			break
	}
	
	return 0 	
}


/* Returns the current class of a player */
public native_GetUserClass(id, numParams) {
	if (numParams != 3)
		return log_error(10, "Bad native parameters")
	
	new player = get_param(1)
	if (gClass[player] == -1)
		set_string(2, "", get_param(3))
	else
		set_string(2, gClassesName[gClass[player]], get_param(3))
	
	return 1
}

/* Writes information of a map */
public native_WriteMapInfo(id, numParams) {
	if (numParams != 2)
		return log_error(10, "Bad native parameters")
	
	new key[256], value[256]
	get_string(1, key, 255)
	get_string(2, value, 255)
	
	ExecuteForward(gWriteMapInfoFwd, fwd_result, key, value)
	if (fwd_result != PLUGIN_HANDLED) {
		new map[32], file[64]
		new linestr[512], line, linelen
		
		get_mapname(map, 31)
		get_configsdir(file, 63)
		add(file, 63, "/GabenMod/")
		add(file, 63, map)
		add(file, 63, ".gmi")
		
		if (file_exists(file)) {
			add(key, 255, "$")
			while (read_file(file, line, linestr, 511, linelen)) {
				if (containi(linestr, key) == 0) { // this is our line
					// format line
					format(linestr, 511, "%s%s", key, value)
					write_file(file, linestr, line)
					// return 1, break loop
					return 1
				}
				line++
			}
			// not found, append
			format(linestr, 511, "%s%s", key, value)
			write_file(file, linestr)
		}
		else {
			format(linestr, 511, "%s$%s", key, value)
			write_file(file, linestr)
		}
	}
	
	return 1
}

/* Reads information of a map */
public native_ReadMapInfo(id, numParams) {
	if (numParams != 3)
		return log_error(10, "Bad native parameters")
	// get params
	new key[256], value[256], maxlen
	get_string(1, key, 255)
	maxlen = get_param(3)
	ExecuteForward(gReadMapInfoFwd, fwd_result, key)
	if (fwd_result != PLUGIN_HANDLED) {
		// and the saved stuff
		new map[32], file[64]
		new linestr[512], line, linelen
		
		get_mapname(map, 31)
		get_configsdir(file, 63)
		add(file, 63, "/GabenMod/")
		add(file, 63, map)
		add(file, 63, ".gmi")
		
		if (file_exists(file)) {
			add(key, 255, "$")
			while (read_file(file, line, linestr, 511, linelen)) {
				if (contain(linestr, key) == 0) { // this is our line
					// format line
					strtok(linestr, key, 255, value, 255, '$', 1)
					set_string(2, value, maxlen)
					// return 1, break loop
					return 1
				}
				line++
			}
		}
		set_string(2, "", maxlen) // clear string if nothing was found
	}
	else
		set_string(2, read_result, maxlen)
	
	return 0
}

/* Delete map info */
public native_DeleteMapInfo(id, numParams) {
	if (numParams != 1)
		return log_error(10, "Bad native parameters")
	
	new key[256]
	get_string(1, key, 255)
	ExecuteForward(gDeleteMapInfoFwd, fwd_result, key)
	if (fwd_result != PLUGIN_HANDLED) {
		new map[32], file[64]
		new linestr[512], line, linelen
		new newlinestr[512], newlinelen, moving = 0
		
		get_mapname(map, 31)
		get_configsdir(file, 63)
		add(file, 63, "/GabenMod/")
		add(file, 63, map)
		add(file, 63, ".gmi")
		
		if (file_exists(file)) {
			add(key, 255, "$")
			while (read_file(file, line, linestr, 511, linelen)) {
				if (moving) {
					if (read_file(file, line+1, newlinestr, 511, newlinelen))
						write_file(file, newlinestr, line)
					else
						write_file(file, "", line)
				}
				else if (contain(linestr, key) == 0) { // this is our line
					// remove line
					if (read_file(file, line+1, newlinestr, 511, newlinelen))
						write_file(file, newlinestr, line)
					else
						write_file(file, "", line)
					moving = 1
				}
				line++
			}
		}
		
		return moving
	}
	
	return 0
}

/* To set the read result of the ReadMapInfo forward */
public native_SetReadResult(id, numParams) {
	if (numParams != 1)
		return log_error(10, "Bad native parameters")
	
	// wtf, what a native ^^
	get_string(1, read_result, 255)
	return 1
}

/* Returns 1 if GabenMod is enabled */
public native_IsEnabled() {
	return gIsEnabled
}

//-----------------------------------------------------------------------
//--- COMMANDS section --------------------------------------------------
//-----------------------------------------------------------------------

/* block cmd */

public cmdBlockThis() {
	return (gIsEnabled ? PLUGIN_HANDLED : PLUGIN_CONTINUE)
}

/* gh_setpoints <user> <points> */
public cmdSetPoints(id, level, cid) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	
	new arg1[32], arg2[32], nick[32], tid
	read_argv(1, arg1, 31)
	remove_quotes(arg1)
	read_argv(2, arg2, 9)
	remove_quotes(arg2)
	
	tid = cmd_target(id, arg1, 2)
	if (tid) {
		// set the points
		updatePoints(tid, str_to_num(arg2), 0)
		console_print(id, "[GM] Done.")
		get_user_name(id, arg1, 31)
		client_print(tid, print_chat, "[GM] %s set your points to %s.", arg1, arg2)
		// and log it
		get_user_name(tid, nick, 31)
		log_message("Admin ^"%s^" set ^"%s^"'s points to %s.", arg1, nick, arg2)
	}
	
	return PLUGIN_HANDLED
}

/* gh_getpoints <user> */
public cmdGetPoints(id, level, cid) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	
	new arg1[32], tid
	read_argv(1, arg1, 31)
	remove_quotes(arg1)
	
	tid = cmd_target(id, arg1, 2)
	if (tid) {
		new name[32]
		get_user_name(tid, name, 31)
		if (gClass[tid] == -1)
			console_print(id, "User ^"%s^" (no class) has %d points.", name, gPoints[tid])
		else
			console_print(id, "User ^"%s^" (%s) has %d points.", name, gClassesName[gClass[tid]], gPoints[tid])
		#if defined KARMA_SUPPORTED
		new fname[32]
		new flag = get_forum_flags(tid)
		
		if (flag != FORUM_UNKNOWN && flag != FORUM_UNRESOLVED)
			get_forum_name(tid, fname, 31)
		switch (flag) {
			case FORUM_DEVELOPER:	 console_print(id, "He is a Developer, has %d karma and is registered as %s", get_user_karma(tid), fname)
			case FORUM_DONOR:	 console_print(id, "He is a Donor, has %d karma and is registered as %s", get_user_karma(tid), fname)
			case FORUM_MODERATOR:	 console_print(id, "He is a Developer, has %d karma and is registered as %s", get_user_karma(tid), fname)
			case FORUM_REGISTERED:	 console_print(id, "He is a Registerd User, has %d karma and is registered as %s", get_user_karma(tid), fname)
			case FORUM_UNKNOWN:	 console_print(id, "He is not registered at http://amxmodx.org/")
			case FORUM_UNRESOLVED:	 console_print(id, "His forum information is not available yet.")
		}
		#endif
	}
	
	return PLUGIN_HANDLED
}

/* gh_addpoints <user> <points> */
public cmdAddPoints(id, level, cid) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	
	new arg1[32], arg2[32], nick[32], tid
	read_argv(1, arg1, 31)
	remove_quotes(arg1)
	read_argv(2, arg2, 31)
	remove_quotes(arg2)
	
	tid = cmd_target(id, arg1, 2)
	if (tid && str_to_num(arg2)) {
		// add some points
		updatePoints(tid, gPoints[tid] + str_to_num(arg2), 0)
		console_print(id, "[GM] Done.")
		get_user_name(id, arg1, 31)
		client_print(tid, print_chat, "[GM] You were given %s points by %s!", arg2, arg1)
		// and log it
		get_user_name(tid, nick, 31)
		log_message("Admin ^"%s^" gave ^"%s^" %s points.", arg1, nick, arg2)
	}
	
	return PLUGIN_HANDLED
}

/* gh_rempoints <user> <points> */
public cmdRemPoints(id, level, cid) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	
	new arg1[32], arg2[10], nick[32], tid
	read_argv(1, arg1, 31)
	remove_quotes(arg1)
	read_argv(2, arg2, 9)
	remove_quotes(arg2)
	
	tid = cmd_target(id, arg1, 2)
	if (tid && str_to_num(arg2)) {
		// add some points
		updatePoints(tid, gPoints[tid] - str_to_num(arg2), 0)
		console_print(id, "[GM] Done.")
		get_user_name(id, arg1, 31)
		client_print(tid, print_chat, "[GM] You were given %s points by %s!", arg2, arg1)
		// and log it
		get_user_name(tid, nick, 31)
		log_message("Admin ^"%s^" removed %s points from ^"%s^"", arg1, arg2, nick)
	}
	
	return PLUGIN_HANDLED
}

public cmdOn(id, level, cid) {
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	
	if (gIsEnabled)
		console_print(id, "[GM] GabenMod is already enabled.")
	else {
		gIsEnabled = 1
		set_pcvar_num(cModEnabled, 1)
		ExecuteForward(gEnablingFwd, fwd_result)
		
		new players[32], playercount
		get_players(players, playercount)
		for(new i=0;i<playercount;i++)
			hook_status(players[i])
		
		set_cvar_num("sv_restartround", 1)
		
		console_print(id, "[GM] GabenMod has been enabled.")
		client_print(id, print_chat, "** GabenMod has been enabled!")
	}
	
	return PLUGIN_HANDLED
}

public cmdOff(id, level, cid) {
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	
	if (!gIsEnabled)
		console_print(id, "[GM] GabenMod is already disabled.")
	else {
		gIsEnabled = 0
		set_pcvar_num(cModEnabled, 0)
		ExecuteForward(gDisablingFwd, fwd_result)
		
		new players[32], playercount, pl
		get_players(players, playercount)
		for(new i=0;i<playercount;i++) {
			pl = players[i]
			
			client_cmd(pl, "slot10") 		// close menus
			gm_SetRendering(pl)			// reset rendering
			hook_status(pl)				// remove statusmsg
			set_pev(pl, pev_takedamage, 2.0)		// remove godmode
			set_pev(pl, pev_movetype, MOVETYPE_WALK)	// remove noclip
			client_print(pl, print_center, "")	// remove messages
			message_begin(MSG_ONE, get_user_msgid("StatusText"), {0, 0, 0}, players[i])
			write_byte(0)
			write_string("")
			message_end()
		}
		
		set_cvar_num("sv_restartround", 1)			// restart round
		
		console_print(id, "[GM] GabenMod has been disabled.")
		client_print(id, print_chat, "** GabenMod has been disabled!")
	}
	
	return PLUGIN_HANDLED
}




/* say /playerpoints */
public cmdShowPoints(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	// ZOMG create a MOTD
	new formatstr[2000], tmp[100]
	formatstr = "<!DOCTYPE HTML PUBLIC ^"-//W3C//DTD HTML 4.01 Transitional//EN^" ^"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd^">^n"
	add(formatstr, 1999, "<html>^n")
	add(formatstr, 1999, "<head>^n")
	add(formatstr, 1999, "<title>Cstrike MOTD</title>^n")
	add(formatstr, 1999, "<style type=^"text/css^">^n")
	add(formatstr, 1999, "* {^n")
	add(formatstr, 1999,   "background:#000000;^n")
	add(formatstr, 1999,   "color:#FFB000;^n")
	add(formatstr, 1999,   "font-family:Verdana,Tahoma;^n")
	add(formatstr, 1999,   "margin-left:4px;^n")
	add(formatstr, 1999,   "margin-top:6px;^n")
	add(formatstr, 1999, "}^n")
	add(formatstr, 1999, "td { border: 1px solid orange; }^n")
	add(formatstr, 1999, "</style>^n")
	add(formatstr, 1999, "</head>^n")
	add(formatstr, 1999, "<b>Player Points</p><br>^n")
	add(formatstr, 1999, "<table border=^"0^" cellpadding=^"3^">^n")
	#if defined KARMA_SUPPORTED
	new karma, flags
	add(formatstr, 1999, "<tr><td>Username</td><td>Class</td><td>Points (available)</td><td>Karma</td><tr>^n")
	#else
	add(formatstr, 1999, "<tr><td>Username</td><td>Class</td><td>Points (available)</td><tr>^n")
	#endif
	new name[32], class[32], points, availablepoints
	for(new i=1;i<33;i++) {
		if (is_user_connected(i)) {
			get_user_name(i, name, 31)
			if (gClass[i] == -1)
				class = "none"
			else
				copy(class, 31, gClassesName[gClass[i]])
			points = gPoints[i]
			availablepoints = gAvailablePoints[i]
			#if defined KARMA_SUPPORTED
			karma = get_user_karma(i)
			flags = get_forum_flags(i)
			if (flags == FORUM_UNKNOWN || flags == FORUM_UNRESOLVED)
				format(tmp, 99, "<tr><td>%s</td><td>%s</td><td>%d (%d)</td><td>-</td></tr>^n", name, class, points, availablepoints) 
			else
				format(tmp, 99, "<tr><td>%s</td><td>%s</td><td>%d (%d)</td><td>%d</td></tr>^n", name, class, points, availablepoints, karma) 
			#else
			format(tmp, 99, "<tr><td>%s</td><td>%s</td><td>%d (%d)</td></tr>^n", name, class, points, availablepoints) 
			#endif
			add(formatstr, 1999, tmp)
		}
		else
			break
	}
	add(formatstr, 1999, "</table></b>^n")
	add(formatstr, 1999, "</body>^n")
	add(formatstr, 1999, "</html>")
	show_motd(id, formatstr)
	return PLUGIN_HANDLED
}

/* say /points */
public cmdShowUserPoints(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	client_print(id, print_chat, "[GM] You have %d points!", gPoints[id])
	return PLUGIN_HANDLED
}

/* say /select */
public cmdSelectClass(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (gAlreadySelected[id])
		client_print(id, print_chat, "[GM] You can select only one class per life.")
	else if (!cs_get_user_buyzone(id) && get_cvar_num("gm_buyzone_req") && gBuyzoneExists)
		client_print(id, print_chat, "[GM] You can only use this menu while you're in the buyzone.")
	else if (!gm_IsValidPlayer(id))
		client_print(id, print_chat, "[GM] You must be alive to use this menu.")
	else
		displaySelectMenu(id, 0)
	return PLUGIN_HANDLED
}

/* say /classes */
public cmdShowClasses(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	// a MOTD?!
	new formatstr[2000], tmp[100]
	formatstr = "<!DOCTYPE HTML PUBLIC ^"-//W3C//DTD HTML 4.01 Transitional//EN^" ^"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd^">^n"
	add(formatstr, 1999, "<html>^n")
	add(formatstr, 1999, "<head>^n")
	add(formatstr, 1999, "<title>Cstrike MOTD</title>^n")
	add(formatstr, 1999, "<style type=^"text/css^">^n")
	add(formatstr, 1999, "* {^n")
	add(formatstr, 1999,   "background:#000000;^n")
	add(formatstr, 1999,   "color:#FFB000;^n")
	add(formatstr, 1999,   "font-family:Verdana,Tahoma;^n")
	add(formatstr, 1999,   "margin-left:4px;^n")
	add(formatstr, 1999,   "margin-top:6px;^n")
	add(formatstr, 1999, "}^n")
	add(formatstr, 1999, "td { border: 1px solid orange; }^n")
	add(formatstr, 1999, "</style>^n")
	add(formatstr, 1999, "</head>^n")
	add(formatstr, 1999, "<body scroll=^"no^"><b>^n")
	add(formatstr, 1999, "<b>Classes</p><br>^n")
	add(formatstr, 1999, "<table border=^"0^" cellpadding=^"3^">^n")
	add(formatstr, 1999, "<tr><td>Class</td><td>Req points</td><td>Req karma</td><td>Short description</td><tr>^n^n")
	for(new i=0;i<gRegisteredClasses;i++) {
		format(tmp, 99, "<tr><td>%s</td><td>%d</td><td>%d</td><td>%s</td></tr>^n", gClassesName[i], gClassesReqP[i], gClassesReqK[i], gClassesDesc[i]) 
		add(formatstr, 1999, tmp)
	}
	add(formatstr, 1999, "</table></b>^n")
	add(formatstr, 1999, "</body>^n")
	add(formatstr, 1999, "</html>")
	show_motd(id, formatstr)
	return PLUGIN_HANDLED
}

public cmdMenu(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (gClass[id] == -1) {
		ExecuteForward(gOpeningClassMnuFwd, fwd_result, id, "", 0)
		if (fwd_result == PLUGIN_CONTINUE)
			client_print(id, print_chat, "[GM] You haven't selected a class yet!")
	}
	else {
		fwd_tmp = equali(gClassesMenu[gClass[id]], "")
		ExecuteForward(gOpeningClassMnuFwd, fwd_result, id, gClassesName[gClass[id]], fwd_tmp) // mhm, convert this to a cell, *might* be recognized as a bool otherwise
		if (fwd_result == PLUGIN_CONTINUE)  {
			if (equali(gClassesMenu[gClass[id]], ""))
				client_print(id, print_chat, "[GM] Your class hasn't got a menu.")
			else {
				callfunc_begin(gClassesMenu[gClass[id]], gClassesPlug[gClass[id]])
				callfunc_push_int(id)
				callfunc_end()
			}
		}
	}
	return PLUGIN_HANDLED
}

public cmdVGUIBuy(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	cmdMenu(id) // show our own class menu
	set_task(0.1, "task_closebuy", id)
	return PLUGIN_HANDLED
}

public task_closebuy(id) {
	if (gm_IsValidPlayer(id))
		client_cmd(id, "client_buy_close") // close the vgui menu
}

public cmdBuy(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (gClass[id] == -1) {
		ExecuteForward(gOpeningBuyMnuFwd, fwd_result, id, "", 0)
		if (fwd_result == PLUGIN_CONTINUE)
			client_print(id, print_chat, "[GM] You haven't selected a class yet!")
	}
	else {
		fwd_tmp = equali(gClassesBuyM[gClass[id]], "")
		ExecuteForward(gOpeningClassMnuFwd, fwd_result, id, gClassesName[gClass[id]], fwd_tmp) // mhm, convert this to a cell, *might* be recognized as a bool otherwise
		if (fwd_result == PLUGIN_CONTINUE)  {
			if (equali(gClassesBuyM[gClass[id]], ""))
				client_print(id, print_chat, "[GM] Your class hasn't got a buy menu.")
			else if (!cs_get_user_buyzone(id) && get_cvar_num("gm_buyzone_req") && gBuyzoneExists)
				client_print(id, print_chat, "[GM] You can only use this menu while you're in the buyzone.")
			else {
				callfunc_begin(gClassesBuyM[gClass[id]], gClassesPlug[gClass[id]])
				callfunc_push_int(id)
				callfunc_end()
			}
		}
	}
	return PLUGIN_HANDLED
}

public cmdHelp(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	new motd[2300]
	add(motd, 2299, "<html><head><title>GabenMod Help</title>^n")
	add(motd, 2299, "<style type=^"text/css^">^n")
	add(motd, 2299,  "pre { font-family:Verdana,Tahoma; color:#FFB000; }^n")
	add(motd, 2299,  "body { background:#000000; margin-left:8px; margin-top:0px; }^n")
	add(motd, 2299, "</style></head>^n")
	add(motd, 2299, "<body scroll=^"none^">^n")
	add(motd, 2299, "<pre>^n")
	add(motd, 2299, "<b><center>GabenMod</center></b>^n")
	add(motd, 2299, "<hr>^n")
	add(motd, 2299, "Commands^n^n")
	add(motd, 2299, "say /help - Displays this window^n")
	add(motd, 2299, "say /select - Change your class^n")
	add(motd, 2299, "say /playerpoints - Shows how many points each user has^n")
	add(motd, 2299, "say /points - Tells you how many points you have^n")
	add(motd, 2299, "say /classes - Shows a list of all the classes^n")
	add(motd, 2299, "say /menu - Displays the class menu^n")
	add(motd, 2299, "say /buy - Displays the buy menu of your class^n^n")
	add(motd, 2299, "<hr>^n")
	add(motd, 2299, "What is GabenMod?^n^n")
	add(motd, 2299, "It's an addon for CS, similar to TFC. You can select classes (say /select), use their skills (say /menu) and buy^n")
	add(motd, 2299, "additional abiilties (say /buy). The spawns are protected by walls, enemies can't go through them. You get points by^n")
	add(motd, 2299, "killing your enemies which you can use them to upgrade your class (say /buy to do that). If you want to see a list of all^n")
	add(motd, 2299, "the classes, simply say /classes.^n^n")
	add(motd, 2299, "<hr>^n")
	add(motd, 2299, "Getting started^n^n")
	add(motd, 2299, "At first you will be prompted to select a class. Just do that. It is not important which class you select, all of^n")
	add(motd, 2299, "them are powerful. After you've done that, you will get some weapons. Okay, now try to walk through the wall that protects^n")
	add(motd, 2299, "your base. Now you can try to kill your enemies, enjoy!^n^n^n")
	add(motd, 2299, "GabenMod is developed by Basic-Master (http://amxmodx.org), published under the terms of the GPL and comes with absolutely^n")
	add(motd, 2299, "no warranty!")
	// not enough space for </pre></body></html> but doesn't matter
	show_motd(id, motd)
	return PLUGIN_HANDLED
}

#if !defined CSDM_COMPILATION
public cmdRespawn(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (!get_pcvar_num(cRespawn))
		client_print(id, print_chat, "[GM] Sorry, the respawn function is currently not enabled.")
	else if (cs_get_user_team(id) == CS_TEAM_SPECTATOR || cs_get_user_team(id) == CS_TEAM_UNASSIGNED)
		client_print(id, print_chat, "[GM] You haven't selected a valid team yet!")
	else if (is_user_alive(id))
		client_print(id, print_chat, "[GM] You are already alive!")
	else {
		if (cs_get_user_team(id) == CS_TEAM_CT)
			cs_set_user_team(id, CS_TEAM_CT, CS_CT_GSG9)
		else
			cs_set_user_team(id, CS_TEAM_T, CS_T_LEET)
		cs_reset_user_model(id)
		
		gKilled[id] = 0
		gRespawning[id] = 1
		dllfunc(DLLFunc_Spawn, id)
		set_task(0.3, "task_spawnagain", id+100)
	}
	
	return PLUGIN_HANDLED
}
#endif

// Skill commands (yeah, I know, there's still another solution but I'm lazy today)

public cmdStartSkill1(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsingSkillFwd, fwd_result, id, 1)
	return PLUGIN_HANDLED
}

public cmdStartSkill2(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsingSkillFwd, fwd_result, id, 2)
	return PLUGIN_HANDLED
}

public cmdStartSkill3(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsingSkillFwd, fwd_result, id, 3)
	return PLUGIN_HANDLED
}

public cmdStartSkill4(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsingSkillFwd, fwd_result, id, 4)
	return PLUGIN_HANDLED
}

public cmdStartSkill5(id) {
	ExecuteForward(gUsingSkillFwd, fwd_result, id, 5)
	return PLUGIN_HANDLED
}

public cmdStopSkill1(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsedSkillFwd, fwd_result, id, 1)
	return PLUGIN_HANDLED
}

public cmdStopSkill2(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsedSkillFwd, fwd_result, id, 2)
	return PLUGIN_HANDLED
}

public cmdStopSkill3(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsedSkillFwd, fwd_result, id, 3)
	return PLUGIN_HANDLED
}

public cmdStopSkill4(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsedSkillFwd, fwd_result, id, 4)
	return PLUGIN_HANDLED
}

public cmdStopSkill5(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	ExecuteForward(gUsedSkillFwd, fwd_result, id, 5)
	return PLUGIN_HANDLED
}

//-----------------------------------------------------------------------
//--- MENU section ------------------------------------------------------
//-----------------------------------------------------------------------

displaySelectMenu(id, page) {
	if (!gIsEnabled) return
	
	if (gRegisteredClasses == 0) {
		client_print(id, print_chat, "[GM] No class has been installed!")
		return
	}
	
	new uClasses[MAX_CLASSES][26], i // contains menu formats
	for(i=0;i<gRegisteredClasses;i++) {
		#if defined KARMA_SUPPORTED
		if (gClass[id] == i || gClassesReqP[i] > gPoints[id] || gClassesReqK[i] > get_user_karma(id))
			format(uClasses[i], 25, "\d%d. %s^n", i+1, gClassesName[i], gClassesReqP[i])
		else
			format(uClasses[i], 25, "\w%d. %s^n", i+1, gClassesName[i])
		#else
		if (gClass[id] == i || gClassesReqP[i] > gPoints[id])
			format(uClasses[i], 25, "\d%d. %s^n", i+1, gClassesName[i], gClassesReqP[i])
		else
			format(uClasses[i], 25, "\w%d. %s^n", i+1, gClassesName[i])
		#endif
	}
	/* Calculate start pos */
	new start
	if (page == 0)
		start = 0
	else
		start = page *7 + (page -1)
	/* Calculate end pos */
	new end = start +7
	if (end > gRegisteredClasses)
		end = gRegisteredClasses
	/* Make menu */
	new menustr[512], keys = (1<<8)|(1<<9)
	menustr = "\rSelect class^n^n"
	for(i=start;i<end;i++) {
		keys = keys|(1<<i-start)
		add(menustr, 511, uClasses[i])
	}
	
	if (page == 0 && end == gRegisteredClasses)
		add(menustr, 511, "^n\w0. Exit")
	else if (page == 0)
		add(menustr, 511, "^n\w9. Next^n0. Exit")
	else if (end != gRegisteredClasses)
		add(menustr, 511, "^n\w9. Next^n0. Back")
	else
		add(menustr, 511, "^n\w0. Back")
	
	uSelMenuPage[id] = page
	show_menu(id, keys, menustr, -1, "Select class")
}

public mnu_select(id, key) {	
	if (!gIsEnabled) return
	
	switch (key) {
		// Next
		case 8: {
			if (gRegisteredClasses - ((uSelMenuPage[id]+1) *7) > 1)
				displaySelectMenu(id, ++uSelMenuPage[id])
		}
		// Exit/Back
		case 9: {
			if (uSelMenuPage[id] != 0)
				displaySelectMenu(id, --uSelMenuPage[id])
		}
		// Class selected
		default: {
			if (!cs_get_user_buyzone(id) && get_cvar_num("gm_buyzone_req") && gBuyzoneExists) {
				client_print(id, print_chat, "[GM] You can only use this menu while you're in the buyzone.")							
				return
			}
			
			new item = uSelMenuPage[id] *7 + key
			new oldclass
			
			#if defined KARMA_SUPPORTED
			if (gClass[id] == item || gClassesReqP[item] > gPoints[id] || gClassesReqK[item] > get_user_karma(id)) {
				displaySelectMenu(id, uSelMenuPage[id])
				return
			}
			#else
			if (gClass[id] == item || gClassesReqP[item] > gPoints[id]) {
				displaySelectMenu(id, uSelMenuPage[id])
				return
			}
			#endif
			
			if (gClass[id] != -1) {
				callfunc_begin(gClassesInit[gClass[id]], gClassesPlug[gClass[id]])
				callfunc_push_int(id)
				callfunc_push_int(0)
				callfunc_end()
			}
			
			oldclass = gClass[id]			
			gAvailablePoints[id] = gPoints[id]
			gClass[id] = item
			gAlreadySelected[id] = 1
			set_hudmessage(0, 0, 255, -1.0, -1.0, 1, 6.0, 6.0, _, _, 3)
			show_hudmessage(id, "%s - %s", gClassesName[item], gClassesDesc[item])
			
			callfunc_begin(gClassesInit[item], gClassesPlug[item])
			callfunc_push_int(id)
			callfunc_push_int(1)
			callfunc_end()
			
			client_print(id, print_chat, "[GM] You are now a %s.", gClassesName[item])
			hook_status(id)
			
			if (oldclass != -1)
				ExecuteForward(gClassChangedFwd, fwd_result, id, gClassesName[oldclass], gClassesName[item])
			else
				ExecuteForward(gClassChangedFwd, fwd_result, id, "", gClassesName[item])
		}
	}
}

//-----------------------------------------------------------------------
//--- MISC section ------------------------------------------------------
//-----------------------------------------------------------------------

public hook_traceline(Float:v1[3], Float:v2[3], noMonsters, id) {
	if (gIsEnabled && get_pcvar_num(cPlayerHints)) {
		tl_player = get_tr(TR_pHit)
		if (is_user_connected(tl_player) && is_user_alive(id)) {
			get_user_name(tl_player, tl_name, 31)
			if (gClass[tl_player] == -1)
				copy(tl_class, 19, "No Class")
			else
				copy(tl_class, 19, gClassesName[gClass[tl_player]])
			
			ExecuteForward(gPlayerInfoFwd, fwd_result, id, tl_player, tl_class)
			if (fwd_result != PLUGIN_HANDLED) {
				if (cs_get_user_team(tl_player) == CS_TEAM_CT) {
					set_hudmessage(0, 0, 255, -1.0, 0.55, 1, 0.1, 0.3, 0.0, 0.0, 3)
					show_hudmessage(id, "%s^n%s^n^nCounter-Terrorist", tl_name, tl_class)
				}
				else {
					set_hudmessage(255, 0, 0, -1.0, 0.55, 1, 0.1, 0.3, 0.0, 0.0, 3)
					show_hudmessage(id, "%s^n%s^n^nTerrorist", tl_name, tl_class)
				}
			}
			return FMRES_HANDLED
		}
	}
	
	return FMRES_IGNORED
}

#if defined CSDM_COMPILATION
public csdm_RoundRestart(post) {
	if (post)
		hook_roundstart()
}
#endif

public hook_roundstart() {
	gCanGiveBomb = pev_valid(engfunc(EngFunc_FindEntityByString, 0, "classname", "func_bombzone"))
	
	#if !defined CSDM_COMPILATION
	new players[32], count, pl
	get_players(players, count)
	for(new i=0;i<count;i++) {
		pl = players[i]
		gRespawning[pl] = 0
		set_task(0.1, "hook_reset", pl)
	}
	#endif
	
	if (!gIsEnabled) return
	
	if (task_exists(100000))
		remove_task(100000)
	if (task_exists(100001))
		remove_task(100001)
	
	new Float:buytime = get_cvar_float("mp_buytime")
	set_task(buytime * 10 - 1.0, "task_getmaxspeed", 100000)
	set_task(buytime * 10 + 1.0, "task_setmaxspeed", 100001)
}

#if !defined CSDM_COMPILATION
public hook_reset(id) {
	if (gIsEnabled && gm_IsValidPlayer(id) && (!gRespawning[id] || gNew[id] || !get_pcvar_num(cRespawn)))
		ExecuteForward(gRespawnFwd, fwd_result, id)
}
#endif

public task_getmaxspeed() {
	if (!gIsEnabled) return
	
	new i, Float:maxspeed
	for(i=0;i<33;i++) {
		if (gm_IsValidPlayer(i)) {
			pev(i, pev_maxspeed, maxspeed)
			gMaxspeed[i] = maxspeed
		}
		else
			gMaxspeed[i] = -1.0
	}
}

public task_setmaxspeed() {
	if (!gIsEnabled) return
	
	new players[32], count
	get_players(players, count, "a")
	for(new i=0;i<count;i++) {
		if (gMaxspeed[players[i]] >= 320.0) {
			engfunc(EngFunc_SetClientMaxspeed, players[i], gMaxspeed[players[i]])
			set_pev(players[i], pev_maxspeed, gMaxspeed[players[i]])
		}
	}
}

public hook_bombplant() {
	gCanGiveBomb = 0
}

public hook_connect(id) {
	gClass[id] = -1
	gPoints[id] = 0
	gNew[id] = 1
	gRespawning[id] = 0
	gOldTeam[id] = CS_TEAM_UNASSIGNED
	
	return FMRES_IGNORED
}

public hook_disconnect(id) {
	if (gClass[id] != -1) {
		callfunc_begin(gClassesInit[gClass[id]], gClassesPlug[gClass[id]])
		callfunc_push_int(id)
		callfunc_push_int(0)
		callfunc_end()
	}
	
	return FMRES_IGNORED
}

public hook_death() {
	death_attacker = read_data(1)
	death_victim = read_data(2)
	
	gKilled[death_victim] = 1
	if (dmgvictim == death_victim)
		return
	
	if (death_attacker == death_victim)
		updatePoints(death_attacker, gPoints[death_attacker] - get_pcvar_num(cKillPoints), 0)
	else if (death_attacker != 0)
		updatePoints(death_attacker, gPoints[death_attacker] + get_pcvar_num(cKillPoints), 0)
}

#if defined CSDM_COMPILATION
public csdm_PostSpawn(player, bool:fake) {
	if (gIsEnabled)
		ExecuteForward(gRespawnFwd, fwd_result, player)
}
#endif

public gm_Respawn(id) {
	if (!gIsEnabled || !gm_IsValidPlayer(id))
		return
	
	if (gNew[id]) {
		if (gNew[id] == 1) {
			set_hudmessage(0, 255, 0, 0.11, 0.03, 1, 6.0, 12.0, _, _, 2)
			show_hudmessage(id, "Are you new? Say /help to display the help!")
		}
		gNew[id] = 0
		gPoints[id] = get_cvar_num("gm_startpoints")
		if (get_cvar_num("gm_dynamicpoints")) {
			new players[32], count, sum = 0
			get_players(players, count)
			for(new i=0;i<count;i++)
				sum += gPoints[players[i]]
			if (sum != 0) {
				sum /= count
				sum /= 3
			}
			
			if (sum > gPoints[id])
				gPoints[id] = sum
		}
		
		#if !defined KARMA_SUPPORTED
		client_print(id, print_chat, "[GM] This server is using GabenMod by Basic-Master and BAILOPAN.")
		client_print(id, print_chat, "[GM] Visit http://www.amxmodx.org/")
		#endif
		gAvailablePoints[id] = gPoints[id]
		
		if (!is_user_bot(id))
			gClass[id] = gBaseClass
		else if (gRegisteredClasses != 0) {
			new class = random_num(0, gRegisteredClasses-1)
			
			callfunc_begin(gClassesInit[class], gClassesPlug[class])
			callfunc_push_int(id)
			callfunc_push_int(1)
			callfunc_end()
			
			gClass[id] = class
			
			ExecuteForward(gClassChangedFwd, fwd_result, id, "", gClassesName[class])
		}
		
		ExecuteForward(gJoinedFwd, fwd_result, id)
	}
	
	gAlreadySelected[id] = 0
	if (gClass[id] != -1) {
		set_hudmessage(0, 0, 255, -1.0, 0.03, 1, _, _, _, _, 0)
		if (!equali(gClassesMenu[gClass[id]], "") && !equali(gClassesBuyM[gClass[id]], ""))
			show_hudmessage(id, "Say /menu to open the class menu or /buy to open the buy menu")
		else if (!equali(gClassesMenu[gClass[id]], ""))
			show_hudmessage(id, "Say /menu to open the class menu")
		else if (!equali(gClassesBuyM[gClass[id]], ""))
			show_hudmessage(id, "Say /buy to open the buy menu")
	}
	else {
		displaySelectMenu(id, 0)
		if (get_cvar_num("gm_startwpn"))
			set_task(0.1, "task_givem3", id)
	}
	
	hook_status(id)
}

public task_givem3(id) {
	if (gIsEnabled && gm_IsValidPlayer(id)) {
		gm_CreateOwnedItem(id, "weapon_m3")
		gm_CreateOwnedItem(id, "ammo_buckshot")
		gm_CreateOwnedItem(id, "ammo_buckshot")
	}
}

public hook_status(id) {
	if (!gIsEnabled) return
	
	if (gClass[id] != -1)
		setStatus(id, gClassesName[gClass[id]], gPoints[id], gAvailablePoints[id])
	else
		setStatus(id, "None", gPoints[id], gAvailablePoints[id])
}

public hook_wpn(id) {
	if (!gIsEnabled) return
	
	if (get_pcvar_num(cStartWpn) && gm_IsValidPlayer(id) && get_user_weapon(id, wpn_clip, wpn_ammo) == CSW_M3) {
		if (gWpnClip[id] > wpn_clip && !gm_AimingAtWall(id)) { // bullet shot
			get_user_origin(id, wpn_origin)
			get_user_origin(id, wpn_hitpos, 4)
			// Explosion
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(3)
			write_coord(wpn_hitpos[0])
			write_coord(wpn_hitpos[1])
			write_coord(wpn_hitpos[2])
			write_short(gExpSprite)
			write_byte(15)
			write_byte(25)
			write_byte(0)
			message_end()
			// Damage
			wpn_fVec1[0] = float(wpn_hitpos[0])
			wpn_fVec1[1] = float(wpn_hitpos[1])
			wpn_fVec1[2] = float(wpn_hitpos[2])
			while ((wpn_ent = engfunc(EngFunc_FindEntityInSphere, wpn_ent, wpn_fVec1, 30.0)) > 0 && wpn_ent)
				gm_ExtraDamage(id, wpn_ent, 15, "m3", 0)
			// Velocity
			pev(id, pev_velocity, wpn_fVec1)
			gm_VelocityByAim(id, 50, wpn_fVec2)
			wpn_fVec1[0] -= wpn_fVec2[0]
			wpn_fVec1[1] -= wpn_fVec2[1]
			wpn_fVec1[2] -= wpn_fVec2[2]
			set_pev(id, pev_velocity, wpn_fVec1)
		}
		gWpnClip[id] = wpn_clip
	}
	else
		gWpnClip[id] = 0
}

public hook_dmg(id) {
	dmg_dmg = read_data(2)
	if (!gIsEnabled || !dmg_dmg || !id || dmgvictim == id || !gm_IsValidPlayer(id))
		return
	
	dmg_attacker = get_user_attacker(id, dmg_wpn)
	if (dmg_wpn == CSW_HEGRENADE) {
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenShake"), { 0, 0, 0 }, id)
		write_short(1<<14)
		write_short(1<<13)
		write_short(1<<14)
		message_end()
		
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), { 0, 0, 0 }, id)
		write_short(1<<10)
		write_short(1<<10)
		write_short(1<<5)
		write_byte(200)
		write_byte(0)
		write_byte(0)
		write_byte(100)
		message_end()
	}
	
	if (read_data(2) != 0) {
		if (dmg_wpn)
			get_weaponname(dmg_wpn, dmg_wpnname, 31)
		else
			copy(dmg_wpnname, 31, "")
		ExecuteForward(gDamageFwd, fwd_result, id, dmg_attacker, dmg_wpnname[7], dmg_dmg, 0)
	}
}

public hook_grenade(id) {
	if (gIsEnabled && get_pcvar_num(cGrenTracers))
		set_task(0.1, "task_maketrace", id) // Give some time to throw the grenade
}

public task_maketrace(id) {
	if (!gIsEnabled) return
	
	new startent = -1, lastent = 0, setstartent = 0
	new color[3] // R G B
	new model[32]
	
	while (lastent != startent || setstartent) {
		lastent = engfunc(EngFunc_FindEntityByString, lastent, "classname", "grenade")
		setstartent = 0
		
		if (pev_valid(lastent)) {
			if (pev(lastent, pev_owner) == id) {
				pev(lastent, pev_model, model, 31)
				color[0] = 0
				color[1] = 0
				color[2] = 0
				if (containi(model, "hegrenade") != -1)
					color[0] = 255
				else if (containi(model, "smokegrenade") != -1)
					color[1] = 255
				else if (containi(model, "flashbang") != -1)
					color[2] = 255
				else
					return
				// Make Tracer
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(22)
				write_short(lastent)
				write_short(gSteam)
				write_byte(10)
				write_byte(4)
				write_byte(color[0])
				write_byte(color[1])
				write_byte(color[2])
				write_byte(100)
				message_end()
				// Flicker
				gm_SetRendering(lastent, kRenderFxPulseFastWide, color[0], color[1], color[2], kRenderTransAdd, 200)
			}
			else if (startent == -1) {
				startent = lastent
				setstartent = 1
			}
		}
		else
			break
	}
}

public client_putinserver(id) {
	gClass[id] = gBaseClass
	gPoints[id] = 0
	gAvailablePoints[id] = 0
	gAlreadySelected[id] = 0
	
	if (gBaseClass != -1) {
		callfunc_begin(gClassesInit[gBaseClass], gClassesPlug[gBaseClass])
		callfunc_push_int(id)
		callfunc_push_int(1)
		callfunc_end()
	}
	
	if (gIsEnabled)
		hook_status(id)
}

public client_command(id) {
	if (!gIsEnabled || read_argv(0, cc_arg, 12) > 11)
		return PLUGIN_CONTINUE 
	
	cc_a = 0 
	do {
		if (equali(g_Aliases[cc_a], cc_arg) || equali(g_Aliases2[cc_a], cc_arg))
			return PLUGIN_HANDLED 
	} while(++cc_a < 34)
	
	return PLUGIN_CONTINUE 
} 

updatePoints(id, newPoints, setavailable) {
	if (newPoints < 0)
		newPoints = 0
	
	if (!setavailable) {
		new playSound = 0
		if (gClass[id] != -1 && gClassesReqP[gClass[id]] > newPoints) { // ZOMG points decreased
			callfunc_begin(gClassesInit[gClass[id]], gClassesPlug[gClass[id]])
			callfunc_push_int(id)
			callfunc_push_int(0)
			callfunc_end()
			
			client_print(id, print_chat, "[GM] You are not longer able to play as a %s.", gClassesName[gClass[id]])
			if (gBaseClass != -1)
				ExecuteForward(gClassChangedFwd, fwd_result, id, gClassesName[gClass[id]], gClassesName[gBaseClass])
			else
				ExecuteForward(gClassChangedFwd, fwd_result, id, gClassesName[gClass[id]], "")
			
			gClass[id] = gBaseClass
			if (gBaseClass != -1) {
				callfunc_begin(gClassesInit[gBaseClass], gClassesPlug[gBaseClass])
				callfunc_push_int(id)
				callfunc_push_int(1)
				callfunc_end()
			}
			
			playSound = 1
		}
		else {
			for(new i=0;i<gRegisteredClasses;i++) {
				if (gClassesReqP[i] <= newPoints && gClassesReqP[i] > gPoints[id]) {
					client_print(id, print_chat, "[GM] You are now able to select %s as class! Use say /select for this.", gClassesName[i])
					playSound = 1
				}
			}
		}
		if (playSound)
			client_cmd(id, "spk ^"sound/fvox/bell.wav^"")
		gAvailablePoints[id] += newPoints - gPoints[id] // add the difference to the user's available points
		gPoints[id] = newPoints
	}
	else
		gAvailablePoints[id] = newPoints
	
	if (gIsEnabled)
		hook_status(id)
}

setStatus(id, class[], points, availablepoints) {
	format(s_txt, 63, "[GabenMod] Class: %s - Points: %d (%d available)", class, points, availablepoints)
	
	message_begin(MSG_ONE, get_user_msgid("StatusText"), {0, 0, 0}, id)
	write_byte(0)
	write_string(s_txt)
	message_end()
}

logKill(id, victim, weaponDescription[] ) {
	
	new namea[32],namev[32],authida[35],authidv[35],teama[16],teamv[16]
	
	//Info On Attacker
	get_user_name(id,namea,31)
	get_user_team(id,teama,15)
	get_user_authid(id,authida,34)
	
	//Info On Victim
	get_user_name(victim,namev,31)
	get_user_team(victim,teamv,15)
	get_user_authid(victim,authidv,34)
	
	//Log This Kill
	if ( id != victim ) {
		log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"%s^"",
		namea,get_user_userid(id),authida,teama,namev,get_user_userid(victim),authidv,teamv, weaponDescription )
	}
	else {
		log_message("^"%s<%d><%s><%s>^" committed suicide with ^"%s^"",
		namea,get_user_userid(id),authida,teama, weaponDescription )
	}
}
#if !defined CSDM_COMPILATION
public task_check() {
	if (!gIsEnabled) return
	
	// Respawn
	if (get_pcvar_num(cRespawn)) {
		get_players(resp_players, resp_count, "b")
		for(chk_i=0;chk_i<resp_count;chk_i++) {
			resp_player = resp_players[chk_i]
			if (!is_user_bot(resp_player) && cs_get_user_team(resp_player) != gOldTeam[resp_player]) {
				gOldTeam[resp_player] = cs_get_user_team(resp_player)
				gKilled[resp_player] = 0
				if (gOldTeam[resp_player] != CS_TEAM_SPECTATOR && gOldTeam[resp_player] != CS_TEAM_UNASSIGNED)
					set_pev(resp_player, pev_modelindex, 0)
			}
			else if (!gRespawning[resp_player] && (is_user_bot(resp_player) || gKilled[resp_player] || pev(resp_player, pev_modelindex) != 0) && cs_get_user_team(resp_player) != CS_TEAM_SPECTATOR && cs_get_user_team(resp_player) != CS_TEAM_UNASSIGNED) {
				set_task(get_pcvar_float(cRespawnDelay), "task_respawnplayer", resp_player+100)
				gRespawning[resp_player] = 1
				gKilled[resp_player] = 0
			}
		}
	}
	// Remove weapons
	if (get_pcvar_num(cRemoveWeapons)) {
		for(chk_i=1;chk_i<31;chk_i++) {
			if (chk_i != CSW_C4 && chk_i != CSW_HEGRENADE && chk_i != CSW_FLASHBANG && chk_i != CSW_SMOKEGRENADE) {
				get_weaponname(chk_i, rem_weapon, 31)
				rem_lastent = 0
				rem_startent = -1
				while((rem_lastent = engfunc(EngFunc_FindEntityByString, rem_lastent, "classname", rem_weapon)) > 0) {
					if (pev_valid(rem_lastent) && pev_valid(pev(rem_lastent, pev_owner))) {
						rem_owner = pev(rem_lastent, pev_owner)
						pev(rem_owner, pev_classname, rem_owner_class, 31)
						if (equali(rem_owner_class, "weaponbox")) {
							engfunc(EngFunc_RemoveEntity, rem_lastent)
							engfunc(EngFunc_RemoveEntity, rem_owner)
						}
					}
					
					if (rem_startent == 0)
						rem_startent = rem_lastent
					else if (rem_startent == rem_lastent)
						break
				}
			}
		}
	}
}

public task_respawnplayer(id) {
	id -= 100
	
	if (gIsEnabled && is_user_connected(id)) {
		new CsTeams:team = cs_get_user_team(id)
		if (!is_user_alive(id) && team != CS_TEAM_SPECTATOR && team != CS_TEAM_UNASSIGNED) {
			dllfunc(DLLFunc_Spawn, id)
			set_task(0.3, "task_spawnagain", id+100)
		}
		else
			gRespawning[id] = 0
	}
	else
		gRespawning[id] = 0
}

public task_spawnagain(id) {
	id -= 100
	if (is_user_connected(id)) {
		dllfunc(DLLFunc_Spawn, id)
		gRespawning[id] = 0
		ExecuteForward(gRespawnFwd, fwd_result, id)
	}
}
#endif

/* Here are some other hooks to block the deathmsg if required */

public hook_messagebegin(msg_dest, msg_type, Float:origin[3], ed) {
	if (gBlockDeathMsg && msg_type == get_user_msgid("DeathMsg")) {
		gInBlock = 1
		return FMRES_SUPERCEDE
	}
	return FMRES_IGNORED
}

public hook_writebyte(value) {
	return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED)
}

public hook_writechar(value) {
	return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED)
}

public hook_writeshort(value) {
	return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED)
}

public hook_writelong(value) {
	return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED)
}

public hook_writeangle(value) {
	return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED)
}

public hook_writecoord(Float:value) {
	return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED)
}

public hook_writestring(sz[]) {
	return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED)
}

public hook_writeent(ent) {
	return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED)
}

public hook_messageend() {
	if (gInBlock) {
		gInBlock = 0
		gBlockDeathMsg = 0
		return FMRES_SUPERCEDE
	}
	return FMRES_IGNORED
}
