// DAZZLER!
// http://www.qlad.net/doc/cmd_TempEnt.php#119:%20TE_Projectile

/* CVARS - copy and paste to shconfig.cfg

//Dazzler
dazzler_level 0
dazzler_radius 3000		//radius of people affected
dazzler_cooldown 15		//# of seconds before Dazzler can flash

*/

#include <amxmod>
#include <superheromod>

// GLOBAL VARIABLES
new gHeroName[]="Dazzler"
new bool:gHasDazzlerPower[SH_MAXSLOTS+1]
new gPlayerLevels[SH_MAXSLOTS+1]
new gSpriteFlare3, gSpriteFlare6
new gSpriteBlueFlare2, gSpriteRedFlare2
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Dazzler","1.18","{HOJ} Batman")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("dazzler_level", "0" )
	register_cvar("dazzler_radius", "3000" )
	register_cvar("dazzler_cooldown", "15" )

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Sparkle Flash", "Flash Nearby Enemies - Grows in intensity as you level up", true, "dazzler_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)
	register_event("ResetHUD","newRound","b")

	// KEY DOWN
	register_srvcmd("dazzler_kd", "dazzler_kd")
	shRegKeyDown(gHeroName, "dazzler_kd")

	// LEVELS
	register_srvcmd("dazzler_levels", "dazzler_levels")
	shRegLevels(gHeroName,"dazzler_levels")

	// INIT
	register_srvcmd("dazzler_init", "dazzler_init")
	shRegHeroInit(gHeroName, "dazzler_init")

}
//----------------------------------------------------------------------------------------------
public plugin_precache()
{
	gSpriteFlare3 = precache_model("sprites/flare3.spr")
	gSpriteFlare6 = precache_model("sprites/flare6.spr")
	gSpriteBlueFlare2 = precache_model("sprites/blueflare2.spr")
	gSpriteRedFlare2 = precache_model("sprites/redflare2.spr")
	precache_sound("debris/beamstart15.wav")
}
//----------------------------------------------------------------------------------------------
public dazzler_levels()
{
	new id[5]
	new lev[5]

	read_argv(1,id,4)
	read_argv(2,lev,4)

	gPlayerLevels[str_to_num(id)] = str_to_num(lev)
}
//----------------------------------------------------------------------------------------------
public dazzler_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has iron man powers
	read_argv(2,temp,5)
	new hasPowers=str_to_num(temp)

	gHasDazzlerPower[id] = (hasPowers!=0)
}
//----------------------------------------------------------------------------------------------
public newRound(id)
{
	gPlayerUltimateUsed[id]=false
}
//----------------------------------------------------------------------------------------------
// RESPOND TO KEYDOWN
public dazzler_kd()
{
	if ( !hasRoundStarted() ) return PLUGIN_HANDLED

	// First Argument is an id with Dazzler Powers!
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	if ( !is_user_alive(id) || !gHasDazzlerPower[id] ) return PLUGIN_HANDLED

	// Dazzler Parameters
	new dazzlerRadius=get_cvar_num("dazzler_radius")
	new dazzlerCooldown=get_cvar_num("dazzler_cooldown")

	// Let them know they already used their ultimate if they have
	if ( gPlayerUltimateUsed[id] ) {
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	// OK Power dazzle enemies closer than x distance
	new fromOrigin[3]
	new toOrigin[3]
	new distanceBetween

	new count = 0
	new Float:num, Float:life, Float:size
	// num   = 2-10 (highest level=10)
	// life  = 2-10 (highest level=10)
	// size  = 50 - 250  (highest level=250)
	num  = 1.0 + 8.0 * ((1.0 * gPlayerLevels[id] ) / shGetNumLevels() )
	life = 1.0 + 8.0 * ((1.0 * gPlayerLevels[id] ) / shGetNumLevels() )
	size = 50 + 150.0 * (( 1.0 * gPlayerLevels[id] ) / shGetNumLevels() )

	// just checks to see if this may be causing server crashes...
	if ( life < 1.0 ) life = 1.0
	if ( life > 10.0) life = 10.0
	if ( size > 200 ) size = 200.0
	if ( size < 50  ) size = 50.0

	get_user_origin(id, fromOrigin)
	for ( new x=1; x<=SH_MAXSLOTS; x++) {
		if ( (is_user_alive(x) && get_user_team(id) != get_user_team(x)) ) {
			get_user_origin(x,toOrigin)
			distanceBetween = get_distance(fromOrigin, toOrigin )
			if ( distanceBetween < dazzlerRadius ) {
				// tracer fireworks
				dazzlerSpriteFlash( toOrigin, toOrigin, floatround(num), floatround(life), floatround(size), 10 )
				dazzlerSpriteFlash( fromOrigin, toOrigin, 10, 5, 10, 1000 )
				emit_sound(id, CHAN_STATIC, "debris/beamstart15.wav", 1.0, ATTN_NORM, 0, PITCH_HIGH)
				emit_sound(x, CHAN_STATIC, "debris/beamstart15.wav", 1.0, ATTN_NORM, 0, PITCH_HIGH)
				count++
			}
		}
	}

	if ( count > 0 ) ultimateTimer(id, dazzlerCooldown * 1.0 )

	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
public dazzlerSpriteFlash( fromOrigin[3], toOrigin[3], count, life, size, speed)
{
	new num = random_num(1,4)
	new sprite

	if ( num == 1 ) sprite = gSpriteFlare3
	if ( num == 2 ) sprite = gSpriteFlare6
	if ( num == 3 ) sprite = gSpriteBlueFlare2
	if ( num == 4 ) sprite = gSpriteRedFlare2

	//TE_SPRITETRAIL - GLOW SPRITE
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(15)             // line of moving glow sprites with gravity, fadeout, and collisions
	write_coord(fromOrigin[0])   // pos
	write_coord(fromOrigin[1])
	write_coord(fromOrigin[2])
	write_coord(toOrigin[0])   // pos
	write_coord(toOrigin[1])
	write_coord(toOrigin[2]+100)
	write_short(sprite) // (sprite index)
	write_byte(count)   // (count)
	write_byte(life)    // (life in 0.1's)
	write_byte(size)    // byte (scale in 0.1's)
	write_byte(speed)     // (velocity along vector in 10's)
	write_byte(5)       // (randomness of velocity in 10's)
	message_end()
}
//----------------------------------------------------------------------------------------------
public client_connect(id)
{
	gHasDazzlerPower[id] = false
}
//----------------------------------------------------------------------------------------------