// Cyclops! - Cool Laser Guy From Xmen (Yeah - Luds Laser Ripoff :D)

/* CVARS - copy and paste to shconfig.cfg

//Cyclops
cyclops_level 5
cyclops_laser_ammo 20			//total # of shots given each round
cyclops_laser_burndecals 1		//Show the burn decals on the walls
cyclops_cooldown 0.20			//Cooldown timer between shots
cyclops_multishot 0.20			//Delay for multishots on holding key down

*/

#include <amxmod>
#include <superheromod>

// Damage Variables
#define h1_dam 100 //head
#define h2_dam 56  //body
#define h3_dam 56  //stomach
#define h4_dam 36  //arm
#define h6_dam 36  //leg

// GLOBAL VARIABLES
new smoke, laser, laser_shots[SH_MAXSLOTS+1]
new bool:gHasCyclopsPower[SH_MAXSLOTS+1]
new gLastWeapon[SH_MAXSLOTS+1]
new gUsingLaser[SH_MAXSLOTS+1]
new gHeroName[]="Cyclops"
static const burn_decal[5] = {199,200,201,202,203}
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Cyclops","1.18","AssKicR/Batman/JTP10181")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("cyclops_level", "5" )
	register_cvar("cyclops_laser_ammo", "20")  // total # of shots...
	register_cvar("cyclops_laser_burndecals", "1")
	register_cvar("cyclops_cooldown", "0.20" )
	register_cvar("cyclops_multishot", "0.20" ) //Delay for multishots on holding key down

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Laser Shot", "Press the +power key to fire your laser beam", true, "cyclops_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)
	register_event("ResetHUD","newRound","b")

	// KEY DOWN
	register_srvcmd("cyclops_kd", "cyclops_kd")
	shRegKeyDown(gHeroName, "cyclops_kd")
	register_srvcmd("cyclops_ku", "cyclops_ku")
	shRegKeyUp(gHeroName, "cyclops_ku")

	// INIT
	register_srvcmd("cyclops_init", "cyclops_init")
	shRegHeroInit(gHeroName, "cyclops_init")

	// DEATH
	register_event("DeathMsg", "cyclops_death", "a")
}
//----------------------------------------------------------------------------------------------
public plugin_precache()
{
	smoke = precache_model("sprites/steam1.spr")
	laser = precache_model("sprites/laserbeam.spr")
	precache_sound("weapons/electro5.wav")
	precache_sound("weapons/xbow_hitbod2.wav")
}
//----------------------------------------------------------------------------------------------
public cyclops_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id = str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has Cyclops powers
	read_argv(2,temp,5)
	new hasPowers=str_to_num(temp)

	gHasCyclopsPower[id] = (hasPowers!=0)

	if (gHasCyclopsPower[id]) {
		gPlayerUltimateUsed[id] = false
		laser_shots[id] = get_cvar_num("cyclops_laser_ammo")
	}
}
//----------------------------------------------------------------------------------------------
public cyclops_death()
{
	new id = read_data(2)

	if ( id <= 0 || id > SH_MAXSLOTS ) return
	remove_task(id)
}
//----------------------------------------------------------------------------------------------
public newRound(id)
{
	remove_task(id)
	laser_shots[id] = get_cvar_num("cyclops_laser_ammo")
	gPlayerUltimateUsed[id] = false
}
//----------------------------------------------------------------------------------------------
// RESPOND TO KEYDOWN
public cyclops_kd()
{
	if ( !hasRoundStarted() ) return PLUGIN_HANDLED

	// First Argument is an id with Cyclops Powers!
	new temp[6]
	read_argv(1,temp,5)
	new id = str_to_num(temp)
	if ( !is_user_alive(id) ) return PLUGIN_HANDLED

	if ( laser_shots[id] <= 0 ) {
		client_print(id,print_center,"No Cyclops Shots Left" )
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	if ( gPlayerUltimateUsed[id] ) {
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	// Remember this weapon...
	new clip,ammo,weaponID = get_user_weapon(id,clip,ammo)
	gLastWeapon[id] = weaponID

	// switch to knife
	engclient_cmd(id,"weapon_knife")

	gUsingLaser[id] = true
	fire_laser(id)  // 1 immediate shot
	if (get_cvar_float("cyclops_multishot") > 0.0) {
		set_task( get_cvar_float("cyclops_multishot"), "fire_laser", id, "", 0, "b")  //delayed shots
	}

	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
public cyclops_ku()
{
	// First Argument is an id with Cyclops Powers!
	new temp[6]
	read_argv(1,temp,5)
	new id = str_to_num(temp)

	remove_task(id)

	if ( !hasRoundStarted() || !gUsingLaser[id]) return

	// Use the ultimate
	ultimateTimer(id, get_cvar_float("cyclops_cooldown") )

	//Reset check var
	gUsingLaser[id] = false

	// Switch back to previous weapon...
	if ( gLastWeapon[id] != CSW_KNIFE ) shSwitchWeaponID( id, gLastWeapon[id] )
}
//----------------------------------------------------------------------------------------------
public laserEffects(id, aimvec[3] )
{
	new origin[3]
	new decal_id = burn_decal[random_num(0,4)]
	emit_sound(id,CHAN_ITEM, "weapons/electro5.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	get_user_origin(id, origin, 1)

	// DELIGHT
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte( 27 )
	write_coord( origin[0] ) //pos
	write_coord( origin[1] )
	write_coord( origin[2] )
	write_byte( 10 )
	write_byte( 250 ) // r, g, b
	write_byte( 0 ) // r, g, b
	write_byte( 0 ) // r, g, b
	write_byte( 2 ) // life
	write_byte( 1 ) // decay
	message_end()

	//BEAMENTPOINTS
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte ( 0 )     //TE_BEAMENTPOINTS 0
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_coord(aimvec[0])
	write_coord(aimvec[1])
	write_coord(aimvec[2])
	write_short( laser )
	write_byte( 1 ) // framestart
	write_byte( 5 ) // framerate
	write_byte( 2 ) // life
	write_byte( 40 ) // width
	write_byte( 0 ) // noise
	write_byte( 250 ) // r, g, b
	write_byte( 0 ) // r, g, b
	write_byte( 0 ) // r, g, b
	write_byte( 200 ) // brightness
	write_byte( 200 ) // speed
	message_end()

	//Sparks
	message_begin( MSG_PVS, SVC_TEMPENTITY)
	write_byte( 9 )
	write_coord( aimvec[0] )
	write_coord( aimvec[1] )
	write_coord( aimvec[2] )
	message_end()

	//Smoke
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte( 5 ) // 5
	write_coord(aimvec[0])
	write_coord(aimvec[1])
	write_coord(aimvec[2])
	write_short( smoke )
	write_byte( 22 )  // 10
	write_byte( 10 )  // 10
	message_end()

	if(get_cvar_num("cyclops_laser_burndecals") == 1) {
		//TE_GUNSHOTDECAL
		message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
		write_byte( 109 ) // decal and ricochet sound
		write_coord( aimvec[0] ) //pos
		write_coord( aimvec[1] )
		write_coord( aimvec[2] )
		write_short (0) // I have no idea what thats supposed to be
		write_byte (decal_id) //decal
		message_end()
	}

}
//----------------------------------------------------------------------------------------------
public fire_laser(id)
{
	new aimvec[3]
	new tid,tbody
	new FFOn = get_cvar_num("mp_friendlyfire")

	if( !is_user_alive(id) ) return PLUGIN_HANDLED

	if ( laser_shots[id] <= 0 ) {
		client_print(id,print_center,"No Cyclops Shots Left" )
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	// Make sure still on knife
	new clip,ammo,weaponID = get_user_weapon(id,clip,ammo)
	if ( weaponID != CSW_KNIFE ) engclient_cmd(id,"weapon_knife")

	// Warn How many Blasts Left...
	laser_shots[id]--
	if(laser_shots[id] < 6) client_print(id,print_center,"Warning: %d Cyclops Shots Left", laser_shots[id] )

	get_user_origin(id,aimvec,3)
	laserEffects(id, aimvec)

	get_user_aiming(id,tid,tbody)

	if( is_user_alive(tid) && ( FFOn || get_user_team(id) != get_user_team(tid) ) ) {
		emit_sound(tid,CHAN_BODY, "weapons/xbow_hitbod2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

		// Determine the damage
		new damage
		switch(tbody) {
			case 1: damage = h1_dam
			case 2: damage = h2_dam
			case 3: damage = h3_dam
			case 4: damage = h4_dam
			case 5: damage = h4_dam
			case 6: damage = h6_dam
			case 7: damage = h6_dam
		}

		// Deal the damage...
		shExtraDamage(tid, id, damage, "Cyclops Laser")
	}
	return PLUGIN_CONTINUE
}
//----------------------------------------------------------------------------------------------
public client_disconnect(id)
{
	// stupid check but lets see
	if ( id <= 0 || id > SH_MAXSLOTS ) return

	// Yeah don't want any left over residuals
	remove_task(id)
	gHasCyclopsPower[id] = false
}
//----------------------------------------------------------------------------------------------

