#!/usr/bin/env python
# -*- coding: utf-8 -*-

# An ES Tools replacement on new CS:S update by fratacos
# Version 0.54

import es
import est
import gamethread
import os.path
import cmdlib

deadchat = es.ServerVar("est_dead_chat", 0, "enable/disable dead chat")
es.ServerVar("est_allowadvanceddrop", 0, "allow/disallow to drop unusual items")
es.ServerVar("est_enable_weapon_restrictions", 0, "enable/disable restrict weapon functions")
es.ServerVar("est_enable_weapon_mods", 0, "enable/disable modding weapon functions")

es.ServerVar("est_debug", 0)
es.ServerVar("est_conprint", 0)
es.ServerVar("est_Message_Mode", 0)
es.ServerVar("est_Max_Read_Line", 0)
es.ServerVar("est_Hook_Cheatish", 0)
es.ServerVar("est_Hook_Kill", 0)
es.ServerVar("est_Hook_Menu", 0)
es.ServerVar("est_Banned_Entities", 0)
es.ServerVar("est_enable_autorebuy_hook", 0)
es.ServerVar("est_enable_weapon_speed_mods", 0)
es.ServerVar("est_enable_gravity_reseting", 0)
es.ServerVar("est_enable_PerUserKeyHook", 0)
es.ServerVar("est_blackhole_size", 0)
es.ServerVar("est_blackhole_gravity", 0)
es.ServerVar("est_blackhole_pulse", 0)
es.ServerVar("est_blackhole_eats", 0)
es.ServerVar("est_Hook_Fire", 0)
es.ServerVar("est_Hook_Events_Matching", 0)
es.ServerVar("est_enable_est_bullet_impact", 0)
es.ServerVar("est_enable_est_player_shoot", 0)
es.ServerVar("est_enable_est_weapon_reload", 0)
es.ServerVar("est_enable_est_player_weapon_switch", 0)
es.ServerVar("est_enable_PerUserKeyEvents", 0)
es.ServerVar("est_enable_Anti_Crash", 0)
es.ServerVar("est_MakeAdmin", 0)
resourcepath = "addons/est/es_tools.res"

reg_list = {
"est_adddownload":[est.adddownload, 1, 1, 0, "<path>", ""],
"est_armor":[est.armor, 3, 3, 0, "<users> <+,-,=> <value>", ""],
"est_armoradd":[est.armoradd, 2, 2, 0, "<users> <value>", ""],
"est_ban":[est.ban, 2, 3, 0, "<users> <time> [reason]", ""],
"est_burn":[est.burn, 1, 2, 0, "<users> [time]", ""],
"est_cash":[est.cash, 3, 3, 0, "<users> <+,-,=> <value>", ""],
"est_cashadd":[est.cashadd, 2, 2, 0, "<users> <value>", ""],
"est_cexec":[est.cexec, 2, 2, 0, "<users> <command>", ""],
"est_closefile":[est.closefile, 1, 1, 0, "<fileid>", ""],
"est_countlines":[est.countlines, 2, 2, 1, "<variable> <fileid>", ""],
"est_csay":[est.csay, 2, 2, 0, "<users> <text>", ""],
"est_curtime":[est.curtime, 1, 1, 1, "<variable>", ""],
"est_cvaraddflag":[est.cvaraddflag, 9, 9, 0, "<cvar> <gamedll> <protected> <sponly> <notify> <cheat> <userinfo> <unlogged> <replicated>", ""],
"est_cvardelflag":[est.cvardelflag, 9, 9, 0, "<cvar> <gamedll> <protected> <sponly> <notify> <cheat> <userinfo> <unlogged> <replicated>", ""],
"est_damage":[est.damage, 3, 3, 0, "<source user> <target users> <value>", ""],
"est_deafen":[est.deafen, 5, 5, 0, "<users> <total time> <percent> <fadeout time> <fadeback time>", ""],
"est_deathadd":[est.deathadd, 2, 2, 0, "<users> <value>", ""],
"est_deaths":[est.deaths, 3, 3, 0, "<users> <+,-,=> <value>", ""],
"est_deathset":[est.deathset, 2, 2, 0, "<users> <value>", ""],
"est_deleteragdolls":[est.deleteragdolls, 0, 1, 0, "[users]", ""],
"est_dissolve":[est.dissolve, 1, 1, 0, "<class name>", ""],
"est_dropweapon":[est.dropweapon, 2, 2, 0, "<users> <weapon name/slot>", ""],
"est_drug":[est.drug, 1, 2, 0, "<users> [time]", ""],
"est_drunk":[est.drunk, 1, 2, 0, "<users> [time]", ""],
"est_endround":[est.endround, 2, 2, 0, "<time> <reason>", ""],
"est_entteleport":[est.entteleport, 4, 4, 0, "<index> <x> <y> <z>", ""],
"est_extinguish":[est.extinguish, 1, 1, 0, "<users>", ""],
"est_fade":[est.fade, 8, 8, 0, "<users> <type> <fadetime> <totaltime> <r> <g> <b> <a>", ""],
"est_fileexists":[est.fileexists, 2, 2, 1, "<variable> <path>", ""],
"est_freeze":[est.freeze, 2, 2, 0, "<users> <1,0>", ""],
"est_getammo":[est.getammo, 3, 3, 1, "<variable> <users> <weapon name/slot>", ""],
"est_getarmor":[est.getarmor, 2, 2, 1, "<variable> <users>", ""],
"est_getclipammo":[est.getclipammo, 3, 3, 1, "<variable> <users> <weapon name/slot>", ""],
"est_getdeaths":[est.getdeaths, 2, 2, 1, "<variable> <users>", ""],
"est_getentclassname":[est.getentclassname, 2, 2, 1, "<variable> <index>", ""],
"est_getescort":[est.getescort, 2, 2, 1, "<variable> <users>", ""],
"est_geteventinfo":[est.geteventinfo, 2, 2, 1, "<variable> <key name>", ""],
"est_getfb":[est.getfb, 2, 2, 1, "<variable> <users>", ""],
"est_getgravity":[est.getgravity, 2, 2, 1, "<variable> <users>", ""],
"est_getgun":[est.getgun, 2, 2, 1, "<variable> <users>", ""],
"est_getkills":[est.getkills, 2, 2, 1, "<variable> <users>", ""],
"est_gethe":[est.gethe, 2, 2, 1, "<variable> <users>", ""],
"est_gethealth":[est.gethealth, 2, 2, 1, "<variable> <users>", ""],
"est_getindex":[est.getindex, 2, 2, 1, "<variable> <users>", ""],
"est_getip":[est.getip, 2, 2, 1, "<variable> <users>", ""],
"est_getline":[est.getline, 3, 3, 1, "<variable> <fileid> <line no>", ""],
"est_getname":[est.getname, 2, 2, 1, "<variable> <users>", ""],
"est_getprimary":[est.getprimary, 2, 2, 1, "<variable> <users>", ""],
"est_getsecondary":[est.getsecondary, 2, 2, 1, "<variable> <users>", ""],
"est_getsg":[est.getsg, 2, 2, 1, "<variable> <users>", ""],
"est_getslot":[est.getslot, 3, 3, 1, "<variable> <users> <weapon name/slot>", ""],
"est_getsteam":[est.getsteam, 2, 2, 1, "<variable> <users>", ""],
"est_getteam":[est.getteam, 2, 2, 1, "<variable> <users>", ""],
"est_getuserid":[est.getuserid, 2, 2, 1, "<variable> <users>", ""],
"est_getviewangle":[est.getviewangle, 4, 4, 0, "<users> <variable pitch> <variable yaw> <variable roll>", ""],
"est_getweaponindex":[est.getweaponindex, 3, 3, 1, "<variable> <users> <weapon name/slot>", ""],
"est_give":[est.give, 2, 2, 0, "<users> <string>", ""],
"est_god":[est.god, 1, 2, 0, "<users> [1,0]", ""],
"est_hasdefuser":[est.hasdefuser, 2, 2, 1, "<variable> <users>", ""],
"est_hashelmet":[est.hashelmet, 2, 2, 1, "<variable> <users>", ""],
"est_haskevlar":[est.haskevlar, 2, 2, 1, "<variable> <users>", ""],
"est_health":[est.health, 2, 3, 0, "<users> <+,-,=,value> [value]", ""],
"est_healthadd":[est.healthadd, 2, 2, 0, "<users> <value>", ""],
"est_hsay":[est.hsay, 2, 2, 0, "<users> <text>", ""],
"est_isalive":[est.isalive, 2, 2, 1, "<variable> <users>", ""],
"est_isalpha":[est.isalpha, 2, 2, 1, "<variable> <string>", ""],
"est_isbomber":[est.isbomber, 2, 2, 1, "<variable> <users>", ""],
"est_isnumeric":[est.isnumeric, 2, 2, 1, "<variable> <string>", ""],
"est_isonly":[est.isonly, 3, 3, 1, "<variable> <string> <check letters>", ""],
"est_jetpack":[est.jetpack, 2, 2, 0, "<users> <1,0>", ""],
"est_kick":[est.kick, 1, 2, 0, "<users> [reason]", ""],
"est_killadd":[est.killadd, 2, 2, 0, "<users> <value>", ""],
"est_kills":[est.kills, 3, 3, 0, "<users> <+,-,=> <value>", ""],
"est_killset":[est.killset, 2, 2, 0, "<users> <value>", ""],
"est_knifeonly":[est.knifeonly, 2, 2, 1, "<variable> <users>", ""],
"est_loadweaponmod":[est.loadweaponmod, 1, 1, 0, "<file name>", ""],
"est_loop":[est.loop, 3, 3, 0, "<variable> <users> <command>", ""],
"est_modplayerweapon":[est.modplayerweapon, 3, 3, 0, "<users> <weapon> <value>", ""],
"est_modweapon":[est.modweapon, 2, 2, 0, "<weapon> <value>", ""],
"est_motd_f":[est.motd_f, 4, 4, 0, "<users> <title> <command> <path>", ""],
"est_motd_t":[est.motd_t, 4, 4, 0, "<users> <title> <command> <text>", ""],
"est_motd_w":[est.motd_w, 4, 4, 0, "<users> <title> <command> <url>", ""],
"est_msg":[est.msg, 2, 2, 0, "<users> <string>", ""],
"est_name":[est.name, 2, 2, 0, "<users> <string>", ""],
"est_noclip":[est.noclip, 2, 2, 0, "<users> <1,0>", ""],
"est_openfile":[est.openfile, 3, 3, 1, "<variable> <flag(r/w)> <path>", ""],
"est_physpush":[est.physpush, 4, 4, 0, "<users> <x> <y> <z>", ""],
"est_play":[est.play, 2, 4, 0, "<users> <path> [duration] [volume]", ""],
"est_playedict":[est.playedict, 2, 4, 0, "<index> <path> [volume] [attenuation]", ""],
"est_playercount":[est.playercount, 2, 2, 1, "<variable> <users>", ""],
"est_playplayer":[est.playplayer, 2, 4, 0, "<users> <path> [volume] [attenuation]", ""],
"est_pushto":[est.pushto, 5, 5, 0, "<users> <x> <y> <z> <force>", ""],
"est_randplayer":[est.randplayer, 2, 2, 1, "<variable> <users>", ""],
"est_regclientcmd":[est.regclientcmd, 2, 2, 0, "<command> <1,0>", ""],
"est_regeventblock":[est.regeventblock, 2, 2, 0, "<event name> <command>", ""],
"est_remove":[est.remove, 1, 1, 0, "<entity>", ""],
"est_removeidle":[est.removeidle, 1, 1, 0, "<weapon / weapon_...>", ""],
"est_removeweapon":[est.removeweapon, 2, 2, 0, "<users> <weapon name/slot>", ""],
"est_rescued":[est.rescued, 1, 1, 1, "<variable>", ""],
"est_restrict":[est.restrict, 2, 2, 0, "<users> <weapon>", ""],
"est_restrictall":[est.restrictall, 1, 1, 0, "<users>", ""],
"est_rocket":[est.rocket, 1, 1, 0, "<users>", ""],
"est_rounddecimal":[est.rounddecimal, 3, 3, 1, "<variable> <value> <places>", ""],
"est_setammo":[est.setammo, 3, 3, 0, "<users> <weapon name/slot> <value>", ""],
"est_setarmor":[est.setarmor, 2, 2, 0, "<users> <value>", ""],
"est_setcash":[est.setcash, 2, 2, 0, "<users> <value>", ""],
"est_setclipammo":[est.setclipammo, 3, 3, 0, "<users> <weapon name/slot> <value>", ""],
"est_setentitycolor":[est.setentitycolor, 5, 5, 0, "<index> <r> <g> <b> <a>", ""],
"est_setentname":[est.setentname, 2, 2, 0, "<index> <name>", ""],
"est_setgravity":[est.setgravity, 2, 2, 0, "<users> <ratio>", ""],
"est_sethealth":[est.sethealth, 2, 2, 0, "<users> <value>", ""],
"est_setmodel":[est.setmodel, 2, 2, 0, "<users> <model path>", ""],
"est_setplayercolor":[est.setplayercolor, 6, 6, 0, "<users> <r> <g> <b> <a> <1:include weapon/0:player only>", ""],
"est_setviewangle":[est.setviewangle, 4, 4, 0, "<users> <pitch> <yaw> <roll>", ""],
"est_setviewcoord":[est.setviewcoord, 4, 4, 0, "<users> <x> <y> <y>", ""],
"est_shake":[est.shake, 4, 4, 0, "<users> <time> <distance> <value>", ""],
"est_slay":[est.slay, 1, 1, 0, "<users>", ""],
"est_spawn":[est.spawn, 1, 2, 0, "<users> [1,0]", ""],
"est_speed":[est.speed, 2, 2, 0, "<users> <speed>", ""],
"est_stopsound":[est.stopsound, 2, 2, 0, "<users> <path>", ""],
"est_stripplayer":[est.stripplayer, 2, 2, 0, "<users> <1,0>", ""],
"est_strlen":[est.strlen, 2, 2, 1, "<variable> <string>", ""],
"est_strtolower":[est.strtolower, 2, 2, 1, "<variable> <string>", ""],
"est_strtoupper":[est.strtoupper, 2, 2, 1, "<variable> <string>", ""],
"est_team":[est.team, 2, 2, 0, "<users> <team>", ""],
"est_teleport":[est.teleport, 4, 4, 0, "<users> <x> <y> <z>", ""],
"est_trimdecimal":[est.trimdecimal, 3, 3, 1, "<variable> <value> <places>", ""],
"est_unregclientcmd":[est.unregclientcmd, 1, 1, 0, "<command>", ""],
"est_unregeventblock":[est.unregeventblock, 1, 2, 0, "<event name> [command]", ""],
"est_unrestrict":[est.unrestrict, 2, 2, 0, "<users> <weapon>", ""],
"est_unrestrictall":[est.unrestrictall, 1, 1, 0, "<users>", ""],
"est_uptime":[est.uptime, 1, 1, 1, "<variable>", ""],
}
nouser_list = ["est_damage"]
for key in reg_list:
	if not "<user>" in reg_list[key][4]:
		nouser_list.append(key)

def load():
	global handles
	handles = []
	# es.set("est_Hook_Events_Matching", es.ServerVar("est_Hook_Events_Matching"))
	# handles.append(nt.conVarRegister("est_Hook_Events_Matching", est_hookeventsmatching))
	file = (__name__).split(".")[0]
	for key in reg_list:
		cmdlib.registerServerCommand(key, reg_cmd, reg_list[key][5])
	if os.path.exists("cstrike/cfg/es_tools.cfg"):
		es.ServerCommand("exec es_tools.cfg")
	if os.path.exists("cstrike/%s" % resourcepath):
		es.loadevents('declare', resourcepath)
		es.loadevents(resourcepath)
	es.ServerVar("sv_hudhint_sound").set(0)
	est.load()

def reg_cmd(args):
	global reg_list
	global nouser_list
	name = es.getargv(0)
	item = reg_list[name]
	argc = es.getargc() - 1
	if not (item[1] <= argc and argc <= item[2]):
		es.dbgmsg(0, "Syntax: " + name + " " + item[4])
		return
	func = item[0]
	arglist = [] + args
	if item[3] >= 1:
		del arglist[item[3] - 1]
	if argc != 0 and not name in nouser_list:
		arglist[0] = est.estfilter(arglist[0])
	if name == "est_damage":
		arglist[1] = est.estfilter(arglist[1])
	if name == "est_getviewangle":
		ret = func(arglist[0])
		if ret != None:
			es.ServerVar(arglist[1]).set(ret[0])
			es.ServerVar(arglist[2]).set(ret[1])
			es.ServerVar(arglist[3]).set(ret[2])
		return
	if item[3] > 0:
		ret = func(*arglist)
		if ret != None:
			es.ServerVar(es.getargv(item[3])).set(ret)
	else:
		func(*arglist)

def unload():
	global handles
	#nt.unregisterHandles(handle)s
	est.unload()
	for item in reg_list:
		cmdlib.unregisterServerCommand(item[0])

def es_player_chat(event_var):
	global deadchat
	if deadchat:
		est.es_player_chat(event_var)

def es_map_start(event_var):
	es.loadevents(resourcepath)
	est.es_map_start(event_var)

def round_start(event_var):
	est.round_start(event_var)

def round_end(event_var):
	est.round_end(event_var)

def player_connect(event_var):
	est.player_connect(event_var)

def player_disconnect(event_var):
	est.player_disconnect(event_var)

def player_death(event_var):
	est.player_death(event_var)

def weapon_fire(event_var):
	est.weapon_fire(event_var)

def item_pickup(event_var):
	est.item_pickup(event_var)

def hostage_follows(event_var):
	est.hostage_follows(event_var)

def hostage_stops_following(event_var):
	est.hostage_stops_following(event_var)

def hostage_rescued(event_var):
	est.hostage_rescued(event_var)

# old codes for hookeventsmatching

def hook_round_end(event_var):
	es.addons.triggerEvent("round_end")
	return False

def hooking(event_var):
	return False

hook_list = [ ["round_end", hook_round_end] ]

def est_hookeventsmatching(value):
	for item in hook_list:
		if item[0] in value:
			handles.append(nt.preEventRegister("round_end", hooking))