#!/usr/bin/env python
# -*- coding: utf-8 -*-

# An ES Tools replacement for CS:S by fratacos
# Version 0.54

#[Added]
#trimdecimal, setviewangle, setviewcoord

#[Fixed]
#spawn, rounddecimal
#optimized ESS functions
#user confliction in deadchat

#[Known Issues]
#endround and rocket are incomplete
#death and restriction functions are fakes
#All commands are in lower cases (this is a limitation of EventScripts)

#[currently not possible]
#est_effect*
#est_enable_PerUserKeyEvents

import es
import spe
import gamethread
import playerlib
import time
import vecmath
import random
import os

hooked_event_var = 0
round_count = 0
round_interval = 0
timer = 0
starttime = time.time()
regclientcmd_list = []
restrict_list = {}
modplayerweapon_list = {}
modweapon_list = {}
weaponmod_list = {}
modified_deaths = 0
deaths_list = {}
regeventblock_list = {}
rocket_list = {}
file_list = {}
file_handle = 0
escort_list = {}
cs_player_manager = 0
count_rescued = 0
allweapons = ["weapon_ak47", "weapon_aug", "weapon_awp", "weapon_c4", "weapon_deagle", "weapon_elite", "weapon_famas", "weapon_fiveseven", "weapon_flashbang", "weapon_g3sg1", "weapon_galil", "weapon_glock", "weapon_hegrenade", "weapon_knife", "weapon_m249", "weapon_m3", "weapon_m4a1", "weapon_mac10", "weapon_mp5navy", "weapon_p228", "weapon_p90", "weapon_scout", "weapon_sg550", "weapon_sg552", "weapon_smokegrenade", "weapon_tmp", "weapon_ump45", "weapon_usp", "weapon_xm1014"]
allflags = ["gamedll", "protected", "sponly", "notify", "cheat", "userinfo", "unlogged", "replicated"]
pyfilter = ["#alive", "#all", "#bot", "#ct", "#dead", "#human", "#spec", "#t", "#un"]
filter_table = [["t","#t"], ["c","#ct"], ["3","#ct"], ["2","#t"], ["s","#spec"], ["1","#spec"], ["u","#un"], ["h","#human"], ["b","#bot"], ["l","#alive"], ["a","#all"], ["d","#dead"] ]
weaponmod_default = {"recoil":0, "damage0":0, "damage1":0, "damage2":0, "damage3":0, "damage4":0, "damage5":0, "damage6":0, "damage7":0, "damageaction":"+", "punchback":0, "speed":1.0, "auto":0}

def load():
	es.addons.registerClientCommandFilter(clientcommandfilter)
	es.addons.registerTickListener(ticklistener)
	spe.registerPreHook("player_disconnect", pre_player_disconnect)
	spe.registerPreHook("player_hurt", pre_player_hurt)
	spe.registerPreHook("weapon_fire", pre_weapon_fire)

def unload():
	spe.unregisterPreHook("weapon_fire", pre_weapon_fire)
	spe.unregisterPreHook("player_hurt", pre_player_hurt)
	spe.unregisterPreHook("player_disconnect", pre_player_disconnect)
	es.addons.unregisterTickListener(ticklistener)
	es.addons.unregisterClientCommandFilter(clientcommandfilter)

def adddownload(param):
	es.stringtable("downloadables", param)
def armor(users, param, value):
	v = int(value)
	for userid in getusers(users):
		if param in "+-":
			now = es.getplayerprop(userid, "CCSPlayer.m_ArmorValue")
			if param == "+":
				now += v
			if param == "-":
				now -= v
			v = now
		if param in "=+-":
			es.setplayerprop(userid, "CCSPlayer.m_ArmorValue", v)
def armoradd(users, value):
	armor(users, "+", value)
def ban(users, time, reason = ""):
	flag = 0
	if reason == "":
		flag = 1
	for userid in getusers(users):
		if flag:
			es.ServerCommand("banid %s %s kick" % (time, userid))
		else:
			es.ServerCommand("banid %s %s" % (time, userid))
			es.ServerCommand("kickid %s %s" % (userid, reason))
def burn(users, time = 0):
	t = int(time)
	for userid in getusers(users):
		if t != 0:
			es.fire(userid, "!self", "IgniteLifetime", t)
		else:
			es.fire(userid, "!self", "ignite")
def cash(users, param, value):
	v = int(value)
	for userid in getusers(users):
		if param in "+-":
			now = es.getplayerprop(userid, "CCSPlayer.m_iAccount")
			if param == "+":
				now += v
			if param == "-":
				now -= v
			v = now
		if param in "=+-":
			es.setplayerprop(userid, "CCSPlayer.m_iAccount", v)
def cashadd(users, value):
	cash(users, "+", value)
def cexec(users, command):
	for userid in getusers(users):
		es.ServerCommand("es_xsexec %s %s" % (userid, command))
def closefile(fileid):
	global file_list
	id = int(fileid)
	if not id in file_list: return
	del file_list[id]
def countlines(fileid):
	global file_list
	id = int(fileid)
	if not id in file_list: return
	no = 0
	for line in file_list[id][2]:
		no += 1
	return no
def csay(users, text):
	es.usermsg("create", "centermsg", "TextMsg")
	es.usermsg("write", "byte", "centermsg", 4)
	es.usermsg("write", "string", "centermsg", unicode(text))
	for userid in getusers(users):
		es.usermsg("send", "centermsg", userid)
	es.usermsg("delete", "centermsg")
def curtime():
	global timer
	if timer == 0:
		timer = time.time()
		return 0
	else:
		return time.time() - timer
def cvaraddflag(cvar, gamedll, protected, sponly, notify, cheat, userinfo, unlogged, replicated):
	global allflags
	data = [gamedll, protected, sponly, notify, cheat, userinfo, unlogged, replicated]
	count = 0
	while count < 8:
		if int(data[count]) == 1:
			es.flags("add", allflags[count], cvar)
		count += 1
def cvardelflag(cvar, gamedll, protected, sponly, notify, cheat, userinfo, unlogged, replicated):
	global allflags
	data = [gamedll, protected, sponly, notify, cheat, userinfo, unlogged, replicated]
	count = 0
	while count < 8:
		if int(data[count]) == 1:
			es.flags("remove", allflags[count], cvar)
		count += 1
def damage(source, target, value):
	flag = 0
	if str(source) == "0":
		for userid in getusers(target):
			source = userid
			es.fire(userid, "!self", "addoutput", "targetname mrdamage")
			index = es.createentity("point_hurt")
			es.entitysetvalue(index, "damage", value)
			es.entitysetvalue(index, "damagetype", 32)
			es.entitysetvalue(index, "targetname", index)
			es.fire(source, index, "addoutput", "DamageTarget mrdamage")
			es.fire(source, index, "Hurt")
			es.fire(source, index, "Kill")
			es.fire(userid, "!self", "addoutput", "targetname mrnothing")
	else:
		targets = getusers(target)
		for userid in targets:
			es.fire(userid, "!self", "addoutput", "targetname mrdamage")
		index = es.createentity("point_hurt")
		es.entitysetvalue(index, "damage", value)
		es.entitysetvalue(index, "damagetype", 32)
		es.entitysetvalue(index, "targetname", index)
		es.entitysetvalue(index, "classname", getgun(source))
		es.fire(source, index, "addoutput", "DamageTarget mrdamage")
		es.fire(source, index, "Hurt")
		es.fire(source, index, "Kill")
		for userid in targets:
			es.fire(userid, "!self", "addoutput", "targetname mrnothing")
def deafen(users, total, percent, fadeout, fadeback):
	for userid in getusers(users):
		es.fadevolume(userid, percent, fadeout, total, fadeback)
def deathadd(users, value):
	deaths(users, "+", value)
def deaths(users, param, v):
	global deaths_list
	global modified_deaths
	global cs_player_manager
	if not param in "=+-":
		return
	if modified_deaths == 0:
		modified_deaths = 1
		players = playerlib.getPlayerList("#all")
		for player in players:
			deaths_list[player.userid] = es.getindexprop(cs_player_manager, "CPlayerResource.m_iDeaths.%.3d" % player.attributes["index"])
	value = int(v)
	for userid in getusers(users):
		if param == "=":
			deaths_list[userid] = value
		if param == "+":
			deaths_list[userid] += value
		if param == "-":
			deaths_list[userid] -= value
def deathset(users, value):
	deaths(users, "=", value)
def dissolve(param):
	trigger = es.getuserid()
	index = es.createentity("env_entity_dissolver", trigger)
	es.entitysetvalue(index, "target", param)
	es.entitysetvalue(index, "magnitude", 1)
	es.entitysetvalue(index, "dissolvetype", 3)
	es.spawnentity(index)
	es.fire(trigger, trigger, "Dissolve")
	es.fire(trigger, trigger, "Kill")
def deleteragdolls(users = 0):
	if str(users) == "0":
		es.fire(es.getuserid(), "cs_ragdoll", "Kill", 0.15)
		return
	handles = []
	for userid in getusers(users):
		handles.append(es.getplayerhandle(userid))
	ragdolls = es.createentitylist("cs_ragdoll")
	for index in ragdolls:
		if es.getindexprop(index, "CCSRagdoll.m_hPlayer") in handles:
			setentname(index, "theragdoll")	
	es.fire(es.getuserid(), "theragdoll", "Kill", 0.15)
def dropweapon(users, param):
	global allweapons
	for userid in getusers(users):
		name = getweaponname(userid, param)
		for item in name:
			if item in allweapons:
				spe.dropWeapon(userid, item)
def drug(users, time = -1):
	t = int(time)
	for userid in getusers(users):
		if t != 0:
			es.cexec(userid, "r_screenoverlay Effects/tp_eyefx/tp_eyefx.vmt")
		if t >= 0:
			gamethread.delayed(t, es.cexec, (userid, "r_screenoverlay nothing"))
def drunk(users, time = -1):
	global round_count
	t = int(time)
	drunk_loop(0, t, getusers(users), 90, 0, int(round_count))
def drunk_loop(count, time, users, fov, ang, round):
	global round_count
	global round_interval
	if (round != round_count) or (time >= 0 and count / 5 > time):
		for userid in users:
			player = playerlib.getPlayer(userid)
			angle = player.getViewAngle()
			es.setang(userid, angle[0], angle[1], 0)
			es.setplayerprop(userid, "CBasePlayer.m_iFOV", 90)
		return
	flag = 0
	for userid in users:
		dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
		if dead:
			player = playerlib.getPlayer(userid)
			angle = player.getViewAngle()
			es.setang(userid, angle[0], angle[1], 0)
			es.setplayerprop(userid, "CBasePlayer.m_iFOV", 90)
			continue
		flag = 1
		player = playerlib.getPlayer(userid)
		index = player.attributes["index"]
		ang += [-15, -10, 10, 15][random.randint(0, 3)]
		if ang < -60: ang = -60
		if ang > 60: ang = 60
		angle = player.getViewAngle()
		es.setang(userid, angle[0], angle[1], ang)
		fov += [-15, -10, -5, 5, 10, 15][random.randint(0, 5)]
		if fov < 30: fov = 30
		if fov > 150: fov = 150
		es.setplayerprop(userid, "CBasePlayer.m_iFOV", fov)
	if flag:
		gamethread.delayed(0.2, drunk_loop, (count + 1, time, users, fov, ang, round))
def endround(time, reason):
	t = int(time)
	r = int(reason)
	if not (0 < r and r < 17):
		return
	data = [["#Target_Bombed", 2], ["#VIP_Escaped", 3], ["#VIP_Assassinated", 2], ["#Terrorists_Escaped", 2], ["#CTs_PreventEscape", 3], ["#Escaping_Terrorists_Neutralized", 3], ["#Bomb_Defused", 3], ["#CTs_Win", 3], ["#Terrorists_Win", 2], ["#Round_Draw", 0], ["#All_Hostages_Rescued", 3], ["#Target_Saved", 3], ["#Hostages_Not_Rescued", 2], ["#Terrorists_Not_Escaped", 3], ["#VIP_Not_Escaped", 2], ["#Game_Commencing", 0]]
	winner = data[r - 1][1]
	text = data[r - 1][0]
	es.event("initialize", "round_end")
	es.event("setint", "round_end", "winner", winner)
	es.event("setint", "round_end", "reason", r)
	es.event("setstring", "round_end", "message", text)
	es.event("fire", "round_end")
	gamethread.delayed(t, endround_delayed1, (t, text))
	gamethread.delayed(t + 0.20, endround_delayed2, (t, text))
def endround_delayed1(t, text):
	es.flags("remove", "cheat", "endround")
	es.ServerCommand("endround")
def endround_delayed2(t, text):
	es.flags("add", "cheat", "endround")
	if t >= 2:
		es.centermsg("")
	else:
		es.centermsg(text)
def entteleport(index, x, y, z):
	setentname(index, "theentity")
	es.fire(es.getuserid(), "theentity", "addoutput", "origin %d %d %d" % (float(x), float(y), float(z)))
def extinguish(users):
	for userid in getusers(users):
		es.fire(userid, "!self", "IgniteLifetime", 0)
def fade(users, type, fadetime, totaltime, r, g, b, a):
	t = int(type)
	if t == 1:
		type = 2
	elif t == 0:
		type = 1
	else:
		type = 8 + 16
	es.usermsg("create", "fade", "Fade")
	es.usermsg("write", "short", "fade", float(fadetime) * 1000)
	es.usermsg("write", "short", "fade", float(totaltime) * 1000)
	es.usermsg("write", "short", "fade", int(type))
	es.usermsg("write", "byte", "fade", int(r))
	es.usermsg("write", "byte", "fade", int(g))
	es.usermsg("write", "byte", "fade", int(b))
	es.usermsg("write", "byte", "fade", int(a))
	for userid in getusers(users):
		es.usermsg("send", "fade", userid)
	es.usermsg("delete", "fade")
def fileexists(path):
	test = os.getcwd() + "/cstrike/" + path
	if not os.path.exists(test): return 0
	if not os.path.isabs(test): return -1
	if not os.path.isfile(test): return -1
	if os.path.islink(test): return -1
	return 1
def freeze(users, param = 1):
	# we can't bit operate directly because movetype is not proper integer
	for userid in getusers(users):
		movetype = es.getplayerprop(userid, "CBaseEntity.movetype")
		if not movetype:
			continue
		if str(param) == "1":
			if movetype & 2:
				es.setplayerprop(userid, "CBaseEntity.movetype", movetype - 2)
		else:
			if not movetype & 2:
				es.setplayerprop(userid, "CBaseEntity.movetype", movetype + 2)
def getammo(users, param):
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		primary = player.getPrimary()
		secondary = player.getSecondary()
		name = getweaponname(userid, param)
		if primary in name:
			return player.ammo.primary
		if secondary in name:
			return player.ammo.secondary
	return None
def getarmor(users):
	for userid in getusers(users):
		return es.getplayerprop(userid, "CCSPlayer.m_ArmorValue")
	return None
def getclipammo(users, param):
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		primary = player.getPrimary()
		secondary = player.getSecondary()
		name = getweaponname(userid, param)
		if primary in name:
			return player.clip.primary
		if secondary in name:
			return player.clip.secondary
	return None
def getdeaths(users):
	global deaths_list
	global modified_deaths
	global cs_player_manager
	if modified_deaths != 0:
		for userid in getusers(users):
			return deaths_list[userid]
	else:
		for userid in getusers(users):
			return es.getindexprop(cs_player_manager, "CPlayerResource.m_iDeaths.%.3d" % playerlib.getPlayer(userid).attributes["index"])
	return None
def getentclassname(index):
	return es.entitygetvalue(index, "classname")
def getescort(users):
	global escort_list
	for userid in getusers(users):
		return escort_list[userid]
	return 0
def geteventinfo(param):
	global hooked_event_var
	if hooked_event_var != 0 and param in hooked_event_var:
		return hooked_event_var[param]
def getfb(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getFB()
	return None
def getgravity(users):
	for userid in getusers(users):
		index = playerlib.getPlayer(userid).attributes["index"]
		return es.entitygetvalue(index, "gravity")
	return None
def getgun(users):
	for userid in getusers(users):
		name = playerlib.getPlayer(userid).weapon
		if name != None:
			return name
	return "weapon_none"
def gethe(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getHE()
	return None
def gethealth(users):
	for userid in getusers(users):
		return es.getplayerprop(userid, "CBasePlayer.m_iHealth")
	return None
def getindex(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).attributes["index"]
	return None
def getip(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).address
def getkills(users):
	global cs_player_manager
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		if player:
			return es.getindexprop(cs_player_manager, "CPlayerResource.m_iScore.%.3d" % player.attributes["index"])
	return None
def getline(fileid, lineno):
	global file_list
	id = int(fileid)
	if not id in file_list: return
	theno = int(lineno)
	no = 0
	for line in file_list[id][2]:
		no += 1
		if no == theno:
			break
	return line
def getname(users):
	for userid in getusers(users):
		return es.getplayername(userid)
	return None
def getprimary(users):
	for userid in getusers(users):
		name = playerlib.getPlayer(userid).getPrimary()
		if name != 0:
			return name
	return "weapon_none"
def getsecondary(users):
	for userid in getusers(users):
		name = playerlib.getPlayer(userid).getSecondary()
		if name != 0:
			return name
	return "weapon_none"
def getsg(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getSG()
def getslot(users, param):
	if not str(param) in "1234":
		return
	for userid in getusers(users):
		weapons = getweaponname(userid, param)
		if weapons == [ "weapon_none" ]:
			continue
		if len(weapons) > 0:
			return weapons[0]
	return "weapon_none"
def getsteam(users):
	for userid in getusers(users):
		return es.getplayersteamid(userid)
	return None
def getteam(users):
	for userid in getusers(users):
		return es.getplayerprop(userid, "CBaseEntity.m_iTeamNum")
	return None
def getuserid(users):
	for userid in getusers(users):
		return userid
	return None
def getviewangle(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getViewAngle()
def getweaponindex(users, param):
	handles = []
	for userid in getusers(users):
		handles.append(es.getplayerhandle(userid))
	name = getweaponname(userid, param)
	if name == ["weapon_none"]:
		return 0
	for item in name:
		weapon = es.createentitylist(item)
		for index in weapon:
			if es.getindexprop(index, "CBaseCombatWeapon.m_hOwner") in handles:
				return index
	return 0
def give(users, param):
	for userid in getusers(users):
		es.ServerCommand("es_xgive %s %s" % (userid, param))
def god(users, param = 1):
	for userid in getusers(users):
		dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
		if not dead:
			if str(param) == "1":
				es.setplayerprop(userid, "CBasePlayer.m_lifeState", 0)
			else:
				es.setplayerprop(userid, "CBasePlayer.m_lifeState", 512)
def hasdefuser(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).hasDefuser()
	return 0
def hashelmet(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).hasHelmet()
	return 0
def haskevlar(users):
	for userid in getusers(users):
		if es.getplayerprop(userid, "CCSPlayer.m_ArmorValue") > 0:
			return 1
		else:
			return 0
	return 0
def health(users, param, value = 0):
	v = int(value)
	if v == 0 and not param in "=+-":
		v = int(param)
		param = "="
	flag = 0
	for userid in getusers(users):
		vv = v
		if param in "+-":
			now = es.getplayerprop(userid, "CBasePlayer.m_iHealth")
			if now == None:
				continue
			vv = now
			if param == "+":
				vv += v
			if param == "-":
				vv -= v
		if param in "=+-":
			es.setplayerprop(userid, "CBasePlayer.m_iHealth", vv)
			es.setplayerprop(userid, "CBasePlayer.m_iMaxHealth", vv)
def healthadd(users, value):
	health(users, "+", value)
def hsay(users, text):
	es.usermsg("create", "hudhint", "HintText")
	es.usermsg("write", "string", "hudhint", unicode(text))
	for userid in getusers(users):
		es.usermsg("send", "hudhint", userid)
	es.usermsg("delete", "hudhint")
def isalive(users):
	for userid in getusers(users):
		if es.getplayerprop(userid, "CBasePlayer.pl.deadflag"):
			return 0
		else:
			return 1
def isalpha(param):
	if param.isalpha():
		return 1
	else:
		return 0
def isbomber(users):
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		if player.hasC4():
			return 1
		else:
			return 0
def isnumeric(param):
	if param.startswith("-"):
		param = param[1:]
	param = param.replace(".", "")
	if param.isdigit():
		return 1
	else:
		return 0
def isonly(param, checker):
	for item in param:
		if not item in checker:
			return 0
	return 1
def jetpack(users, param):
	p = int(param)
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		player.jetpack(p)
def kick(users, reason = ""):
	flag = 0
	if reason == "":
		flag = 1
	for userid in getusers(users):
		if flag:
			es.ServerCommand("kickid %s" % userid)
		else:
			es.ServerCommand("kickid %s %s" % (userid, reason))
def killadd(users, v):
	kills(users, "+", v)
def kills(users, param, v):
	value = int(v)
	if param == "+":
		apply = value
	if param == "-":
		apply = -value
	if not param == "=":
		trigger = es.getuserid()
		index = es.createentity("game_score")
		es.setentityname(index, index)
		es.fire(trigger, index, "addoutput", "spawnflags 1")
		es.fire(trigger, index, "addoutput", "points %d" % apply)
	for userid in getusers(users):
		if param == "=":
			apply = value - getkills(userid)
			index = es.createentity("game_score")
			es.setentityname(index, index)
			es.fire(userid, index, "addoutput", "spawnflags 1")
			es.fire(userid, index, "addoutput", "points %d" % apply)
		es.fire(userid, index, "ApplyScore")
		if param == "=":
			es.fire(userid, index, "Kill")
	if not param == "=":
		es.fire(trigger, index, "Kill")
def killset(users, v):
	kills(users, "=", v)
def knifeonly(users):
	for userid in getusers(users):
		if getweaponname(userid, 1) == ["weapon_none"] and getweaponname(userid, 2) == ["weapon_none"] and getweaponname(userid, 3) == ["weapon_knife"] and getweaponname(userid, 4) == ["weapon_none"]:
			return 1
		else:
			return 0
def loadweaponmod(filename):
	if es.ServerVar("est_enable_weapon_mods") == 0:
		return
	global allweapons
	global weaponmod_list
	global weaponmod_default
	path = "addons/est/" + filename
	test = os.getcwd() + "/cstrike/" + path
	if fileexists(path) != 1:
		return
	item = None
	status = 0
	file = open(test)
	try:
		for line in file:
			line = line.replace("\r", "")
			line = line.replace("\n", "")
			line = line.replace("\t", "")
			line = line.replace(" ", "")
			if line == "" or line.startswith("//"):
				continue
			if "{" in line:
				status += 1
				if status != 2:
					continue
				item = None
				temp = line.split('"')
				if len(temp) != 3:
					continue
				tempitem = "weapon_" + temp[1]
				if not tempitem in allweapons:
					continue
				item = tempitem
				weaponmod_list[item] = weaponmod_default
				continue
			if "}" in line and status > 0:
				status -= 1
				continue
			if status == 2 and item != None:
				temp = line.split('"')
				if len(temp) != 3:
					continue
				param = temp[0]
				value = temp[1]
				temp_dic = weaponmod_list[item]
				temp_dic[param] = value
	finally:
		if file: file.close()
def loop(variable, users, command):
	for userid in getusers(users):
		es.ServerCommand("es_set %s %s" % (variable, userid))
		es.ServerCommand(command)
def modplayerweapon(users, param, value):
	global allweapons
	global modplayerweapon_list
	v = int(value)
	if not param in allweapons:
		return
	for userid in getusers(users):
		id = int(userid)
		if v == -1:
			if not id in modplayerweapon_list:
				continue
			mods = modplayerweapon_list[id]
			for item in mods:
				if item[0] == param:
					modplayerweapon_list[id].remove(item)
					break
		else:
			if not id in modplayerweapon_list:
				modplayerweapon_list[id] = []
			modplayerweapon_list[id].append([param, v])
def modweapon(param, value):
	global allweapons
	if not param in allweapons:
		return
	global modweapon_list
	v = int(value)
	if v == -1:
		if param in modweapon_list:
			del modweapon_list[param]
	else:
		modweapon_list[param] = v
def motd(users, title, type, msg):
	data = { "title":title, "type":type, "msg":msg }
	es.usermsg('create', 'panel', 'VGUIMenu')
	es.usermsg('write', 'string', 'panel', "info")
	es.usermsg('write', 'byte', 'panel', 1)
	es.usermsg('write', 'byte', 'panel', len(data))
	for item in data:
		es.usermsg('write', 'string', 'panel', item)
		es.usermsg('write', 'string', 'panel', data[item])
	for userid in getusers(users):
		es.usermsg('send', 'panel', userid)
	es.usermsg('delete', 'panel')
def motd_f(users, title, command, path):
	motd(users, unicode(title), "3", path)
def motd_t(users, title, command, text):
	motd(users, unicode(title), "0", unicode(text))
def motd_w(users, title, command, url):
	motd(users, unicode(title), "2", url)
def msg(users, value):
	for userid in getusers(users):
		es.tell(userid, "#multi", value)
def name(users, value):
	for userid in getusers(users):
		if es.getplayersteamid(userid) == "BOT":
			es.botsetvalue(userid, "name", unicode(value))
		else:
			es.cexec(userid, "name %s" % unicode(value))
def noclip(users, value):
	if int(value) == 1:
		v = 1
	else:
		v = 0
	for userid in getusers(users):
		playerlib.getPlayer(userid).noclip(v)
def openfile(flags, path):
	global file_list
	global file_handle
	if not flags in ["r", "w"]: return
	test = os.getcwd() + "/cstrike/" + path
	if fileexists(test) != 1:
		return
	file = open(test)
	try:
		file_handle += 1
		file_list[file_handle] = [flags, test, file.readlines()]
		return file_handle
	finally:
		if file: file.close()
def physpush(users, x, y, z):
	for userid in getusers(users):
		xx = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[0]")
		yy = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[1]")
		zz = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[2]")
		vec = vecmath.vector(es.getplayerprop(userid, "CBasePlayer.localdata.m_vecBaseVelocity"))
		es.setplayerprop(userid, "CBasePlayer.localdata.m_vecBaseVelocity", "%f,%f,%f" % (float(x) + vec[0] - xx, float(y) + vec[1] - yy, float(z) + vec[2] - zz))
def play(users, param, duration = 0, volume = 1.0):
	d = float(duration)
	v = float(volume)
	for userid in getusers(users):
		es.playsound(userid, param, v)
	if d != 0:
		gamethread.delayed(d, stopsound, (userid, param))
def playedict(index, param, volume = 1.0, attenuation = 0.5):
	v = float(volume)
	a = float(attenuation)
	es.emitsound("entity", int(index), param, v, a)
def playercount(users):
	return len(getusers(users))
def playplayer(users, param, volume = 1.0, attenuation = 0.5):
	v = float(volume)
	a = float(attenuation)
	for userid in getusers(users):
		es.emitsound("player", userid, param, v, a)
def pushto(users, x, y, z, force):
	target = vecmath.vector(float(x), float(y), float(z))
	f = float(force)
	for userid in getusers(users):
		xx = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[0]")
		yy = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[1]")
		zz = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[2]")
		origin = es.getplayerprop(userid, "CBaseEntity.m_vecOrigin")
		source = vecmath.vector(origin)
		base = target - source
		es.setplayerprop(userid, "CBasePlayer.localdata.m_vecBaseVelocity", "%f,%f,%f" % (base[0] * f - xx, base[1] * f - yy, base[2] * f - zz))
def randplayer(users):
	players = getusers(users)
	max = len(players)
	if max > 0:
		no = random.randint(0, max - 1)
		count = 0
		for item in players:
			if count == no:
				return item
			count += 1
	return None
def regclientcmd(command, type):
	global regclientcmd_list
	if str(type) == "1":
		t = 1
	else:
		t = 0
	for item in regclientcmd_list:
		if item[0] == command:
			regclientcmd_list.remove(item)
			break
	regclientcmd_list.append([command, t])
def regeventblock(eventname, code):
	global regeventblock_list
	if eventname in regeventblock_list:
		return
	regeventblock_list[eventname] = code
	spe.registerPreHook(eventname, hooked)
def remove(param):
	es.fire(es.getuserid(), str(param), "Kill")
def removeidle(param):
	if param == "weapon":
		global allweapons
		for weapon in allweapons:
			removeidle(weapon)
		return
	weapon = es.createentitylist(param)
	for index in weapon:
		if es.getindexprop(index, "CBaseCombatWeapon.m_hOwner") == -1:
			setentname(index, "theweapon")
	es.fire(es.getuserid(), "theweapon", "Kill")
def removeweapon(users, param):
	handles = {}
	flag = 0
	weapons = []
	if str(param) in "1234":
		flag = 1
	else:
		weapons = [param]
	for userid in getusers(users):
		handle = es.getplayerhandle(userid)
		if flag:
			name = getweaponname(userid, param)
			if name == ["weapon_none"]:
				continue
			for item in name:
				weapons.append(item)
				if item in handles:
					handles[item].append(handle)
				else:
					handles[item] = [handle]
		else:
			if param in handles:
				handles[param].append(handle)
			else:
				handles[param] = [handle]
	for weaponname in weapons:
		weapon = es.createentitylist(weaponname)
		for index in weapon:
			if es.getindexprop(index, "CBaseCombatWeapon.m_hOwner") in handles[weaponname]:
				setentname(index, "theweapon")
	es.fire(es.getuserid(), "theweapon", "Kill")
def rescued():
	global count_rescued
	return count_rescued
def restrict(users, param):
	if str(param) in "1234":
		return
	if str(param) == "mp5":
		param = "mp5navy"
	item = "weapon_%s" % param
	global allweapons
	if not item in allweapons:
		return
	global restrict_list
	for userid in getusers(users):
		if not item in restrict_list[userid]:
			restrict_list[userid].append(item)
def restrictall(users):
	global restrict_list
	global allweapons
	for userid in getusers(users):
		restrict_list[userid] = allweapons
def rocket(users):
	# smoke sprites -> explosion white ring -> bones (optional)
	global rocket_list
	global round_count
	god(users, 0)
	shake(users, 10, 40, 25)
	for userid in getusers(users):
		dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
		if dead:
			continue
		rocket_list[int(userid)] = 1
		es.emitsound("player", userid, "weapons/rpg/rocketfire1.wav", 0.5, 0.5)
		gamethread.delayed(1, es.emitsound, ("player", userid, "weapons/rpg/rocket1.wav", 0.5, 0.5))
		vec = vecmath.vector(es.getplayerprop(userid, "CBaseEntity.m_vecOrigin"))
		gamethread.delayed(1, rocket_loop, (userid, 0, vec[2], vec[2], int(round_count)))
def rocket_loop(userid, count, height, oldheight, round):
	global rocket_list
	global restrict_list
	global round_count
	global round_interval
	if round != round_count and round_interval == 0:
		return
	if not int(userid) in rocket_list:
		return
	dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
	if dead:
		es.stopsound(userid, "weapons/rpg/rocket1.wav")
		rocket_list[int(userid)] = 0
		return
	physpush(userid, 0, 0, 350)
	origin = es.getplayerprop(userid, "CBaseEntity.m_vecOrigin")
	vec = vecmath.vector(origin)
	if vec[2] >= height or count < 7:
		gamethread.delayed(0.2, rocket_loop, (userid, count + 1, vec[2], height, round))
	else:
		es.stopsound(userid, "weapons/rpg/rocket1.wav")
		rocket_list[int(userid)] = 0
		es.emitsound("player", userid, "weapons/hegrenade/explode3.wav", 0.5, 0.5)
		index = es.createentity("env_explosion")
		es.spawnentity(index)
		es.setentityname(index, "theexplosion")
		vec = vecmath.vector(es.getplayerprop(userid, "CBaseEntity.m_vecOrigin"))
		vec[2] += 50
		es.fire(userid, "theexplosion", "addoutput", "origin %f %f %f" % (vec[0], vec[1], vec[2]))
		es.fire(userid, "theexplosion", "addoutput", "iRadiusOverride 100")
		es.fire(userid, "theexplosion", "addoutput", "iMagnitude 100")
		es.fire(userid, "theexplosion", "Explode")
		es.fire(userid, "theexplosion", "Kill")
		slay(userid)
def rounddecimal(value, places):
	v = round(float(value), int(places))
	if places == "0":
		return str(int(v))
	return str(v)
def setammo(users, param, value):
	status = 0
	if param in ["1", "2"]:
		status = int(param)
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		if status == 1:
			player.setPrimaryAmmo(int(value))
			continue
		if status == 2:
			player.setSecondaryAmmo(int(value))
			continue
		primary = player.getPrimary()
		secondary = player.getSecondary()
		name = getweaponname(userid, param)
		if primary in name:
			player.setPrimaryAmmo(int(value))
		if secondary in name:
			player.setSecondaryAmmo(int(value))
def setarmor(users, value):
	armor(users, "=", value)
def setcash(users, value):
	cash(users, "=", value)
def setclipammo(users, param, value):
	status = 0
	if param in ["1", "2"]:
		status = int(param)
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		if status == 1:
			player.setPrimaryClip(int(value))
			continue
		if status == 2:
			player.setSecondaryClip(int(value))
			continue
		primary = player.getPrimary()
		secondary = player.getSecondary()
		name = getweaponname(userid, param)
		if primary in name:
			player.setPrimaryClip(int(value))
		if secondary in name:
			player.setSecondaryClip(int(value))
def setentitycolor(index, r, g, b, a):
	color = int(r) + (int(g) << 8) + (int(b) << 16) + (int(a) << 24)
	if color >= 2**31: color -= 2**32
	es.setindexprop(index, "CBaseEntity.m_nRenderMode", es.getindexprop(index, "CBaseEntity.m_nRenderMode") | 1)
	es.setindexprop(index, "CBaseEntity.m_nRenderFX", es.getindexprop(index, "CBaseEntity.m_nRenderFX") | 256)
	es.setindexprop(index, "CBaseEntity.m_clrRender", color)
def setentname(index, param):
	es.setentityname(index, param)
def setgravity(users, ratio):
	for userid in getusers(users):
		es.fire(userid, "!self", "addoutput", "gravity %f" % float(ratio))
def sethealth(users, value):
	health(users, "=", value)
def setmodel(users, model):
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		player.setModel(model)
def setplayercolor(users, r, g, b, a, weapon):
	if str(weapon) == "1":
		w = 1
	else:
		w = 0
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		player.setColor(int(r), int(g), int(b), int(a))
		if w == 1 and player.weapon != None:
			player.setWeaponColor(int(r), int(g), int(b), int(a))
def setviewangle(users, pitch, yaw, roll):
	for userid in getusers(users):
		es.setang(userid, pitch, yaw, roll)
def setviewcoord(users, x, y, z):
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		pos = [x, y, z]
		player.viewCoord(pos)
def shake(users, time, distance, value):
	es.usermsg("create", "shake", "Shake")
	es.usermsg("write", "byte", "shake", 0)
	es.usermsg("write", "float", "shake", float(value))
	es.usermsg("write", "float", "shake", float(distance))
	es.usermsg("write", "float", "shake", float(time))
	for userid in getusers(users):
		es.usermsg("send", "shake", userid)
	es.usermsg("delete", "shake")
def slay(users):
	damage(0, users, 10000)
def spawn(users, param = 0):
	gamethread.delayed(0.15, spawn_delayed, (users, param))
def spawn_delayed(users, param):
	if param == "1":
		p = 1
	else:
		p = 0
	global spawn_restrict
	for userid in getusers(users):
		if not es.getplayerprop(userid, "CBaseEntity.m_iTeamNum") in [2, 3]:
			continue
		if p:
			spe.respawn(userid)
		else:
			es.ServerCommand("es_xsetplayerprop %s CBasePlayer.m_lifeState 512" % userid)
			es.ServerCommand("es_xsetplayerprop %s CCSPlayer.m_iPlayerState 0" % userid)
			es.ServerCommand("es_xspawnplayer %s" % userid)
def speed(users, value):
	for userid in getusers(users):
		es.setplayerprop(userid, "CBasePlayer.localdata.m_flLaggedMovementValue", value)
def stopsound(users, param):
	for userid in getusers(users):
		es.stopsound(userid, param)
def stripplayer(users, param = 0):
	trigger = es.getuserid()
	index = es.createentity("player_weaponstrip")
	es.setentityname(index, "thestrip")
	for userid in getusers(users):
		if str(param) != "0":
			es.fire(userid, "thestrip", "StripWeaponsAndSuit")
		else:
			es.fire(userid, "thestrip", "Strip")
	es.fire(trigger, "thestrip", "Kill")
def strlen(param):
	return len(param)
def strtolower(param):
	return param.lower()
def strtoupper(param):
	return param.upper()
def team(users, no):
	if not str(no) in "0123":
		return
	n = int(no)
	temp = getusers(users)
	for userid in temp:
		if n > 1:
			spe.switchTeam(userid, n)
		else:
			index = playerlib.getPlayer(userid).attributes["index"]
			setentname(index, "thetarget")
			gamethread.delayed(0.1, setentname, (index, "thenothing"))
	if n <= 1:
		es.ServerCommand("es_xfire %s thetarget SetTeam %s" % (es.getuserid(), no))
def teleport(users, x, y, z):
	for userid in getusers(users):
		es.setpos(userid, float(x), float(y), float(z))
def trimdecimal(value, places):
	v = str(float(value))
	p = int(places)
	if p == 0:
		return v[0]
	return v[:p + 2]
def unregclientcmd(command):
	global regclientcmd_list
	if [command, 0] in regclientcmd_list:
		regclientcmd_list.remove([command, 0])
	if [command, 1] in regclientcmd_list:
		regclientcmd_list.remove([command, 1])
def unregeventblock(eventname, code = ""):
	global regeventblock_list
	if not eventname in regeventblock_list:
		return
	del regeventblock_list[eventname]
	spe.unregisterPreHook(eventname, hooked)
def unrestrict(users, param):
	if str(param) in "1234":
		return
	if str(param) == "mp5":
		param = "mp5navy"
	item = "weapon_%s" % param
	global allweapons
	if not item in allweapons:
		return
	global restrict_list
	for userid in getusers(users):
		if not userid in restrict_list:
			continue
		if item in restrict_list[userid]:
			restrict_list[userid].remove(item)
def unrestrictall(users):
	global restrict_list
	for userid in getusers(users):
		if not userid in restrict_list:
			continue
		restrict_list[userid] = []
def uptime():
	global starttime
	return time.time() - starttime

def es_player_chat(event_var):
	userid = event_var["userid"]
	text = event_var["text"]
	if int(userid) <= 0:
		return
	if es.exists("saycommand", text):
		return
	team = es.getplayerprop(userid, "CBaseEntity.m_iTeamNum")
	if team in [0, 1]:
		if not int(event_var["teamonly"]):
			players = "#alive"
			type = "#Cstrike_Chat_AllSpec"
			flag = 1
	elif es.getplayerprop(userid, "CBasePlayer.pl.deadflag") == 1:
		if int(event_var["teamonly"]):
			if team == 2:
				str = "#t,#alive"
				type = "#Cstrike_Chat_T_Dead"
			if team == 3:
				str = "#ct,#alive"
				type = "#Cstrike_Chat_CT_Dead"
			players = str
		else:
			players = "#alive"
			type = "#Cstrike_Chat_AllDead"
	else:
		return
	name = es.getplayername(userid)
	player = playerlib.getPlayer(userid)
	es.usermsg('create', 'deadchat', 'SayText2')
	es.usermsg('write', 'byte', 'deadchat', player.attributes["index"])
	es.usermsg('write', 'byte', 'deadchat', 1)
	es.usermsg('write', 'string', 'deadchat', type)
	es.usermsg('write', 'string', 'deadchat', unicode(name))
	es.usermsg('write', 'string', 'deadchat', unicode(text))
	for userid in playerlib.getUseridList(players):
		es.usermsg('send', 'deadchat', userid)
	es.usermsg('delete', 'deadchat')

def player_connect(event_var):
	global restrict_list
	global deaths_list
	global rocket_list
	global escort_list
	userid = int(event_var["userid"])
	restrict_list[userid] = []
	deaths_list[userid] = 0
	rocket_list[userid] = 0
	escort_list[userid] = 0

def pre_player_disconnect(event_var):
	global rocket_list
	userid = int(event_var["userid"])
	if rocket_list[userid] == 1:
		es.stopsound(userid, "weapons/rpg/rocket1.wav")

def player_disconnect(event_var):
	global restrict_list
	global deaths_list
	global rocket_list
	global escort_list
	userid = int(event_var["userid"])
	del restrict_list[userid]
	del deaths_list[userid]
	del rocket_list[userid]
	del escort_list[userid]

def pre_weapon_fire(event_var):
	if es.ServerVar("est_enable_weapon_mods") == 0:
		return
	userid = int(event_var["userid"])
	item = "weapon_%s" % event_var["weapon"]
	if item == "weapon_mp5":
		item = "weapon_mp5navy"
	global weaponmod_list
	if item in weaponmod_list:
		temp_dic = weaponmod_list[item]
		auto = temp_dic["auto"]
		if auto == "0":
			return
		gamethread.delayed(0, es.setplayerprop, (userid, "CCSPlayer.cslocaldata.m_iShotsFired", 0))

def weapon_fire(event_var):
	if es.ServerVar("est_enable_weapon_mods") == 0:
		return
	userid = int(event_var["userid"])
	item = "weapon_%s" % event_var["weapon"]
	if item == "weapon_mp5":
		item = "weapon_mp5navy"
	global weaponmod_list
	if item in weaponmod_list:
		temp_dic = weaponmod_list[item]
		recoil = temp_dic["recoil"]
		if recoil == "0":
			return
		vec = vecmath.vector(es.getplayerprop(userid, "CBasePlayer.localdata.m_Local.m_vecPunchAngle"))
		v = float(recoil) * -0.1
		temp = "%f,%f,%f" % (v, vec[1], vec[2])
		es.setplayerprop(userid, "CBasePlayer.localdata.m_Local.m_vecPunchAngle", temp)

def pre_player_hurt(event_var):
	if es.ServerVar("est_enable_weapon_mods") == 0:
		return
	userid = int(event_var["userid"])
	attacker = int(event_var["attacker"])
	if attacker == 0 or userid == 0:
		return
	item = "weapon_%s" % event_var["weapon"]
	if item == "weapon_mp5":
		item = "weapon_mp5navy"
	global modplayerweapon_list
	global modweapon_list
	global weaponmod_list
	flag = 0
	if item in weaponmod_list:
		temp_dic = weaponmod_list[item]
		action = temp_dic["damageaction"]
		if not action in ["=", "+", "*"]:
			return
		param = "damage%d" % event_var["hitgroup"]
		if action == "=":
			point = int(temp_dic[param])
		if action == "+":
			point = event_var["dmg_health"] + int(temp_dic[param])
		if action == "*":
			point = event_var["dmg_health"] * int(temp_dic[param])
		flag = 1
	elif attacker in modplayerweapon_list:
		mods = modplayerweapon_list[attacker]
		for mod in mods:
			if mod[0] == item:
				point = mod[1]
				flag = 1
				break
	elif item in modweapon_list:
		point = modweapon_list[item]
		flag = 1
	if flag == 0:
		return
	health = es.getplayerprop(userid, "CBasePlayer.m_iHealth")
	if event_var["dmg_health"] != point:
		es.setplayerprop(userid, "CBasePlayer.m_iHealth", health + event_var["dmg_health"])
		damage(attacker, userid, point)

def player_death(event_var):
	global deaths_list
	userid = int(event_var["userid"])
	deaths_list[userid] += 1

def item_pickup(event_var):
	# we have to think about autobuy and rebuy
	weapon_restrictions = es.ServerVar("est_enable_weapon_restrictions")
	if not weapon_restrictions:
		return
	userid = int(event_var["userid"])
	item = "weapon_%s" % event_var["item"]
	if item == "weapon_mp5":
		item = "weapon_mp5navy"
	global allweapons
	if not item in allweapons:
		return
	global restrict_list
	restricts = restrict_list[userid]
	if item in restricts:
		removeweapon(userid, item)

def es_map_start(event_var):
	global modified_deaths
	global round_count
	global round_interval
	global cs_player_manager
	modified_deaths = 0
	round_count = 0
	round_interval = 0
	cs_player_manager = es.getentityindex("cs_player_manager")

def round_start(event_var):
	global timer
	global round_interval
	global count_rescued
	global escort_list
	for item in escort_list:
		escort_list[item] = 0
	count_rescued = 0
	timer = time.time()
	drug("#all", 0)
	round_interval = 0

def round_end(event_var):
	global round_count
	global round_interval
	round_count += 1
	round_interval = 1

def hostage_follows(event_var):
	global escort_list
	userid = int(event_var["userid"])
	escort_list[userid] += 1

def hostage_stops_following(event_var):
	global escort_list
	userid = int(event_var["userid"])
	escort_list[userid] -= 1

def hostage_rescued(event_var):
	global count_rescued
	global escort_list
	userid = int(event_var["userid"])
	count_rescued += 1
	escort_list[userid] -= 1

def hooked(event_var):
	global hooked_event_var
	global regeventblock_list
	eventname = event_var["spe_eventname"]
	hooked_event_var = event_var
	es.ServerCommand(regeventblock_list[eventname])

def clientcommandfilter(userid, args):
	global regclientcmd_list
	global restrict_list
	advanceddrop = es.ServerVar("est_allowadvanceddrop")
	weapon_restrictions = es.ServerVar("est_enable_weapon_restrictions")
	cmd = args[0].lower()
	flag = 0
	if weapon_restrictions:
		if advanceddrop and cmd == "drop" and not "drop" in regclientcmd_list:
			flag = 1
	else:
		if advanceddrop and cmd == "drop":
			flag = 1
	if flag == 1:
		gun = getgun(userid)
		if gun in ["weapon_knife", "weapon_hegrenade", "weapon_flashbang", "weapon_smokegrenade"]:
			spe.dropWeapon(userid, gun)
			return False
	if cmd == "buy" and es.getplayerprop(userid, "CCSPlayer.m_bInBuyZone") and len(args) > 1 and weapon_restrictions:
		restricts = restrict_list[userid]
		item = "weapon_%s" % args[1].lower()
		if item == "weapon_mp5":
			item = "weapon_mp5navy"
		if item in restricts:
			es.playsound(userid, "buttons/weapon_cant_buy.wav", 1.0)
			return False
	for item in regclientcmd_list:
		if item[0] == cmd:
			es.event("initialize", "est_cmdhook")
			es.event("setint", "est_cmdhook", "userid", userid)
			es.event("setstring", "est_cmdhook", "hooktext", args[0])
			if len(args) > 1:
				es.event("setstring", "est_cmdhook", "commandstring", args[1])
			else:
				es.event("setstring", "est_cmdhook", "commandstring", "")
			es.event("fire", "est_cmdhook")
			if int(item[1]) != 0: return True
			else: return False
	return True

def getweaponname(userid, param):
	if str(param) in "1234":
		p = int(param)
		player = playerlib.getPlayer(userid)
		gun = False
		if p == 1:
			gun = player.getPrimary()
		if p == 2:
			gun = player.getSecondary()
		if gun != False:
			return [gun]
		if p == 3:
			return ["weapon_knife"]
		if p == 4:
			name = []
			if player.getHE() > 0:
				name.append("weapon_hegrenade")
			if player.getSG() > 0:
				name.append("weapon_smokegrenade")
			if player.getFB() > 0:
				name.append("weapon_flashbang")
			if name != []:
				return name
	else:
		if param.startswith("weapon_"):
			return [param]
		else:
			if param == "mp5":
				param = "mp5navy"
			if param != "":
				return ["weapon_%s" % param]
	return ["weapon_none"]

def getusers(users):
	# http://www.eventscripts.com/pages/Est_PlayerSelection
	# Python style #alive, #all, #bot, #ct, #dead, #human, #spec, #t, #un
	# EST style #a, #c, #3, #t, #2, #s, #1, #u, #0, #h, #b, #l, #d
	# ex1: #alive,#ct (for CT who is alive)
	# ex2: #23!d (for all T and CT who is alive)
	# issue1: names start with # are not supported
	# issue2: names with digits vs userid
	global pyfilter
	if str(users).startswith("#"):
		status = 0
		notfilter = ""
		if "," in users:
			status = 1
		if "!" in users:
			all = users.split("!")
			users = all[0]
			notfilter = all[1]
			status = 2
		if status == 0:
			if users in pyfilter:
				status = 1
			else:
				status = 2
		if status == 2:
			global filter_table
			filter = []
			for item in filter_table:
				if item[0] in users:
					idlist = playerlib.getUseridList(item[1])
					filter.extend(idlist)
			users = set(filter)
			if notfilter != "":
				filter = []
				for item in filter_table:
					if item[0] in notfilter:
						idlist = playerlib.getUseridList(item[1])
						filter.extend(idlist)
				notfilter = set(filter)
				for item in notfilter:
					if int(item) in users:
						users.remove(int(item))
		else:
			users = playerlib.getUseridList(users)
	else:
		all = playerlib.getUseridList("#all")
		test = str(users)
		test = test.strip(" ,")
		if test.isdigit():
			test = str(users)
			if not "," in test:
				testid = int(test)
				if testid in all:
					return [testid]
		else:
			newusers = []
			for userid in all:
				if users == es.getplayersteamid(userid):
					newusers.append(userid)
				elif str(users) in es.getplayername(userid):
					newusers.append(userid)
			users = newusers
	if not hasattr(users, "__iter__"):
		users = (users,)
	return users

def estfilter(users):
	if not str(users).startswith("#"):
		return users
	users = users.replace("t", "2")
	users = users.replace("c", "3")
	return users

def unicode(text):
	# for unicode texts in usermsg
	status = 0
	error = ":; ()"
	for item in error:
		if item in text:
			status = 1
			break
	if status:
		msg = text
	else:
		msg = '"' + text + '"'
	return msg

def ticklistener():
	global modified_deaths
	if modified_deaths != 0:
		global deaths_list
		players = playerlib.getPlayerList("#all")
		for player in players:
			userid = int(player.userid)
			if not userid in deaths_list:
				continue
			es.setindexprop(cs_player_manager, "CPlayerResource.m_iDeaths.%.3d" % player.attributes["index"], deaths_list[userid])