#include <amxmodx>
#include <zombieplague>
#include <fun> 
#include <engine>
#include <fakemeta>
#include <hamsandwich>

/* [ZP] Extra Item : Katana Samurai! By xLeoNNN. (san antonio,chile)
   this is my first plugin, katana is a sword that kills at one stroke, with effects, 
   skin etc.
   Credits : 
   
   meTaLiCroSS  :  for its "chainsaw" to guide me in some events
   S34Qu4K3     :  to solve the bug that had the skin of the katana
   Mr.Death     :  how to create the effects and use the "Temp Entity"
   DJ HD        :  to optimize and organize the plugin
*/
   
new g_iBuy

new V_KATANA[] = "models/v_katana.mdl" 
new P_KATANA[]        = "models/p_katana.mdl"
new W_KATANA[]    = "models/w_katana.mdl"

new bool:g_katana[33]
new g_currentweapon[33]
new g_iMaxPlayers
new g_mgcur

// Cvar pointer
new cvar_katanasounds, cvar_oneround, cvar_explobody, cvar_katanaenabled

new const katana_sounds[][] =
{
	"katana/katana_deploy.wav",
	"katana/katana_hit1.wav",
	"katana/katana_hit2.wav",
	"katana/katana_stab.wav",
	"katana/katana_hitwall.wav",
	"katana/katana_slash1.wav",
	"katana/katana_slash2.wav"
}

new const old_knifeSounds[][] =
{
	"weapons/knife_deploy1.wav",
	"weapons/knife_hit1.wav",
	"weapons/knife_hit2.wav",
	"weapons/knife_hit3.wav",
	"weapons/knife_hit4.wav",
	"weapons/knife_hitwall.wav",
	"weapons/knife_slash1.wav",
	"weapons/knife_slash2.wav",
	"weapons/knife_stab.wav"
}

public plugin_init()
{
	register_plugin("[ZP] Extra Item: Katana Samurai!", "1.0", "x[L]eoNNN") 
	g_iBuy = zp_register_extra_item("Katana Samurai!", 10, ZP_TEAM_HUMAN)

	// Event
	register_event("HLTV", "event_round_start", "a", "1=0", "2=0")
	register_event("CurWeapon", "Event_CurWeapon", "be","1=1")
	
	// Forwards
	register_forward(FM_SetModel, "fw_SetModel")
	register_forward(FM_EmitSound, "fw_EmitSound")
	
	// Ham 
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
	RegisterHam(Ham_Spawn, "player", "fw_PlayerSpawn", 1)
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled")
	
	// Cvars 
	cvar_katanaenabled = register_cvar("zp_katana_enabled", "1")
	cvar_katanasounds = register_cvar("zp_katana_sounds", "1")
	cvar_oneround = register_cvar("zp_katana_oneround", "0")
	cvar_explobody = register_cvar("zp_katana_explobody", "1")
	
	// Others 
	register_clcmd("drop_katana", "drop_weaponKatana")
	register_touch("katana", "player", "PlayerTouchKatana")
	g_mgcur = get_user_msgid("CurWeapon")
}

public plugin_precache()
{
	precache_model(V_KATANA)
	precache_model(P_KATANA)
	precache_model(W_KATANA)
	
	for(new i = 0; i < sizeof katana_sounds; i++)
	precache_sound(katana_sounds[i])
}

// Item Selected forward
public zp_extra_item_selected(id, itemid)
{	
	if (get_pcvar_num(cvar_katanaenabled))
	{
		if (itemid == g_iBuy)
		
		g_katana[id] = true
		strip_user_weapons(id)
		give_item (id, "weapon_knife")
		set_user_armor(id, 700)
		set_user_health(id, 300)
		client_print(id, print_chat, "[ZP] Katana Samurai! Destrosed Your Enemy'S!")
	}
}

public event_round_start()
{
	for(new i = 1; i <= g_iMaxPlayers; i++)
	{
		if (!is_user_connected(i))
		continue
		
		if (g_katana[i])
		{
			g_katana[i] = false
		}
		give_item(i, "weapon_knife")
		remove_entity_name("katana")
	}
}

public Event_CurWeapon(id) 
{     
	if(!is_user_alive(id))
		return PLUGIN_CONTINUE
	
	g_currentweapon[id] = read_data(2) 
	
	if(!g_katana[id] || g_currentweapon[id] != CSW_KNIFE)
		return PLUGIN_CONTINUE
	
	entity_set_string(id, EV_SZ_viewmodel, V_KATANA)
	entity_set_string(id, EV_SZ_weaponmodel, P_KATANA)
	
	return PLUGIN_CONTINUE 
}

public fw_SetModel(entity, model[])
{
	if(!is_valid_ent(entity)) 
		return FMRES_IGNORED
	
	if(!equali(model, "models/w_knife.mdl")) 
		return FMRES_IGNORED;
	
	new className[33]
	entity_get_string(entity, EV_SZ_classname, className, 32)
	
	if(equal(className, "weaponbox") || equal(className, "armoury_entity") || equal(className, "grenade"))
	{
		entity_set_model(entity, W_KATANA)
		return FMRES_SUPERCEDE
	}
	
	return FMRES_IGNORED
}  

public fw_TakeDamage(victim, inflictor, attacker, Float:damage, damage_bits)
{
	if(!is_user_connected(attacker) || !is_user_connected(victim) || zp_get_user_nemesis(victim) || attacker == victim || !attacker)
		return HAM_IGNORED
	
	if(g_katana[attacker] && g_currentweapon[attacker] == CSW_KNIFE)
	{	
		static Float:originF[3]
		pev(victim, pev_origin, originF)
		
		new plrWeapId, plrClip, plrAmmo
		plrWeapId = get_user_weapon(attacker, plrClip, plrAmmo)
		if (plrWeapId == CSW_KNIFE)
			SetHamParamFloat(4, damage += get_user_health(victim))
		
		client_print(attacker, print_center, "Enemy Scraf!")
	}
	
	if(zp_get_user_nemesis(victim) || zp_get_user_first_zombie(victim) || zp_get_user_last_zombie(victim))
	{
		client_print(attacker, print_center, "The Nemesis, First Zombie And Last Zombie Inmunes")
	}
	return PLUGIN_HANDLED; 
}

public fw_PlayerKilled(victim, attacker, shouldgib)
{
	if(!is_user_connected(attacker) || !is_user_connected(victim) || attacker == victim || !attacker)
		return HAM_IGNORED
	
	if(g_katana[attacker] && g_currentweapon[attacker] == CSW_KNIFE && get_pcvar_num(cvar_explobody))
	{
		SetHamParamInteger(3, 2)
		static iOrigin[3]
		get_user_origin(victim, iOrigin)
		implosion_efect(iOrigin)
	}
	
	if(g_katana[victim])
	{
		g_katana[victim] = false
	}
	return HAM_IGNORED
}

implosion_efect(iOrigin[3])
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_IMPLOSION)
	write_coord(iOrigin[0])
	write_coord(iOrigin[1])
	write_coord(iOrigin[2])
	write_byte(200)
	write_byte(40)
	write_byte(45)
	message_end()
}

public zp_user_infected_post(infected, infector)
{
	
	if (g_katana[infected])
	{
		g_katana[infected] = false
	}
}

public client_putinserver(id)
{
	g_katana[id] = false
}

public client_disconnect(id)
{
	g_katana[id] = false
}

public fw_PlayerSpawn(id)
{
	if(get_pcvar_num(cvar_oneround))
	{
		g_katana[id] = false
		strip_oneWeapon(id, "weapon_knife")
		give_item(id, "weapon_knife")
	}
}

stock strip_oneWeapon(id, weapon[])
{
	if (!equal(weapon, "weapon_", 7))
	return 0
	
	new idd = get_weaponid(weapon)
	
	if (!idd) return 0
	
	new iEnty
	
	while((iEnty = find_ent_by_class(iEnty, weapon)) && entity_get_edict(iEnty, EV_ENT_owner) != id) {}
	
	if (!iEnty) return 0
	
	if (get_user_weapon(id) == idd)
	ExecuteHamB(Ham_Weapon_RetireWeapon,iEnty);
	
	if(!ExecuteHamB(Ham_RemovePlayerItem,id,iEnty))
	return 0
	
	ExecuteHamB(Ham_Item_Kill, iEnty)
	
	entity_set_int(id, EV_INT_weapons, entity_get_int(id, EV_INT_weapons) & ~(1<<idd))
	
	return 1
}

public fw_EmitSound(id, channel, const sound[])
{
	if(!is_user_connected(id))
		return FMRES_IGNORED
	
	if(!is_user_alive(id) || zp_get_user_zombie(id) || zp_get_user_survivor(id) || !g_katana[id] || !get_pcvar_num(cvar_katanasounds))
		return FMRES_IGNORED
	
	for(new i = 0; i < sizeof katana_sounds; i++)
	{
		if(equal(sound, old_knifeSounds[i]))
		{
			emit_sound(id, channel, katana_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM)
			return FMRES_SUPERCEDE
		}
	}
	
	return FMRES_IGNORED
}

public drop_weaponKatana(id)
{
	if(g_katana[id] && g_currentweapon[id] == CSW_KNIFE)
	{
		katana_playerDrop(id)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_CONTINUE
}

public katana_playerDrop(id) 
{
	static Float:flAim[3], Float:flOrigin[3]
	VelocityByAim(id, 64, flAim)
	entity_get_vector(id, EV_VEC_origin, flOrigin)
	
	flOrigin[0] += flAim[0]
	flOrigin[1] += flAim[1]
	
	new iEnt = create_entity("info_target")
	
	new Float:katana_iMin[3] = { -2.0, -2.0, -2.0 }
	new Float:katana_iMax[3] = { 2.0, 2.0, 2.0 }
	
	entity_set_string(iEnt, EV_SZ_classname, "katana")
	entity_set_origin(iEnt, flOrigin)
	entity_set_model(iEnt, W_KATANA)
	set_size(iEnt, katana_iMin, katana_iMax)
	entity_set_vector(iEnt, EV_VEC_mins, katana_iMin)
	entity_set_vector(iEnt, EV_VEC_maxs, katana_iMax)
	entity_set_int(iEnt, EV_INT_solid, SOLID_TRIGGER)
	entity_set_int(iEnt, EV_INT_movetype, MOVETYPE_TOSS)
	
	g_katana[id] = false
	
	reset_knifeModel(id)
}

public reset_knifeModel(id)
{
	if(user_has_weapon(id, CSW_KNIFE))
	ExecuteHamB(Ham_Item_Deploy, find_ent_by_owner(-1, "weapon_knife", id))
	
	engclient_cmd(id, "weapon_knife")
	emessage_begin(MSG_ONE, g_mgcur, _, id)
	ewrite_byte(1)
	ewrite_byte(CSW_KNIFE)
	ewrite_byte(-1)
	emessage_end()
}

public PlayerTouchKatana(Has, player)
{
	if(!is_valid_ent(Has) || !is_valid_ent(player))
	return PLUGIN_CONTINUE
	
	if(!is_user_connected(player))
	return PLUGIN_CONTINUE
	
	if(!is_user_alive(player) || zp_get_user_zombie(player) || zp_get_user_survivor(player) || g_katana[player])
	return PLUGIN_CONTINUE
	
	g_katana[player] = true
	
	reset_knifeModel(player)
	
	remove_entity(Has)
	
	return PLUGIN_CONTINUE
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang3082\\ f0\\ fs16 \n\\ par }
*/
