/* AMX Mod script.
 *
 * (c) 2003, OLO
 * This file is provided as is (no warranties).
 *
 * Admin commads:
 * amx_pausecfgmenu - displays menu by which you can pause, unpause and stop plugins
 * amx_pausecfg - list commands for pause/unpause managment
 *
 * WARNING: Stopped plugins won't work properly after activation 
 * (without mapchange) due to unactive status during players connections. 
 * For proper activation clear the file with stopped plugins
 * (option #7 in menu) or unstop selected one, save configuration,
 * then change your map.
 */

#include <translator>
#include <amxmod>
#include <amxmisc>

// Uncomment if you want to have two new commands
// amx_off - pause plugins not marked as unpauseable
// amx_on - enable plugins not marked as unpauseable
//#define DIRECT_ONOFF

#define MAX_SYSTEM 32
 
new g_menuPos[33]
new g_fileToSave[64]
new g_cstrikeRunning
new g_Modified
new g_couldntFind[] = "Couldn't find a plugin matching ^"%s^""
new g_pluginMatch[] = "Plugin matching ^"%s^" %s"
new g_addCmd[] = "amx_pausecfg add ^"%s^""
new g_system[MAX_SYSTEM]
new g_systemNum

public plugin_init(){
  load_translations("pausecfg")
  register_plugin(_T("Pause Plugins"),"0.9.9","default")
  register_concmd("amx_pausecfg","cmdPlugin",ADMIN_CFG,_T("- list commands for pause/unpause managment"))
  register_clcmd("amx_pausecfgmenu","cmdMenu",ADMIN_CFG,_T("- pause/unpause plugins with menu"))
#if defined DIRECT_ONOFF
  register_concmd("amx_off","cmdOFF",ADMIN_CFG,_T("- pauses some plugins"))
  register_concmd("amx_on","cmdON",ADMIN_CFG,_T("- unpauses some plugins"))
#endif
  register_menucmd(register_menuid("Pause/Unpause Plugins"),1023,"actionMenu")
  g_cstrikeRunning = (is_running("cstrike") || is_running("czero"))
  return PLUGIN_CONTINUE
}

#if defined DIRECT_ONOFF

public cmdOFF(id,level,cid){
  if (cmd_access(id,level,cid,1))
    pausePlugins(id)
  return PLUGIN_HANDLED
}

public cmdON(id,level,cid){
  if (cmd_access(id,level,cid,1))
    unpausePlugins(id)
  return PLUGIN_HANDLED
}

#endif

public plugin_cfg() {
  build_path( g_fileToSave , 63 , "$basedir/config/pausecfg.ini" )  
  loadSettings(g_fileToSave)
  // Put here the (English) titles of the plugins you don't want to pause
  server_cmd(g_addCmd , "Pause Plugins" )
  server_cmd(g_addCmd , "Admin Commands" )
  server_cmd(g_addCmd , "TimeLeft" )
  server_cmd(g_addCmd , "Slots Reservation" )
  server_cmd(g_addCmd , "Admin Chat" )
  server_cmd(g_addCmd , "NextMap" )
  server_cmd(g_addCmd , "Admin Help" )
  server_cmd(g_addCmd , "Admin Base" )
  server_cmd(g_addCmd , "Admin Votes" )  
  server_cmd(g_addCmd , "Welcome Message" )
  server_cmd(g_addCmd , "Stats Configuration" )
  server_cmd(g_addCmd , "Commands Menu" )
  server_cmd(g_addCmd , "Maps Menu" )
  server_cmd(g_addCmd , "Menus Front-End" )
  server_cmd(g_addCmd , "Admin Base for MySQL" )
  server_cmd(g_addCmd , "Players Menu" )
  server_cmd(g_addCmd , "Teleport Menu" )
  server_cmd(g_addCmd , "Language Manager" )
}

public actionMenu(id,key){
  switch(key){
  case 6:{
      if (file_exists(g_fileToSave)){
        delete_file(g_fileToSave)
        client_print(id,print_chat,_T("* Configuration file cleared. Reload the map if needed"))
      }
      else
        client_print(id,print_chat,_T("* Configuration was already cleared!"))
      displayMenu(id,g_menuPos[id])
  }
  case 7:{
      if (saveSettings(g_fileToSave)){
        g_Modified = 0
        client_print(id,print_chat,_T("* Configuration saved successfully"))
      }
      else
        client_print(id,print_chat,_T("* Configuration saving failed!!!"))
      displayMenu(id,g_menuPos[id])
    }
  case 8: displayMenu(id,++g_menuPos[id])
  case 9: displayMenu(id,--g_menuPos[id])
  default:{
      new option = g_menuPos[id] * 6 + key
      new file[32],status[16],jit,unused[2]
      get_plugin(option,file,31,unused,0,unused,0,unused,0,status,15,jit,id)
      switch( status[0] ) {
        case 'r': pause("ac",file)
        case 'p': {
          g_Modified = 1
          pause("dc",file)  
        }
        case 's': {
          g_Modified = 1
          unpause("ac",file)
        }
      }
      displayMenu(id,g_menuPos[id])
    }
  }
  return PLUGIN_HANDLED
}

getStatus( code, arg[], iarg ){
  switch(code){
    case 'r': copy( arg, iarg , "ON" )
    case 's': copy( arg, iarg , "STOPPED" )
    case 'p': copy( arg, iarg , "OFF" )
    case 'b': copy( arg, iarg , "ERROR" )
    default: copy( arg, iarg , "LOCKED" )
  }
}

isSystem( id ){
  for( new a = 0; a < g_systemNum; ++a)
    if ( g_system[ a ] == id )
      return 1
  return 0
}

displayMenu(id, pos){
  if (pos < 0) return
  new filename[32],title[32],status[8],jit
  new datanum = get_pluginsnum()
  new menu_body[512], start = pos * 6, k = 0
  if (start >= datanum) start = pos = g_menuPos[id] = 0
  new len = format(menu_body,511,
  g_cstrikeRunning ? _T("\yPause/Unpause Plugins\R%d/%d^n\w^n",id)
                   : _T("Pause/Unpause Plugins %d/%d^n^n",id) ,
      pos + 1,((datanum/6)+((datanum%6)?1:0)))
  new end = start + 6, keys = (1<<9)|(1<<7)|(1<<6)
  if (end > datanum) end = datanum
  for(new a = start; a < end; ++a){
    get_plugin(a,filename,31,title,31,status,0,status,0,status,1,jit,id)
    getStatus( status[0] , status , 7  )
    if ( isSystem( a ) || (status[0]!='O'&&status[0]!='S')) {
      if (g_cstrikeRunning){
        len += format(menu_body[len],511-len, "\d%d. %s\R%s^n\w",++k, title, _T(status,id) )     
      }
      else{
        ++k
        len += format(menu_body[len],511-len, "#. %s %s^n", title, _T(status,id) )
      }
    }
    else{
      keys |= (1<<k)
      len += format(menu_body[len],511-len,
        g_cstrikeRunning ? "%d. %s\y\R%s^n\w" : "%d. %s %s^n",
        ++k,title, _T(status,id) )
    }
  }
  len += format(menu_body[len],511-len,_T("^n7. Clear file with stopped^n",id))  
  len += format(menu_body[len],511-len,g_cstrikeRunning ? _T("8. Save stopped \y\R%s^n\w",id)
    : _T("8. Save stopped %s^n",id) ,g_Modified ? "*" : "")
  if (end != datanum){
    format(menu_body[len],511-len,_T("^n9. More...^n0. %s",id),
      pos ? _T("Back",id)
          : _T("Exit",id) )
    keys |= (1<<8)
  }
  else
    format(menu_body[len],511-len,"^n0. %s",
      pos ? _T("Back",id)
          : _T("Exit",id) )
  show_menu(id,keys,menu_body,-1,"Pause/Unpause Plugins")
}

public cmdMenu(id,level,cid){
  if (cmd_access(id,level,cid,1))
    displayMenu(id,g_menuPos[id] = 0)
  return PLUGIN_HANDLED
}

pausePlugins(id){
  new filename[32],title[32],status[2],jit
  new count = 0, imax = get_pluginsnum()
  for (new a=0;a<imax;++a){
    get_plugin(a,filename,31,title,31,status,0,status,0,status,1,jit)
    if ( !isSystem( a ) && status[0]=='r' && pause("ac",filename) ) {
      //console_print(id,"Pausing %s (file ^"%s^")",title,filename)
      ++count
    }
  }
  console_print(id,_T("Paused %d %s"),count,
    (count==1)? _T("plugin")
              : _T("plugins") )
}

unpausePlugins(id){
  new filename[32],title[32],status[2],jit
  new count = 0, imax = get_pluginsnum()
  for (new a=0;a<imax;++a){
    get_plugin(a,filename,31,title,31,status,0,status,0,status,1,jit)
    if ( !isSystem( a ) && status[0]=='p' && unpause("ac",filename) ) {
      //console_print(id,"Unpausing %s (file ^"%s^")",title,filename)
      ++count
    }
  }
  console_print(id,_T("Unpaused %d %s"),count,
    (count==1)? _T("plugin")
              : _T("plugins") )
}

findPluginByFile(arg[32],&len){
  new name[32],title[32],status[2],jit
  new inum  = get_pluginsnum()
  for(new a = 0; a < inum; ++a){
    get_plugin(a,name,31,title,31,status,0,status,0,status,1,jit)
    if ( equali(name,arg,len) && (status[0]=='r'||status[0]=='p'||status[0]=='s') ){
      len = copy(arg,31,name)
      return a
    }
  }
  return -1
}

findPluginByTitle(name[],file[],len,id){
  new title[32],status[2],jit
  new inum  = get_pluginsnum()
  // first search english names
  for(new a = 0; a < inum; ++a){
    get_plugin(a,file,len,title,31,status,0,status,0,status,1,jit)
    if ( equali( title , name ) )
      return a
  }
  // then translated ones
  for(new a = 0; a < inum; ++a){
    get_plugin(a,file,len,title,31,status,0,status,0,status,1,jit,id)
    if ( equali( title , name ) )
      return a
  }
  return -1
}

public cmdPlugin(id,level,cid){
  if (!cmd_access(id,level,cid,1))
    return PLUGIN_HANDLED
  new cmds[32]
  read_argv(1,cmds,31)
  if ( equal(cmds, "add" ) && read_argc() > 2  ) {
    read_argv(2, cmds ,31)
    new file[2]
    if ( (g_system[ g_systemNum ] = findPluginByTitle( cmds , file , 0, id )) != -1 ) {
      if ( g_systemNum < MAX_SYSTEM )
        g_systemNum++
      else
        console_print( id , _T("Can't mark more plugins as unpauseable!") )
    }
  }
  else if ( equal(cmds, "off" ) ){
    pausePlugins(id)
  }
  else if ( equal(cmds, "on" ) ){
    unpausePlugins(id)
  }
  else if ( equal(cmds, "save" ) ){
    if (saveSettings(g_fileToSave)){
      g_Modified = 0
      console_print(id,_T("Configuration saved successfully"))
    }
    else
      console_print(id,_T("Configuration saving failed!!!"))
  }
  else if ( equal(cmds, "clear" ) ) {
    if (file_exists(g_fileToSave)){
      delete_file(g_fileToSave)
      console_print(id,_T("Configuration file cleared. Reload the map if needed"))
    }
    else
      console_print(id,_T("Configuration was already cleared!"))
  }
  else if ( equal(cmds, "pause" )  )  {
    new arg[32], a ,len = read_argv(2,arg,31)
    if ( len && ((a = findPluginByFile(arg,len)) != -1) && !isSystem( a ) && pause("ac",arg) )
      console_print(id,_T(g_pluginMatch),arg ,
        _T("paused"))
    else console_print(id,_T(g_couldntFind),arg)
  }
  else if ( equal(cmds, "enable" )  ) {
    new arg[32], a , len = read_argv(2,arg,31)
    if ( len && (a = findPluginByFile(arg,len)) != -1 && !isSystem( a ) && unpause("ac",arg) )
      console_print(id,_T(g_pluginMatch),arg ,
        _T("unpaused"))
    else console_print(id,_T(g_couldntFind),arg)
  }
  else if ( equal(cmds, "stop" )  ) {
    new arg[32], a, len = read_argv(2,arg,31)
    if ( len && (a = findPluginByFile(arg,len)) != -1 && !isSystem( a ) && pause("dc",arg)){
      g_Modified = 1
      console_print(id,_T(g_pluginMatch), arg ,
        _T("stopped") )
    }
    else console_print(id,_T(g_couldntFind),arg)
  }
  else if ( equal(cmds, "list" )  ) {
  	new arg1[8], jit, running = 0
  	new start = read_argv(2,arg1,7) ? strtonum(arg1) : 1
  	if (--start < 0) start = 0
  	new plgnum = get_pluginsnum()
  	if (start >= plgnum) start = plgnum - 1
  	console_print(id,_T("^n----- Pause Plugins: Loaded plugins -----"))
  	console_print(id,"       %-18.17s %-8.7s %-17.16s %-16.15s %-9.8s %-4.3s",
  	  _T("name"),
  	  _T("version"),
  	  _T("author"),
  	  _T("file"),
  	  _T("status"),
  	  _T("jit") )
  	new plugin[32],title[32],version[16],author[32],status[16]
  	new end = start + 10
  	if (end > plgnum) end = plgnum
  	for (new a = start; a < end; ++a){
    	get_plugin(a,plugin,31,title,31,version,15,author,31,status,15,jit,id)
    	if (status[0] == 'r') ++running
    	console_print(id, " [%3d] %-18.17s %-8.7s %-17.16s %-16.15s %-9.8s %-4.3s",a+1,title,version,author,plugin, _T(status), jit?_T("yes"):_T("no") )
  	
  	}
  	console_print(id,_T("----- Entries %d - %d of %d (%d running) -----"),start+1,end,plgnum,running)
  	if (end < plgnum)
     	console_print(id,_T("----- Use 'amx_pausecfg list %d' for more -----"),end+1)
  	else
     	console_print(id,_T("----- Use 'amx_pausecfg list 1' for begin -----"))
  }
  else {
    console_print(id,_T("Usage:  amx_pausecfg <command> [name]"))
    console_print(id,_T("Commands:"))
    console_print(id,_T("^toff - pauses all plugins not in the list"))
    console_print(id,_T("^ton - unpauses all plugins"))
    console_print(id,_T("^tstop <file> - stops a plugin"))
    console_print(id,_T("^tpause <file> - pauses a plugin"))
    console_print(id,_T("^tenable <file> - enables a plugin"))
    console_print(id,_T("^tsave - saves a list of stopped plugins"))
    console_print(id,_T("^tclear - clears a list of stopped plugins"))
    console_print(id,_T("^tlist [id] - lists plugins"))
    console_print(id,_T("^tadd <title> - marks a plugin as unpauseable"))
  }
  return PLUGIN_HANDLED
}

saveSettings(filename[]){
  if (file_exists(filename))
    delete_file(filename)
  new text[256], file[32],title[32],status[2],jit
  new inum  = get_pluginsnum()
  if (!write_file(filename,";Generated by Pause Plugins Plugin. Do not modify!^n;Title Filename"))
    return 0
  for(new a = 0; a < inum; ++a){
    get_plugin(a,file,31,title,31,status,0,status,0,status,1,jit)
    if ( status[0] == 's' ){
      format(text,255,"^"%s^" ;%s",title,file)
      write_file(filename,text)
    }
  }
  return 1
}

loadSettings(filename[]){
  if (!file_exists(filename)) return 0
  new name[256], file[32], i, pos = 0
  while (read_file(filename,pos++,name,255,i)){
    if ( name[0]!= ';' && parse(name,name,31) &&
      (i = findPluginByTitle( name , file , 31, 0 ) != -1) )
      pause("dc", file )
  }
  return 1
}
