/* AMX Mod script.
*
* (c) 2003, OLO
* This file is provided as is (no warranties).
*/

#include <translator>
#include <amxmod>
#include <amxmisc>

#define MAXRCONCVARS 16
new g_cvarRcon[ MAXRCONCVARS ][32]
new g_cvarRconNum
new g_logFile[16]
new g_pauseCon
new Float:g_pausAble
new bool:g_Paused
new g_addCvar[] = "amx_cvar add %s"

public plugin_init(){
  load_translations("admincmd")
  register_plugin(_T("Admin Commands"),"0.9.9","default")
  register_concmd("amx_kick","cmdKick",ADMIN_KICK,_T("<name or #userid> [reason]"))
  register_concmd("amx_ban","cmdBan",ADMIN_BAN,_T("<name|#userid|authid|ip> [ip] <minutes> [reason]"))
  register_concmd("amx_unban","cmdUnban",ADMIN_BAN,_T("<authid or ip>"))
  register_concmd("amx_slay","cmdSlay",ADMIN_SLAY,_T("<name or #userid>"))
  register_concmd("amx_slap","cmdSlap",ADMIN_SLAY,_T("<name or #userid> [power]"))
  register_concmd("amx_leave","cmdLeave",ADMIN_KICK,_T("<tag> [tag] [tag] [tag]"))
  register_concmd("amx_pause","cmdPause",ADMIN_CVAR,_T("- pause or unpause the game"))
  register_concmd("amx_who","cmdWho",0,_T("- displays who is on server"))
  register_concmd("amx_cvar","cmdCvar",ADMIN_CVAR,_T("<cvar> [value]"))
  register_clcmd("amx_map","cmdMap",ADMIN_MAP,_T("<mapname>"))
  register_clcmd("pauseAck","cmdLBack")
  register_clcmd("amx_cfg","cmdCfg",ADMIN_CFG,_T("<filename>"))
  register_clcmd("amx_rcon","cmdRcon",ADMIN_RCON,_T("<command line>"))
  register_cvar("amx_show_activity","2")
  register_cvar("amx_vote_delay","")
  register_cvar("amx_vote_time","")
  register_cvar("amx_vote_answers","")
  register_cvar("amx_vote_ratio","")
  register_cvar("amx_show_activity","")  
  get_logfile(g_logFile,15)
}

public plugin_cfg(){
  // Cvars which can be changed only with rcon access
  server_cmd( g_addCvar ,"rcon_password")
  server_cmd( g_addCvar ,"amx_show_activity")
  server_cmd( g_addCvar ,"amx_mode")
  server_cmd( g_addCvar ,"amx_password_field")
  server_cmd( g_addCvar ,"amx_default_access")
  server_cmd( g_addCvar ,"amx_reserved_slots")
  server_cmd( g_addCvar ,"amx_reservation")
  server_cmd( g_addCvar ,"amx_conmotd_file")
}

public getBanArgs(start,&minutes,reason[],rlen)
{
  new str[64], argc = read_argc()
  if(argc<start)
    minutes = 0
  else
  {
    read_argv(start,str,63)
    minutes = strtonum(str)
  }
  reason[0] = 0
  if(argc>start)
  {
    new len = 0
    for(new i=start+1; i<argc && len<rlen; i++)
    {
      read_argv(i,str,63)
      len += format(reason[len], rlen, len?" %s":"%s", str)
    }
  }
}

public cmdBan(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED

  new arg[32], len, i=0, found=0, myname[32], myauthid[32], kicked=0
  new player, minutes=0, reason[128], freason[128]
  new players[32], pnum, startarg

  get_players(players,pnum)
  get_user_name(id,myname,31)
  get_user_authid(id,myauthid,31)

  len = read_argv(1,arg,31)
  if(arg[0] != '#')
    player = find_player("bl",arg)
  else
    player = find_player("k",strtonum(arg[1]))

  if (player)
  {
    if(arg[0]!='#' && player != find_player("blj",arg))
      console_print(id, _T("There are more than one client matching to your argument"))
    else
    {
      new authid[32], arg2[32]
      get_user_authid(player,authid,31)

      read_argv(2, arg2, 31)
      if(equali(arg2,"ip"))
        startarg = 3
      else
        startarg = 2

      if(startarg == 2 && equal(authid,"HLTV"))
      {
        console_print(id,_T("Sorry, you can't ban HLTV proxies! Use sv_proxies (server Cvar) instead"))
        return PLUGIN_HANDLED
      }

      get_user_name(player,arg,31)

      if(get_user_flags(player) & ADMIN_IMMUNITY)
      {
        console_print(id,_T("Client ^"%s^" has immunity"), arg)
        return PLUGIN_HANDLED
      }

      getBanArgs(startarg,minutes,reason,127)
      if(reason[0])
        format(freason,127,"Banned: %s",reason)
      else
        copy(freason,127,"Banned.")

      found = 1
      kicked--

      if ( get_cvar_num("sv_lan") || startarg == 3)
      {
        new address[32], address2[32]
        get_user_ip(player,address,31,1)
        for(i=0; i<pnum; i++)
        {
          get_user_ip(players[i],address2,31,1)
          if(equal(address,address2))
          {
            server_cmd("kick #%d %s", get_user_userid(players[i]),freason)
            kicked++
          }
        }
        server_cmd("addip %d ^"%s^";wait;writeip",minutes,address)
      }
      else
      {
        new authid2[32]
        get_user_authid(player,authid,31)
        for(i=0; i<pnum; i++)
          if(players[i] != player)
          {
            get_user_authid(players[i],authid2,31)
            if(equal(authid,authid2))
            {
              server_cmd("kick #%d %s", get_user_userid(players[i]),freason)
              kicked++
            }
          }
        server_cmd("banid %d ^"%s^" kick;wait;writeid",minutes,authid)
      }

      if(found)
      {
        log_to_file(g_logFile,"Ban: ^"%s<%d><%s><>^" ban and kick ^"%s<%d><%s><>^" (minutes ^"%d^") (reason ^"%s^")", 
          myname,get_user_userid(id),myauthid, arg,player,authid,minutes,reason)
        console_print(id,_T("Client ^"%s^" kicked and banned"),arg)
        if(kicked)
          console_print(id,_T("%d other player(s) with same %s kicked and banned as well"),kicked,
            (get_cvar_num("sv_lan") || startarg == 3) ? _T("IP")
                                                      : _T("AuthID") )
      }
    }
  }
  else
  {
    strtoupper(arg)
    if(contain(arg,".")==-1)
    {
      startarg = 2
#if !defined NO_STEAM
      if(len == 7 && equali(arg,"STEAM_",6))
      {
        new str[16]
        read_argv(3,str,15)
        add(arg,31,":")
        add(arg,31,str)
        read_argv(5,str,15)
        add(arg,31,":")
        len = add(arg,31,str)
        startarg = 6
      }
      if(len>10 && equali(arg,"STEAM_",6) && arg[7] == ':' && arg[9] == ':' && strtonum(arg[10]))
#else
      if(strtonum(arg))
#endif
      {
        new authid[32]
        getBanArgs(startarg,minutes,reason,127)
        found=1

        log_to_file(g_logFile,"Ban: ^"%s<%d><%s><>^" ban ^"%s^" (minutes ^"%d^") (reason ^"%s^")", 
          myname,get_user_userid(id),myauthid,arg,minutes,reason)
  
        for(i=0; i<pnum; i++)
        {
          get_user_authid(players[i],authid,31)
          if(equal(authid,arg))
          {
            server_cmd("kick #%d %s", get_user_userid(players[i]),freason)
            kicked++
          }
        }

        server_cmd("banid %d ^"%s^";wait;writeid",minutes,arg)

        console_print(id,_T("AuthID ^"%s^" added to ban list"), arg)
        if(kicked)
          console_print(id, _T("%d player(s) with this AuthID kicked"), kicked)
      }
    }
    else
    {
      new dots = 0
      while(isdigit(arg[i]) || arg[i]=='.')
        if(arg[i++] == '.')
          dots++
      if(i == len && dots == 3)
      {
        new address[32]
        getBanArgs(2,minutes,reason,127)
        found=1

        log_to_file(g_logFile,"Ban: ^"%s<%d><%s><>^" ban ^"%s^" (minutes ^"%d^") (reason ^"%s^")", 
          myname,get_user_userid(id),myauthid,arg,minutes,reason)

        for(i=0; i<pnum; i++)
        {
          get_user_ip(players[i],address,31,1)
          if(equal(address,arg))
          {
            server_cmd("kick #%d %s", get_user_userid(players[i]),freason)
            kicked++
          }
        }

        server_cmd("addip %d ^"%s^";wait;writeip",minutes,arg)

        console_print(id,_T("IP ^"%s^" added to ban list"), arg)
        if(kicked)
          console_print(id, _T("%d player(s) with this IP kicked"), kicked)

      }
    }
  }

  if(!found)
  {
    console_print(id,_T("Could not find specified Player/AuthID/IP"))
    console_print(id,_T("Usage: amx_ban <name|#userid|authid|ip> [ip] <minutes> [reason]"))
  }
  else
  {
    new activity = get_cvar_num("amx_show_activity")

    if(activity == 1)
    {
      if(minutes)
        client_print(0,print_chat,_T("ADMIN: ban %s for %d min."), arg, minutes)
      else
        client_print(0,print_chat,_T("ADMIN: ban %s permanently"), arg)
    }
    else if(activity==2)
    {
      if(minutes)
        client_print(0,print_chat,_T("ADMIN %s: ban %s for %d min."), myname, arg, minutes)
      else
        client_print(0,print_chat,_T("ADMIN %s: ban %s permanently"), myname, arg)    
    }
  }
  
  return PLUGIN_HANDLED
}

public cmdKick(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new arg[32]
  read_argv(1,arg,31)
  new player = cmd_target(id,arg,1)
  if (!player) return PLUGIN_HANDLED
  new authid[32],authid2[32],name2[32],name[32],userid2, arg2[32]
  get_user_authid(id,authid,31)
  get_user_authid(player,authid2,31)
  get_user_name(player,name2,31)
  get_user_name(id,name,31)
  userid2 = get_user_userid(player)
  read_argv(2,arg2,31)
  log_to_file(g_logFile,"Kick: ^"%s<%d><%s><>^" kick ^"%s<%d><%s><>^" (reason ^"%s^")", 
    name,get_user_userid(id),authid, name2,userid2,authid2,arg2 )
  switch(get_cvar_num("amx_show_activity")) {
  case 2: client_print(0,print_chat,_T("ADMIN %s: kick %s"),name,name2)
  case 1: client_print(0,print_chat,_T("ADMIN: kick %s"),name2)
  } 
  server_cmd("kick #%d",userid2)
  console_print(id,_T("Client ^"%s^" kicked"),name2)
  return PLUGIN_HANDLED
}

public cmdUnban(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new arg[32],authid[32],name[32], len, pos = 0
  len = read_args(arg,31)
  if (contain(arg,".")!=-1) {
    server_cmd("removeip ^"%s^"; writeip",arg)
    console_print(id,_T("Ip ^"%s^" removed from ban list"), arg  )
  }
  else {
    if(arg[0]=='"' && arg[len-1]=='"') {
      pos = 1
      arg[len-1] = 0
    }
    server_cmd("removeid %s; writeid",arg[pos])
    console_print(id,_T("Authid ^"%s^" removed from ban list"), arg[pos]  )
  }
  get_user_name(id,name,31)  
  switch(get_cvar_num("amx_show_activity")) {
    case 2: client_print(0,print_chat,_T("ADMIN %s: unban %s"),name,arg[pos])
    case 1: client_print(0,print_chat,_T("ADMIN: unban %s"),arg[pos])
  }
  get_user_authid(id,authid,31)
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" unban ^"%s^"",
    name,get_user_userid(id),authid, arg[pos] )
  return PLUGIN_HANDLED
}

public cmdSlay(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new arg[32]
  read_argv(1,arg,31)
  new player = cmd_target(id,arg,5)
  if (!player) return PLUGIN_HANDLED
  user_kill(player)
  new authid[32],name2[32],authid2[32],name[32]
  get_user_authid(id,authid,31)
  get_user_name(id,name,31)
  get_user_authid(player,authid2,31)
  get_user_name(player,name2,31)
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" slay ^"%s<%d><%s><>^"",
    name,get_user_userid(id),authid, name2,get_user_userid(player),authid2 )
    
  switch(get_cvar_num("amx_show_activity")) {
  case 2: client_print(0,print_chat,_T("ADMIN %s: slay %s"),name,name2)
  case 1: client_print(0,print_chat,_T("ADMIN: slay %s"),name2)
  }   
    
  console_print(id,_T("Client ^"%s^" slayed"),name2)
  return PLUGIN_HANDLED
}

public cmdSlap(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new arg[32]
  read_argv(1,arg,31)
  new player = cmd_target(id,arg,5)
  if (!player) return PLUGIN_HANDLED
  new spower[32],authid[32],name2[32],authid2[32],name[32]
  read_argv(2,spower,31)
  new damage = strtonum(spower)
  user_slap(player,damage)
  get_user_authid(id,authid,31)
  get_user_name(id,name,31)
  get_user_authid(player,authid2,31)
  get_user_name(player,name2,31)
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" slap with %d damage ^"%s<%d><%s><>^"",
    name,get_user_userid(id),authid, damage,name2,get_user_userid(player),authid2 )
    
  switch(get_cvar_num("amx_show_activity")) {
  case 2: client_print(0,print_chat,_T("ADMIN %s: slap %s with %d damage"),name,name2,damage)
  case 1: client_print(0,print_chat,_T("ADMIN: slap %s with %d damage"),name2,damage)
  }       
      
  console_print(id,_T("Client ^"%s^" slaped with %d damage"),name2,damage)
  return PLUGIN_HANDLED
}

public chMap(map[])
	server_cmd("changelevel %s",map)

public cmdMap(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new arg[32]
  new arglen = read_argv(1,arg,31)
  if ( !is_map_valid(arg) ){
    console_print(id,_T("Map with that name not found or map is invalid"))
    return PLUGIN_HANDLED
  } 
  new authid[32],name[32]
  get_user_authid(id,authid,31)
  get_user_name(id,name,31)
  switch(get_cvar_num("amx_show_activity")) {
    case 2: client_print(0,print_chat,_T("ADMIN %s: changelevel %s"),name,arg)
    case 1: client_print(0,print_chat,_T("ADMIN: changelevel %s"),arg)
  }
  message_begin(MSG_ALL, SVC_INTERMISSION)
  message_end()
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" changelevel ^"%s^"", name,get_user_userid(id),authid, arg)
  set_task(1.0,"chMap",0,arg,arglen+1)
  return PLUGIN_HANDLED
}

onlyRcon( name[] ) {
  for(new a = 0; a < g_cvarRconNum; ++a)
    if ( equal( g_cvarRcon[a] , name) )
      return 1
  return 0
}

public cmdCvar(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new arg[32], arg2[64]
  read_argv(1,arg,31)
  read_argv(2,arg2,63)
  if (  equal(arg,"add") && (get_user_flags(id) & ADMIN_RCON) ) {
    if ( cvar_exists(arg2) ){
      if ( g_cvarRconNum <  MAXRCONCVARS )
        copy( g_cvarRcon[ g_cvarRconNum++ ] , 31, arg2 )
      else
        console_print(id,_T("Can't add more cvars for rcon access!"))
    }
    return PLUGIN_HANDLED
  }
  if (!cvar_exists(arg)){
    console_print(id,_T("Unknown cvar: %s"),arg)
    return PLUGIN_HANDLED
  }
  if ( onlyRcon(arg) && !(get_user_flags(id) & ADMIN_RCON)){
    console_print(id,_T("You have no access to that cvar"))
    return PLUGIN_HANDLED
  }
  else if (equal(arg,"sv_password") && !(get_user_flags(id) & ADMIN_PASSWORD)){
    console_print(id,_T("You have no access to that cvar"))
    return PLUGIN_HANDLED
  }
  if (read_argc() < 3){
    get_cvar_string(arg,arg2,63)
    console_print(id,_T("Cvar ^"%s^" is ^"%s^""),arg,arg2)
    return PLUGIN_HANDLED
  }
  new authid[32],name[32]
  get_user_authid(id,authid,31)
  get_user_name(id,name,31)
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" set cvar (name ^"%s^") (value ^"%s^")",
    name,get_user_userid(id),authid, arg,arg2)
  set_cvar_string(arg,arg2)
  
  new activity = get_cvar_num("amx_show_activity")
  if (activity) {
    if (activity == 1)
    {
      if (equal(arg,"rcon_password"))
        client_print(0,print_chat,_T("ADMIN: set cvar %s to ^"%s^""),arg,_T("*** PROTECTED ***"))
      else
        client_print(0,print_chat,_T("ADMIN: set cvar %s to ^"%s^""),arg,arg2)
    }
    else
    {
      if (equal(arg,"rcon_password"))
        client_print(0,print_chat,_T("ADMIN %s: set cvar %s to ^"%s^""),name,arg,_T("*** PROTECTED ***"))
      else
        client_print(0,print_chat,_T("ADMIN %s: set cvar %s to ^"%s^""),name,arg,arg2)
    }
  } 
  
  console_print(id,_T("Cvar ^"%s^" changed to ^"%s^""),arg,arg2)
  return PLUGIN_HANDLED
}

public cmdCfg(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new arg[128]
  read_argv(1,arg,127)
  if (!file_exists(arg)){
    console_print(id,_T("File ^"%s^" not found"),arg)
    return PLUGIN_HANDLED 
  }
  new authid[32],name[32]
  get_user_authid(id,authid,31)
  get_user_name(id,name,31)
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" execute cfg (file ^"%s^")",
    name,get_user_userid(id),authid, arg)
  console_print(id,_T("Executing file ^"%s^""),arg)
  server_cmd("exec %s",arg)
  
  switch(get_cvar_num("amx_show_activity")) {
      case 2: client_print(0,print_chat,_T("ADMIN %s: execute config %s"),name,arg)
      case 1: client_print(0,print_chat,_T("ADMIN: execute config %s"),arg)
  }
  
  return PLUGIN_HANDLED
}

public cmdLBack(){ 
  set_cvar_float("pausable",g_pausAble)
  console_print(g_pauseCon,_T("Server %s"), g_Paused ? _T("unpaused") : _T("paused"))
  g_Paused = !g_Paused
  return PLUGIN_HANDLED
}

public cmdPause(id,level,cid){ 
  if (!cmd_access(id,level,cid,1))
    return PLUGIN_HANDLED 
  new authid[32],name[32],slayer = id
  get_user_authid(id,authid,31) 
  get_user_name(id,name,31) 
  g_pausAble = get_cvar_float("pausable")
  if (!slayer) slayer = find_player("h") 
  if (!slayer){ 
    console_print(id,_T("Server was unable to pause the game. Real players on server are needed"))
    return PLUGIN_HANDLED  
  }
  set_cvar_float("pausable",1.0) 
  client_cmd(slayer,"pause;pauseAck")
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" %s server", 
    name,get_user_userid(id),authid, g_Paused ? "unpause" : "pause" )
  console_print(id,_T("Server proceed %s"), g_Paused ? _T("unpausing") : _T("pausing"))
  
  switch(get_cvar_num("amx_show_activity")) {
    case 2: client_print(0,print_chat,_T("ADMIN %s: %s server"),name,g_Paused ? _T("unpause") : _T("pause"))
    case 1: client_print(0,print_chat,_T("ADMIN: %s server"),g_Paused ? _T("unpause") : _T("pause"))
  }
  
  g_pauseCon = id
  return PLUGIN_HANDLED
} 

public cmdRcon(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new arg[128],authid[32],name[32]
  read_args(arg,127)
  get_user_authid(id,authid,31)
  get_user_name(id,name,31)
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" server console (cmdline ^"%s^")",
    name,get_user_userid(id),authid, arg)
  console_print(id,_T("Command line ^"%s^" sent to server console"),arg)
  server_cmd(arg)
  return PLUGIN_HANDLED
}

public cmdWho(id,level,cid){
  new players[32], inum, authid[32],name[32], flags, sflags[32]
  get_players(players,inum)
  console_print(id,"^n%s:^n #  %-26.25s %-20.19s %-8s %-4.3s %-4.3s %s",
    _T("Clients on server"), _T("nick"),_T("authid"),_T("userid"),_T("imm"),_T("res"),_T("access"))
  for(new a = 0; a < inum; ++a) {
      get_user_authid(players[a],authid,31)
      get_user_name(players[a],name,31)
      flags = get_user_flags(players[a])
      get_flags(flags,sflags,31)
      console_print(id,"%2d  %-26.25s %-20.19s %-8d %-4.3s %-4.3s %s", players[a],name,authid,
      get_user_userid(players[a]),(flags&ADMIN_IMMUNITY)?_T("yes"):_T("no"),
      (flags&ADMIN_RESERVATION)?_T("yes"):_T("no"),sflags)
  }
  console_print(id,_T("Total %d"),inum)
  get_user_authid(id,authid,31)
  get_user_name(id,name,31)
  log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" ask for players list",name,get_user_userid(id),authid) 
  return PLUGIN_HANDLED
}

hasTag(name[],tags[4][32],tagsNum){
  for(new a=0;a<tagsNum;++a)
    if (contain(name,tags[a])!=-1)
      return a
  return -1
}

public cmdLeave(id,level,cid){
  if (!cmd_access(id,level,cid,2))
    return PLUGIN_HANDLED
  new argnum = read_argc()
  new ltags[4][32]
  new ltagsnum = 0
  for(new a=1;a<5;++a){
    if (a<argnum)
      read_argv(a,ltags[ltagsnum++],31)
    else
      ltags[ltagsnum++][0] = 0
  }
  new nick[32], ires, pnum = get_maxplayers() + 1, count = 0
  for(new b=1;b<pnum;++b){
    if (!is_user_connected(b)&&!is_user_connecting(b)) continue
    get_user_name(b,nick,31)
    ires = hasTag(nick,ltags,ltagsnum)
    if (ires!=-1){
      console_print(id,_T("Skipping ^"%s^" (matching ^"%s^")"),nick,ltags[ires])
      continue
    }
    if (get_user_flags(b)&ADMIN_IMMUNITY){
      console_print(id,_T("Skipping ^"%s^" (immunity)"),nick)      
      continue
    }
    console_print(id,_T("Kicking ^"%s^""),nick)
    if (is_user_bot(b))
      server_cmd("kick #%d",get_user_userid(b))
    else
      client_cmd(b,_T("echo * You have been dropped because admin has left only specified group of clients;disconnect"))
    count++
  }
  console_print(id,_T("Kicked %d clients"),count)
  new authid[32],name[32]
  get_user_authid(id,authid,31)
  get_user_name(id,name,31)
  log_to_file(g_logFile,"Kick: ^"%s<%d><%s><>^" leave some group (tag1 ^"%s^") (tag2 ^"%s^") (tag3 ^"%s^") (tag4 ^"%s^")",
    name,get_user_userid(id),authid,ltags[0],ltags[1],ltags[2],ltags[3] )
    
  switch(get_cvar_num("amx_show_activity")) {
    case 2: client_print(0,print_chat,_T("ADMIN %s: leave %s %s %s %s"),name,ltags[0],ltags[1],ltags[2],ltags[3])
    case 1: client_print(0,print_chat,_T("ADMIN: leave %s %s %s %s"),ltags[0],ltags[1],ltags[2],ltags[3])
  } 
    
  return PLUGIN_HANDLED
}
