import es, cfglib, popuplib, playerlib, os.path, gamethread

info = es.AddonInfo()
info['name'] = "Undead's DeathMatch"
info['basename'] = "undeads_deathmatch"
info['version'] = "1.1"
info['author'] = "Undead"
info['url'] = "http://forums.eventscripts.com/viewtopic.php?f=27&t=39036"
info['description'] = "DeathMatch Mod by Undead"

es.ServerVar(info['basename'], info['version'], info['description']).makepublic()

gunlist_dir = str(es.ServerVar('eventscripts_gamedir')) + '/cfg/undeads_deathmatch'
dmcfg = cfglib.AddonCFG(gunlist_dir + '/config.cfg')
dmsp = dmcfg.cvar('udm_spawn_protection', '0', '0 = Disabled Spawn Protection, 1 = Enable Spawn Protection')
dmspt = dmcfg.cvar('udm_spawn_protection_time', '5', 'Seconds of Spawn Protection')
dmspf = dmcfg.cvar('udm_spawn_protection_freeze', '0', '0 = Disabled Freeze during Spawn Protection Time, 1 = Enabled')
dmcfg.write()

dict_weap = {}

def load():
  dmcfg.execute()
  dm = popuplib.easymenu('dm_menu', '_popup_choice', dm_menuselect)
  dm.settitle("Undead's DeathMatch:")
  dm.addoption('1', "New Weapons")
  dm.addoption('2', "Previous Weapons")
  dm.addoption('3', "Same Weapons Every Time")
  sec = popuplib.easymenu('sec_menu', '_popup_choice', sec_menuselect)
  sec.settitle("Select Secondary:")
  if os.path.isfile(gunlist_dir + '/secondary_guns.txt'):
    a = open(gunlist_dir + '/secondary_guns.txt', 'r')
    for line in a:
      weap = str(line).replace('\n','').split(',')
      sec.addoption(weap[0], weap[1])
    a.close()
  prim = popuplib.easymenu('prim_menu', '_popup_choice', prim_menuselect)
  prim.settitle("Select Primary:")
  if os.path.isfile(gunlist_dir + '/primary_guns.txt'):
    a = open(gunlist_dir + '/primary_guns.txt', 'r')
    for line in a:
      weap = str(line).replace('\n','').split(',')
      prim.addoption(weap[0], weap[1])
    a.close()
  for userid in es.getUseridList():
    userid = int(userid)
    dict_weap[userid] = {'sec': 0, 'prim': 0, 'auto': 0, 'uses': 0}

def player_activate(ev):
  userid = int(ev['userid'])
  if userid not in dict_weap:
    dict_weap[userid] = {'sec': 0, 'prim': 0, 'auto': 0}

def player_disconnect(ev):
  userid = int(ev['userid'])
  if userid in dict_weap:
    del dict_weap[userid]

def player_spawn(ev):
  if ev['es_userteam'] in ['2','3']:
    userid = int(ev['userid'])
    player = playerlib.getPlayer(userid)
    for weap in player.getWeaponList():
      if weap != 'weapon_knife':
        es.server.queuecmd('es_remove %s'%weap)
    es.server.queuecmd('es_sexec %s use weapon_knife'%userid)
    if userid in dict_weap:
      if dict_weap[userid]["auto"] == 0:
        popuplib.send('dm_menu', userid)
      else:
        es.give(userid, 'weapon_%s'%dict_weap[userid]["sec"])
        es.server.queuecmd('es_give %s weapon_%s'%(userid, dict_weap[userid]["prim"]))
    if dmsp == '1':
      player.godmode(1)
      if dmspf == '1':
        player.freeze(1)
      gamethread.delayed(int(dmspt), normal_mode, player)

def normal_mode(player):
  player.godmode(0)
  if dmspf == '1':
    player.freeze(0)

def dm_menuselect(userid, choice, popupid):
  userid = int(userid)
  player = playerlib.getPlayer(userid)
  if choice == '1':
    popuplib.send('sec_menu', userid)
  elif choice == '2':
    es.give(userid, 'weapon_%s'%dict_weap[userid]["sec"])
    es.server.queuecmd('es_give %s weapon_%s'%(userid, dict_weap[userid]["prim"]))
  elif choice == '3':
    es.give(userid, 'weapon_%s'%dict_weap[userid]["sec"])
    es.server.queuecmd('es_give %s weapon_%s'%(userid, dict_weap[userid]["prim"]))
    dict_weap[userid]["auto"] = 1

def sec_menuselect(userid, choice, popupid):
  userid = int(userid)
  dict_weap[userid]["sec"] = choice
  es.give(userid, 'weapon_%s'%choice)
  popuplib.send('prim_menu', userid)

def prim_menuselect(userid, choice, popupid):
  userid = int(userid)
  dict_weap[userid]["prim"] = choice
  es.give(userid, 'weapon_%s'%choice)

def player_say(ev):
  userid = int(ev['userid'])
  if ev['text'] == 'guns':
    if userid in dict_weap:
      if dict_weap[userid]["uses"] == 0:
        popuplib.send('dm_menu', userid)
        dict_weap[userid]['uses'] = 1
      else:
        es.tell(userid, 'You have already used this command.')

def player_death(ev):
  userid = int(ev['userid'])
  if userid in dict_weap:
    dict_weap[userid]["uses"] = 0
  es.setplayerprop(userid, "CCSPlayer.m_iPlayerState", 0)
  es.setplayerprop(userid, "CCSPlayer.baseclass.m_lifeState", 512)
  es.spawnplayer(userid)